/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public class StatementQuery
extends StatementDMQL {
    public static final StatementQuery[] emptyArray = new StatementQuery[0];

    StatementQuery(Session session, QueryExpression queryExpression, ParserDQL.CompileContext compileContext) {
        super(44, 2003, session.getCurrentSchemaHsqlName());
        this.statementReturnType = 2;
        this.queryExpression = queryExpression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Result result = this.queryExpression.getResult(session, session.getMaxRows());
        result.setStatement(this);
        return result;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 44: {
                return this.queryExpression.getMetaData();
            }
            case 70: {
                return this.queryExpression.getMetaData();
            }
        }
        throw Error.runtimeError(201, "StatementQuery.getResultMetaData()");
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n2;
        this.queryExpression.getBaseTableNames(orderedHashSet);
        for (n2 = 0; n2 < this.subqueries.length; ++n2) {
            if (this.subqueries[n2].queryExpression == null) continue;
            this.subqueries[n2].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n2 = 0; n2 < this.routines.length; ++n2) {
            orderedHashSet.addAll(this.routines[n2].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.queryExpression.isUpdatable) {
            this.queryExpression.getBaseTableNames(orderedHashSet);
        }
    }

    @Override
    public int getResultProperties() {
        return this.queryExpression.isUpdatable ? 8 : 0;
    }

    public void setCursorName(HsqlNameManager.HsqlName hsqlName) {
        this.cursorName = hsqlName;
    }

    public HsqlNameManager.HsqlName getCursorName() {
        return this.cursorName;
    }
}

