/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public final class StatementManager {
    private Database database;
    private Session session;
    private HashSet<StatementWrapper> statementSet;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Session session) {
        this.session = session;
        this.database = session.database;
        this.statementSet = new HashSet(32, new StatementComparator());
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    void reset() {
        this.statementSet.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    public Statement getStatement(long l2) {
        StatementWrapper statementWrapper = (StatementWrapper)this.csidMap.get(l2);
        if (statementWrapper == null) {
            return null;
        }
        return this.getStatement(statementWrapper);
    }

    private Statement getStatement(StatementWrapper statementWrapper) {
        Statement statement = statementWrapper.statement;
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            Statement statement2 = this.recompileStatement(statement);
            if (statement2 == null) {
                this.removeStatement(statement.getID());
                return null;
            }
            statement2.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            statementWrapper.statement = statement2;
            return statement2;
        }
        return statementWrapper.statement;
    }

    public Statement getStatement(Statement statement) {
        StatementWrapper statementWrapper;
        long l2 = statement.getID();
        if (l2 != 0L && (statementWrapper = (StatementWrapper)this.csidMap.get(l2)) != null) {
            return this.getStatement(statementWrapper);
        }
        return this.recompileStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Statement statement) {
        Statement statement2;
        HsqlNameManager.HsqlName hsqlName = this.session.getCurrentSchemaHsqlName();
        try {
            HsqlNameManager.HsqlName hsqlName2 = statement.getSchemaName();
            int n2 = statement.getCursorPropertiesRequest();
            if (hsqlName2 != null) {
                this.session.setSchema(hsqlName2.name);
            }
            boolean bl = statement.generatedResultMetaData() != null;
            statement2 = this.session.compileStatement(statement.getSQL(), n2);
            statement2.setCursorPropertiesRequest(n2);
            if (!statement.getResultMetaData().areTypesCompatible(statement2.getResultMetaData())) {
                Statement statement3 = null;
                return statement3;
            }
            if (!statement.getParametersMetaData().areTypesCompatible(statement2.getParametersMetaData())) {
                Statement statement4 = null;
                return statement4;
            }
            statement2.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            if (bl) {
                StatementDML statementDML = (StatementDML)statement;
                statement2.setGeneratedColumnInfo(statementDML.generatedType, statementDML.generatedInputMetaData);
            }
        }
        catch (Throwable throwable) {
            Statement statement5 = null;
            return statement5;
        }
        finally {
            this.session.setCurrentSchemaHsqlName(hsqlName);
        }
        return statement2;
    }

    private long registerStatement(StatementWrapper statementWrapper) {
        Statement statement = statementWrapper.statement;
        statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        long l2 = this.nextID();
        statement.setID(l2);
        this.statementSet.add(statementWrapper);
        this.csidMap.put(l2, statementWrapper);
        return l2;
    }

    void freeStatement(long l2) {
        StatementWrapper statementWrapper = (StatementWrapper)this.csidMap.get(l2);
        if (statementWrapper == null) {
            return;
        }
        --statementWrapper.usageCount;
        if (statementWrapper.usageCount == 0L) {
            this.removeStatement(l2);
        }
    }

    private void removeStatement(long l2) {
        if (l2 <= 0L) {
            return;
        }
        StatementWrapper statementWrapper = (StatementWrapper)this.csidMap.remove(l2);
        if (statementWrapper != null) {
            this.statementSet.remove(statementWrapper);
        }
    }

    Statement compile(Result result) {
        StatementWrapper statementWrapper = new StatementWrapper();
        statementWrapper.sql = result.getMainString();
        statementWrapper.cursorProps = result.getExecuteProperties();
        statementWrapper.generatedType = result.getGeneratedResultType();
        statementWrapper.generatedMetaData = result.getGeneratedResultMetaData();
        statementWrapper.schemaName = this.session.currentSchema;
        StatementWrapper statementWrapper2 = this.statementSet.get(statementWrapper);
        if (statementWrapper2 != null) {
            if (statementWrapper2.statement.getCompileTimestamp() >= this.database.schemaManager.getSchemaChangeTimestamp()) {
                ++statementWrapper2.usageCount;
                return statementWrapper2.statement;
            }
            this.removeStatement(statementWrapper2.statement.getID());
        }
        statementWrapper2 = statementWrapper;
        statementWrapper2.statement = this.session.compileStatement(statementWrapper2.sql, statementWrapper2.cursorProps);
        statementWrapper2.statement.setCursorPropertiesRequest(statementWrapper2.cursorProps);
        statementWrapper2.statement.setGeneratedColumnInfo(result.getGeneratedResultType(), result.getGeneratedResultMetaData());
        this.registerStatement(statementWrapper2);
        statementWrapper2.usageCount = 1L;
        return statementWrapper2.statement;
    }

    private static class StatementWrapper {
        String sql;
        HsqlNameManager.HsqlName schemaName;
        int cursorProps;
        int generatedType;
        ResultMetaData generatedMetaData;
        Statement statement;
        long usageCount;

        private StatementWrapper() {
        }
    }

    private static class StatementComparator
    implements ObjectComparator<StatementWrapper> {
        private StatementComparator() {
        }

        @Override
        public boolean equals(StatementWrapper statementWrapper, StatementWrapper statementWrapper2) {
            return statementWrapper.sql.equals(statementWrapper2.sql) && statementWrapper.schemaName.equals(statementWrapper2.schemaName) && statementWrapper.cursorProps == statementWrapper2.cursorProps && statementWrapper.generatedType == statementWrapper2.generatedType && ResultMetaData.areGeneratedReguestsCompatible(statementWrapper.generatedMetaData, statementWrapper2.generatedMetaData);
        }

        @Override
        public int hashCode(StatementWrapper statementWrapper) {
            return statementWrapper.sql.hashCode();
        }

        @Override
        public long longKey(StatementWrapper statementWrapper) {
            return 0L;
        }
    }
}

