/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.GroupSet;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementResultUpdate;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.navigator.RowSetNavigatorDataChangeMemory;
import org.hsqldb.result.Result;

public class SessionContext {
    Session session;
    public Boolean isAutoCommit;
    Boolean isReadOnly;
    Boolean noSQL;
    int currentMaxRows;
    OrderedHashMap sessionVariables;
    RangeVariable[] sessionVariablesRange;
    RangeGroup[] sessionVariableRangeGroups;
    private HsqlArrayList stack;
    Object[] diagnosticsVariables = ValuePool.emptyObjectArray;
    Object[] routineArguments = ValuePool.emptyObjectArray;
    Object[] routineVariables = ValuePool.emptyObjectArray;
    Result[] routineCursors = Result.emptyArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    Object[][] triggerArguments = null;
    public int depth;
    Boolean isInRoutine;
    Number lastIdentity = ValuePool.INTEGER_0;
    OrderedHashMap savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    GroupSet groupSet;
    List currentGroup;
    OrderedHashMap sessionTables;
    OrderedHashMap popSessionTables;
    public Statement currentStatement;
    public int rownum;
    HashSet constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();
    RangeIterator checkIterator = new RangeVariable.RangeIteratorCheck();

    SessionContext(Session session) {
        this.session = session;
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new OrderedHashMap();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, null, true, 4);
        this.sessionVariableRangeGroups = new RangeGroup[]{new RangeGroup.RangeGroupSimple(this.sessionVariablesRange, true)};
        this.isAutoCommit = Boolean.FALSE;
        this.isReadOnly = Boolean.FALSE;
        this.noSQL = Boolean.FALSE;
        this.isInRoutine = Boolean.FALSE;
    }

    void resetStack() {
        while (this.depth > 0) {
            this.pop(this.isInRoutine);
        }
    }

    public void push() {
        this.push(false);
    }

    private void push(boolean bl) {
        if (this.depth > 256) {
            throw Error.error(458);
        }
        this.session.sessionData.persistentStoreCollection.push(bl);
        if (this.stack == null) {
            this.stack = new HsqlArrayList(32, true);
        }
        this.stack.add(this.diagnosticsVariables);
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.triggerArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.routineCursors);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.lastIdentity);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(this.isInRoutine);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.stack.add(ValuePool.getInt(this.rownum));
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = Boolean.FALSE;
        this.currentMaxRows = 0;
        this.isInRoutine = bl;
        ++this.depth;
    }

    public void pop() {
        this.pop(false);
    }

    private void pop(boolean bl) {
        this.session.sessionData.persistentStoreCollection.pop(bl);
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
        this.currentMaxRows = (Integer)this.stack.remove(this.stack.size() - 1);
        this.isInRoutine = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.noSQL = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isReadOnly = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isAutoCommit = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.lastIdentity = (Number)this.stack.remove(this.stack.size() - 1);
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (OrderedHashMap)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineCursors = (Result[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.triggerArguments = (Object[][])this.stack.remove(this.stack.size() - 1);
        this.routineArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.diagnosticsVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushRoutineInvocation() {
        this.push(true);
    }

    public void popRoutineInvocation() {
        this.pop(true);
    }

    public void pushDynamicArguments(Object[] objectArray) {
        this.push();
        this.dynamicArguments = objectArray;
    }

    public void pushStatementState() {
        if (this.stack == null) {
            this.stack = new HsqlArrayList(32, true);
        }
        this.stack.add(ValuePool.getInt(this.rownum));
    }

    public void popStatementState() {
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
    }

    public void setDynamicArguments(Object[] objectArray) {
        this.dynamicArguments = objectArray;
    }

    RowSetNavigatorDataChange getRowSetDataChange() {
        return new RowSetNavigatorDataChangeMemory(this.session);
    }

    void clearStructures(StatementDMQL statementDMQL) {
        int n2 = statementDMQL.rangeIteratorCount;
        if (n2 > this.rangeIterators.length) {
            n2 = this.rangeIterators.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.rangeIterators[i2] == null) continue;
            this.rangeIterators[i2].release();
            this.rangeIterators[i2] = null;
        }
    }

    public RangeIterator getCheckIterator(RangeVariable rangeVariable) {
        int n2 = rangeVariable.rangePosition;
        if (n2 >= this.rangeIterators.length) {
            int n3 = (int)ArrayUtil.getBinaryNormalisedCeiling(n2 + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, n3);
        }
        this.rangeIterators[n2] = this.checkIterator;
        return this.checkIterator;
    }

    public void setRangeIterator(RangeIterator rangeIterator) {
        int n2 = rangeIterator.getRangePosition();
        if (n2 >= this.rangeIterators.length) {
            int n3 = (int)ArrayUtil.getBinaryNormalisedCeiling(n2 + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, n3);
        }
        this.rangeIterators[n2] = rangeIterator;
    }

    public RangeIterator getRangeIterator(int n2) {
        RangeIterator[] rangeIteratorArray = this.rangeIterators;
        if (this.stack != null) {
            for (int i2 = 0; i2 < this.stack.size(); ++i2) {
                Object e2 = this.stack.get(i2);
                if (!(e2 instanceof RangeIterator[])) continue;
                rangeIteratorArray = (RangeIterator[])e2;
                break;
            }
        }
        return rangeIteratorArray[n2];
    }

    public void unsetRangeIterator(RangeIterator rangeIterator) {
        int n2 = rangeIterator.getRangePosition();
        this.rangeIterators[n2] = null;
    }

    public void setGroupSet(GroupSet groupSet) {
        this.groupSet = groupSet;
    }

    public void setGroup(List list) {
        this.currentGroup = list;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema columnSchema) {
        int n2 = this.sessionVariables.size();
        if (!this.sessionVariables.add(columnSchema.getName().name, columnSchema)) {
            throw Error.error(5504);
        }
        Object[] objectArray = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, objectArray, this.routineVariables.length);
        this.routineVariables = objectArray;
        this.routineVariables[n2] = columnSchema.getDefaultValue(this.session);
    }

    public void pushRoutineTables() {
        this.popSessionTables = this.sessionTables;
        this.sessionTables = new OrderedHashMap();
    }

    public void popRoutineTables() {
        this.sessionTables.clear();
        this.sessionTables = this.popSessionTables;
    }

    public void addSessionTable(Table table) {
        if (this.sessionTables == null) {
            this.sessionTables = new OrderedHashMap();
        }
        if (this.sessionTables.containsKey(table.getName().name)) {
            throw Error.error(5504);
        }
        this.sessionTables.add(table.getName().name, table);
    }

    public void setSessionTables(Table[] tableArray) {
    }

    public Table findSessionTable(String string) {
        if (this.sessionTables == null) {
            return null;
        }
        return (Table)this.sessionTables.get(string);
    }

    public void dropSessionTable(String string) {
        this.sessionTables.remove(string);
    }
}

