/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    protected Scanner scanner;
    protected Token token;
    protected int partPosition;
    protected HsqlException lastError;
    protected HsqlNameManager.HsqlName lastSynonym;
    protected boolean isCheckOrTriggerCondition;
    protected boolean isSchemaDefinition;
    protected boolean isViewDefinition;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner scanner) {
        this.scanner = scanner;
        this.token = scanner.token;
        this.recordedStatement = new HsqlArrayList(256);
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getPartPosition() {
        return this.partPosition;
    }

    public void setPartPosition(int n2) {
        this.partPosition = n2;
    }

    void reset(Session session, String string) {
        this.scanner.reset(session, string);
        this.partPosition = 0;
        this.lastError = null;
        this.lastSynonym = null;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isViewDefinition = false;
        this.isRecording = false;
        this.recordedStatement.clear();
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int n2) {
        if (n2 == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(n2);
        if (this.isRecording) {
            int n3;
            for (n3 = this.recordedStatement.size() - 1; n3 >= 0; --n3) {
                Token token = (Token)this.recordedStatement.get(n3);
                if (token.position < n2) break;
            }
            this.recordedStatement.setSize(n3 + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.partPosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int n2) {
        return this.scanner.getPart(n2, this.scanner.getTokenPosition());
    }

    String getStatement(int n2, short[] sArray) {
        while (this.token.tokenType != 941 && this.token.tokenType != 1014 && ArrayUtil.find(sArray, this.token.tokenType) == -1) {
            this.read();
        }
        String string = this.scanner.getPart(n2, this.scanner.getTokenPosition());
        return string;
    }

    String getStatementForRoutine(int n2, short[] sArray) {
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        while (true) {
            if (this.token.tokenType == 941) {
                n5 = this.scanner.getTokenPosition();
                n4 = n3;
            } else {
                if (this.token.tokenType == 1014) {
                    if (n4 <= 0 || n4 != n3 - 1) break;
                    this.rewind(n5);
                    break;
                }
                if (ArrayUtil.find(sArray, this.token.tokenType) != -1) break;
            }
            this.read();
            ++n3;
        }
        String string = this.scanner.getPart(n2, this.scanner.getTokenPosition());
        return string;
    }

    Recorder startRecording() {
        if (!this.isRecording) {
            this.recordedStatement.add(this.token.duplicate());
            this.isRecording = true;
        }
        return new Recorder();
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.token.duplicate();
    }

    void replaceToken(String string) {
        this.scanner.replaceToken(string);
        if (this.isRecording) {
            Token token = this.token.duplicate();
            token.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(token);
        }
    }

    void replaceToken(Token token, Token token2) {
        String string = token.tokenString;
        if (token2 != null) {
            string = string + token2.tokenString;
        }
        string = string + " ";
        this.scanner.replaceToken(string);
        if (this.isRecording) {
            token.position = this.scanner.getTokenPosition();
            this.recordedStatement.set(this.recordedStatement.size() - 1, token);
            if (token2 != null) {
                this.recordedStatement.add(token2);
            }
        }
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int n2 = -1;
            switch (this.token.tokenType) {
                case 1022: {
                    n2 = 5587;
                    break;
                }
                case 1021: {
                    n2 = 5588;
                    break;
                }
                case 1023: {
                    n2 = 5586;
                    break;
                }
                case 1019: {
                    n2 = 5584;
                    break;
                }
                case -1: {
                    n2 = 5582;
                    break;
                }
                case 1020: {
                    n2 = 5585;
                    break;
                }
                case 1024: {
                    n2 = 5589;
                    break;
                }
                case 1025: {
                    n2 = 5583;
                    break;
                }
            }
            throw Error.error(n2, this.token.getFullString());
        }
        if (this.isRecording) {
            Token token = this.token.duplicate();
            token.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(token);
        }
    }

    boolean isReservedKey() {
        return this.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.token.isReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.token.isCoreReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    void checkIsIrregularCharInIdentifier() {
        if (this.token.hasIrregularChar) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (!this.token.isDelimitedIdentifier) {
            throw Error.error(5569);
        }
    }

    void checkIsUndelimitedIdentifier() {
        if (!this.token.isUndelimitedIdentifier) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 1011) {
            throw this.unexpectedToken();
        }
    }

    void checkIsQuotedString() {
        if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int n2) {
        if (this.token.tokenType != n2) {
            String string = Tokens.getKeyword(n2);
            throw this.unexpectedTokenRequire(string);
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String string) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(string)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsValue();
        if (!this.token.dataType.isCharacterType()) {
            throw Error.error(5563);
        }
        String string = this.token.tokenString;
        this.read();
        return string;
    }

    void readThis(int n2) {
        if (this.token.tokenType != n2) {
            String string = Tokens.getKeyword(n2);
            throw this.unexpectedTokenRequire(string);
        }
        this.read();
    }

    boolean readIfThis(int n2) {
        if (this.token.tokenType == n2) {
            this.read();
            return true;
        }
        return false;
    }

    void readThis(String string) {
        if (!string.equals(this.token.tokenString)) {
            throw this.unexpectedTokenRequire(string);
        }
        this.read();
    }

    boolean readIfThis(String string) {
        if (string.equals(this.token.tokenString)) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerObject() {
        int n2 = this.readInteger();
        return ValuePool.getInt(n2);
    }

    int readInteger() {
        boolean bl = false;
        if (this.token.tokenType == 934) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int n2 = ((Number)this.token.tokenValue).intValue();
        if (bl) {
            n2 = -n2;
        }
        this.read();
        return n2;
    }

    long readBigint() {
        boolean bl = false;
        if (this.token.tokenType == 934) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long l2 = ((Number)this.token.tokenValue).longValue();
        if (bl) {
            l2 = -l2;
        }
        this.read();
        return l2;
    }

    Expression readDateTimeIntervalLiteral(Session session) {
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 77: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String string = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newDate(string);
                return new ExpressionValue(timestampData, Type.SQL_DATE);
            }
            case 297: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String string = this.token.tokenString;
                this.read();
                TimeData timeData = this.scanner.newTime(string);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timeData, type);
            }
            case 298: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String string = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newTimestamp(string);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timestampData, type);
            }
            case 150: {
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 934) {
                    this.read();
                    bl = true;
                } else if (this.token.tokenType == 937) {
                    this.read();
                }
                if (this.token.tokenType != 1011) break;
                String string = this.token.tokenString;
                if (!this.token.dataType.isIntegralType() && !this.token.dataType.isCharacterType()) break;
                this.read();
                IntervalType intervalType = this.readIntervalType(session, false);
                Object object = this.scanner.newInterval(string, intervalType);
                intervalType = (IntervalType)this.scanner.dateTimeType;
                if (bl) {
                    object = intervalType.negate(object);
                }
                return new ExpressionValue(object, intervalType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(n2);
        return null;
    }

    IntervalType readIntervalType(Session session, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = n4 = this.token.tokenType;
        String string = this.token.tokenString;
        n7 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n9);
        this.read();
        if (this.token.tokenType == 936) {
            this.read();
            n5 = this.readInteger();
            if (n5 <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 924) {
                if (n9 != 264) {
                    throw this.unexpectedToken();
                }
                this.read();
                n6 = this.readInteger();
                if (n6 < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(922);
        }
        if (this.token.tokenType == 301) {
            n3 = this.getPosition();
            this.read();
            n2 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, this.token.tokenType);
            if (n2 > n7) {
                n4 = this.token.tokenType;
                this.read();
            } else {
                this.rewind(n3);
            }
        }
        if (this.token.tokenType == 936) {
            if (n4 != 264 || n4 == n9) {
                throw this.unexpectedToken();
            }
            this.read();
            n6 = this.readInteger();
            if (n6 < 0) {
                throw Error.error(5592);
            }
            this.readThis(922);
        }
        n8 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n4);
        if (n5 == -1 && bl) {
            n5 = n7 == 5 ? 12 : 9;
        }
        if (n7 == -1 && session.database.sqlSyntaxMys) {
            n3 = FunctionCustom.getSQLTypeForToken(string);
            n2 = IntervalType.getStartIntervalType(n3);
            int n10 = IntervalType.getEndIntervalType(n3);
            return IntervalType.getIntervalType(n3, n2, n10, 9L, 9, true);
        }
        return IntervalType.getIntervalType(n7, n8, n5, n6);
    }

    static int getExpressionType(int n2) {
        int n3 = expressionTypeMap.get(n2, -1);
        if (n3 == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return n3;
    }

    HsqlException unexpectedToken(String string) {
        return Error.parseError(5581, string, this.scanner.getLineNumber());
    }

    HsqlException unexpectedToken(int n2) {
        String string = Tokens.getKeyword(n2);
        return Error.parseError(5581, string, this.scanner.getLineNumber());
    }

    HsqlException unexpectedTokenRequire(String string) {
        if (this.token.tokenType == 1014) {
            return Error.parseError(5590, 1, this.scanner.getLineNumber(), new String[]{"", string});
        }
        String string2 = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, 1, this.scanner.getLineNumber(), new String[]{string2, string});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 1014) {
            return Error.parseError(5590, null, this.scanner.getLineNumber());
        }
        String string = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, string, this.scanner.getLineNumber());
    }

    HsqlException tooManyIdentifiers() {
        String string = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.parseError(5551, string, this.scanner.getLineNumber());
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String string, NumberType numberType) {
        return this.scanner.convertToNumber(string, numberType);
    }

    OrderedHashMap readPropertyValuePairs(boolean bl, boolean bl2) {
        int n2;
        OrderedHashMap<String, Token> orderedHashMap;
        block2: {
            orderedHashMap = null;
            do {
                n2 = this.getPosition();
                if (!this.token.isUndelimitedIdentifier) break block2;
                String string = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 1014) break block2;
                boolean bl3 = this.readIfThis(417);
                if (!bl && (!bl2 ? bl3 : !bl3)) break block2;
                if (this.token.tokenType != 1011 && this.token.tokenType != 1012) break block2;
                Token token = this.token.duplicate();
                if (orderedHashMap == null) {
                    orderedHashMap = new OrderedHashMap<String, Token>();
                }
                orderedHashMap.put(string, token);
                this.read();
            } while (this.readIfThis(924));
            n2 = this.getPosition();
        }
        this.rewind(n2);
        return orderedHashMap;
    }

    static {
        expressionTypeMap.put(417, 40);
        expressionTypeMap.put(929, 43);
        expressionTypeMap.put(932, 44);
        expressionTypeMap.put(930, 41);
        expressionTypeMap.put(933, 45);
        expressionTypeMap.put(935, 46);
        expressionTypeMap.put(56, 74);
        expressionTypeMap.put(173, 77);
        expressionTypeMap.put(178, 76);
        expressionTypeMap.put(289, 75);
        expressionTypeMap.put(17, 78);
        expressionTypeMap.put(105, 79);
        expressionTypeMap.put(6, 80);
        expressionTypeMap.put(272, 80);
        expressionTypeMap.put(283, 81);
        expressionTypeMap.put(284, 82);
        expressionTypeMap.put(326, 83);
        expressionTypeMap.put(327, 84);
        expressionTypeMap.put(9, 85);
        expressionTypeMap.put(753, 86);
        expressionTypeMap.put(817, 87);
        expressionTypeMap.put(640, 89);
    }

    class Recorder {
        int position;

        Recorder() {
            this.position = ParserBase.this.recordedStatement.size() - 1;
        }

        String getSQL() {
            int n2 = ParserBase.this.recordedStatement.size() - this.position - 1;
            Token[] tokenArray = new Token[n2];
            ParserBase.this.recordedStatement.toArraySlice(tokenArray, this.position, this.position + n2);
            return Token.getSQL(tokenArray);
        }
    }
}

