/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.TimestampData;

public class HsqlDateTime {
    public static final Locale defaultLocale = Locale.UK;
    private static final Calendar tempCalDefault = new GregorianCalendar();
    private static final Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
    private static final String sdftPattern = "HH:mm:ss";
    private static final SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SimpleDateFormat sdftsSys = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Date sysDate = new Date();
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date date = sdfd.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long l2) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l2 * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date date = sdfts.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l2, int n2, int n3) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l2 * 1000L);
            String string = sdfts.format(sysDate);
            if (n3 > 0) {
                string = string + '.' + StringUtil.toZeroPaddedString(n2, 9, n3);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l2) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l2);
            return sdfts.format(sysDate);
        }
    }

    private static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long l2) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.clear();
                tempCalGMT.setTimeInMillis(l2);
                calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
                return calendar.getTimeInMillis();
            }
        }
    }

    public static long convertMillisFromCalendar(Calendar calendar, long l2) {
        return HsqlDateTime.convertMillisFromCalendar(tempCalGMT, calendar, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, Calendar calendar2, long l2) {
        Calendar calendar3 = calendar;
        synchronized (calendar3) {
            Calendar calendar4 = calendar2;
            synchronized (calendar4) {
                calendar.clear();
                calendar2.setTimeInMillis(l2);
                calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
                return calendar.getTimeInMillis();
            }
        }
    }

    public static void setTimeInMillis(Calendar calendar, long l2) {
        calendar.setTimeInMillis(l2);
    }

    public static long convertToNormalisedTime(long l2) {
        return HsqlDateTime.convertToNormalisedTime(tempCalGMT, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(Calendar calendar, long l2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l2);
            HsqlDateTime.resetToDate(calendar);
            long l3 = calendar.getTimeInMillis();
            return l2 - l3;
        }
    }

    public static long getNormalisedTime(long l2) {
        return HsqlDateTime.getNormalisedTime(tempCalGMT, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long l2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l2);
            HsqlDateTime.resetToTime(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static long getNormalisedDate(long l2) {
        return HsqlDateTime.getNormalisedDate(tempCalGMT, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long l2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l2);
            HsqlDateTime.resetToDate(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static int getZoneSeconds() {
        return HsqlDateTime.getZoneSeconds(tempCalDefault);
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar calendar, long l2) {
        return calendar.getTimeZone().getOffset(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(Calendar calendar, long l2, int n2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            return calendar.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(Calendar calendar, long l2, int n2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            switch (n2) {
                case 136: {
                    int n3 = calendar.get(7);
                    if (n3 == 1) {
                        n3 = 8;
                    }
                    calendar.add(6, 2 - n3);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                case 126: {
                    int n4 = calendar.get(7);
                    calendar.add(6, 1 - n4);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(calendar, n2);
                }
            }
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(Calendar calendar, long l2, int n2) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            switch (n2) {
                case 101: {
                    if (calendar.get(2) <= 6) break;
                    calendar.add(1, 1);
                    break;
                }
                case 102: {
                    if (calendar.get(5) <= 15) break;
                    calendar.add(2, 1);
                    break;
                }
                case 103: {
                    if (calendar.get(11) <= 11) break;
                    calendar.add(5, 1);
                    break;
                }
                case 104: {
                    if (calendar.get(12) <= 29) break;
                    calendar.add(11, 1);
                    break;
                }
                case 105: {
                    if (calendar.get(13) <= 29) break;
                    calendar.add(12, 1);
                    break;
                }
                case 106: {
                    if (calendar.get(14) <= 499) break;
                    calendar.add(13, 1);
                    break;
                }
                case 126: {
                    int n3 = calendar.get(6);
                    int n4 = calendar.get(1);
                    int n5 = calendar.get(3);
                    int n6 = calendar.get(7);
                    calendar.clear();
                    calendar.set(1, n4);
                    if (n6 > 3) {
                        ++n5;
                    }
                    if (n5 == 1 && (n3 > 356 || n3 < 7)) {
                        calendar.set(6, n3);
                        while (true) {
                            if (calendar.get(7) == 1) {
                                return calendar.getTimeInMillis();
                            }
                            calendar.add(6, -1);
                        }
                    }
                    calendar.set(3, n5);
                    return calendar.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(calendar, n2);
            return calendar.getTimeInMillis();
        }
    }

    static void zeroFromPart(Calendar calendar, int n2) {
        switch (n2) {
            case 101: {
                calendar.set(2, 0);
            }
            case 102: {
                calendar.set(5, 1);
            }
            case 103: {
                calendar.set(11, 0);
            }
            case 104: {
                calendar.set(12, 0);
            }
            case 105: {
                calendar.set(13, 0);
            }
            case 106: {
                calendar.set(14, 0);
            }
        }
    }

    public static TimestampData toDate(String string, String string2, SimpleDateFormat simpleDateFormat, boolean bl) {
        long l2;
        int n2 = 0;
        String string3 = HsqlDateTime.toJavaDatePattern(string2);
        String string4 = null;
        int n3 = string3.indexOf("*IY");
        if (n3 >= 0) {
            throw Error.error(3472);
        }
        n3 = string3.indexOf("*WW");
        if (n3 >= 0) {
            throw Error.error(3472);
        }
        n3 = string3.indexOf("*W");
        if (n3 >= 0) {
            throw Error.error(3472);
        }
        n3 = string3.indexOf("SSS");
        if (n3 >= 0) {
            string4 = string3;
            string3 = string3.substring(0, n3) + string3.substring(n3 + 3);
        }
        try {
            simpleDateFormat.applyPattern(string3);
            l2 = simpleDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            throw Error.error(3407, exception.toString());
        }
        if (n3 >= 0 && bl) {
            string3 = string4;
            try {
                simpleDateFormat.applyPattern(string3);
                long l3 = simpleDateFormat.parse(string).getTime();
                int n4 = 1;
                n2 = (int)(l3 -= l2);
                while (l3 > 1000L) {
                    l3 /= 10L;
                    n4 *= 10;
                }
                n2 *= 1000000 / n4;
            }
            catch (Exception exception) {
                throw Error.error(3407, exception.toString());
            }
        }
        return new TimestampData(l2 / 1000L, n2, 0);
    }

    public static String toFormattedDate(Date date, String string, SimpleDateFormat simpleDateFormat) {
        CharSequence charSequence;
        int n2;
        int n3;
        int n4;
        Calendar calendar;
        String string2 = HsqlDateTime.toJavaDatePattern(string);
        try {
            simpleDateFormat.applyPattern(string2);
        }
        catch (Exception exception) {
            throw Error.error(3472);
        }
        String string3 = simpleDateFormat.format(date);
        int n5 = string3.indexOf("*IY");
        if (n5 >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n4 = 3;
            n3 = string3.indexOf("*IYYY");
            if (n3 >= 0) {
                n4 = 5;
                n5 = n3;
            }
            n2 = calendar.get(1);
            int n6 = calendar.get(3);
            if (n6 == 1 && calendar.get(6) > 360) {
                ++n2;
            } else if (n6 > 51 && calendar.get(6) < 4) {
                --n2;
            }
            charSequence = String.valueOf(n2);
            if (n4 == 3) {
                charSequence = ((String)charSequence).substring(((String)charSequence).length() - 2);
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n5, n5 + n4, (String)charSequence);
            string3 = stringBuilder.toString();
        }
        if ((n5 = string3.indexOf("*WW")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n4 = 3;
            n3 = calendar.get(6);
            n2 = (n3 - 1) / 7 + 1;
            String string4 = String.valueOf(n2);
            if (string4.length() == 1) {
                string4 = "0" + string4;
            }
            charSequence = new StringBuilder(string3);
            ((StringBuilder)charSequence).replace(n5, n5 + n4, string4);
            string3 = ((StringBuilder)charSequence).toString();
        }
        if ((n5 = string3.indexOf("*IW")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n4 = 3;
            n3 = calendar.get(3);
            String string5 = String.valueOf(n3);
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n5, n5 + n4, string5);
            string3 = stringBuilder.toString();
        }
        if ((n5 = string3.indexOf("*W")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n4 = 2;
            n3 = calendar.get(5);
            int n7 = (n3 - 1) / 7 + 1;
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n5, n5 + n4, String.valueOf(n7));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public static String toJavaDatePattern(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        Tokenizer tokenizer = new Tokenizer();
        int n3 = -1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            char c2;
            char c3 = c2 = i2 == n2 ? (char)'\uffff' : (char)string.charAt(i2);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(c2)) {
                    c2 = '\'';
                } else if (c2 == '\'') {
                    stringBuilder.append(c2);
                }
                stringBuilder.append(c2);
                continue;
            }
            if (tokenizer.next(c2, i2)) continue;
            if (tokenizer.consumed) {
                int n4 = tokenizer.getLastMatch();
                String string2 = javaDateTokens[n4];
                if (string2.startsWith("'") && string2.endsWith("'")) {
                    if (n3 == stringBuilder.length()) {
                        stringBuilder.setLength(stringBuilder.length() - 1);
                        string2 = string2.substring(1);
                    }
                    n3 = stringBuilder.length() + string2.length();
                }
                stringBuilder.append(string2);
                i2 = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(c2)) {
                c2 = '\'';
                stringBuilder.append(c2);
            } else if (tokenizer.isLiteral(c2)) {
                stringBuilder.append(c2);
            } else if (c2 != '\uffff') {
                throw Error.error(3407, string.substring(i2));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String string3 = stringBuilder.toString();
        return string3;
    }

    public static int toStandardIntervalPart(String string) {
        int n2 = string.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i2 = 0; i2 <= n2; ++i2) {
            char c2;
            char c3 = c2 = i2 == n2 ? (char)'\uffff' : (char)string.charAt(i2);
            if (tokenizer.next(c2, i2)) continue;
            int n3 = tokenizer.getLastMatch();
            if (n3 >= 0) {
                return sqlIntervalCodes[n3];
            }
            return -1;
        }
        return -1;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static {
        TimeZone.getDefault();
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdft.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdft.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'W'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "'*IW'", "dd", "D", "'*W'", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "SSS"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, -1, -1, 126, 136, 103, 103, -1, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = HsqlDateTime.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char c2) {
            if (this.quoteChar == c2) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char c2) {
            return ArrayUtil.isInSortedArray(c2, this.literalChars);
        }

        private boolean isZeroBit(int n2) {
            return (this.state & 1L << n2) == 0L;
        }

        private void setBit(int n2) {
            this.state |= 1L << n2;
        }

        public boolean next(char c2, int n2) {
            int n3 = ++this.offset;
            int n4 = this.offset + 1;
            int n5 = 0;
            this.matched = false;
            int n6 = this.tokens.length;
            while (--n6 >= 0) {
                if (!this.isZeroBit(n6)) continue;
                if (this.tokens[n6][n3] == Character.toUpperCase(c2)) {
                    if (this.tokens[n6].length == n4) {
                        this.setBit(n6);
                        this.lastMatched = n6;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = n2;
                        continue;
                    }
                    ++n5;
                    continue;
                }
                this.setBit(n6);
            }
            return n5 > 0;
        }
    }

    public static class SystemTimeString {
        private Date date = new Date();
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public SystemTimeString() {
            this.dateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
            this.dateFormat.setLenient(false);
        }

        public synchronized String getTimestampString() {
            this.date.setTime(System.currentTimeMillis());
            return this.dateFormat.format(this.date);
        }
    }
}

