/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.error.Error;

public class ExpressionOrderBy
extends Expression {
    private boolean isDescending;
    private boolean isNullsLast;

    ExpressionOrderBy(Expression expression) {
        super(95);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.collation = expression.collation;
        expression.collation = null;
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setNullsLast(boolean bl) {
        this.isNullsLast = bl;
    }

    boolean isNullsLast() {
        return this.isNullsLast;
    }

    @Override
    public Object getValue(Session session) {
        return this.nodes[0].getValue(session);
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        this.nodes[0].resolveTypes(session, expression);
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        this.dataType = this.nodes[0].dataType;
        if (this.collation != null && !this.dataType.isCharacterType()) {
            throw Error.error(4650, this.collation.getName().statementName);
        }
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ORDER").append(' ').append("BY").append(' ');
        if (this.nodes[0].alias != null) {
            stringBuilder.append(this.nodes[0].alias.name);
        } else {
            stringBuilder.append(this.nodes[0].getSQL());
        }
        if (this.collation != null) {
            stringBuilder.append(' ').append(this.collation.getName().getSchemaQualifiedStatementName());
        }
        if (this.isDescending) {
            stringBuilder.append(' ').append("DESC");
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLeftNode().describe(session, n2));
        if (this.isDescending) {
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("DESC").append('\n');
        }
        return stringBuilder.toString();
    }
}

