/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteArrayInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteInteger;

public abstract class MqttWireMessage {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final Charset STRING_ENCODING = StandardCharsets.UTF_8;
    private static final String[] PACKET_NAMES = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private static final long FOUR_BYTE_INT_MAX = 0xFFFFFFFFL;
    private static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    private byte type;
    protected int msgId;
    protected boolean duplicate = false;
    private MqttToken token;

    public MqttWireMessage(byte type) {
        this.type = type;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws MqttException {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int msgId) {
        this.msgId = msgId;
    }

    public String getKey() {
        return Integer.toString(this.getMessageId());
    }

    public byte[] getHeader() throws MqttException {
        try {
            int first = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] varHeader = this.getVariableHeader();
            int remLen = varHeader.length + this.getPayload().length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(first);
            dos.write(MqttWireMessage.encodeMBI(remLen));
            dos.write(varHeader);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    protected abstract byte[] getVariableHeader() throws MqttException;

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(MqttPersistable data) throws MqttException {
        byte[] payload = data.getPayloadBytes();
        if (payload == null) {
            payload = new byte[]{};
        }
        MultiByteArrayInputStream mbais = new MultiByteArrayInputStream(data.getHeaderBytes(), data.getHeaderOffset(), data.getHeaderLength(), payload, data.getPayloadOffset(), data.getPayloadLength());
        return MqttWireMessage.createWireMessage(mbais);
    }

    public static MqttWireMessage createWireMessage(byte[] bytes) throws MqttException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return MqttWireMessage.createWireMessage(bais);
    }

    private static MqttWireMessage createWireMessage(InputStream inputStream) throws MqttException {
        try {
            MqttWireMessage result;
            CountingInputStream counter = new CountingInputStream(inputStream);
            DataInputStream in = new DataInputStream(counter);
            int first = in.readUnsignedByte();
            byte type = (byte)(first >> 4);
            byte info = (byte)(first &= 0xF);
            long remLen = MqttWireMessage.readMBI(in).getValue();
            long totalToRead = (long)counter.getCounter() + remLen;
            long remainder = totalToRead - (long)counter.getCounter();
            byte[] data = new byte[]{};
            if (remainder > 0L) {
                data = new byte[(int)remainder];
                in.readFully(data, 0, data.length);
            }
            if (type == 1) {
                result = new MqttConnect(info, data);
            } else if (type == 3) {
                result = new MqttPublish(info, data);
            } else if (type == 4) {
                result = new MqttPubAck(info, data);
            } else if (type == 7) {
                result = new MqttPubComp(info, data);
            } else if (type == 2) {
                result = new MqttConnack(info, data);
            } else if (type == 12) {
                result = new MqttPingReq(info, data);
            } else if (type == 13) {
                result = new MqttPingResp(info, data);
            } else if (type == 8) {
                result = new MqttSubscribe(info, data);
            } else if (type == 9) {
                result = new MqttSuback(info, data);
            } else if (type == 10) {
                result = new MqttUnsubscribe(info, data);
            } else if (type == 11) {
                result = new MqttUnsubAck(info, data);
            } else if (type == 6) {
                result = new MqttPubRel(info, data);
            } else if (type == 5) {
                result = new MqttPubRec(info, data);
            } else if (type == 14) {
                result = new MqttDisconnect(info, data);
            } else {
                throw ExceptionHelper.createMqttException(6);
            }
            return result;
        }
        catch (IOException io) {
            throw new MqttException(io);
        }
    }

    public static byte[] encodeMBI(long number) {
        MqttWireMessage.validateVariableByteInt((int)number);
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            bos.write(digit);
        } while (no > 0L && ++numBytes < 4);
        return bos.toByteArray();
    }

    public static MultiByteInteger readMBI(DataInputStream in) throws IOException {
        byte digit;
        int msgLength = 0;
        int multiplier = 1;
        int count = 0;
        do {
            digit = in.readByte();
            ++count;
            msgLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        if (msgLength < 0 || msgLength > 0xFFFFFFF) {
            throw new IOException("This property must be a number between 0 and 268435455. Read value was: " + msgLength);
        }
        return new MultiByteInteger(msgLength, count);
    }

    protected byte[] encodeMessageId() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public static void encodeUTF8(DataOutputStream dos, String stringToEncode) throws MqttException {
        MqttWireMessage.validateUTF8String(stringToEncode);
        try {
            byte[] encodedString = stringToEncode.getBytes(STRING_ENCODING);
            byte byte1 = (byte)(encodedString.length >>> 8 & 0xFF);
            byte byte2 = (byte)(encodedString.length >>> 0 & 0xFF);
            dos.write(byte1);
            dos.write(byte2);
            dos.write(encodedString);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MqttException(ex);
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public static String decodeUTF8(DataInputStream input) throws MqttException {
        try {
            int encodedLength = input.readUnsignedShort();
            byte[] encodedString = new byte[encodedLength];
            input.readFully(encodedString);
            String output = new String(encodedString, STRING_ENCODING);
            MqttWireMessage.validateUTF8String(output);
            return output;
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    private static void validateUTF8String(String input) throws IllegalArgumentException {
        int i2 = 0;
        while (i2 < input.length()) {
            boolean isBad = false;
            char c2 = input.charAt(i2);
            if (Character.isHighSurrogate(c2)) {
                if (++i2 == input.length()) {
                    isBad = true;
                } else {
                    char c22 = input.charAt(i2);
                    if (Character.isLowSurrogate(c22)) {
                        isBad = true;
                    } else {
                        int ch = (c2 & 0x3FF) << 10 | c22 & 0x3FF;
                        if ((ch & 0xFFFF) == 65535 || (ch & 0xFFFF) == 65534) {
                            isBad = true;
                        }
                    }
                }
            } else if (Character.isISOControl(c2) || Character.isLowSurrogate(c2)) {
                isBad = true;
            } else if (c2 >= '\ufdd0' && (c2 == '\ufffe' || c2 >= '\ufdd0' || c2 <= '\ufddf')) {
                isBad = true;
            }
            if (isBad) {
                throw new IllegalArgumentException(String.format("Invalid UTF-8 char: [%x]", c2));
            }
            ++i2;
        }
    }

    public static void validateVariableByteInt(int value) throws IllegalArgumentException {
        if (value >= 0 && value <= 0xFFFFFFF) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 268435455");
    }

    public MqttToken getToken() {
        return this.token;
    }

    public void setToken(MqttToken token) {
        this.token = token;
    }

    public String toString() {
        return PACKET_NAMES[this.type];
    }
}

