/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.est;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Base64;

class CTEBase64InputStream
extends InputStream {
    protected final InputStream src;
    protected final byte[] rawBuf = new byte[1024];
    protected final byte[] data = new byte[768];
    protected final OutputStream dataOutputStream;
    protected final Long max;
    protected int rp;
    protected int wp;
    protected boolean end;
    protected long read;

    public CTEBase64InputStream(InputStream inputStream, Long l2) {
        this.src = inputStream;
        this.dataOutputStream = new OutputStream(){

            public void write(int n2) throws IOException {
                CTEBase64InputStream.this.data[CTEBase64InputStream.this.wp++] = (byte)n2;
            }
        };
        this.max = l2;
    }

    protected int pullFromSrc() throws IOException {
        if (this.read >= this.max) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n2 = this.src.read()) >= 33 || n2 == 13 || n2 == 10) {
                if (n3 >= this.rawBuf.length) {
                    throw new IOException("Content Transfer Encoding, base64 line length > 1024");
                }
                this.rawBuf[n3++] = (byte)n2;
                ++this.read;
                continue;
            }
            if (n2 < 0) continue;
            ++this.read;
        } while (n2 > -1 && n3 < this.rawBuf.length && n2 != 10 && this.read < this.max);
        if (n3 > 0) {
            try {
                Base64.decode(this.rawBuf, 0, n3, this.dataOutputStream);
            }
            catch (Exception exception) {
                throw new IOException("Decode Base64 Content-Transfer-Encoding: " + exception);
            }
        } else if (n2 == -1) {
            return -1;
        }
        return this.wp;
    }

    public int read() throws IOException {
        if (this.rp == this.wp) {
            this.rp = 0;
            this.wp = 0;
            int n2 = this.pullFromSrc();
            if (n2 == -1) {
                return n2;
            }
        }
        return this.data[this.rp++] & 0xFF;
    }

    public void close() throws IOException {
        this.src.close();
    }
}

