/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoiceButton;

public class PDCheckbox
extends PDChoiceButton {
    private static final COSName KEY = COSName.getPDFName("AS");
    private static final COSName OFF_VALUE = COSName.getPDFName("Off");
    private COSName value;

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
        COSDictionary ap = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("AP"));
        if (ap != null) {
            COSBase n2 = ap.getDictionaryObject(COSName.getPDFName("N"));
            if (n2 instanceof COSDictionary) {
                for (COSName name : ((COSDictionary)n2).keySet()) {
                    if (name.equals(OFF_VALUE)) continue;
                    this.value = name;
                }
            }
        } else {
            this.value = (COSName)this.getDictionary().getDictionaryObject("V");
        }
    }

    public boolean isChecked() {
        boolean retval = false;
        String onValue = this.getOnValue();
        COSName radioValue = (COSName)this.getDictionary().getDictionaryObject(KEY);
        if (radioValue != null && this.value != null && radioValue.getName().equals(onValue)) {
            retval = true;
        }
        return retval;
    }

    public void check() {
        this.getDictionary().setItem(KEY, (COSBase)this.value);
    }

    public void unCheck() {
        this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
    }

    public void setValue(String newValue) {
        this.getDictionary().setName("V", newValue);
        if (newValue == null) {
            this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
        } else {
            this.getDictionary().setName(KEY, newValue);
        }
    }

    public String getOffValue() {
        return OFF_VALUE.getName();
    }

    public String getOnValue() {
        String retval = null;
        COSDictionary ap = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.getPDFName("AP"));
        COSBase n2 = ap.getDictionaryObject(COSName.getPDFName("N"));
        if (n2 instanceof COSDictionary) {
            for (COSName key : ((COSDictionary)n2).keySet()) {
                if (key.equals(OFF_VALUE)) continue;
                retval = key.getName();
            }
        }
        return retval;
    }

    public String getValue() throws IOException {
        return this.getDictionary().getNameAsString("V");
    }
}

