/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;

public class PDAppearanceCharacteristicsDictionary
implements COSObjectable {
    private COSDictionary dictionary;

    public PDAppearanceCharacteristicsDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public int getRotation() {
        return this.getDictionary().getInt(COSName.R, 0);
    }

    public void setRotation(int rotation) {
        this.getDictionary().setInt(COSName.R, rotation);
    }

    public PDGamma getBorderColour() {
        COSBase c2 = this.getDictionary().getItem(COSName.getPDFName("BC"));
        if (c2 instanceof COSArray) {
            return new PDGamma((COSArray)c2);
        }
        return null;
    }

    public void setBorderColour(PDGamma c2) {
        this.getDictionary().setItem("BC", (COSObjectable)c2);
    }

    public PDGamma getBackground() {
        COSBase c2 = this.getDictionary().getItem(COSName.getPDFName("BG"));
        if (c2 instanceof COSArray) {
            return new PDGamma((COSArray)c2);
        }
        return null;
    }

    public void setBackground(PDGamma c2) {
        this.getDictionary().setItem("BG", (COSObjectable)c2);
    }

    public String getNormalCaption() {
        return this.getDictionary().getString("CA");
    }

    public void setNormalCaption(String caption) {
        this.getDictionary().setString("CA", caption);
    }

    public String getRolloverCaption() {
        return this.getDictionary().getString("RC");
    }

    public void setRolloverCaption(String caption) {
        this.getDictionary().setString("RC", caption);
    }

    public String getAlternateCaption() {
        return this.getDictionary().getString("AC");
    }

    public void setAlternateCaption(String caption) {
        this.getDictionary().setString("AC", caption);
    }

    public PDXObjectForm getNormalIcon() {
        COSBase i2 = this.getDictionary().getDictionaryObject("I");
        if (i2 instanceof COSStream) {
            return new PDXObjectForm((COSStream)i2);
        }
        return null;
    }

    public PDXObjectForm getRolloverIcon() {
        COSBase i2 = this.getDictionary().getDictionaryObject("RI");
        if (i2 instanceof COSStream) {
            return new PDXObjectForm((COSStream)i2);
        }
        return null;
    }

    public PDXObjectForm getAlternateIcon() {
        COSBase i2 = this.getDictionary().getDictionaryObject("IX");
        if (i2 instanceof COSStream) {
            return new PDXObjectForm((COSStream)i2);
        }
        return null;
    }
}

