/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.DualCOSObjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSArrayList<E>
implements List<E> {
    private COSArray array;
    private List<E> actual;
    private COSDictionary parentDict;
    private COSName dictKey;

    public COSArrayList() {
        this.array = new COSArray();
        this.actual = new ArrayList();
    }

    public COSArrayList(List<E> actualList, COSArray cosArray) {
        this.actual = actualList;
        this.array = cosArray;
    }

    public COSArrayList(E actualObject, COSBase item, COSDictionary dictionary, COSName dictionaryKey) {
        this.array = new COSArray();
        this.array.add(item);
        this.actual = new ArrayList();
        this.actual.add(actualObject);
        this.parentDict = dictionary;
        this.dictKey = dictionaryKey;
    }

    public COSArrayList(E actualObject, COSBase item, COSDictionary dictionary, String dictionaryKey) {
        this(actualObject, item, dictionary, COSName.getPDFName(dictionaryKey));
    }

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.actual.contains(o2);
    }

    @Override
    public Iterator<E> iterator() {
        return this.actual.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.actual.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a2) {
        return this.actual.toArray(a2);
    }

    @Override
    public boolean add(E o2) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        if (o2 instanceof String) {
            this.array.add(new COSString((String)o2));
        } else if (o2 instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)o2;
            this.array.add(dual.getFirstCOSObject());
            this.array.add(dual.getSecondCOSObject());
        } else if (this.array != null) {
            this.array.add(((COSObjectable)o2).getCOSObject());
        }
        return this.actual.add(o2);
    }

    @Override
    public boolean remove(Object o2) {
        boolean retval = true;
        int index = this.actual.indexOf(o2);
        if (index >= 0) {
            this.actual.remove(index);
            this.array.remove(index);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.actual.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        if (this.parentDict != null && c2.size() > 0) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        this.array.addAll(this.toCOSObjectList(c2));
        return this.actual.addAll(c2);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c2) {
        if (this.parentDict != null && c2.size() > 0) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        if (c2.size() > 0 && c2.toArray()[0] instanceof DualCOSObjectable) {
            this.array.addAll(index * 2, this.toCOSObjectList(c2));
        } else {
            this.array.addAll(index, this.toCOSObjectList(c2));
        }
        return this.actual.addAll(index, c2);
    }

    public static List<Integer> convertIntegerCOSArrayToList(COSArray intArray) {
        COSArrayList retval = null;
        if (intArray != null) {
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            for (int i2 = 0; i2 < intArray.size(); ++i2) {
                numbers.add(new Integer(((COSNumber)intArray.get(i2)).intValue()));
            }
            retval = new COSArrayList(numbers, intArray);
        }
        return retval;
    }

    public static List<Float> convertFloatCOSArrayToList(COSArray floatArray) {
        COSArrayList retval = null;
        if (floatArray != null) {
            ArrayList<Float> numbers = new ArrayList<Float>();
            for (int i2 = 0; i2 < floatArray.size(); ++i2) {
                numbers.add(new Float(((COSNumber)floatArray.get(i2)).floatValue()));
            }
            retval = new COSArrayList(numbers, floatArray);
        }
        return retval;
    }

    public static List<String> convertCOSNameCOSArrayToList(COSArray nameArray) {
        COSArrayList retval = null;
        if (nameArray != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i2 = 0; i2 < nameArray.size(); ++i2) {
                names.add(((COSName)nameArray.getObject(i2)).getName());
            }
            retval = new COSArrayList(names, nameArray);
        }
        return retval;
    }

    public static List<String> convertCOSStringCOSArrayToList(COSArray stringArray) {
        COSArrayList retval = null;
        if (stringArray != null) {
            ArrayList<String> string = new ArrayList<String>();
            for (int i2 = 0; i2 < stringArray.size(); ++i2) {
                string.add(((COSString)stringArray.getObject(i2)).getString());
            }
            retval = new COSArrayList(string, stringArray);
        }
        return retval;
    }

    public static COSArray convertStringListToCOSNameCOSArray(List<String> strings) {
        COSArray retval = new COSArray();
        for (int i2 = 0; i2 < strings.size(); ++i2) {
            retval.add(COSName.getPDFName(strings.get(i2)));
        }
        return retval;
    }

    public static COSArray convertStringListToCOSStringCOSArray(List<String> strings) {
        COSArray retval = new COSArray();
        for (int i2 = 0; i2 < strings.size(); ++i2) {
            retval.add(new COSString(strings.get(i2)));
        }
        return retval;
    }

    public static COSArray converterToCOSArray(List<?> cosObjectableList) {
        COSArray array = null;
        if (cosObjectableList != null) {
            if (cosObjectableList instanceof COSArrayList) {
                array = ((COSArrayList)cosObjectableList).array;
            } else {
                array = new COSArray();
                for (Object next : cosObjectableList) {
                    Object object;
                    if (next instanceof String) {
                        array.add(new COSString((String)next));
                        continue;
                    }
                    if (next instanceof Integer || next instanceof Long) {
                        array.add(COSInteger.get(((Number)next).longValue()));
                        continue;
                    }
                    if (next instanceof Float || next instanceof Double) {
                        array.add(new COSFloat(((Number)next).floatValue()));
                        continue;
                    }
                    if (next instanceof COSObjectable) {
                        object = (COSObjectable)next;
                        array.add(object.getCOSObject());
                        continue;
                    }
                    if (next instanceof DualCOSObjectable) {
                        object = (DualCOSObjectable)next;
                        array.add(object.getFirstCOSObject());
                        array.add(object.getSecondCOSObject());
                        continue;
                    }
                    if (next == null) {
                        array.add(COSNull.NULL);
                        continue;
                    }
                    throw new RuntimeException("Error: Don't know how to convert type to COSBase '" + next.getClass().getName() + "'");
                }
            }
        }
        return array;
    }

    private List<COSBase> toCOSObjectList(Collection<?> list) {
        ArrayList<COSBase> cosObjects = new ArrayList<COSBase>();
        for (Object next : list) {
            if (next instanceof String) {
                cosObjects.add(new COSString((String)next));
                continue;
            }
            if (next instanceof DualCOSObjectable) {
                DualCOSObjectable object = (DualCOSObjectable)next;
                this.array.add(object.getFirstCOSObject());
                this.array.add(object.getSecondCOSObject());
                continue;
            }
            COSObjectable cos = (COSObjectable)next;
            cosObjects.add(cos.getCOSObject());
        }
        return cosObjects;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        this.array.removeAll(this.toCOSObjectList(c2));
        return this.actual.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        this.array.retainAll(this.toCOSObjectList(c2));
        return this.actual.retainAll(c2);
    }

    @Override
    public void clear() {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)null);
        }
        this.actual.clear();
        this.array.clear();
    }

    @Override
    public boolean equals(Object o2) {
        return ((Object)this.actual).equals(o2);
    }

    @Override
    public int hashCode() {
        return ((Object)this.actual).hashCode();
    }

    @Override
    public E get(int index) {
        return this.actual.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (element instanceof String) {
            COSString item = new COSString((String)element);
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, (COSBase)item);
            }
            this.array.set(index, item);
        } else if (element instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)element;
            this.array.set(index * 2, dual.getFirstCOSObject());
            this.array.set(index * 2 + 1, dual.getSecondCOSObject());
        } else {
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, ((COSObjectable)element).getCOSObject());
            }
            this.array.set(index, ((COSObjectable)element).getCOSObject());
        }
        return this.actual.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        this.actual.add(index, element);
        if (element instanceof String) {
            this.array.add(index, new COSString((String)element));
        } else if (element instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)element;
            this.array.add(index * 2, dual.getFirstCOSObject());
            this.array.add(index * 2 + 1, dual.getSecondCOSObject());
        } else {
            this.array.add(index, ((COSObjectable)element).getCOSObject());
        }
    }

    @Override
    public E remove(int index) {
        if (this.array.size() > index && this.array.get(index) instanceof DualCOSObjectable) {
            this.array.remove(index);
            this.array.remove(index);
        } else {
            this.array.remove(index);
        }
        return this.actual.remove(index);
    }

    @Override
    public int indexOf(Object o2) {
        return this.actual.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.actual.indexOf(o2);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.actual.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.actual.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.actual.subList(fromIndex, toIndex);
    }

    public String toString() {
        return "COSArrayList{" + this.array.toString() + "}";
    }

    public COSArray toList() {
        return this.array;
    }
}

