/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.PDFOperator;

public class ContentStreamWriter {
    private OutputStream output;
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] EOL = new byte[]{10};

    public ContentStreamWriter(OutputStream out) {
        this.output = out;
    }

    public void writeTokens(List tokens, int start, int end) throws IOException {
        for (int i2 = start; i2 < end; ++i2) {
            Object o2 = tokens.get(i2);
            this.writeObject(o2);
            this.output.write(32);
        }
        this.output.flush();
    }

    private void writeObject(Object o2) throws IOException {
        if (o2 instanceof COSString) {
            ((COSString)o2).writePDF(this.output);
        } else if (o2 instanceof COSFloat) {
            ((COSFloat)o2).writePDF(this.output);
        } else if (o2 instanceof COSInteger) {
            ((COSInteger)o2).writePDF(this.output);
        } else if (o2 instanceof COSBoolean) {
            ((COSBoolean)o2).writePDF(this.output);
        } else if (o2 instanceof COSName) {
            ((COSName)o2).writePDF(this.output);
        } else if (o2 instanceof COSArray) {
            COSArray array = (COSArray)o2;
            this.output.write(COSWriter.ARRAY_OPEN);
            for (int i2 = 0; i2 < array.size(); ++i2) {
                this.writeObject(array.get(i2));
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.ARRAY_CLOSE);
        } else if (o2 instanceof COSDictionary) {
            COSDictionary obj = (COSDictionary)o2;
            this.output.write(COSWriter.DICT_OPEN);
            for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writeObject(entry.getKey());
                this.output.write(SPACE);
                this.writeObject(entry.getValue());
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.DICT_CLOSE);
            this.output.write(SPACE);
        } else if (o2 instanceof PDFOperator) {
            PDFOperator op = (PDFOperator)o2;
            if (op.getOperation().equals("BI")) {
                this.output.write("BI".getBytes("ISO-8859-1"));
                ImageParameters params = op.getImageParameters();
                COSDictionary dic = params.getDictionary();
                for (COSName key : dic.keySet()) {
                    COSBase value = dic.getDictionaryObject(key);
                    key.writePDF(this.output);
                    this.output.write(SPACE);
                    this.writeObject(value);
                    this.output.write(EOL);
                }
                this.output.write("ID".getBytes("ISO-8859-1"));
                this.output.write(EOL);
                this.output.write(op.getImageData());
            } else {
                this.output.write(op.getOperation().getBytes("ISO-8859-1"));
                this.output.write(EOL);
            }
        } else {
            throw new IOException("Error:Unknown type in content stream:" + o2);
        }
    }

    public void writeTokens(List tokens) throws IOException {
        this.writeTokens(tokens, 0, tokens.size());
    }
}

