/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.pdfbox.pdfwriter.COSFilterInputStream;
import org.apache.pdfbox.util.StringUtil;

public class COSStandardOutputStream
extends FilterOutputStream {
    public static final byte[] CRLF = StringUtil.getBytes("\r\n");
    public static final byte[] LF = StringUtil.getBytes("\n");
    public static final byte[] EOL = StringUtil.getBytes("\n");
    private long pos = 0L;
    private boolean onNewLine = false;
    private FileChannel fileChannel = null;
    private FileDescriptor fileDescriptor = null;
    private long mark = -1L;

    public COSStandardOutputStream(OutputStream out) {
        super(out);
        if (out instanceof FileOutputStream) {
            try {
                this.fileChannel = ((FileOutputStream)out).getChannel();
                this.fileDescriptor = ((FileOutputStream)out).getFD();
                this.pos = this.fileChannel.position();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public long getPos() {
        return this.pos;
    }

    public void setPos(long pos) throws IOException {
        if (this.fileChannel != null) {
            this.checkPos();
            this.pos = pos;
            this.fileChannel.position(pos);
        }
    }

    public boolean isOnNewLine() {
        return this.onNewLine;
    }

    public void setOnNewLine(boolean newOnNewLine) {
        this.onNewLine = newOnNewLine;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkPos();
        this.setOnNewLine(false);
        this.out.write(b2, off, len);
        this.pos += (long)len;
    }

    public void write(int b2) throws IOException {
        this.checkPos();
        this.setOnNewLine(false);
        this.out.write(b2);
        ++this.pos;
    }

    public void writeCRLF() throws IOException {
        this.write(CRLF);
    }

    public void writeEOL() throws IOException {
        if (!this.isOnNewLine()) {
            this.write(EOL);
            this.setOnNewLine(true);
        }
    }

    public void writeLF() throws IOException {
        this.write(LF);
    }

    public void mark() throws IOException {
        this.checkPos();
        this.mark = this.getPos();
    }

    public void reset() throws IOException {
        if (this.mark < 0L) {
            return;
        }
        this.setPos(this.mark);
    }

    private void checkPos() throws IOException {
        if (this.fileChannel != null && this.fileChannel.position() != this.getPos()) {
            throw new IOException("OutputStream has an invalid position");
        }
    }

    public byte[] getFileInBytes(int[] byteRange) throws IOException {
        return null;
    }

    public InputStream getFilterInputStream(int[] byteRange) {
        return new COSFilterInputStream(new FileInputStream(this.fileDescriptor), byteRange);
    }
}

