/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class EndstreamOutputStream
extends BufferedOutputStream {
    private boolean hasCR = false;
    private boolean hasLF = false;
    private int pos = 0;
    private boolean mustFilter = true;

    public EndstreamOutputStream(OutputStream out) {
        super(out);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.pos == 0 && len > 10) {
            this.mustFilter = false;
            for (int i2 = 0; i2 < 10; ++i2) {
                if (b2[i2] >= 9 && (b2[i2] <= 10 || b2[i2] >= 32 || b2[i2] == 13)) continue;
                this.mustFilter = true;
                break;
            }
        }
        if (this.mustFilter) {
            if (this.hasCR) {
                if (!this.hasLF && len == 1 && b2[off] == 10) {
                    this.hasCR = false;
                    return;
                }
                super.write(13);
                this.hasCR = false;
            }
            if (this.hasLF) {
                super.write(10);
                this.hasLF = false;
            }
            if (len > 0) {
                if (b2[off + len - 1] == 13) {
                    this.hasCR = true;
                    --len;
                } else if (b2[off + len - 1] == 10) {
                    this.hasLF = true;
                    if (--len > 0 && b2[off + len - 1] == 13) {
                        this.hasCR = true;
                        --len;
                    }
                }
            }
        }
        super.write(b2, off, len);
        this.pos += len;
    }

    public void flush() throws IOException {
        if (this.hasCR && !this.hasLF) {
            super.write(13);
            ++this.pos;
        }
        this.hasCR = false;
        this.hasLF = false;
        super.flush();
    }
}

