/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.persistence.util.COSHEXTable;

public class ASCIIHexFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ASCIIHexFilter.class);
    private static final int[] REVERSE_HEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private boolean isWhitespace(int c2) {
        return c2 == 0 || c2 == 9 || c2 == 10 || c2 == 12 || c2 == 13 || c2 == 32;
    }

    private boolean isEOD(int c2) {
        return c2 == 62;
    }

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        int value = 0;
        int firstByte = 0;
        int secondByte = 0;
        while ((firstByte = compressedData.read()) != -1) {
            while (this.isWhitespace(firstByte)) {
                firstByte = compressedData.read();
            }
            if (firstByte == -1 || this.isEOD(firstByte)) break;
            if (REVERSE_HEX[firstByte] == -1) {
                log.error("Invalid Hex Code; int: " + firstByte + " char: " + (char)firstByte);
            }
            value = REVERSE_HEX[firstByte] * 16;
            secondByte = compressedData.read();
            if (secondByte == -1 || this.isEOD(secondByte)) {
                result.write(value);
                break;
            }
            if (secondByte >= 0) {
                if (REVERSE_HEX[secondByte] == -1) {
                    log.error("Invalid Hex Code; int: " + secondByte + " char: " + (char)secondByte);
                }
                value += REVERSE_HEX[secondByte];
            }
            result.write(value);
        }
        result.flush();
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        int byteRead = 0;
        while ((byteRead = rawData.read()) != -1) {
            int value = (byteRead + 256) % 256;
            result.write(COSHEXTable.TABLE[value]);
        }
        result.flush();
    }
}

