/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding.conversion;

import java.io.UnsupportedEncodingException;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.encoding.conversion.CJKEncodings;
import org.apache.pdfbox.encoding.conversion.EncodingConverter;

public class CJKConverter
implements EncodingConverter {
    private String encodingName = null;
    private String charsetName = null;

    public CJKConverter(String encoding) {
        this.encodingName = encoding;
        this.charsetName = CJKEncodings.getCharset(encoding);
    }

    public String convertString(String s) {
        if (s.length() == 1) {
            return s;
        }
        if (this.charsetName.equalsIgnoreCase("UTF-16BE")) {
            return s;
        }
        try {
            return new String(s.getBytes("UTF-16BE"), this.charsetName);
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public String convertBytes(byte[] c2, int offset, int length, CMap cmap) {
        if (cmap != null) {
            try {
                if (cmap.isInCodeSpaceRanges(c2, offset, length)) {
                    return new String(c2, offset, length, this.charsetName);
                }
                return null;
            }
            catch (UnsupportedEncodingException uee) {
                return new String(c2, offset, length);
            }
        }
        return null;
    }
}

