/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Encoding
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(Encoding.class);
    public static final String NOTDEF = ".notdef";
    protected final Map<Integer, String> codeToName = new HashMap<Integer, String>();
    protected final Map<String, Integer> nameToCode = new HashMap<String, Integer>();
    private static final Map<String, String> NAME_TO_CHARACTER = new HashMap<String, String>();
    private static final Map<String, String> CHARACTER_TO_NAME = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadGlyphList(String location) {
        BufferedReader glyphStream = null;
        try {
            InputStream resource = ResourceLoader.loadResource(location);
            if (resource == null) {
                throw new MissingResourceException("Glyphlist not found: " + location, Encoding.class.getName(), location);
            }
            glyphStream = new BufferedReader(new InputStreamReader(resource));
            String line = null;
            while ((line = glyphStream.readLine()) != null) {
                int semicolonIndex;
                if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                String unicodeValue = null;
                try {
                    String characterName = line.substring(0, semicolonIndex);
                    unicodeValue = line.substring(semicolonIndex + 1, line.length());
                    StringTokenizer tokenizer = new StringTokenizer(unicodeValue, " ", false);
                    StringBuilder value = new StringBuilder();
                    while (tokenizer.hasMoreTokens()) {
                        int characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                        value.append((char)characterCode);
                    }
                    if (NAME_TO_CHARACTER.containsKey(characterName)) {
                        LOG.warn("duplicate value for characterName=" + characterName + "," + value);
                        continue;
                    }
                    NAME_TO_CHARACTER.put(characterName, value.toString());
                }
                catch (NumberFormatException nfe) {
                    LOG.error("malformed unicode value " + unicodeValue, nfe);
                }
            }
        }
        catch (IOException io) {
            LOG.error("error while reading the glyph list.", io);
        }
        finally {
            if (glyphStream != null) {
                try {
                    glyphStream.close();
                }
                catch (IOException e2) {
                    LOG.error("error when closing the glyph list.", e2);
                }
            }
        }
    }

    public Map<Integer, String> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }

    public Map<String, Integer> getNameToCodeMap() {
        return Collections.unmodifiableMap(this.nameToCode);
    }

    public void addCharacterEncoding(int code, String name) {
        this.codeToName.put(code, name);
        this.nameToCode.put(name, code);
    }

    public boolean hasCodeForName(String name) {
        return this.nameToCode.containsKey(name);
    }

    public boolean hasNameForCode(int code) {
        return this.codeToName.containsKey(code);
    }

    public int getCode(String name) throws IOException {
        Integer code = this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name + "'");
        }
        return code;
    }

    public String getName(int code) throws IOException {
        return this.codeToName.get(code);
    }

    public static String getCharacterForName(String name) {
        if (NAME_TO_CHARACTER.containsKey(name)) {
            LOG.debug("No character for name " + name);
            return NAME_TO_CHARACTER.get(name);
        }
        return null;
    }

    public String getNameFromCharacter(char c2) throws IOException {
        String name = CHARACTER_TO_NAME.get(Character.toString(c2));
        if (name == null) {
            throw new IOException("No name for character '" + c2 + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String name = this.getName(code);
        if (name != null) {
            return this.getCharacter(name);
        }
        return null;
    }

    public String getCharacter(String name) {
        String character;
        block17: {
            character = NAME_TO_CHARACTER.get(name);
            if (character == null) {
                if (name.indexOf(46) > 0) {
                    character = this.getCharacter(name.substring(0, name.indexOf(46)));
                } else if (name.startsWith("uni")) {
                    int nameLength = name.length();
                    StringBuilder uniStr = new StringBuilder();
                    try {
                        int chPos = 3;
                        while (chPos + 4 <= nameLength) {
                            int characterCode = Integer.parseInt(name.substring(chPos, chPos + 4), 16);
                            if (characterCode > 55295 && characterCode < 57344) {
                                LOG.warn("Unicode character name with not allowed code area: " + name);
                            } else {
                                uniStr.append((char)characterCode);
                            }
                            chPos += 4;
                        }
                        character = uniStr.toString();
                        NAME_TO_CHARACTER.put(name, character);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Not a number in Unicode character name: " + name);
                        character = name;
                    }
                } else if (name.startsWith("u")) {
                    try {
                        int characterCode = Integer.parseInt(name.substring(1), 16);
                        if (characterCode > 55295 && characterCode < 57344) {
                            LOG.warn("Unicode character name with not allowed code area: " + name);
                            break block17;
                        }
                        character = String.valueOf((char)characterCode);
                        NAME_TO_CHARACTER.put(name, character);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Not a number in Unicode character name: " + name);
                        character = name;
                    }
                } else if (this.nameToCode.containsKey(name)) {
                    int code = this.nameToCode.get(name);
                    character = Character.toString((char)code);
                } else {
                    character = name;
                }
            }
        }
        return character;
    }

    static {
        Encoding.loadGlyphList("org/apache/pdfbox/resources/glyphlist.txt");
        Encoding.loadGlyphList("org/apache/pdfbox/resources/additional_glyphlist.txt");
        try {
            File external;
            String location = System.getProperty("glyphlist_ext");
            if (location != null && (external = new File(location)).exists()) {
                Encoding.loadGlyphList(location);
            }
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        NAME_TO_CHARACTER.put(NOTDEF, "");
        NAME_TO_CHARACTER.put("fi", "fi");
        NAME_TO_CHARACTER.put("fl", "fl");
        NAME_TO_CHARACTER.put("ffi", "ffi");
        NAME_TO_CHARACTER.put("ff", "ff");
        NAME_TO_CHARACTER.put("pi", "pi");
        for (Map.Entry<String, String> entry : NAME_TO_CHARACTER.entrySet()) {
            CHARACTER_TO_NAME.put(entry.getValue(), entry.getKey());
        }
    }
}

