/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.encoding.StandardEncoding;

public class DictionaryEncoding
extends Encoding {
    private COSDictionary encoding = null;

    public DictionaryEncoding(COSDictionary fontEncoding) throws IOException {
        this.encoding = fontEncoding;
        Encoding baseEncoding = StandardEncoding.INSTANCE;
        COSName baseEncodingName = (COSName)this.encoding.getDictionaryObject(COSName.BASE_ENCODING);
        if (baseEncodingName != null) {
            baseEncoding = EncodingManager.INSTANCE.getEncoding(baseEncodingName);
        }
        this.nameToCode.putAll(baseEncoding.nameToCode);
        this.codeToName.putAll(baseEncoding.codeToName);
        COSArray differences = (COSArray)this.encoding.getDictionaryObject(COSName.DIFFERENCES);
        int currentIndex = -1;
        for (int i2 = 0; differences != null && i2 < differences.size(); ++i2) {
            COSBase next = differences.getObject(i2);
            if (next instanceof COSNumber) {
                currentIndex = ((COSNumber)next).intValue();
                continue;
            }
            if (!(next instanceof COSName)) continue;
            COSName name = (COSName)next;
            this.addCharacterEncoding(currentIndex++, name.getName());
        }
    }

    public COSBase getCOSObject() {
        return this.encoding;
    }
}

