/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageable;

public class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals(PASSWORD)) {
                if (++i2 >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i2];
                continue;
            }
            if (args[i2].equals(PRINTER_NAME)) {
                if (++i2 >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i2];
                continue;
            }
            if (args[i2].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            pdfFile = args[i2];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load(pdfFile);
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printService = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i3 = 0; !printerFound && i3 < printService.length; ++i3) {
                    if (printService[i3].getName().indexOf(printerName) == -1) continue;
                    printJob.setPrintService(printService[i3]);
                    printerFound = true;
                }
            }
            printJob.setPageable(new PDPageable(document, printJob));
            if (silentPrint || printJob.printDialog()) {
                printJob.print();
            }
            Object var11_11 = null;
            if (document == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -silentPrint                 Print without prompting for printer info\n");
        System.exit(1);
    }
}

