/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.encoding.Encoding;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class PostScriptTable
extends TTFTable {
    private float formatType;
    private float italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private long isFixedPitch;
    private long minMemType42;
    private long maxMemType42;
    private long mimMemType1;
    private long maxMemType1;
    private String[] glyphNames = null;
    public static final String TAG = "post";

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.formatType = data.read32Fixed();
        this.italicAngle = data.read32Fixed();
        this.underlinePosition = data.readSignedShort();
        this.underlineThickness = data.readSignedShort();
        this.isFixedPitch = data.readUnsignedInt();
        this.minMemType42 = data.readUnsignedInt();
        this.maxMemType42 = data.readUnsignedInt();
        this.mimMemType1 = data.readUnsignedInt();
        this.maxMemType1 = data.readUnsignedInt();
        if (this.formatType == 1.0f) {
            this.glyphNames = new String[258];
            System.arraycopy(Encoding.MAC_GLYPH_NAMES, 0, this.glyphNames, 0, 258);
        } else if (this.formatType == 2.0f) {
            int i2;
            int numGlyphs = data.readUnsignedShort();
            int[] glyphNameIndex = new int[numGlyphs];
            this.glyphNames = new String[numGlyphs];
            int maxIndex = Integer.MIN_VALUE;
            for (int i3 = 0; i3 < numGlyphs; ++i3) {
                int index;
                glyphNameIndex[i3] = index = data.readUnsignedShort();
                if (index > Short.MAX_VALUE) continue;
                maxIndex = Math.max(maxIndex, index);
            }
            String[] nameArray = null;
            if (maxIndex >= 258) {
                nameArray = new String[maxIndex - 258 + 1];
                for (i2 = 0; i2 < maxIndex - 258 + 1; ++i2) {
                    int numberOfChars = data.readUnsignedByte();
                    nameArray[i2] = data.readString(numberOfChars);
                }
            }
            for (i2 = 0; i2 < numGlyphs; ++i2) {
                int index = glyphNameIndex[i2];
                this.glyphNames[i2] = index < 258 ? Encoding.MAC_GLYPH_NAMES[index] : (index >= 258 && index <= Short.MAX_VALUE ? nameArray[index - 258] : ".undefined");
            }
        } else if (this.formatType == 2.5f) {
            int i4;
            int[] glyphNameIndex = new int[ttf.getNumberOfGlyphs()];
            for (i4 = 0; i4 < glyphNameIndex.length; ++i4) {
                int offset = data.readSignedByte();
                glyphNameIndex[i4] = i4 + 1 + offset;
            }
            this.glyphNames = new String[glyphNameIndex.length];
            for (i4 = 0; i4 < this.glyphNames.length; ++i4) {
                String name = Encoding.MAC_GLYPH_NAMES[glyphNameIndex[i4]];
                if (name == null) continue;
                this.glyphNames[i4] = name;
            }
        } else if (this.formatType == 3.0f) {
            // empty if block
        }
        this.initialized = true;
    }

    public float getFormatType() {
        return this.formatType;
    }

    public void setFormatType(float formatTypeValue) {
        this.formatType = formatTypeValue;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(long isFixedPitchValue) {
        this.isFixedPitch = isFixedPitchValue;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float italicAngleValue) {
        this.italicAngle = italicAngleValue;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(long maxMemType1Value) {
        this.maxMemType1 = maxMemType1Value;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(long maxMemType42Value) {
        this.maxMemType42 = maxMemType42Value;
    }

    public long getMimMemType1() {
        return this.mimMemType1;
    }

    public void setMimMemType1(long mimMemType1Value) {
        this.mimMemType1 = mimMemType1Value;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(long minMemType42Value) {
        this.minMemType42 = minMemType42Value;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short underlinePositionValue) {
        this.underlinePosition = underlinePositionValue;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short underlineThicknessValue) {
        this.underlineThickness = underlineThicknessValue;
    }

    public String[] getGlyphNames() {
        return this.glyphNames;
    }

    public void setGlyphNames(String[] glyphNamesValue) {
        this.glyphNames = glyphNamesValue;
    }
}

