/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List<NameRecord> nameRecords = new ArrayList<NameRecord>();
    private String fontFamily = null;
    private String fontSubFamily = null;
    private String psName = null;

    @Override
    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        NameRecord nr;
        int i2;
        int formatSelector = data.readUnsignedShort();
        int numberOfNameRecords = data.readUnsignedShort();
        int offsetToStartOfStringStorage = data.readUnsignedShort();
        for (i2 = 0; i2 < numberOfNameRecords; ++i2) {
            nr = new NameRecord();
            nr.initData(ttf, data);
            this.nameRecords.add(nr);
        }
        for (i2 = 0; i2 < numberOfNameRecords; ++i2) {
            nr = this.nameRecords.get(i2);
            data.seek(this.getOffset() + 6L + (long)(numberOfNameRecords * 2 * 6) + (long)nr.getStringOffset());
            int platform = nr.getPlatformId();
            int encoding = nr.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            boolean isPlatform310 = false;
            boolean isPlatform10 = false;
            if (platform == 3 && (encoding == 1 || encoding == 0)) {
                charset = "UTF-16";
                isPlatform310 = true;
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "ISO-10646-1";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            } else if (platform == 1 && encoding == 0) {
                isPlatform10 = true;
            }
            String string = data.readString(nr.getStringLength(), charset);
            nr.setString(string);
            int nameID = nr.getNameId();
            if (nameID == 1) {
                if (!isPlatform310 && (!isPlatform10 || this.fontFamily != null)) continue;
                this.fontFamily = string;
                continue;
            }
            if (nameID == 2) {
                if (!isPlatform310 && (!isPlatform10 || this.fontSubFamily != null)) continue;
                this.fontSubFamily = string;
                continue;
            }
            if (nameID != 6 || !isPlatform310 && (!isPlatform10 || this.psName != null)) continue;
            this.psName = string;
        }
        this.initialized = true;
    }

    public List<NameRecord> getNameRecords() {
        return this.nameRecords;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSubFamily() {
        return this.fontSubFamily;
    }

    public String getPSName() {
        return this.psName;
    }
}

