/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.ttf.GlyfCompositeComp;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class GlyfCompositeDescript
extends GlyfDescript {
    private List<GlyfCompositeComp> components = new ArrayList<GlyfCompositeComp>();
    private GlyphData[] glyphs = null;
    private boolean beingResolved = false;
    private boolean resolved = false;

    public GlyfCompositeDescript(TTFDataStream bais, GlyphTable glyphTable) throws IOException {
        super((short)-1, bais);
        GlyfCompositeComp comp;
        this.glyphs = glyphTable.getGlyphs();
        do {
            comp = new GlyfCompositeComp(bais);
            this.components.add(comp);
        } while ((comp.getFlags() & 0x20) != 0);
        if ((comp.getFlags() & 0x100) != 0) {
            this.readInstructions(bais, bais.readUnsignedShort());
        }
    }

    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            System.err.println("Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int firstIndex = 0;
        int firstContour = 0;
        for (GlyfCompositeComp comp : this.components) {
            comp.setFirstIndex(firstIndex);
            comp.setFirstContour(firstContour);
            GlyphDescription desc = this.getGlypDescription(comp.getGlyphIndex());
            if (desc == null) continue;
            desc.resolve();
            firstIndex += desc.getPointCount();
            firstContour += desc.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    public int getEndPtOfContours(int i2) {
        GlyfCompositeComp c2 = this.getCompositeCompEndPt(i2);
        if (c2 != null) {
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            return gd.getEndPtOfContours(i2 - c2.getFirstContour()) + c2.getFirstIndex();
        }
        return 0;
    }

    public byte getFlags(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            return gd.getFlags(i2 - c2.getFirstIndex());
        }
        return 0;
    }

    public short getXCoordinate(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            int n2 = i2 - c2.getFirstIndex();
            short x = gd.getXCoordinate(n2);
            short y = gd.getYCoordinate(n2);
            short x1 = (short)c2.scaleX(x, y);
            x1 = (short)(x1 + c2.getXTranslate());
            return x1;
        }
        return 0;
    }

    public short getYCoordinate(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            int n2 = i2 - c2.getFirstIndex();
            short x = gd.getXCoordinate(n2);
            short y = gd.getYCoordinate(n2);
            short y1 = (short)c2.scaleY(x, y);
            y1 = (short)(y1 + c2.getYTranslate());
            return y1;
        }
        return 0;
    }

    public boolean isComposite() {
        return true;
    }

    public int getPointCount() {
        if (!this.resolved) {
            System.err.println("getPointCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp c2 = this.components.get(this.components.size() - 1);
        return c2.getFirstIndex() + this.getGlypDescription(c2.getGlyphIndex()).getPointCount();
    }

    public int getContourCount() {
        if (!this.resolved) {
            System.err.println("getContourCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp c2 = this.components.get(this.components.size() - 1);
        return c2.getFirstContour() + this.getGlypDescription(c2.getGlyphIndex()).getContourCount();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    private GlyfCompositeComp getCompositeComp(int i2) {
        for (int n2 = 0; n2 < this.components.size(); ++n2) {
            GlyfCompositeComp c2 = this.components.get(n2);
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            if (c2.getFirstIndex() > i2 || i2 >= c2.getFirstIndex() + gd.getPointCount()) continue;
            return c2;
        }
        return null;
    }

    private GlyfCompositeComp getCompositeCompEndPt(int i2) {
        for (int j2 = 0; j2 < this.components.size(); ++j2) {
            GlyfCompositeComp c2 = this.components.get(j2);
            GlyphDescription gd = this.getGlypDescription(c2.getGlyphIndex());
            if (c2.getFirstContour() > i2 || i2 >= c2.getFirstContour() + gd.getContourCount()) continue;
            return c2;
        }
        return null;
    }

    private GlyphDescription getGlypDescription(int index) {
        GlyphData glyph;
        if (this.glyphs != null && index < this.glyphs.length && (glyph = this.glyphs[index]) != null) {
            return glyph.getDescription();
        }
        return null;
    }
}

