/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class CMAPTable
extends TTFTable {
    public static final String TAG = "cmap";
    public static final int PLATFORM_MISC = 0;
    public static final int PLATFORM_MACINTOSH = 1;
    public static final int PLATFORM_WINDOWS = 3;
    public static final int ENCODING_SYMBOL = 0;
    public static final int ENCODING_UNICODE = 1;
    public static final int ENCODING_SHIFT_JIS = 2;
    public static final int ENCODING_BIG5 = 3;
    public static final int ENCODING_PRC = 4;
    public static final int ENCODING_WANSUNG = 5;
    public static final int ENCODING_JOHAB = 6;
    private CMAPEncodingEntry[] cmaps;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int i2;
        int version = data.readUnsignedShort();
        int numberOfTables = data.readUnsignedShort();
        this.cmaps = new CMAPEncodingEntry[numberOfTables];
        for (i2 = 0; i2 < numberOfTables; ++i2) {
            CMAPEncodingEntry cmap = new CMAPEncodingEntry();
            cmap.initData(data);
            this.cmaps[i2] = cmap;
        }
        for (i2 = 0; i2 < numberOfTables; ++i2) {
            this.cmaps[i2].initSubtable(this, ttf.getNumberOfGlyphs(), data);
        }
        this.initialized = true;
    }

    public CMAPEncodingEntry[] getCmaps() {
        return this.cmaps;
    }

    public void setCmaps(CMAPEncodingEntry[] cmapsValue) {
        this.cmaps = cmapsValue;
    }
}

