/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharStringRenderer
extends CharStringHandler {
    private static final Log LOG = LogFactory.getLog(CharStringRenderer.class);
    private boolean isCharstringType1 = true;
    private boolean isFirstCommand = true;
    private GeneralPath path = null;
    private Point2D sidebearingPoint = null;
    private Point2D referencePoint = null;
    private int width = 0;
    private boolean hasNonEndCharOp = false;

    public CharStringRenderer() {
        this.isCharstringType1 = true;
    }

    public CharStringRenderer(boolean isType1) {
        this.isCharstringType1 = isType1;
    }

    public GeneralPath render(List<Object> sequence) {
        this.path = new GeneralPath();
        this.sidebearingPoint = new Point2D.Float(0.0f, 0.0f);
        this.referencePoint = null;
        this.setWidth(0);
        this.handleSequence(sequence);
        return this.path;
    }

    @Override
    public List<Integer> handleCommand(List<Integer> numbers, CharStringCommand command) {
        if (this.isCharstringType1) {
            this.handleCommandType1(numbers, command);
        } else {
            this.handleCommandType2(numbers, command);
        }
        return null;
    }

    private void handleCommandType2(List<Integer> numbers, CharStringCommand command) {
        String name = CharStringCommand.TYPE2_VOCABULARY.get(command.getKey());
        if (!this.hasNonEndCharOp) {
            boolean bl = this.hasNonEndCharOp = !"endchar".equals(name);
        }
        if ("vmoveto".equals(name)) {
            if (this.path.getCurrentPoint() != null) {
                this.closePath();
            }
            if (this.isFirstCommand && numbers.size() == 2) {
                this.setWidth(numbers.get(0));
                this.rmoveTo(0, numbers.get(1));
            } else {
                this.rmoveTo(0, numbers.get(0));
            }
        } else if ("rlineto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 3) {
                this.setWidth(numbers.get(0));
            }
            this.rrlineTo(numbers);
        } else if ("hlineto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 2) {
                this.setWidth(numbers.get(0));
            }
            this.hlineTo(numbers);
        } else if ("vlineto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 2) {
                this.setWidth(numbers.get(0));
            }
            this.vlineTo(numbers);
        } else if ("rrcurveto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 7) {
                this.setWidth(numbers.get(0));
            }
            this.rrCurveTo(numbers);
        } else if ("rlinecurve".equals(name)) {
            this.rlineCurve(numbers);
        } else if ("rcurveline".equals(name)) {
            this.rcurveLine(numbers);
        } else if ("closepath".equals(name)) {
            this.closePath();
        } else if ("rmoveto".equals(name)) {
            if (this.path.getCurrentPoint() != null) {
                this.closePath();
            }
            if (this.isFirstCommand && numbers.size() == 3) {
                this.setWidth(numbers.get(0));
                this.rmoveTo(numbers.get(1), numbers.get(2));
            } else {
                this.rmoveTo(numbers.get(0), numbers.get(1));
            }
        } else if ("hmoveto".equals(name)) {
            if (this.path.getCurrentPoint() != null) {
                this.closePath();
            }
            if (this.isFirstCommand && numbers.size() == 2) {
                this.setWidth(numbers.get(0));
                this.rmoveTo(numbers.get(1), 0);
            } else {
                this.rmoveTo(numbers.get(0), 0);
            }
        } else if ("vhcurveto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 5) {
                this.setWidth(numbers.get(0));
            }
            this.rvhCurveTo(numbers);
        } else if ("hvcurveto".equals(name)) {
            if (this.isFirstCommand && numbers.size() == 5) {
                this.setWidth(numbers.get(0));
            }
            this.rhvCurveTo(numbers);
        } else if ("hhcurveto".equals(name)) {
            this.rhhCurveTo(numbers);
        } else if ("vvcurveto".equals(name)) {
            this.rvvCurveTo(numbers);
        } else if ("hstem".equals(name)) {
            if (numbers.size() % 2 == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("vstem".equals(name)) {
            if (numbers.size() % 2 == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("hstemhm".equals(name)) {
            if (numbers.size() % 2 == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("vstemhm".equals(name)) {
            if (numbers.size() % 2 == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("cntrmask".equals(name)) {
            if (numbers.size() == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("hintmask".equals(name)) {
            if (numbers.size() == 1) {
                this.setWidth(numbers.get(0));
            }
        } else if ("endchar".equals(name)) {
            if (this.hasNonEndCharOp) {
                this.closePath();
            }
            if (numbers.size() % 2 == 1) {
                this.setWidth(numbers.get(0));
                if (numbers.size() > 1) {
                    LOG.debug("endChar: too many numbers left, using the first one, see PDFBOX-1501 for details");
                }
            }
        }
        if (this.isFirstCommand) {
            this.isFirstCommand = false;
        }
    }

    private void handleCommandType1(List<Integer> numbers, CharStringCommand command) {
        String name = CharStringCommand.TYPE1_VOCABULARY.get(command.getKey());
        if ("vmoveto".equals(name)) {
            this.rmoveTo(0, numbers.get(0));
        } else if ("rlineto".equals(name)) {
            this.rlineTo(numbers.get(0), numbers.get(1));
        } else if ("hlineto".equals(name)) {
            this.rlineTo(numbers.get(0), 0);
        } else if ("vlineto".equals(name)) {
            this.rlineTo(0, numbers.get(0));
        } else if ("rrcurveto".equals(name)) {
            this.rrcurveTo(numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), numbers.get(4), numbers.get(5));
        } else if ("closepath".equals(name)) {
            this.closePath();
        } else if ("sbw".equals(name)) {
            this.pointSb(numbers.get(0), numbers.get(1));
            this.setWidth(numbers.get(2));
        } else if ("hsbw".equals(name)) {
            this.pointSb(numbers.get(0), 0);
            this.setWidth(numbers.get(1));
        } else if ("rmoveto".equals(name)) {
            this.rmoveTo(numbers.get(0), numbers.get(1));
        } else if ("hmoveto".equals(name)) {
            this.rmoveTo(numbers.get(0), 0);
        } else if ("vhcurveto".equals(name)) {
            this.rrcurveTo(0, numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), 0);
        } else if ("hvcurveto".equals(name)) {
            this.rrcurveTo(numbers.get(0), 0, numbers.get(1), numbers.get(2), 0, numbers.get(3));
        }
    }

    private void rmoveTo(Number dx, Number dy) {
        Point2D point = this.referencePoint;
        if (point == null && (point = this.path.getCurrentPoint()) == null) {
            point = this.sidebearingPoint;
        }
        this.referencePoint = null;
        this.path.moveTo((float)(point.getX() + dx.doubleValue()), (float)(point.getY() + dy.doubleValue()));
    }

    private void hlineTo(List<Integer> numbers) {
        for (int i2 = 0; i2 < numbers.size(); ++i2) {
            if (i2 % 2 == 0) {
                this.rlineTo(numbers.get(i2), 0);
                continue;
            }
            this.rlineTo(0, numbers.get(i2));
        }
    }

    private void vlineTo(List<Integer> numbers) {
        for (int i2 = 0; i2 < numbers.size(); ++i2) {
            if (i2 % 2 == 0) {
                this.rlineTo(0, numbers.get(i2));
                continue;
            }
            this.rlineTo(numbers.get(i2), 0);
        }
    }

    private void rlineTo(Number dx, Number dy) {
        Point2D point = this.path.getCurrentPoint();
        this.path.lineTo((float)(point.getX() + dx.doubleValue()), (float)(point.getY() + dy.doubleValue()));
    }

    private void rrlineTo(List<Integer> numbers) {
        for (int i2 = 0; i2 < numbers.size(); i2 += 2) {
            this.rlineTo(numbers.get(i2), numbers.get(i2 + 1));
        }
    }

    private void rrCurveTo(List<Integer> numbers) {
        if (numbers.size() >= 6) {
            for (int i2 = 0; i2 < numbers.size(); i2 += 6) {
                float x1 = numbers.get(i2).intValue();
                float y1 = numbers.get(i2 + 1).intValue();
                float x2 = numbers.get(i2 + 2).intValue();
                float y2 = numbers.get(i2 + 3).intValue();
                float x3 = numbers.get(i2 + 4).intValue();
                float y3 = numbers.get(i2 + 5).intValue();
                this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
            }
        }
    }

    private void rrcurveTo(Number dx1, Number dy1, Number dx2, Number dy2, Number dx3, Number dy3) {
        Point2D point = this.path.getCurrentPoint();
        float x1 = (float)point.getX() + dx1.floatValue();
        float y1 = (float)point.getY() + dy1.floatValue();
        float x2 = x1 + dx2.floatValue();
        float y2 = y1 + dy2.floatValue();
        float x3 = x2 + dx3.floatValue();
        float y3 = y2 + dy3.floatValue();
        this.path.curveTo(x1, y1, x2, y2, x3, y3);
    }

    private void rlineCurve(List<Integer> numbers) {
        if (numbers.size() >= 6) {
            if (numbers.size() - 6 > 0) {
                for (int i2 = 0; i2 < numbers.size() - 6 && i2 + 1 < numbers.size(); i2 += 2) {
                    this.rlineTo(numbers.get(i2), numbers.get(i2 + 1));
                }
            }
            float x1 = numbers.get(numbers.size() - 6).intValue();
            float y1 = numbers.get(numbers.size() - 5).intValue();
            float x2 = numbers.get(numbers.size() - 4).intValue();
            float y2 = numbers.get(numbers.size() - 3).intValue();
            float x3 = numbers.get(numbers.size() - 2).intValue();
            float y3 = numbers.get(numbers.size() - 1).intValue();
            this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
        }
    }

    private void rcurveLine(List<Integer> numbers) {
        for (int i2 = 0; i2 < numbers.size() && numbers.size() - i2 >= 6; i2 += 6) {
            float x1 = numbers.get(i2).intValue();
            float y1 = numbers.get(i2 + 1).intValue();
            float x2 = numbers.get(i2 + 2).intValue();
            float y2 = numbers.get(i2 + 3).intValue();
            float x3 = numbers.get(i2 + 4).intValue();
            float y3 = numbers.get(i2 + 5).intValue();
            this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
            if (numbers.size() - (i2 + 6) != 2) continue;
            this.rlineTo(numbers.get(i2 + 6), numbers.get(i2 + 7));
        }
    }

    private void rvhCurveTo(List<Integer> numbers) {
        boolean odd;
        boolean smallCase = numbers.size() <= 5;
        boolean bl = odd = numbers.size() % 2 != 0;
        if (!odd ? numbers.size() % 4 == 0 : (numbers.size() - 1) % 4 == 0) {
            float lastY = -1.0f;
            for (int i2 = 0; i2 < numbers.size() && numbers.size() - i2 >= 4; i2 += 4) {
                float y3;
                float x1 = lastY != -1.0f ? (float)numbers.get(i2).intValue() : 0.0f;
                float y1 = lastY != -1.0f ? 0.0f : (float)numbers.get(i2).intValue();
                float x2 = numbers.get(i2 + 1).intValue();
                float y2 = numbers.get(i2 + 2).intValue();
                float x3 = lastY != -1.0f ? 0.0f : (float)numbers.get(i2 + 3).intValue();
                float f2 = y3 = lastY != -1.0f ? (float)numbers.get(i2 + 3).intValue() : 0.0f;
                if (odd && numbers.size() - i2 == 5) {
                    if (smallCase) {
                        y3 = numbers.get(i2 + 4).intValue();
                    } else {
                        x3 = numbers.get(i2 + 4).intValue();
                    }
                }
                this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
                if (lastY != -1.0f) {
                    if (numbers.size() - (i2 + 4) <= 0) break;
                    this.rvhCurveTo(numbers.subList(i2 + 4, numbers.size()));
                    break;
                }
                lastY = 0.0f;
            }
        }
    }

    private void rhvCurveTo(List<Integer> numbers) {
        boolean odd;
        boolean smallCase = numbers.size() <= 5;
        boolean bl = odd = numbers.size() % 2 != 0;
        if (!odd ? numbers.size() % 4 == 0 : (numbers.size() - 1) % 4 == 0) {
            float lastX = -1.0f;
            for (int i2 = 0; i2 < numbers.size() && numbers.size() - i2 >= 4; i2 += 4) {
                float y3;
                float x1 = lastX != -1.0f ? 0.0f : (float)numbers.get(i2).intValue();
                float y1 = lastX != -1.0f ? (float)numbers.get(i2).intValue() : 0.0f;
                float x2 = numbers.get(i2 + 1).intValue();
                float y2 = numbers.get(i2 + 2).intValue();
                float x3 = lastX != -1.0f ? (float)numbers.get(i2 + 3).intValue() : 0.0f;
                float f2 = y3 = lastX != -1.0f ? 0.0f : (float)numbers.get(i2 + 3).intValue();
                if (odd && numbers.size() - i2 == 5) {
                    if (smallCase) {
                        x3 = numbers.get(i2 + 4).intValue();
                    } else {
                        y3 = numbers.get(i2 + 4).intValue();
                    }
                }
                this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
                if (lastX != -1.0f) {
                    if (numbers.size() - (i2 + 4) <= 0) break;
                    this.rhvCurveTo(numbers.subList(i2 + 4, numbers.size()));
                    break;
                }
                lastX = 0.0f;
            }
        }
    }

    private void rhhCurveTo(List<Integer> numbers) {
        boolean odd;
        boolean bl = odd = numbers.size() % 2 != 0;
        if (!odd ? numbers.size() % 4 == 0 : (numbers.size() - 1) % 4 == 0) {
            float lastY = -1.0f;
            boolean bHandled = false;
            int increment = odd ? 1 : 0;
            for (int i2 = 0; i2 < numbers.size() && numbers.size() - i2 >= 4; i2 += 4) {
                float x1 = (odd && !bHandled ? numbers.get(i2 + increment) : numbers.get(i2)).intValue();
                float y1 = lastY != -1.0f ? lastY : (odd && !bHandled ? (float)numbers.get(i2).intValue() : 0.0f);
                float x2 = numbers.get(i2 + 1 + increment).intValue();
                float y2 = numbers.get(i2 + 2 + increment).intValue();
                float x3 = numbers.get(i2 + 3 + increment).intValue();
                float y3 = 0.0f;
                this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
                lastY = 0.0f;
                if (odd && !bHandled) {
                    ++i2;
                    bHandled = true;
                }
                increment = 0;
            }
        }
    }

    private void rvvCurveTo(List<Integer> numbers) {
        boolean odd;
        boolean bl = odd = numbers.size() % 2 != 0;
        if (!odd ? numbers.size() % 4 == 0 : (numbers.size() - 1) % 4 == 0) {
            boolean bHandled = false;
            int increment = odd ? 1 : 0;
            for (int i2 = 0; i2 < numbers.size() && numbers.size() - i2 >= 4; i2 += 4) {
                float x1 = odd && !bHandled ? (float)numbers.get(i2).intValue() : 0.0f;
                float y1 = numbers.get(i2 + increment).intValue();
                float x2 = numbers.get(i2 + 1 + increment).intValue();
                float y2 = numbers.get(i2 + 2 + increment).intValue();
                float x3 = 0.0f;
                float y3 = numbers.get(i2 + 3 + increment).intValue();
                this.rrcurveTo(Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
                if (odd && !bHandled) {
                    ++i2;
                    bHandled = true;
                }
                increment = 0;
            }
        }
    }

    private void closePath() {
        this.referencePoint = this.path.getCurrentPoint();
        this.path.closePath();
    }

    private void pointSb(Number x, Number y) {
        this.sidebearingPoint = new Point2D.Float(x.floatValue(), y.floatValue());
    }

    public Rectangle2D getBounds() {
        return this.path.getBounds2D();
    }

    public int getWidth() {
        return this.width;
    }

    private void setWidth(int aWidth) {
        this.width = aWidth;
    }
}

