/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.optim.univariate.BracketFinder;
import org.apache.commons.math3.optim.univariate.BrentOptimizer;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.SimpleUnivariateValueChecker;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowellOptimizer
extends MultivariateOptimizer {
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;
    private final LineSearch line;

    public PowellOptimizer(double rel, double abs, ConvergenceChecker<PointValuePair> checker) {
        this(rel, abs, FastMath.sqrt(rel), FastMath.sqrt(abs), checker);
    }

    public PowellOptimizer(double rel, double abs, double lineRel, double lineAbs, ConvergenceChecker<PointValuePair> checker) {
        super(checker);
        if (rel < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(rel, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (abs <= 0.0) {
            throw new NotStrictlyPositiveException(abs);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = abs;
        this.line = new LineSearch(lineRel, lineAbs);
    }

    public PowellOptimizer(double rel, double abs) {
        this(rel, abs, null);
    }

    public PowellOptimizer(double rel, double abs, double lineRel, double lineAbs) {
        this(rel, abs, lineRel, lineAbs, null);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        GoalType goal = this.getGoalType();
        double[] guess = this.getStartPoint();
        int n2 = guess.length;
        double[][] direc = new double[n2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            direc[i2][i2] = 1.0;
        }
        ConvergenceChecker<PointValuePair> checker = this.getConvergenceChecker();
        double[] x = guess;
        double fVal = this.computeObjectiveValue(x);
        double[] x1 = (double[])x.clone();
        while (true) {
            this.incrementIterationCount();
            double fX = fVal;
            double fX2 = 0.0;
            double delta = 0.0;
            int bigInd = 0;
            double alphaMin = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                double[] d2 = MathArrays.copyOf(direc[i3]);
                fX2 = fVal;
                UnivariatePointValuePair optimum = this.line.search(x, d2);
                fVal = optimum.getValue();
                alphaMin = optimum.getPoint();
                double[][] result = this.newPointAndDirection(x, d2, alphaMin);
                x = result[0];
                if (!(fX2 - fVal > delta)) continue;
                delta = fX2 - fVal;
                bigInd = i3;
            }
            boolean stop = 2.0 * (fX - fVal) <= this.relativeThreshold * (FastMath.abs(fX) + FastMath.abs(fVal)) + this.absoluteThreshold;
            PointValuePair previous = new PointValuePair(x1, fX);
            PointValuePair current = new PointValuePair(x, fVal);
            if (!stop && checker != null) {
                stop = checker.converged(this.getIterations(), previous, current);
            }
            if (stop) {
                if (goal == GoalType.MINIMIZE) {
                    return fVal < fX ? current : previous;
                }
                return fVal > fX ? current : previous;
            }
            double[] d3 = new double[n2];
            double[] x2 = new double[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                d3[i4] = x[i4] - x1[i4];
                x2[i4] = 2.0 * x[i4] - x1[i4];
            }
            x1 = (double[])x.clone();
            fX2 = this.computeObjectiveValue(x2);
            if (!(fX > fX2)) continue;
            double t = 2.0 * (fX + fX2 - 2.0 * fVal);
            double temp = fX - fVal - delta;
            t *= temp * temp;
            temp = fX - fX2;
            if (!((t -= delta * temp * temp) < 0.0)) continue;
            UnivariatePointValuePair optimum = this.line.search(x, d3);
            fVal = optimum.getValue();
            alphaMin = optimum.getPoint();
            double[][] result = this.newPointAndDirection(x, d3, alphaMin);
            x = result[0];
            int lastInd = n2 - 1;
            direc[bigInd] = direc[lastInd];
            direc[lastInd] = result[1];
        }
    }

    private double[][] newPointAndDirection(double[] p, double[] d2, double optimum) {
        int n2 = p.length;
        double[] nP = new double[n2];
        double[] nD = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nD[i2] = d2[i2] * optimum;
            nP[i2] = p[i2] + nD[i2];
        }
        double[][] result = new double[][]{nP, nD};
        return result;
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }

    private class LineSearch
    extends BrentOptimizer {
        private static final double REL_TOL_UNUSED = 1.0E-15;
        private static final double ABS_TOL_UNUSED = Double.MIN_VALUE;
        private final BracketFinder bracket;

        LineSearch(double rel, double abs) {
            super(1.0E-15, Double.MIN_VALUE, new SimpleUnivariateValueChecker(rel, abs));
            this.bracket = new BracketFinder();
        }

        public UnivariatePointValuePair search(final double[] p, final double[] d2) {
            final int n2 = p.length;
            UnivariateFunction f2 = new UnivariateFunction(){

                public double value(double alpha) {
                    double[] x = new double[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        x[i2] = p[i2] + alpha * d2[i2];
                    }
                    double obj = PowellOptimizer.this.computeObjectiveValue(x);
                    return obj;
                }
            };
            GoalType goal = PowellOptimizer.this.getGoalType();
            this.bracket.search(f2, goal, 0.0, 1.0);
            return this.optimize(new MaxEval(Integer.MAX_VALUE), new UnivariateObjectiveFunction(f2), goal, new SearchInterval(this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid()));
        }
    }
}

