/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;

public class Sinc
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private static final double SHORTCUT = 0.006;
    private final boolean normalized;

    public Sinc() {
        this(false);
    }

    public Sinc(boolean normalized) {
        this.normalized = normalized;
    }

    public double value(double x) {
        double scaledX;
        double d2 = scaledX = this.normalized ? Math.PI * x : x;
        if (FastMath.abs(scaledX) <= 0.006) {
            double scaledX2 = scaledX * scaledX;
            return ((scaledX2 - 20.0) * scaledX2 + 120.0) / 120.0;
        }
        return FastMath.sin(scaledX) / scaledX;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
        double scaledX = (this.normalized ? Math.PI : 1.0) * t.getValue();
        double scaledX2 = scaledX * scaledX;
        double[] f2 = new double[t.getOrder() + 1];
        if (FastMath.abs(scaledX) <= 0.006) {
            for (int i2 = 0; i2 < f2.length; ++i2) {
                int k2 = i2 / 2;
                f2[i2] = (i2 & 1) == 0 ? (double)((k2 & 1) == 0 ? 1 : -1) * (1.0 / (double)(i2 + 1) - scaledX2 * (1.0 / (double)(2 * i2 + 6) - scaledX2 / (double)(24 * i2 + 120))) : ((k2 & 1) == 0 ? -scaledX : scaledX) * (1.0 / (double)(i2 + 2) - scaledX2 * (1.0 / (double)(6 * i2 + 24) - scaledX2 / (double)(120 * i2 + 720)));
            }
        } else {
            double inv = 1.0 / scaledX;
            double cos = FastMath.cos(scaledX);
            double sin = FastMath.sin(scaledX);
            f2[0] = inv * sin;
            double[] sc = new double[f2.length];
            sc[0] = 1.0;
            double coeff = inv;
            for (int n2 = 1; n2 < f2.length; ++n2) {
                int kStart;
                double s = 0.0;
                double c2 = 0.0;
                if ((n2 & 1) == 0) {
                    sc[n2] = 0.0;
                    kStart = n2;
                } else {
                    sc[n2] = sc[n2 - 1];
                    c2 = sc[n2];
                    kStart = n2 - 1;
                }
                for (int k3 = kStart; k3 > 1; k3 -= 2) {
                    sc[k3] = (double)(k3 - n2) * sc[k3] - sc[k3 - 1];
                    s = s * scaledX2 + sc[k3];
                    sc[k3 - 1] = (double)(k3 - 1 - n2) * sc[k3 - 1] + sc[k3 - 2];
                    c2 = c2 * scaledX2 + sc[k3 - 1];
                }
                sc[0] = sc[0] * (double)(-n2);
                s = s * scaledX2 + sc[0];
                f2[n2] = (coeff *= inv) * (s * sin + c2 * scaledX * cos);
            }
        }
        if (this.normalized) {
            double scale = Math.PI;
            int i3 = 1;
            while (i3 < f2.length) {
                int n3 = i3++;
                f2[n3] = f2[n3] * scale;
                scale *= Math.PI;
            }
        }
        return t.compose(f2);
    }
}

