/*
 * Decompiled with CFR 0.152.
 */
package drivers.yamahaec;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String version = "0.1";
    private boolean quitDriver = false;
    private String BASEURL = "/YamahaExtendedControl/v1/";
    private String name = null;
    public int port = 80;
    public String host = "0.0.0.0";
    private String inputs = "";

    public boolean init(String name, HashMap<String, String> config) {
        block20: {
            String responseCode;
            JSONObject obj;
            String resp;
            super.init(name);
            this.name = name;
            try {
                this.port = Integer.parseInt(config.get("port"));
                this.host = config.get("host");
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host and port ignored");
            }
            this.messageLog(String.valueOf(name) + ": driver started, version " + this.version + " | connecting to host: " + this.host + " port: " + this.port);
            try {
                resp = userBase.urlGet("http://" + this.host + ":" + this.port + this.BASEURL + "system/getFeatures", null, null);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": command: " + "http://" + this.host + ":" + this.port + this.BASEURL + "system/getFeatures");
                    this.messageLog(String.valueOf(name) + ": resp: " + resp);
                }
                if (!(resp = this.getJSON(resp)).equalsIgnoreCase("error")) {
                    obj = new JSONObject(resp);
                    responseCode = obj.get("response_code").toString();
                    this.messageLog("getFeatures: response code " + responseCode);
                    if ("0".equals(responseCode)) {
                        String system = obj.get("system").toString();
                        obj = new JSONObject(system);
                        JSONArray arr = obj.getJSONArray("input_list");
                        String labels = "";
                        String values = "";
                        int i2 = 0;
                        while (i2 < arr.length()) {
                            obj = arr.getJSONObject(i2);
                            String input = obj.get("id").toString();
                            labels = String.valueOf(labels) + "," + input;
                            values = String.valueOf(values) + "," + input;
                            ++i2;
                        }
                        this.inputs = labels;
                        userBase.uiSet(String.valueOf(name) + ".input", "labels", labels);
                        userBase.uiSet(String.valueOf(name) + ".input", "values", values);
                    } else {
                        this.messageLog("error in getFeatures, response code: " + responseCode);
                    }
                } else {
                    this.messageLog("error in getFeatures");
                }
            }
            catch (Exception e3) {
                this.messageLog("exception in getFeatures");
            }
            try {
                resp = userBase.urlGet("http://" + this.host + ":" + this.port + this.BASEURL + "system/getDeviceInfo", null, null);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": command: " + "http://" + this.host + ":" + this.port + this.BASEURL + "system/getDeviceInfo");
                    this.messageLog(String.valueOf(name) + ": resp: " + resp);
                }
                if (!(resp = this.getJSON(resp)).equalsIgnoreCase("error")) {
                    obj = new JSONObject(resp);
                    responseCode = obj.get("response_code").toString();
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(name) + ": response code " + responseCode);
                    }
                    if ("0".equals(responseCode)) {
                        this.ioWrite("model.name", obj.get("model_name").toString());
                        this.ioWrite("device.id", obj.get("device_id").toString());
                        this.ioWrite("system.version", obj.get("system_version").toString());
                        this.ioWrite("api.version", obj.get("api_version").toString());
                        this.ioWrite("connection", "online");
                    } else {
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(name) + ": error in getDeviceInfo, response code: " + responseCode);
                            this.quitDriver = true;
                        }
                        this.quitDriver = true;
                    }
                } else if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": error in getDeviceInfo");
                    this.quitDriver = true;
                }
            }
            catch (Exception e4) {
                if (!this.isVerboseLog()) break block20;
                this.messageLog(String.valueOf(name) + ": exception in getDeviceInfo");
                this.quitDriver = true;
            }
        }
        return true;
    }

    public boolean loop() {
        if (this.quitDriver) {
            return false;
        }
        try {
            String mute;
            String power;
            String resp = userBase.urlGet("http://" + this.host + ":" + this.port + this.BASEURL + "main/getStatus", null, null);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": command: " + "http://" + this.host + ":" + this.port + this.BASEURL + "main/getStatus");
                this.messageLog(String.valueOf(this.name) + ": resp: " + resp);
            }
            if (!resp.startsWith("200")) {
                throw new Exception(String.valueOf(this.name) + ": error in getStatus");
            }
            JSONObject json = new JSONObject(this.getJSON(resp));
            String string = power = json.getString("power").equals("on") ? "1" : "0";
            if (power.equals("1")) {
                userBase.uiSet(String.valueOf(this.name) + ".poweron", "visible", "false");
                userBase.uiSet(String.valueOf(this.name) + ".poweroff", "visible", "true");
            } else {
                userBase.uiSet(String.valueOf(this.name) + ".poweron", "visible", "true");
                userBase.uiSet(String.valueOf(this.name) + ".poweroff", "visible", "false");
            }
            String string2 = mute = json.getBoolean("mute") ? "1" : "0";
            if (mute.equals("1")) {
                userBase.uiSet(String.valueOf(this.name) + ".mute", "visible", "false");
                userBase.uiSet(String.valueOf(this.name) + ".unmute", "visible", "true");
            } else {
                userBase.uiSet(String.valueOf(this.name) + ".mute", "visible", "true");
                userBase.uiSet(String.valueOf(this.name) + ".unmute", "visible", "false");
            }
            int volume = json.getInt("volume");
            userBase.uiSet(String.valueOf(this.name) + ".volume", "value", String.valueOf(volume));
            int sleep = json.getInt("sleep");
            userBase.uiSet(String.valueOf(this.name) + ".sleep", "value", String.valueOf(sleep));
            String input = json.getString("input");
            userBase.uiSet(String.valueOf(this.name) + ".input", "value", input);
            this.ioWrite("power", power);
            this.ioWrite("sleep", "" + sleep);
            this.ioWrite("volume", "" + volume);
            this.ioWrite("mute", mute);
            this.ioWrite("input", input);
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - exception in getStatus - " + e2.getMessage());
        }
        this.sleep(1000L);
        return true;
    }

    public boolean end() {
        this.ioWrite("connection", "offline");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (!id.startsWith("poweron")) break block9;
                                this.ioSet("power", "1");
                                return "!";
                            }
                            if (!id.startsWith("poweroff")) break block10;
                            this.ioSet("power", "0");
                            return "!";
                        }
                        if (!id.startsWith("mute")) break block11;
                        this.ioSet("mute", "1");
                        return "!";
                    }
                    if (!id.startsWith("unmute")) break block12;
                    this.ioSet("mute", "0");
                    return "!";
                }
                if (!id.startsWith("volume")) break block13;
                String volume = id.split("\\.")[1];
                userBase.uiSet(String.valueOf(this.name) + ".volume", "value", volume);
                this.ioSet("volume", volume);
                return "!";
            }
            if (!id.startsWith("input")) break block14;
            String input = id.split("\\.")[1];
            userBase.uiSet(String.valueOf(this.name) + ".input", "value", input);
            this.ioSet("input", input);
            return "!";
        }
        try {
            if (id.startsWith("sleep")) {
                String sleep = id.split("\\.")[1];
                userBase.uiSet(String.valueOf(this.name) + ".input", "value", sleep);
                this.ioSet("sleep", sleep);
                return "!";
            }
        }
        catch (Exception e2) {
            this.errorLog("exception processing command " + id + " - " + e2.getMessage());
        }
        return null;
    }

    public void command(String name, String value) {
        try {
            if (name.equals("power")) {
                if (value.equals("1")) {
                    String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setPower?power=on";
                    Driver.urlGet(url, null, null);
                } else if (value.equals("0")) {
                    String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setPower?power=standby";
                    Driver.urlGet(url, null, null);
                }
            } else if (name.equals("mute")) {
                if (value.equals("1")) {
                    String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setMute?enable=true";
                    Driver.urlGet(url, null, null);
                } else if (value.equals("0")) {
                    String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setMute?enable=false";
                    Driver.urlGet(url, null, null);
                }
            } else if (name.equals("volume")) {
                int volume = Integer.parseInt(value);
                if (volume < 0 || volume > 100) {
                    throw new Exception("volume value not allowed");
                }
                String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setVolume?volume=" + value;
                Driver.urlGet(url, null, null);
            } else if (name.equals("sleep")) {
                int sleep = Integer.parseInt(value);
                if (sleep != 0 && sleep != 30 && sleep != 60 && sleep != 90 && sleep != 120) {
                    throw new Exception("sleep value not allowed");
                }
                String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setSleep?sleep=" + sleep;
                Driver.urlGet(url, null, null);
            } else if (name.equals("input")) {
                if (!this.inputs.contains(value)) {
                    throw new Exception("input value not allowed");
                }
                String url = "http://" + this.host + ":" + this.port + this.BASEURL + "main/setInput?input=" + value;
                Driver.urlGet(url, null, null);
            }
        }
        catch (Exception e2) {
            this.errorLog("exception processing command " + name + " - " + e2.getMessage());
        }
    }

    String getJSON(String s) {
        String newS = s;
        newS = s.startsWith("200:") ? newS.replace("200:", "") : "error";
        return newS;
    }
}

