/*
 * Decompiled with CFR 0.152.
 */
package drivers.vivaldifreenet;

import com.hsyco.driverBase;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[]{"vivaldifreenet"};
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 64;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final long COM_IDLE_MILLIS = 50L;
    private static final String[] SOURCES = new String[]{"--", "RADIO", "CD", "DVD", "TV", "DVR", "AUX1", "AUX2", "MP3", "AUXIN", "MICBASE", "USB", "MICIN", "MICOUT", "BT", "", "", "", "DAB"};
    private String name = null;
    private String comm = null;
    private Hashtable<Integer, Integer> offlineCounter = new Hashtable();
    private HashSet<Integer> online = new HashSet();
    private HashSet<Integer> devices = new HashSet();
    private Hashtable<Integer, byte[]> queryResponseCache = new Hashtable();
    private Hashtable<Integer, byte[]> textResponseRDSDABCache = new Hashtable();
    private Hashtable<Integer, byte[]> textResponseCDCache = new Hashtable();
    private Hashtable<Integer, byte[]> textResponseTRKCache = new Hashtable();
    private Hashtable<Integer, Integer> volumeCache = new Hashtable();
    private BitSet mk3Mode = new BitSet();

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        this.enableSystemtopoDiscovery();
        try {
            String[] addresslist = config.get("addresslist").split("[ ,;]+");
            int i2 = 0;
            while (i2 < addresslist.length) {
                this.devices.add(Integer.parseInt(addresslist[i2]));
                this.deviceSet(100, String.valueOf(addresslist[i2]) + ".power", "", String.valueOf(name.toUpperCase()) + " " + addresslist[i2] + " POWER");
                ++i2;
            }
        }
        catch (Exception e2) {
            this.errorLog("unrecoverable error: addresslist not set or format error");
            return false;
        }
        if (this.devices.size() == 0) {
            this.errorLog("unrecoverable error: addresslist not set");
            return false;
        }
        this.comm = config.get("comm");
        if (this.comm == null) {
            this.errorLog("unrecoverable error: comm port not set");
            return false;
        }
        return true;
    }

    public boolean loop() {
        for (int address : this.devices) {
            if (this.commandQuery(address)) {
                if (!this.online.contains(address)) {
                    this.offlineCounter.put(address, 0);
                    this.online(address);
                }
                switch (this.getSource(address)) {
                    case 1: 
                    case 18: {
                        this.commandRequestTextString(address, 1);
                        break;
                    }
                    case 11: {
                        this.commandRequestTextString(address, 2);
                        this.commandRequestTextString(address, 3);
                    }
                }
                continue;
            }
            Integer i2 = this.offlineCounter.get(address);
            if (i2 == null) {
                this.offlineCounter.put(address, 1);
                continue;
            }
            if (i2 == 4) {
                this.offlineCounter.put(address, i2 + 1);
                this.offline(address);
                continue;
            }
            if (i2 >= 4) continue;
            this.offlineCounter.put(address, i2 + 1);
        }
        this.sleep(50L);
        return true;
    }

    public boolean end() {
        return true;
    }

    public void command(String name, String value) {
        block79: {
            try {
                String[] lnamea = name.toLowerCase().split("[.]");
                String lvalue = value.toLowerCase();
                int address = Integer.parseInt(lnamea[0]);
                String command = lnamea[1];
                if (command.equals("power")) {
                    if (lvalue.equals("1") || lvalue.equals("on")) {
                        this.commandWrite(address, 1, 1);
                    } else if (lvalue.equals("0") || lvalue.equals("off")) {
                        this.commandWrite(address, 1, 0);
                    } else if (lvalue.equals("flip")) {
                        this.commandWrite(address, 1, this.getPower(address) == 1 ? 0 : 1);
                    }
                    break block79;
                }
                if (command.equals("volume")) {
                    if (lvalue.equals("off")) {
                        this.commandWrite(address, 2, -1);
                    } else if (lvalue.equals("on")) {
                        Integer ivalue = this.volumeCache.get(address);
                        this.commandWrite(address, 2, ivalue != null ? ivalue : 10);
                    } else if (lvalue.equals("flip")) {
                        if (this.getMute(address) == 1) {
                            Integer ivalue = this.volumeCache.get(address);
                            this.commandWrite(address, 2, ivalue != null ? ivalue : 10);
                        } else {
                            this.commandWrite(address, 2, -1);
                        }
                    } else if (lvalue.equals("+") || lvalue.equals("up")) {
                        Integer ivalue = this.volumeCache.get(address);
                        this.commandWrite(address, 2, ivalue != null ? ivalue + 1 : 10);
                    } else if (lvalue.equals("-") || lvalue.equals("down")) {
                        Integer ivalue = this.volumeCache.get(address);
                        this.commandWrite(address, 2, ivalue != null ? ivalue - 1 : 10);
                    } else {
                        int ivalue = Integer.parseInt(lvalue);
                        if (ivalue >= 0 && ivalue <= 50) {
                            this.commandWrite(address, 2, ivalue);
                        }
                    }
                    break block79;
                }
                if (command.equals("source")) {
                    if (lvalue.equals("flip")) {
                        switch (this.getSource(address)) {
                            case 11: {
                                this.commandWrite(address, 5, 1);
                                break;
                            }
                            case 1: {
                                this.commandWrite(address, 5, 18);
                                break;
                            }
                            case 18: {
                                this.commandWrite(address, 5, 9);
                                break;
                            }
                            case 9: {
                                this.commandWrite(address, 5, 7);
                                break;
                            }
                            case 7: {
                                this.commandWrite(address, 5, 14);
                                break;
                            }
                            case 14: {
                                this.commandWrite(address, 5, 11);
                                break;
                            }
                            default: {
                                this.commandWrite(address, 5, 1);
                                break;
                            }
                        }
                        break block79;
                    }
                    int i2 = 1;
                    while (i2 < SOURCES.length) {
                        if (SOURCES[i2].length() > 0 && SOURCES[i2].equalsIgnoreCase(lvalue)) {
                            this.commandWrite(address, 5, i2);
                            break block79;
                        }
                        ++i2;
                    }
                    break block79;
                }
                if (command.equals("freq")) {
                    if (lvalue.startsWith("m") && lvalue.length() == 2 && lvalue.charAt(1) >= '0' && lvalue.charAt(1) <= '9') {
                        int mem = lvalue.charAt(1) - 48;
                        String s = this.varGet("__HSYCO__VIVALDIFREENET_" + this.name.toUpperCase() + "_" + address + "_M" + mem + "!");
                        if (s != null) {
                            this.commandWrite(address, 10, Integer.parseInt(s) - 875);
                            this.commandWrite(address, 5, 1);
                        }
                    } else if (lvalue.equals("up") || lvalue.equals("+")) {
                        int freq = this.getFreq(address);
                        freq = freq < 875 || freq >= 1080 ? 875 : ++freq;
                        this.commandWrite(address, 10, freq - 875);
                    } else if (lvalue.equals("down") || lvalue.equals("-")) {
                        int freq = this.getFreq(address);
                        freq = freq <= 875 || freq > 1080 ? 1080 : --freq;
                        this.commandWrite(address, 10, freq - 875);
                    } else {
                        int ivalue = Integer.parseInt(lvalue);
                        if (ivalue >= 875 && ivalue <= 1080) {
                            this.commandWrite(address, 10, ivalue - 875);
                        }
                    }
                } else if (command.equals("radio")) {
                    if (lvalue.equals("up") || lvalue.equals("+")) {
                        this.commandMediaControl(address, 5, 2);
                    } else if (lvalue.equals("down") || lvalue.equals("-")) {
                        this.commandMediaControl(address, 5, 1);
                    }
                } else if (command.equals("cd")) {
                    if (lvalue.equals("up") || lvalue.equals("+")) {
                        this.commandMediaControl(address, 1, 2);
                    } else if (lvalue.equals("down") || lvalue.equals("-")) {
                        this.commandMediaControl(address, 1, 1);
                    }
                } else if (command.equals("trk")) {
                    if (lvalue.equals("up") || lvalue.equals("+")) {
                        this.commandMediaControl(address, 2, 2);
                    } else if (lvalue.equals("down") || lvalue.equals("-")) {
                        this.commandMediaControl(address, 2, 1);
                    }
                } else if (command.equals("play")) {
                    if (lvalue.equals("1") || lvalue.equals("play")) {
                        Integer ivalue = this.volumeCache.get(address);
                        this.commandWrite(address, 2, ivalue != null ? ivalue : 10);
                        this.commandMediaControl(address, 3, 1);
                    } else if (lvalue.equals("0") || lvalue.equals("pause")) {
                        this.commandWrite(address, 2, -1);
                        this.commandMediaControl(address, 3, 2);
                    } else if (lvalue.equals("flip")) {
                        if (this.getMute(address) == 1) {
                            Integer ivalue = this.volumeCache.get(address);
                            this.commandWrite(address, 2, ivalue != null ? ivalue : 10);
                            this.commandMediaControl(address, 3, 1);
                        } else {
                            this.commandWrite(address, 2, -1);
                            this.commandMediaControl(address, 3, 2);
                        }
                    }
                } else if (command.equals("high")) {
                    int ivalue = Integer.parseInt(lvalue);
                    if (ivalue >= -10 && ivalue <= 10) {
                        this.commandWrite(address, 3, ivalue + 10);
                    }
                } else if (command.equals("low")) {
                    int ivalue = Integer.parseInt(lvalue);
                    if (ivalue >= -10 && ivalue <= 10) {
                        this.commandWrite(address, 4, ivalue + 10);
                    }
                } else if (command.equals("mid")) {
                    int ivalue = Integer.parseInt(lvalue);
                    if (ivalue >= -10 && ivalue <= 10) {
                        this.commandWrite(address, 11, ivalue + 10);
                    }
                } else if (command.startsWith("m") && command.length() == 2 && command.charAt(1) >= '0' && command.charAt(1) <= '9') {
                    int freq;
                    int mem = command.charAt(1) - 48;
                    int n2 = freq = lvalue.equals("freq") ? this.getFreq(address) : Integer.parseInt(lvalue);
                    if (freq >= 875 && freq <= 1080) {
                        this.varSet("__HSYCO__VIVALDIFREENET_" + this.name.toUpperCase() + "_" + address + "_M" + mem + "!", Integer.toString(freq));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        block20: {
            try {
                String[] ida = id.toLowerCase().split("[.]", 3);
                int address = Integer.parseInt(ida[0]);
                if (ida.length != 3) break block20;
                if (ida[1].equals("nav")) {
                    switch (this.getSource(address)) {
                        case 1: 
                        case 18: {
                            this.command(String.valueOf(ida[0]) + ".radio", ida[2]);
                            break;
                        }
                        case 11: {
                            if (ida[2].equals("up") || ida[2].equals("+")) {
                                this.command(String.valueOf(ida[0]) + ".trk", ida[2]);
                                break;
                            }
                            if (!ida[2].equals("down") && !ida[2].equals("-")) break block20;
                            this.command(String.valueOf(ida[0]) + ".cd", ida[2]);
                        }
                        default: {
                            break;
                        }
                    }
                    break block20;
                }
                if (ida[1].equals("freq")) {
                    if (this.getSource(address) == 1) {
                        if (!ida[2].contains("/")) {
                            this.command(String.valueOf(ida[0]) + "." + ida[1], ida[2].contains(".") ? ida[2].replaceAll("[.]", "") : String.valueOf(ida[2]) + "0");
                        } else if (ida[2].endsWith("/up")) {
                            this.command(String.valueOf(ida[0]) + "." + ida[1], ida[2].substring(0, ida[2].length() - 3));
                            this.uiSet(String.valueOf(address) + ".freq." + ida[2].substring(0, ida[2].indexOf(47)), "blink", "false");
                        } else if (ida[2].endsWith("/stop")) {
                            this.command(String.valueOf(ida[0]) + "." + ida[2].substring(0, ida[2].length() - 5), "freq");
                            this.uiSet(String.valueOf(address) + ".freq." + ida[2].substring(0, ida[2].indexOf(47)), "blink", "false");
                        } else if (ida[2].endsWith("/repeat/1")) {
                            this.uiSet(String.valueOf(address) + ".freq." + ida[2].substring(0, ida[2].indexOf(47)), "blink", "true");
                        }
                    }
                } else {
                    this.command(String.valueOf(ida[0]) + "." + ida[1], ida[2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private synchronized boolean commandQuery(int address) {
        byte[] in;
        block8: {
            block7: {
                block6: {
                    byte[] out = new byte[15];
                    try {
                        Calendar now = Calendar.getInstance();
                        out[0] = (byte)(address == 0 ? -128 : (byte)(address & 0x7F));
                        out[1] = -96;
                        out[2] = 12;
                        out[4] = 1;
                        out[7] = (byte)now.get(11);
                        out[8] = (byte)now.get(12);
                        out[9] = (byte)now.get(5);
                        out[10] = (byte)(now.get(2) + 1);
                        out[11] = (byte)(now.get(1) % 100);
                        out[14] = this.checkSum(address, out);
                        this.sleep(50L);
                        this.readCommBytes(this.comm, 0);
                        this.writeCommBytes(this.comm, out);
                        in = this.readCommBytes(this.comm, 22);
                        if (in != null) break block6;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (in.length != 0) break block7;
                if (!this.online.contains(address)) {
                    this.mk3Mode.flip(address);
                }
                return false;
            }
            if (in.length == 22) break block8;
            return false;
        }
        return this.parseResponse(address, in, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean commandWrite(int address, int paramId, int paramValue) {
        byte[] out = new byte[33];
        int delay = 0;
        try {
            byte[] in;
            Calendar now = Calendar.getInstance();
            out[0] = (byte)(address == 0 ? -128 : (byte)(address & 0x7F));
            out[1] = -96;
            out[2] = 12;
            out[4] = 2;
            switch (paramId) {
                case 1: {
                    out[5] = 0;
                    out[6] = 1;
                    out[7] = (byte)paramValue;
                    break;
                }
                case 2: {
                    out[5] = 0;
                    out[6] = 2;
                    out[8] = paramValue >= 0 ? (int)paramValue : -128;
                    break;
                }
                case 3: {
                    out[5] = 0;
                    out[6] = 4;
                    out[9] = (byte)paramValue;
                    break;
                }
                case 4: {
                    out[5] = 0;
                    out[6] = 8;
                    out[10] = (byte)paramValue;
                    break;
                }
                case 5: {
                    switch (paramValue) {
                        case 1: {
                            delay = 1000;
                            break;
                        }
                        case 18: {
                            delay = 2500;
                            break;
                        }
                    }
                    out[5] = 0;
                    out[6] = 16;
                    out[11] = (byte)paramValue;
                    break;
                }
                case 10: {
                    out[5] = 2;
                    out[6] = 0;
                    out[16] = (byte)paramValue;
                    break;
                }
                case 11: {
                    out[5] = 4;
                    out[6] = 0;
                    out[17] = (byte)paramValue;
                    break;
                }
                default: {
                    return false;
                }
            }
            out[25] = (byte)now.get(11);
            out[26] = (byte)now.get(12);
            out[27] = (byte)now.get(5);
            out[28] = (byte)(now.get(2) + 1);
            out[29] = (byte)(now.get(1) % 100);
            out[32] = this.checkSum(address, out);
            this.sleep(50L);
            this.readCommBytes(this.comm, 0);
            this.writeCommBytes(this.comm, out);
            if (delay > 0) {
                this.sleep(delay);
            }
            return (in = this.readCommBytes(this.comm, 22)) != null && in.length == 22;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private synchronized boolean commandRequestTextString(int address, int type) {
        byte[] in;
        ByteArrayOutputStream inbos;
        block5: {
            block4: {
                byte[] out = new byte[15];
                inbos = new ByteArrayOutputStream();
                try {
                    out[0] = (byte)(address == 0 ? -128 : (byte)(address & 0x7F));
                    out[1] = -96;
                    out[2] = 12;
                    out[4] = 3;
                    out[7] = (byte)type;
                    out[14] = this.checkSum(address, out);
                    this.sleep(50L);
                    this.readCommBytes(this.comm, 0);
                    this.writeCommBytes(this.comm, out);
                    in = this.readCommBytes(this.comm, 3);
                    if (in != null && in.length == 3) break block4;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            byte l2 = in[2];
            inbos.write(in);
            in = this.readCommBytes(this.comm, l2);
            if (in != null && in.length == l2) break block5;
            return false;
        }
        inbos.write(in);
        return this.parseResponse(address, inbos.toByteArray(), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean commandMediaControl(int address, int paramId, int paramValue) {
        byte[] out = new byte[15];
        try {
            out[0] = (byte)(address == 0 ? -128 : (byte)(address & 0x7F));
            out[1] = -96;
            out[2] = 12;
            out[4] = 4;
            switch (paramId) {
                case 1: {
                    out[7] = (byte)paramValue;
                    break;
                }
                case 2: {
                    out[8] = (byte)paramValue;
                    break;
                }
                case 3: {
                    out[9] = (byte)paramValue;
                    break;
                }
                case 5: {
                    out[11] = (byte)paramValue;
                    break;
                }
                default: {
                    return false;
                }
            }
            out[14] = this.checkSum(address, out);
            this.sleep(50L);
            this.readCommBytes(this.comm, 0);
            this.writeCommBytes(this.comm, out);
            byte[] in = this.readCommBytes(this.comm, 10);
            return in != null && in.length == 10;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseResponse(int address, byte[] data, Integer subcommand) {
        block27: {
            block26: {
                if (data[data.length - 1] == this.checkSum(address, data)) break block26;
                return false;
            }
            if (address == data[3]) break block27;
            return false;
        }
        try {
            block28: {
                switch (data[4] & 0x7F) {
                    case 1: {
                        byte[] cache = this.queryResponseCache.get(address);
                        if (cache != null && Arrays.equals(data, cache)) return true;
                        this.queryResponseCache.put(address, data);
                        this.ioWrite(String.valueOf(address) + ".power", data[5] == 1 ? "1" : "0");
                        if ((data[6] & 0x80) > 0) {
                            this.ioWrite(String.valueOf(address) + ".volume", "off");
                        } else {
                            this.volumeCache.put(address, Integer.valueOf(data[6]));
                            this.ioWrite(String.valueOf(address) + ".volume", Integer.toString(data[6]));
                        }
                        this.ioWrite(String.valueOf(address) + ".high", Integer.toString(data[7] - 10));
                        this.ioWrite(String.valueOf(address) + ".low", Integer.toString(data[8] - 10));
                        this.ioWrite(String.valueOf(address) + ".mid", Integer.toString(data[15] - 10));
                        this.ioWrite(String.valueOf(address) + ".source", SOURCES[data[9]].toLowerCase());
                        this.ioWrite(String.valueOf(address) + ".freq", Integer.toString((data[14] & 0xFF) + 875));
                        this.updateDisplay(address);
                        return true;
                    }
                    case 3: {
                        switch (subcommand) {
                            case 1: {
                                byte[] cache = this.textResponseRDSDABCache.get(address);
                                if (cache != null && Arrays.equals(data, cache)) return true;
                                this.textResponseRDSDABCache.put(address, data);
                                StringBuffer sb = new StringBuffer();
                                int i2 = 5;
                                while (i2 < data.length - 1) {
                                    if (data[i2] != 0) {
                                        sb.append((char)data[i2]);
                                    }
                                    ++i2;
                                }
                                if (this.getSource(address) == 18) {
                                    this.ioWrite(String.valueOf(address) + ".dab.text", sb.toString().trim());
                                } else {
                                    this.ioWrite(String.valueOf(address) + ".rds.text", sb.toString().trim());
                                }
                                this.updateDisplay(address);
                                break block28;
                            }
                            case 2: {
                                byte[] cache = this.textResponseCDCache.get(address);
                                if (cache != null && Arrays.equals(data, cache)) return true;
                                this.textResponseCDCache.put(address, data);
                                StringBuffer sb = new StringBuffer();
                                int i3 = 5;
                                while (i3 < data.length - 1) {
                                    if (data[i3] != 0) {
                                        sb.append((char)data[i3]);
                                    }
                                    ++i3;
                                }
                                this.ioWrite(String.valueOf(address) + ".cd.text", sb.toString().trim());
                                this.updateDisplay(address);
                                break block28;
                            }
                            case 3: {
                                byte[] cache = this.textResponseTRKCache.get(address);
                                if (cache != null && Arrays.equals(data, cache)) return true;
                                this.textResponseTRKCache.put(address, data);
                                StringBuffer sb = new StringBuffer();
                                int i4 = 5;
                                while (i4 < data.length - 1) {
                                    if (data[i4] != 0) {
                                        sb.append((char)data[i4]);
                                    }
                                    ++i4;
                                }
                                this.ioWrite(String.valueOf(address) + ".trk.text", sb.toString().trim());
                                this.updateDisplay(address);
                            }
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void updateDisplay(int address) {
        try {
            byte[] data = this.queryResponseCache.get(address);
            if (this.online.contains(address)) {
                if (data[5] == 1) {
                    this.uiSet(String.valueOf(address) + ".source", "visible", "true");
                    this.uiSet(String.valueOf(address) + ".volume", "visible", "true");
                    this.uiSet(String.valueOf(address) + ".source", "text", SOURCES[this.getSource(address)]);
                    if (this.getMute(address) == 1) {
                        this.uiSet(String.valueOf(address) + ".volume", "blink", "true");
                        this.uiSet(String.valueOf(address) + ".volume", "text", Integer.toString(this.volumeCache.get(address)));
                    } else {
                        this.uiSet(String.valueOf(address) + ".volume", "blink", "false");
                        this.uiSet(String.valueOf(address) + ".volume", "text", Integer.toString(this.volumeCache.get(address)));
                    }
                    switch (this.getSource(address)) {
                        case 1: {
                            byte[] cache = this.textResponseRDSDABCache.get(address);
                            if (cache == null) {
                                this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                                this.uiSet(String.valueOf(address) + ".text", "text", "");
                                break;
                            }
                            StringBuffer sb = new StringBuffer();
                            String s = Integer.toString(this.getFreq(address));
                            sb.append(s.substring(0, s.length() - 1));
                            sb.append('.');
                            sb.append(s.substring(s.length() - 1));
                            this.uiSet(String.valueOf(address) + ".freq", "value", sb.toString());
                            this.uiSet(String.valueOf(address) + ".freq", "visible", "true");
                            sb = new StringBuffer();
                            int i2 = 5;
                            while (i2 < cache.length - 1) {
                                if (cache[i2] != 0) {
                                    sb.append((char)cache[i2]);
                                }
                                ++i2;
                            }
                            this.uiSet(String.valueOf(address) + ".text", "text", sb.toString().trim());
                            this.uiSet(String.valueOf(address) + ".text", "visible", "true");
                            break;
                        }
                        case 18: {
                            byte[] cache = this.textResponseRDSDABCache.get(address);
                            this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                            if (cache == null) {
                                this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                                this.uiSet(String.valueOf(address) + ".text", "text", "");
                                break;
                            }
                            StringBuffer sb = new StringBuffer();
                            int i3 = 5;
                            while (i3 < cache.length - 1) {
                                if (cache[i3] != 0) {
                                    sb.append((char)cache[i3]);
                                }
                                ++i3;
                            }
                            this.uiSet(String.valueOf(address) + ".text", "text", sb.toString().trim());
                            this.uiSet(String.valueOf(address) + ".text", "visible", "true");
                            break;
                        }
                        case 11: {
                            this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                            byte[] cache = this.textResponseTRKCache.get(address);
                            if (cache == null) {
                                this.uiSet(String.valueOf(address) + ".text", "text", "");
                                break;
                            }
                            StringBuffer sb = new StringBuffer();
                            int i4 = 5;
                            while (i4 < cache.length - 1) {
                                if (cache[i4] != 0) {
                                    sb.append((char)cache[i4]);
                                }
                                ++i4;
                            }
                            cache = this.textResponseCDCache.get(address);
                            if (cache == null) {
                                this.uiSet(String.valueOf(address) + ".text", "text", "");
                                break;
                            }
                            sb.append(" ");
                            i4 = 5;
                            while (i4 < cache.length - 1) {
                                if (cache[i4] != 0) {
                                    sb.append((char)cache[i4]);
                                }
                                ++i4;
                            }
                            this.uiSet(String.valueOf(address) + ".text", "text", sb.toString().trim());
                            break;
                        }
                        default: {
                            this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                            this.uiSet(String.valueOf(address) + ".text", "text", "");
                            break;
                        }
                    }
                } else {
                    this.uiSet(String.valueOf(address) + ".source", "visible", "false");
                    this.uiSet(String.valueOf(address) + ".volume", "visible", "false");
                    this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                    this.uiSet(String.valueOf(address) + ".text", "text", "OFF");
                }
            } else {
                this.uiSet(String.valueOf(address) + ".source", "visible", "false");
                this.uiSet(String.valueOf(address) + ".volume", "visible", "false");
                this.uiSet(String.valueOf(address) + ".freq", "visible", "false");
                this.uiSet(String.valueOf(address) + ".text", "text", "OFFLINE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void online(int address) {
        this.online.add(address);
        this.ioWrite(String.valueOf(address) + ".status", "online");
        this.updateDisplay(address);
    }

    private void offline(int address) {
        this.online.remove(address);
        this.ioWrite(String.valueOf(address) + ".status", "offline");
        this.updateDisplay(address);
    }

    private byte checkSum(int address, byte[] data) {
        if (this.mk3Mode.get(address)) {
            int crc = 89;
            byte sum = 0;
            int i2 = 0;
            while (i2 < data.length - 1) {
                byte extract = data[i2];
                int j2 = 8;
                while (j2 > 0) {
                    sum = (byte)((crc ^ extract) & 1);
                    crc >>>= 1;
                    if (sum > 0) {
                        crc = (crc ^ 0x8C) & 0xFF;
                    }
                    extract = (byte)(extract >>> 1);
                    --j2;
                }
                ++i2;
            }
            return (byte)crc;
        }
        byte c2 = 85;
        int i3 = 0;
        while (i3 < data.length - 1) {
            c2 = (byte)(c2 ^ data[i3]);
            ++i3;
        }
        return c2;
    }

    private int getFreq(int address) {
        try {
            byte[] data = this.queryResponseCache.get(address);
            return (data[14] & 0xFF) + 875;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private int getMute(int address) {
        try {
            byte[] data = this.queryResponseCache.get(address);
            return (data[6] & 0x80) > 0 ? 1 : 0;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private int getPower(int address) {
        try {
            byte[] data = this.queryResponseCache.get(address);
            return data[5] == 1 ? 1 : 0;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private int getSource(int address) {
        try {
            byte[] data = this.queryResponseCache.get(address);
            return data[5] == 1 ? data[9] : 0;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < data.length) {
                String s = Integer.toHexString(data[i2] & 0xFF);
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
                sb.append(' ');
                ++i2;
            }
            return sb.toString().trim();
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

