/*
 * Decompiled with CFR 0.152.
 */
package drivers.tsecmacs;

import drivers.tsecmacs.Driver;
import drivers.tsecmacs.Utils;
import java.util.HashMap;
import java.util.Map;

public class alarmsUtils {
    public static void setAlarms(String type, int id, int alarms, Driver driver) {
        type = type.toLowerCase().substring(0, type.length() - 1);
        if (alarms != 0) {
            HashMap<Integer, Boolean> error = Utils.genErrorCode(alarms);
            for (Map.Entry<Integer, Boolean> entry : error.entrySet()) {
                Integer key = entry.getKey();
                Boolean value = entry.getValue();
                String err = Utils.toChar(value);
                alarmsUtils.switchCase(type, id, driver, key, err);
            }
            String errValue = "";
            String errValueB = "";
            if (error.containsValue(true)) {
                errValue = "true";
                errValueB = "1";
            } else {
                errValue = "false";
                errValueB = "0";
            }
            driver.ioWrite("alarm", errValueB);
            driver.ioWrite(String.valueOf(type) + "." + id + ".alarm.cumulative", errValueB);
            if (driver.gui.booleanValue()) {
                driver.uiSetVisible("alarm", errValue);
                driver.uiSetVisible(String.valueOf(type) + "." + id + ".alarm.cumulative", errValue);
            }
        } else {
            alarmsUtils.setAllZero(driver, type, id, "0");
        }
    }

    public static void switchCase(String type, int id, Driver driver, int key, String err) {
        String errType = "";
        switch (key) {
            case 0: {
                errType = ".persistent.perturbation.alarm";
                break;
            }
            case 1: {
                errType = ".persistent.perturbation.prealarm";
                break;
            }
            case 2: {
                errType = ".climbing.alarm";
                break;
            }
            case 3: {
                errType = ".climbing.prealarm";
                break;
            }
            case 4: {
                errType = ".remove.alarm";
                break;
            }
            case 5: {
                errType = ".magnetic.attack.alarm";
                break;
            }
            case 7: {
                errType = ".accelerometer.fault";
                break;
            }
            case 8: {
                errType = ".sensor.fault";
                break;
            }
            case 9: {
                errType = ".cut.alarm";
                break;
            }
            case 10: {
                errType = ".sporadic.cut.alarm";
                break;
            }
            case 11: {
                errType = ".cut.prealarm";
                break;
            }
            case 12: {
                errType = ".sporadic.cut.prealarm";
                break;
            }
            case 16: {
                errType = ".communication.with.sensor.failed";
                break;
            }
            case 17: {
                errType = ".sensor.not.found";
                break;
            }
            case 18: {
                errType = ".bus.fault";
                break;
            }
            case 19: {
                errType = ".error.writing.parameters.on.sensor";
                break;
            }
            case 20: {
                errType = ".communication.security.problem";
                break;
            }
            case 21: {
                errType = ".tamper.mas";
                break;
            }
            case 22: {
                errType = ".sd.card.not.inserted.or.damaged";
                break;
            }
            case 23: {
                errType = ".communication.mas-eth.lost";
                break;
            }
            case 24: {
                errType = ".configuration.in.progress";
                break;
            }
            case 25: {
                errType = ".power.supply.problems";
                break;
            }
            case 30: {
                errType = ".consistency.error";
                break;
            }
            case 31: {
                errType = ".zone.or.output.not.use";
            }
        }
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + errType, err);
    }

    private static void setAllZero(Driver driver, String type, int id, String err) {
        driver.ioWrite("alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm.cumulative", err);
        if (driver.gui.booleanValue()) {
            driver.uiSetVisible("alarm", "false");
            driver.uiSetVisible(String.valueOf(type) + "." + id + ".alarm.cumulative", "false");
        }
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".persistent.perturbation.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".persistent.perturbation.prealarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".climbing.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".climbing.prealarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".remove.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".magnetic.attack.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".accelerometer.fault", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".sensor.fault", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".cut.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".sporadic.cut.alarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".cut.prealarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".sporadic.cut.prealarm", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".communication.with.sensor.failed", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".sensor.not.found", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".bus.fault", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".error.writing.parameters.on.sensor", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".communication.security.problem", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".tamper.mas", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".sd.card.not.inserted.or.damaged", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".communication.mas-eth.lost", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".configuration.in.progress", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".power.supply.problems", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".consistency.error", err);
        driver.ioWrite(String.valueOf(type) + "." + id + ".alarm" + ".zone.or.output.not.use", err);
    }
}

