/*
 * Decompiled with CFR 0.152.
 */
package drivers.tsecmacs;

import com.hsyco.hsyco;
import drivers.tsecmacs.Driver;
import drivers.tsecmacs.alarmsUtils;
import drivers.tsecmacs.httpUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static void dataExtractor(Driver driver, HttpURLConnection con, String type) {
        BufferedReader in = null;
        try {
            try {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                JSONObject result = new JSONObject(response.toString());
                JSONArray arr = result.getJSONArray(type);
                if (type.equals("Sensors")) {
                    for (Object o2 : arr) {
                        if (!(o2 instanceof JSONObject)) continue;
                        JSONObject obj = (JSONObject)o2;
                        int id = obj.getInt("Id");
                        int zoneid = obj.getInt("ZoneId");
                        int isenabled = obj.getInt("IsEnable");
                        driver.ioWrite("sensor." + id + ".zoneid", String.valueOf(zoneid));
                        driver.ioWrite("sensor." + id + ".isenabled", String.valueOf(isenabled));
                    }
                } else {
                    for (Object o3 : arr) {
                        if (!(o3 instanceof JSONObject)) continue;
                        JSONObject obj = (JSONObject)o3;
                        int id = obj.getInt("Id");
                        int outputid = obj.getInt("OutputId");
                        String name = obj.getString("Name");
                        driver.ioWrite("zone." + id + ".outputid", String.valueOf(outputid));
                        driver.ioWrite("zone." + id + ".name", name);
                    }
                }
            }
            catch (JSONException f2) {
                hsyco.errorLog("Token json error: " + f2.toString());
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e2) {
                hsyco.errorLog("Exception into stream in request login: " + e2.toString());
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void dataAlarmsExtractor(Driver driver, HttpURLConnection con, String type) {
        BufferedReader in = null;
        try {
            try {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                JSONObject result = new JSONObject(response.toString());
                JSONArray arr = result.getJSONArray(type);
                for (Object o2 : arr) {
                    if (!(o2 instanceof JSONObject)) continue;
                    JSONObject obj = (JSONObject)o2;
                    int id = obj.getInt("Id");
                    int alarms = obj.getInt("Alarms");
                    alarmsUtils.setAlarms(type, id, alarms, driver);
                }
            }
            catch (JSONException f2) {
                hsyco.errorLog("Token json error: " + f2.toString());
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e2) {
                hsyco.errorLog("Exception into stream in request login: " + e2.toString());
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean sesnorStatusExtractor(HttpURLConnection con) {
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            JSONObject result = new JSONObject(response.toString());
            int code = result.getInt("Result");
            switch (code) {
                case 100: {
                    return true;
                }
            }
            return false;
        }
        catch (JSONException f2) {
            hsyco.errorLog("Token json error: " + f2.toString());
        }
        catch (IOException e2) {
            hsyco.errorLog("Exception into stream in request login: " + e2.toString());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loginDataExtractor(Driver driver, HttpURLConnection con, String address, String port, String username, String password) {
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            JSONObject result = new JSONObject(response.toString());
            int code = result.getInt("Result");
            switch (code) {
                case 0: {
                    Utils.getToken(driver, result);
                    return true;
                }
                case 10: {
                    hsyco.errorLog(String.valueOf(driver.driverName) + " - Exception - Login error: User not found");
                    return false;
                }
                case 11: {
                    hsyco.errorLog(String.valueOf(driver.driverName) + " - Exception - Login error: Wrong passowrd");
                    return false;
                }
                case 13: {
                    hsyco.errorLog(String.valueOf(driver.driverName) + " - Exception - Login error: Generic error");
                    return false;
                }
                case 12: {
                    Utils.getToken(driver, result);
                    httpUtils.obtainToken(driver, 2, address, port, username, password);
                    return true;
                }
            }
            return false;
        }
        catch (JSONException f2) {
            hsyco.errorLog("Token json error: " + f2.toString());
            return false;
        }
        catch (IOException e2) {
            hsyco.errorLog("Exception into stream in request login: " + e2.toString());
            return false;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void getToken(Driver driver, JSONObject result) {
        String token = result.getString("Extra");
        driver.setToken(token);
    }

    public static boolean[] reverse(boolean[] array) {
        int maxIndex = array.length - 1;
        int halfLength = array.length / 2;
        int i2 = 0;
        while (i2 < halfLength) {
            boolean temp = array[i2];
            array[i2] = array[maxIndex - i2];
            array[maxIndex - i2] = temp;
            ++i2;
        }
        return array;
    }

    public static HashMap<Integer, Boolean> genErrorCode(int num) {
        boolean[] ret = new boolean[32];
        int i2 = 0;
        while (i2 < 32) {
            ret[31 - i2] = (1 << i2 & num) != 0;
            ++i2;
        }
        HashMap<Integer, Boolean> error = new HashMap<Integer, Boolean>();
        int i3 = 0;
        boolean[] blArray = Utils.reverse(ret);
        int n2 = blArray.length;
        int n3 = 0;
        while (n3 < n2) {
            boolean bool = blArray[n3];
            error.put(i3, bool);
            ++i3;
            ++n3;
        }
        return error;
    }

    public static String toChar(Boolean b2) {
        return b2 == null ? "?" : (b2 != false ? "1" : "0");
    }
}

