/*
 * Decompiled with CFR 0.152.
 */
package drivers.tsecmacs;

import com.hsyco.driverBase;
import drivers.tsecmacs.httpUtils;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    String driverName = null;
    private Boolean genEvent = false;
    Boolean gui = true;
    String username;
    String password;
    private String address;
    private String port;
    private Integer pollingtime = 0;
    private long loopTimemillis = 0L;
    String token;

    public void setToken(String token) {
        this.token = token;
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.driverName = name;
        this.loadConfig(config);
        if (this.port.equals("0")) {
            this.port = String.valueOf(DEFAULTSOCKETPORT);
        }
        if (this.pollingtime == 0) {
            this.pollingtime = 1000;
        }
        if (this.username == null || this.password == null) {
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            this.errorLog(String.valueOf(this.driverName) + " - startup failed - Username or Password is null");
            return false;
        }
        boolean success = httpUtils.obtainToken(this, 0, this.address, this.port, this.username, this.password);
        if (!success) {
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            return false;
        }
        return true;
    }

    public boolean loop() throws InterruptedException {
        long now = System.currentTimeMillis();
        long sleepTime = this.loopTimemillis + (long)this.pollingtime.intValue() - now;
        if (sleepTime > 0L) {
            this.sleep(sleepTime);
            this.loopTimemillis += (long)this.pollingtime.intValue();
        } else {
            this.loopTimemillis = now;
        }
        httpUtils.getData(this, this.address, this.port, "Sensors");
        httpUtils.getData(this, this.address, this.port, "Zones");
        httpUtils.getAlarmsData(this, this.address, this.port, "Sensors");
        httpUtils.getAlarmsData(this, this.address, this.port, "Zones");
        if (!this.genEvent.booleanValue()) {
            this.genEvent = true;
            this.ioWrite("connection", "online");
        }
        return true;
    }

    public boolean end() {
        this.genEvent = true;
        this.ioWrite("connection", "offline");
        return true;
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.genEvent.booleanValue()) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    private void loadConfig(HashMap<String, String> config) {
        try {
            this.username = config.get("user");
            this.password = config.get("password");
            this.address = config.get("host");
            this.port = config.get("port");
            this.gui = Boolean.parseBoolean(config.get("gui"));
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.driverName) + ": WARN ioServersOption some params where ignored");
        }
    }

    public void command(String name, String value) {
        block7: {
            try {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.driverName) + ": command: " + name + " / value: " + value);
                    this.messageLog(String.valueOf(this.driverName) + ": command - subcommand: " + name + " / value: " + value);
                }
                if (name.startsWith("sensor.") && name.endsWith(".isenabled")) {
                    String sernsorNum = name.split("\\.")[1];
                    if (value.equals("1")) {
                        httpUtils.setSensorStatus(this, sernsorNum, "1", this.address, this.port);
                    } else if (value.equals("0")) {
                        httpUtils.setSensorStatus(this, sernsorNum, "0", this.address, this.port);
                    }
                }
            }
            catch (Exception e2) {
                if (!this.isVerboseLog()) break block7;
                this.messageLog(String.valueOf(this.driverName) + " - command failed " + name + ": " + value);
            }
        }
    }

    void uiSetVisible(String name, String value) {
        this.uiSet(name, "visible", value);
    }
}

