/*
 * Decompiled with CFR 0.152.
 */
package drivers.tlabq;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.tlabq.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final String[] WEBOBJECTS = new String[]{"tlabq"};
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 400;
    private boolean startupevents;
    private boolean firstloop = true;
    private boolean gui = true;
    private String name;
    private String username;
    private String password;
    private String host;
    private boolean armed = false;
    private int pollinterval = 1000;
    private int logSize = 400;
    private ArrayList<Log> templogs = new ArrayList();
    private Vector<String> logs;
    private String logsVar;
    private String lastLogVar;
    private Log mostRecentLog;
    private int generalInfoCounter = 0;
    private long lastLogTs = 0L;
    private String httpResp;
    private HashMap<String, String> zones = new HashMap();
    private HashMap<String, Integer> zonesStatus = new HashMap();
    private ConcurrentLinkedQueue<Integer> areas = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                int port = Integer.parseInt(config.get("port"));
                this.host = String.valueOf(inet.getHostName()) + ":" + port;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            if (config.containsKey("gui")) {
                this.gui = Boolean.parseBoolean(config.get("gui"));
            }
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 1000 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            try {
                int n2 = Integer.parseInt(config.get("logsize"));
                if (n2 <= 400) {
                    this.logSize = n2;
                }
            }
            catch (Exception e4) {
                this.messageLog(String.valueOf(name) + ": logsize ignored");
            }
            Log.LANGUAGE = Configuration.language == 1 ? 1 : 0;
            if (this.gui) {
                this.uiSet("connection.offline", "visible", "true");
                this.uiSet("connection.online", "visible", "false");
                this.uiSet("zones.wired.list", "panel", "false");
                this.uiSet("zones.radio.list", "panel", "false");
            }
            int a22 = 1;
            while (a22 <= 4) {
                this.areas.add(a22);
                ++a22;
            }
            Driver a22 = this;
            synchronized (a22) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "ids", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - mQgetObj");
                }
                if (this.httpResp.startsWith("401")) {
                    throw new Exception(String.valueOf(this.name) + " - unauthorized");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readInfo(this.httpResp.substring(4));
            }
            this.sleep(100L);
            a22 = this;
            synchronized (a22) {
                JSONObject json = new JSONObject();
                json.put("method", "m_q_get_zone_names");
                JSONObject params = this.getOrderedJSONObject();
                json.put("params", params);
                json.put("id", "000");
                int idRangeZone = 1;
                while (idRangeZone <= 10) {
                    params.put("range", idRangeZone);
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", json.toString(), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - m_q_get_zone_names");
                    }
                    if (this.httpResp.startsWith("401")) {
                        throw new Exception(String.valueOf(this.name) + " - unauthorized");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    this.readZoneNames(this.httpResp.substring(4));
                    this.sleep(100L);
                    ++idRangeZone;
                }
            }
            this.sleep(100L);
            a22 = this;
            synchronized (a22) {
                JSONArray userIds = new JSONArray();
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "cnfUser", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - cnfUser");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                JSONObject resp = new JSONObject(this.httpResp.substring(4));
                JSONObject result = resp.getJSONObject("result");
                JSONObject cnfUser = result.getJSONObject("cnfUser");
                userIds = cnfUser.getJSONArray("user");
                JSONObject json = new JSONObject();
                json.put("method", "m_q_get_user_base_info");
                JSONObject params = this.getOrderedJSONObject();
                json.put("params", params);
                json.put("id", "000");
                int i2 = 0;
                while (i2 < userIds.length()) {
                    int ursId = userIds.getInt(i2);
                    params.put("id", ursId);
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", json.toString(), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - m_q_get_user_base_info");
                    }
                    if (this.httpResp.startsWith("401")) {
                        throw new Exception(String.valueOf(this.name) + " - unauthorized");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    JSONObject resp2 = new JSONObject(this.httpResp.substring(4));
                    JSONObject result2 = resp2.getJSONObject("result");
                    JSONObject user2 = result2.getJSONObject("user");
                    String usrName = user2.getString("name");
                    this.ioWrite("u" + ursId + ".name", usrName);
                    this.sleep(100L);
                    ++i2;
                }
            }
            this.loadLogs();
            this.readRecordLog();
            this.logsUiSet();
            this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
            return true;
        }
        catch (Exception e5) {
            this.errorLog("Initialization failed - " + e5.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        if (this.generalInfoCounter >= 100) {
            this.generalInfoCounter = 0;
        }
        try {
            if (this.generalInfoCounter++ % 10 == 0) {
                Driver driver = this;
                synchronized (driver) {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "diag", 0), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get general info stauts");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    this.readGeneralStatus(this.httpResp.substring(4));
                }
                this.sleep(100L);
            }
            this.armed = false;
            for (int a2 : this.areas) {
                Driver driver = this;
                synchronized (driver) {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("m_q_get_area", null, a2), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get area status");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    this.readAreaStatus(this.httpResp.substring(4), '\u0000');
                }
                this.sleep(100L);
            }
            this.ioWrite("ins", this.armed ? "1" : "0");
            if (this.gui) {
                this.uiSet("ins", "visible", "" + this.armed);
            }
            this.readRecordLog();
            Driver a2 = this;
            synchronized (a2) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "cnfZone", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get zone status");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readZoneStatus(this.httpResp.substring(4));
            }
            this.sleep(100L);
            a2 = this;
            synchronized (a2) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "cnfOut", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get output status");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readOutputStatus(this.httpResp.substring(4));
            }
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
                this.securityLog(null, "HSYCO ONLINE");
                if (this.gui) {
                    this.uiSet("connection.offline", "visible", "false");
                    this.uiSet("connection.online", "visible", "true");
                    this.uiSet("object.container.areas.tabs", "visible", "" + (this.areas.size() > 1));
                }
            }
            if (this.lastLogTs != 0L && System.currentTimeMillis() > this.lastLogTs + 5000L) {
                this.uiSet("log0", "value", "");
                this.lastLogTs = 0L;
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2);
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog(null, "HSYCO OFFLINE");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        if (Configuration.verboseLog) {
            this.messageLog("User command: " + id);
        }
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String[] cmds = cmd.split("\\.");
        String value = id.substring(sep + 1);
        if (cmds[0].equals("object")) {
            String pin = userBase.uiGet(session, String.valueOf(this.name) + ".object.pin", "_val_");
            if (cmds[1].equals("ins")) {
                if (pin != null) {
                    if (pin.isEmpty()) {
                        pin = null;
                    } else if (value.equals("ok")) {
                        this.uiSet(session, "object.pin", "_ts_", "" + System.currentTimeMillis());
                    } else {
                        long pinTs = 0L;
                        try {
                            pinTs = Long.parseLong(userBase.uiGet(session, String.valueOf(this.name) + ".object.pin", "_ts_"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() > pinTs + 15000L) {
                            pin = null;
                        }
                    }
                }
                if (pin == null) {
                    this.uiSet(session, "object.pin", "_val_", "");
                    this.uiSet(session, "object.pin", "value", "");
                    this.uiSet(session, "object.container.pin", "visible", "true");
                    this.uiSet(session, "object.pin.ok", "name", String.valueOf(this.name) + "." + cmd);
                } else {
                    String dp = cmds[2];
                    if (!cmds[3].equals("t")) {
                        dp = String.valueOf(dp) + ".group." + cmds[3];
                    }
                    dp = String.valueOf(dp) + ".ins";
                    String dpVal = userBase.ioGet(String.valueOf(this.name) + "." + dp).equals("1") ? "0" : "1";
                    this.uiSet(session, "object." + dp, "blink", "true");
                    this.uiSet(session, "object.container.pin", "visible", "false");
                    Integer cmdRes = this.doCommand(dp, String.valueOf(dpVal) + "/" + pin);
                    if (cmdRes == null || cmdRes != 200) {
                        this.uiSet(session, "object.pin", "_val_", "");
                    }
                    this.uiSet(session, "object." + dp, "blink", "false");
                }
            } else if (cmds[1].equals("pin")) {
                if (pin == null) {
                    pin = "";
                }
                if (value.equals("c")) {
                    if (pin.length() > 0) {
                        pin = pin.substring(0, pin.length() - 1);
                    } else {
                        this.uiSet(session, "object.container.pin", "visible", "false");
                    }
                } else if (pin.length() < 6) {
                    pin = String.valueOf(pin) + value;
                }
                this.uiSet(session, "object.pin", "_val_", pin);
                this.uiSet(session, "object.pin", "value", pin.replaceAll(".", "*"));
            }
        }
        return "";
    }

    public void command(String name, String value) {
        this.doCommand(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer doCommand(String cmd, String value) {
        try {
            JSONObject params;
            String id;
            String[] fields;
            JSONObject json = null;
            Integer cmdRes = null;
            char cmdGrId = '\u0000';
            if (cmd.startsWith("a")) {
                JSONArray groups;
                fields = cmd.split("\\.");
                id = fields[0].substring(1);
                json = new JSONObject();
                json.put("method", "m_q_set_area");
                json.put("id", "0000");
                params = this.getOrderedJSONObject();
                params.put("aId", Integer.parseInt(id));
                String[] groupIds = new String[]{"a", "b", "c", "d"};
                if (fields[1].equals("name")) {
                    if (value.length() > 16) {
                        throw new Exception("area name too long (max 16 characters)");
                    }
                    params.put("name", value);
                }
                if (fields[1].equals("ins")) {
                    groups = new JSONArray();
                    String[] val_pin = value.split("/");
                    if (val_pin.length > 1) {
                        params.put("uCode", val_pin[1]);
                    }
                    int val = Integer.parseInt(val_pin[0]);
                    int i2 = 0;
                    while (i2 < 4) {
                        JSONObject group = new JSONObject();
                        String en = userBase.ioGet(String.valueOf(this.name) + "." + "a" + id + ".group." + groupIds[i2] + ".en");
                        if ("1".equals(en)) {
                            group.put("ins", val);
                        }
                        groups.put(i2, group);
                        ++i2;
                    }
                    params.put("grps", groups);
                } else if (fields[1].equals("group")) {
                    groups = new JSONArray();
                    String groupId = fields[2];
                    int i3 = 0;
                    while (i3 < 4) {
                        JSONObject group = new JSONObject();
                        if (groupIds[i3].equals(groupId)) {
                            if (fields[3].equals("name")) {
                                if (value.length() > 16) {
                                    throw new Exception("group name too long (max 16 characters)");
                                }
                                group.put("name", value);
                            } else if (fields[3].equals("ins")) {
                                cmdGrId = groupId.charAt(0);
                                String[] val_pin = value.split("/");
                                int val = Integer.parseInt(val_pin[0]);
                                group.put("ins", val);
                                if (val_pin.length > 1) {
                                    params.put("uCode", val_pin[1]);
                                }
                            }
                        }
                        groups.put(i3, group);
                        ++i3;
                    }
                    params.put("grps", groups);
                }
                json.put("params", params);
            } else if (cmd.startsWith("o")) {
                fields = cmd.split("\\.");
                id = fields[0].substring(1);
                json = new JSONObject();
                json.put("method", "m_q_set_out");
                json.put("id", "0000");
                params = this.getOrderedJSONObject();
                params.put("id", Integer.parseInt(id));
                if (fields.length == 1) {
                    params.put("stat", Integer.parseInt(value));
                } else if (fields[1].equals("name")) {
                    if (value.length() > 16) {
                        throw new Exception("output name too long (max 16 characters)");
                    }
                    params.put("name", value);
                } else if (fields[1].equals("sec")) {
                    params.put("sec", Integer.parseInt(value));
                }
                json.put("params", params);
            }
            int i4 = 0;
            while (i4 < 5) {
                Driver driver = this;
                synchronized (driver) {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", json.toString(), this.username, this.password);
                    if (this.httpResp == null) {
                        this.errorLog(String.valueOf(this.name) + " - error in HTTP POST request");
                    } else if (!this.httpResp.startsWith("200")) {
                        this.errorLog(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    } else {
                        if (cmd.startsWith("a")) {
                            cmdRes = this.readAreaStatus(this.httpResp.substring(4), cmdGrId);
                            if (cmdRes != null && cmdRes != 200) {
                                this.errorLog(String.valueOf(this.name) + " - Command " + cmd + " error: " + cmdRes);
                            }
                        }
                        break;
                    }
                }
                this.sleep(100L);
                ++i4;
            }
            return cmdRes;
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + cmd + ", " + value + " - " + e2.getMessage());
            return null;
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void loadLogs() {
        block12: {
            this.logsVar = "__HSYCO__TLABQ_" + this.name + ".log!";
            this.lastLogVar = "__HSYCO__TLABQ_" + this.name + ".last_log!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(this.logsVar);
                    if (s == null) {
                        this.logs = new Vector(this.logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    this.logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    this.logs = new Vector(this.logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mostRecentLog = Log.readMostRecentLog(userBase.varGet(this.lastLogVar));
    }

    void securityLog(String time, String event) {
        if (time != null) {
            String message = String.valueOf(time) + " - " + event;
            hsyco.securityLog(String.valueOf(this.name) + " - " + message);
            if (this.gui) {
                this.logs.add(0, message);
                this.logsUiSet();
                this.uiSet("log0", "value", message);
                this.lastLogTs = System.currentTimeMillis();
                this.saveLogs();
            }
        } else {
            hsyco.securityLog(String.valueOf(this.name) + " - " + event);
        }
    }

    private void logsUiSet() {
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            String guiEntry = this.logs.get(i2).replace(" - ", "<br>");
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("<hr></div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logsVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private String prepareStatusRequest(String method, String param, int id) {
        try {
            JSONObject json = new JSONObject();
            json.put("method", method);
            JSONObject params = this.getOrderedJSONObject();
            if (method.equals("m_q_get_area")) {
                params.put("aId", id);
            } else if (method.equals("m_q_get_rec")) {
                params.put("ri", Integer.parseInt(param));
                params.put("num", id);
            } else if (method.equals("m_q_get_out")) {
                params.put("id", id);
            } else if (method.equals("mQgetObj")) {
                params.put("oName", param);
            }
            json.put("params", params);
            json.put("id", "000");
            return json.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void readInfo(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject ids = result.getJSONObject("ids");
            if (ids.has("id")) {
                String id = ids.getString("id");
                this.ioWrite("id", id);
            }
            if (ids.has("md")) {
                String model = ids.getString("md");
                this.ioWrite("model", model);
            }
            if (ids.has("fw")) {
                String fw = ids.getString("fw");
                this.ioWrite("fw", fw);
            }
            if (ids.has("db")) {
                int db = ids.getInt("db");
                this.ioWrite("dataconfig", "" + db);
            }
            if (ids.has("ta")) {
                int ta = ids.getInt("ta");
                if (ta == 240) {
                    this.ioWrite("accesstype", "admin");
                } else if (ta == 255) {
                    this.ioWrite("accesstype", "no_valid_access");
                } else {
                    this.ioWrite("accesstype", "" + ta);
                }
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in TLABQ info status - " + e2.getMessage());
        }
    }

    private void readGeneralStatus(String resp) throws Exception {
        try {
            int n2;
            String s;
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject diag = result.getJSONObject("diag");
            boolean fault = false;
            if (diag.has("temp")) {
                s = diag.getString("temp");
                this.ioWrite("temp", s);
            }
            if (diag.has("cred")) {
                s = diag.getString("cred");
                this.ioWrite("credit", s);
            }
            if (diag.has("gsm")) {
                n2 = diag.getInt("gsm");
                this.ioWrite("gsm.fault", "" + n2);
                fault = true;
            } else {
                this.ioWrite("gsm.fault", "0");
            }
            if (diag.has("gsmCau")) {
                n2 = diag.getInt("gsmCau");
                this.ioWrite("gsm.fault.cause", "" + n2);
            }
            if (diag.has("pstn")) {
                n2 = diag.getInt("pstn");
                this.ioWrite("pstn.fault", "" + n2);
                fault = true;
            } else {
                this.ioWrite("pstn.fault", "0");
            }
            if (diag.has("mains")) {
                n2 = diag.getInt("mains");
                this.ioWrite("nopower", "" + n2);
                this.uiSet("nopower", "visible", "true");
            } else {
                this.ioWrite("nopower", "0");
                this.uiSet("nopower", "visible", "false");
            }
            if (diag.has("dNoPwr")) {
                n2 = diag.getInt("dNoPwr");
                this.ioWrite("nopower.device", "" + n2);
            }
            if (diag.has("batt")) {
                n2 = diag.getInt("batt");
                this.ioWrite("batt.fault", "" + n2);
                this.uiSet("batt.fault", "visible", "true");
            } else {
                this.ioWrite("batt.fault", "0");
                this.uiSet("batt.fault", "visible", "false");
            }
            if (diag.has("dBatt")) {
                n2 = diag.getInt("dBatt");
                this.ioWrite("batt.fault.device", "" + n2);
            }
            if (diag.has("tamper")) {
                n2 = diag.getInt("tamper");
                this.ioWrite("tamper", "" + n2);
                this.uiSet("tamper", "visible", "true");
            } else {
                this.ioWrite("tamper", "0");
                this.uiSet("tamper", "visible", "false");
            }
            if (diag.has("dTamper")) {
                n2 = diag.getInt("dTamper");
                this.ioWrite("tamper.device", "" + n2);
            }
            if (diag.has("coerc")) {
                n2 = diag.getInt("coerc");
                this.ioWrite("coercion", "" + n2);
                fault = true;
            } else {
                this.ioWrite("coercion", "0");
            }
            if (diag.has("uCoerc")) {
                n2 = diag.getInt("uCoerc");
                this.ioWrite("coercion.user", "" + n2);
            }
            if (diag.has("rfI")) {
                n2 = diag.getInt("rfI");
                this.ioWrite("radiointerference", "" + n2);
                fault = true;
            } else {
                this.ioWrite("radiointerference", "0");
            }
            if (diag.has("zr")) {
                n2 = diag.getInt("zr");
                this.ioWrite("radiozone.fault", "" + n2);
                fault = true;
            } else {
                this.ioWrite("radiozone.fault", "0");
            }
            if (diag.has("dZr")) {
                n2 = diag.getInt("dZr");
                this.ioWrite("radiozone.fault.zone", "" + n2);
                fault = true;
            }
            if (diag.has("rfRap")) {
                n2 = diag.getInt("rfRap");
                this.ioWrite("theft", "" + n2);
                fault = true;
            } else {
                this.ioWrite("theft", "0");
            }
            if (diag.has("dRfRap")) {
                n2 = diag.getInt("dRfRap");
                this.ioWrite("theft.device", "" + n2);
            }
            if (diag.has("rfEmMed")) {
                n2 = diag.getInt("rfEmMed");
                this.ioWrite("medemergency", "" + n2);
                fault = true;
            } else {
                this.ioWrite("medemergency", "0");
            }
            if (diag.has("dRfEmMed")) {
                n2 = diag.getInt("dRfEmMed");
                this.ioWrite("medemergency.device", "" + n2);
            }
            if (diag.has("sirRf")) {
                n2 = diag.getInt("sirRf");
                this.ioWrite("radiohooter.fault", "" + n2);
                fault = true;
            } else {
                this.ioWrite("radiohooter.fault", "0");
            }
            if (diag.has("dSirRf")) {
                n2 = diag.getInt("dSirRf");
                this.ioWrite("radiohooter.fault.device", "" + n2);
            }
            if (diag.has("kbr")) {
                n2 = diag.getInt("kbr");
                this.ioWrite("radiokeyboard.fault", "" + n2);
                fault = true;
            } else {
                this.ioWrite("radiokeyboard.fault", "0");
            }
            if (diag.has("dKbr")) {
                n2 = diag.getInt("dKbr");
                this.ioWrite("radiokeyboard.fault.device", "" + n2);
            }
            if (diag.has("reAcc")) {
                n2 = diag.getInt("reAcc");
                this.ioWrite("remoteaccess", "" + n2);
            } else {
                this.ioWrite("remoteaccess", "0");
            }
            if (diag.has("sirRfMan")) {
                JSONArray arr = diag.getJSONArray("sirRfMan");
                s = "";
                if (arr.length() != 0) {
                    int i2 = 0;
                    while (i2 < arr.length()) {
                        s = String.valueOf(s) + "," + arr.getInt(i2);
                        ++i2;
                    }
                    this.ioWrite("radiohooter.ids", s.substring(1));
                    fault = true;
                }
            }
            if (this.gui) {
                this.uiSet("fault", "visible", "" + fault);
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in general status - " + e2.getMessage());
        }
    }

    private Integer readAreaStatus(String resp, char cmdGrId) throws Exception {
        Integer insResult = null;
        try {
            block31: {
                int areaId;
                block30: {
                    JSONObject json = new JSONObject(resp);
                    JSONObject result = json.getJSONObject("result");
                    JSONObject area = result.getJSONObject("area");
                    areaId = area.getInt("aId");
                    Boolean areaEnabled = null;
                    Boolean areaTot = null;
                    if (area.has("name")) {
                        String s = area.getString("name");
                        this.ioWrite("a" + areaId + ".name", s);
                        if (this.gui) {
                            this.uiSet("a" + areaId + ".name", "value", s);
                        }
                    }
                    if (area.has("all")) {
                        this.ioWrite("a" + areaId + ".alarmgroups", Log.decodeBitmapGroups(area.getInt("all")));
                    }
                    if (area.has("man")) {
                        this.ioWrite("a" + areaId + ".tampergroups", Log.decodeBitmapGroups(area.getInt("man")));
                    }
                    if (area.has("pre")) {
                        this.ioWrite("a" + areaId + ".prealarmgroups", Log.decodeBitmapGroups(area.getInt("pre")));
                    }
                    if (area.has("acc")) {
                        this.ioWrite("a" + areaId + ".blindgroups", Log.decodeBitmapGroups(area.getInt("acc")));
                    }
                    if (!area.has("grps")) break block30;
                    char grId = 'a';
                    JSONArray ar = area.getJSONArray("grps");
                    int i2 = 0;
                    while (i2 < ar.length()) {
                        JSONObject obj = ar.getJSONObject(i2);
                        if (obj.has("name")) {
                            String name = obj.getString("name");
                            this.ioWrite("a" + areaId + ".group." + grId + ".name", name);
                            if (this.gui) {
                                this.uiSet("a" + areaId + ".group." + grId + ".name", "value", name);
                            }
                        }
                        int en = 0;
                        if (obj.has("en")) {
                            en = obj.getInt("en");
                            if (en == 1) {
                                areaEnabled = true;
                            } else if (areaEnabled == null) {
                                areaEnabled = false;
                            }
                            this.ioWrite("a" + areaId + ".group." + grId + ".en", "" + en);
                            if (this.gui) {
                                this.uiSet("a" + areaId + ".group." + grId + ".en", "visible", "" + (en == 1));
                            }
                        }
                        if (obj.has("ins")) {
                            int res = 200;
                            boolean isCmdResp = obj.has("result");
                            if (isCmdResp && (cmdGrId == '\u0000' || cmdGrId == grId)) {
                                res = obj.getInt("result");
                                if (insResult == null || insResult == 200) {
                                    insResult = res;
                                }
                            }
                            if (res == 200) {
                                int ins = obj.getInt("ins");
                                if (!isCmdResp && en == 1) {
                                    if (ins == 0) {
                                        areaTot = false;
                                    } else {
                                        this.armed = true;
                                        if (areaTot == null) {
                                            areaTot = true;
                                        }
                                    }
                                }
                                this.ioWrite("a" + areaId + ".group." + grId + ".ins", "" + ins);
                                if (this.gui) {
                                    this.uiSet("a" + areaId + ".group." + grId + ".ins", "visible", "" + (ins == 1));
                                }
                            }
                        }
                        grId = (char)(grId + 1);
                        ++i2;
                    }
                    if (areaEnabled != null) {
                        this.ioWrite("a" + areaId + ".en", areaEnabled != false ? "1" : "0");
                        if (this.gui) {
                            this.uiSet("a" + areaId + ".en", "visible", "" + areaEnabled);
                        }
                    }
                    if (areaTot == null) break block31;
                    this.ioWrite("a" + areaId + ".ins", areaTot != false ? "1" : "0");
                    if (!this.gui) break block31;
                    this.uiSet("a" + areaId + ".ins", "visible", "" + areaTot);
                    break block31;
                }
                if (this.firstloop) {
                    this.areas.remove(areaId);
                    if (this.gui) {
                        this.uiSet("a" + areaId + ".en", "visible", "false");
                        this.uiSet("a" + areaId + ".ins", "visible", "false");
                        char grId = 'a';
                        while (grId <= 'd') {
                            this.uiSet("a" + areaId + ".group." + grId + ".en", "visible", "false");
                            this.uiSet("a" + areaId + ".group." + grId + ".ins", "visible", "false");
                            grId = (char)(grId + '\u0001');
                        }
                    }
                }
            }
            return insResult;
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in area status - " + e2.getMessage());
        }
    }

    private void readOutputStatus(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject cnfOut = result.getJSONObject("cnfOut");
            JSONArray outputs = cnfOut.getJSONArray("out");
            int i2 = 0;
            while (i2 < outputs.length()) {
                int status = outputs.getInt(i2);
                if (status != 0) {
                    String hexVal = Integer.toHexString(status);
                    this.ioWrite("o" + (i2 + 1) + ".status", hexVal);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in output status - " + e2.getMessage());
        }
    }

    private void readZoneNames(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONArray zoneNames = result.getJSONArray("zoneNames");
            int i2 = 0;
            while (i2 < zoneNames.length()) {
                JSONObject zone = zoneNames.getJSONObject(i2);
                String id = "z" + (zone.getInt("i") + 1);
                String name = zone.getString("n");
                this.zones.put(id, name);
                this.ioWrite(String.valueOf(id) + ".name", name);
                String nameExt = zone.optString("e", null);
                if (nameExt != null) {
                    this.zones.put(String.valueOf(id) + "e", nameExt);
                    this.ioWrite(String.valueOf(id) + "e.name", nameExt);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in zone names response - " + e2.getMessage());
        }
    }

    private void readZoneStatus(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject cnfZone = result.getJSONObject("cnfZone");
            int numWiredZone = cnfZone.getInt("nZf");
            JSONArray zoneArray = cnfZone.getJSONArray("zone");
            StringBuilder labelsZf = new StringBuilder();
            StringBuilder labelsZr = new StringBuilder();
            boolean changed = false;
            boolean alarm = false;
            boolean alarmMem = false;
            int i2 = 0;
            while (i2 < zoneArray.length()) {
                int status = zoneArray.getInt(i2);
                if (status != 0) {
                    String id = "z" + (i2 + 1);
                    if (status >= 32 && status <= 35) {
                        alarmMem = true;
                    } else if (status >= 64 && status <= 67) {
                        alarm = true;
                    }
                    Integer prevStatus = this.zonesStatus.put(id, status);
                    if (prevStatus == null || prevStatus != status) {
                        changed = true;
                        int zBypass = 0;
                        int zTamper = 0;
                        int zOpen = 0;
                        int zAlarm = 0;
                        int zAlarmMem = 0;
                        if (status == 1) {
                            zBypass = 1;
                        } else if (status == 3) {
                            zTamper = 1;
                        } else if (status >= 17 && status <= 19) {
                            zOpen = status - 16;
                        } else if (status >= 32 && status <= 35) {
                            zAlarmMem = 1;
                            zOpen = status - 32;
                        } else if (status >= 64 && status <= 67) {
                            zAlarm = 1;
                            zOpen = status - 64;
                        }
                        this.ioWrite(String.valueOf(id) + ".bypass", "" + zBypass);
                        this.ioWrite(String.valueOf(id) + ".tamper", "" + zTamper);
                        this.ioWrite(String.valueOf(id) + ".open", "" + zOpen);
                        this.ioWrite(String.valueOf(id) + ".alarm", "" + zAlarm);
                        this.ioWrite(String.valueOf(id) + ".alarm.memory", "" + zAlarmMem);
                    }
                    if (this.gui) {
                        StringBuilder labels = i2 < numWiredZone ? labelsZf : labelsZr;
                        String name = this.zones.get(id);
                        if (name == null) {
                            name = "Zone " + (i2 + 1);
                        }
                        labels.append(',');
                        labels.append(name);
                        labels.append('|');
                        labels.append(this.zoneStatusToImg(status, false));
                        String nameExt = this.zones.get(String.valueOf(id) + "e");
                        if (nameExt != null) {
                            labels.append(',');
                            labels.append(nameExt);
                            labels.append('|');
                            labels.append(this.zoneStatusToImg(status, true));
                        }
                    }
                }
                ++i2;
            }
            this.ioWrite("alarm", alarm ? "1" : "0");
            this.ioWrite("alarm.memory", alarmMem ? "1" : "0");
            if (this.gui && changed) {
                if (labelsZf.length() > 0) {
                    this.uiSet("zones.wired.list", "labels", labelsZf.substring(1));
                }
                if (labelsZr.length() > 0) {
                    this.uiSet("zones.radio.list", "labels", labelsZr.substring(1));
                }
                this.uiSet("alarm", "visible", alarm ? "true" : "false");
                this.uiSet("alarm.memory", "visible", alarmMem ? "true" : "false");
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in zone status - " + e2.getMessage());
        }
    }

    private String zoneStatusToImg(int status, boolean ext) {
        int intExt;
        if (status == 1) {
            return "zona_esclusa.png";
        }
        if (status == 3) {
            return "zona_in_manomissione.png";
        }
        if (status >= 64 && status <= 67) {
            int intExt2 = status & 0xF;
            if (intExt2 == 3 || intExt2 == 1 && !ext || intExt2 == 2 && ext) {
                return "zona_in_allarme.png";
            }
        } else if ((status >= 17 && status <= 19 || status >= 33 && status <= 35) && ((intExt = status & 0xF) == 3 || intExt == 1 && !ext || intExt == 2 && ext)) {
            return "zona_aperta.png";
        }
        return "zona_a_riposo.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecordLog() throws Exception {
        int logStart = 1;
        int increment = 5;
        Log firstLog = null;
        boolean stop = false;
        this.templogs.clear();
        while (!stop && logStart <= 400) {
            Driver driver = this;
            synchronized (driver) {
                block13: {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("m_q_get_rec", "" + logStart, increment), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - mQgetObj");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    try {
                        JSONObject json = new JSONObject(this.httpResp.substring(4));
                        JSONObject result = json.getJSONObject("result");
                        JSONArray recs = result.getJSONArray("rec");
                        int i2 = 0;
                        while (i2 < recs.length()) {
                            JSONObject rec = recs.getJSONObject(i2);
                            JSONArray recInfo = rec.getJSONArray("r");
                            int[] rawLog = new int[20];
                            int j2 = 0;
                            while (j2 < recInfo.length()) {
                                rawLog[j2] = recInfo.getInt(j2);
                                ++j2;
                            }
                            Log log = new Log(rawLog);
                            if (this.mostRecentLog != null && this.mostRecentLog.equals(log)) {
                                stop = true;
                                break;
                            }
                            if (logStart == 1 && i2 == 0) {
                                firstLog = log;
                            }
                            this.templogs.add(log);
                            ++i2;
                        }
                    }
                    catch (Exception e2) {
                        if (!this.isVerboseLog()) break block13;
                        this.errorLog(String.valueOf(this.name) + " - error reading JSON response in record logs - " + e2.getMessage());
                    }
                }
            }
            this.sleep(100L);
            logStart += increment;
        }
        if (firstLog != null) {
            this.mostRecentLog = firstLog;
        }
        this.writeLogs();
    }

    private void writeLogs() {
        Collections.reverse(this.templogs);
        for (Log log : this.templogs) {
            String msg = log.decodeLogMessage(this.name);
            if (msg.isEmpty()) continue;
            this.securityLog(log.getTime(), msg);
        }
        if (this.mostRecentLog != null) {
            userBase.varSet(this.lastLogVar, this.mostRecentLog.writeMostRecentLog());
        }
    }

    private JSONObject getOrderedJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            Field changeMap = jsonObject.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonObject, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (Exception e2) {
            this.errorLog(e2.getMessage());
        }
        return jsonObject;
    }
}

