/*
 * Decompiled with CFR 0.152.
 */
package drivers.texecom;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.texecom.Consumer;
import drivers.texecom.RespException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[]{"texecom"};
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM");
    private final byte[] REQ_PANEL_ID;
    private byte[] REQ_ZONE_STATUS;
    private final byte[] REQ_SYSTEM_OUTPUT_STATUS;
    final byte[] REQ_PARTITIONS_OUTPUT_STATUS;
    private final byte[] REQ_LCD;
    private final byte[] REQ_LOG_POINTER;
    final byte[] REQ_LOG_EVENT;
    private final byte[] REQ_OUTPUTS_STATUS;
    private final byte[] REQ_TIME;
    private byte[] CMD_BYPASS_ZONE;
    private byte[] CMD_UNBYPASS_ZONE;
    private final byte[] CMD_SET_PC_OUTPUT;
    private final byte[] CMD_SET_X10_OUTPUT;
    private final byte[] CMD_SET_TIME;
    private String name;
    private String commPort;
    private long pollInterval;
    private boolean genEvent;
    private int maxZone;
    int maxPartition;
    private int pinLength;
    private int logSize;
    private boolean online;
    private Vector<String> logs;
    private String logVar;
    int logPointer;
    private Object pollingkLock;
    private List<String> pinBuffer;
    private boolean debug;

    public Driver() {
        byte[] byArray = new byte[4];
        byArray[0] = 92;
        byArray[1] = 73;
        byArray[2] = 47;
        this.REQ_PANEL_ID = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 92;
        byArray2[1] = 83;
        byArray2[3] = 8;
        byArray2[4] = 47;
        this.REQ_SYSTEM_OUTPUT_STATUS = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[0] = 92;
        byArray3[1] = 80;
        byArray3[3] = 18;
        byArray3[4] = 47;
        this.REQ_PARTITIONS_OUTPUT_STATUS = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 92;
        byArray4[1] = 76;
        byArray4[2] = 47;
        this.REQ_LCD = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[0] = 92;
        byArray5[1] = 71;
        byArray5[2] = 48;
        byArray5[3] = 47;
        this.REQ_LOG_POINTER = byArray5;
        byte[] byArray6 = new byte[7];
        byArray6[0] = 92;
        byArray6[1] = 71;
        byArray6[2] = 50;
        byArray6[5] = 47;
        this.REQ_LOG_EVENT = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[0] = 92;
        byArray7[1] = 79;
        byArray7[2] = 63;
        byArray7[3] = 47;
        this.REQ_OUTPUTS_STATUS = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[0] = 92;
        byArray8[1] = 84;
        byArray8[2] = 63;
        byArray8[3] = 47;
        this.REQ_TIME = byArray8;
        byte[] byArray9 = new byte[7];
        byArray9[0] = 92;
        byArray9[1] = 79;
        byArray9[2] = 80;
        byArray9[5] = 47;
        this.CMD_SET_PC_OUTPUT = byArray9;
        byte[] byArray10 = new byte[7];
        byArray10[0] = 92;
        byArray10[1] = 79;
        byArray10[2] = 88;
        byArray10[5] = 47;
        this.CMD_SET_X10_OUTPUT = byArray10;
        byte[] byArray11 = new byte[9];
        byArray11[0] = 92;
        byArray11[1] = 84;
        byArray11[7] = 47;
        this.CMD_SET_TIME = byArray11;
        this.pollInterval = 3000L;
        this.genEvent = false;
        this.maxZone = 168;
        this.maxPartition = 16;
        this.pinLength = 4;
        this.logSize = 20;
        this.logPointer = -1;
        this.pollingkLock = new Object();
        this.pinBuffer = new ArrayList<String>();
        this.debug = false;
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.commPort = config.get("comm");
            try {
                this.pollInterval = Integer.parseInt(config.get("pollinterval")) * 1000;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxZone = Integer.parseInt(config.get("maxzone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxPartition = Integer.parseInt(config.get("maxpartition"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.pinLength = Integer.parseInt(config.get("pinlength"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.logSize = Integer.parseInt(config.get("logsize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.maxZone > 168) {
                byte[] byArray = new byte[7];
                byArray[0] = 92;
                byArray[1] = 90;
                byArray[5] = 47;
                this.REQ_ZONE_STATUS = byArray;
                byte[] byArray2 = new byte[6];
                byArray2[0] = 92;
                byArray2[1] = 66;
                byArray2[4] = 47;
                this.CMD_BYPASS_ZONE = byArray2;
                byte[] byArray3 = new byte[6];
                byArray3[0] = 92;
                byArray3[1] = 85;
                byArray3[4] = 47;
                this.CMD_UNBYPASS_ZONE = byArray3;
            } else {
                byte[] byArray = new byte[6];
                byArray[0] = 92;
                byArray[1] = 90;
                byArray[4] = 47;
                this.REQ_ZONE_STATUS = byArray;
                byte[] byArray4 = new byte[5];
                byArray4[0] = 92;
                byArray4[1] = 66;
                byArray4[3] = 47;
                this.CMD_BYPASS_ZONE = byArray4;
                byte[] byArray5 = new byte[5];
                byArray5[0] = 92;
                byArray5[1] = 85;
                byArray5[3] = 47;
                this.CMD_UNBYPASS_ZONE = byArray5;
            }
            this.loadLogs();
            String pwd = config.get("password");
            byte[] req_access = new byte[pwd.length() + 4];
            req_access[0] = 92;
            req_access[1] = 87;
            int i2 = 0;
            while (i2 < pwd.length()) {
                req_access[i2 + 2] = (byte)pwd.charAt(i2);
                ++i2;
            }
            req_access[req_access.length - 2] = 47;
            this.writeAndProcessResp(req_access, 0, Consumer.OK_CONSUMER);
            this.writeAndProcessResp(this.REQ_PANEL_ID, 0, Consumer.PANEL_ID_CONSUMER);
            String startupevents = config.get("startupevents");
            if (startupevents != null) {
                this.genEvent = Boolean.parseBoolean(startupevents);
            }
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void loadLogs() {
        this.logVar = "__HSYCO__TEXECOM_" + this.name + ".log!";
        ObjectInputStream ois = null;
        try {
            try {
                String s = userBase.varGet(this.logVar);
                if (s == null) {
                    this.logs = new Vector(this.logSize);
                }
                byte[] data = Base64.decodeBase64(s);
                ois = new ObjectInputStream(new ByteArrayInputStream(data));
                this.logs = (Vector)ois.readObject();
            }
            catch (Exception e2) {
                this.logs = new Vector(this.logSize);
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    synchronized void writeAndProcessResp(byte[] data, int respLen, Consumer c2) throws IOException, RespException {
        String err;
        byte[] resp;
        int n2;
        data[data.length - 1] = Driver.getChecksum(data, data.length - 1);
        if (this.debug) {
            System.err.print(">> ");
            byte[] byArray = data;
            n2 = data.length;
            int n3 = 0;
            while (n3 < n2) {
                byte d2 = byArray[n3];
                System.err.print(String.valueOf(Integer.toHexString(d2 & 0xFF)) + "#" + (char)d2 + " ");
                ++n3;
            }
            System.err.println();
        }
        this.readComm(this.commPort, 0);
        if (this.writeCommBytes(this.commPort, data) != data.length) {
            throw new IOException("write comm error");
        }
        if (respLen > 0) {
            resp = this.readCommBytes(this.commPort, respLen);
            if (resp == null) {
                throw new IOException("read comm error: null");
            }
            if (this.debug) {
                System.err.print("<< ");
                byte[] byArray = resp;
                int n4 = resp.length;
                n2 = 0;
                while (n2 < n4) {
                    byte d3 = byArray[n2];
                    System.err.print(String.valueOf(Integer.toHexString(d3 & 0xFF)) + "#" + (char)d3 + " ");
                    ++n2;
                }
                System.err.println();
            }
            if (resp.length != respLen) {
                String err2;
                if (resp.length == 8 && (err2 = new String(resp, 0, 5, StandardCharsets.US_ASCII)).equals("ERROR")) {
                    throw new RespException("Error response 1");
                }
                throw new IOException("read comm error: length " + resp.length + "!=" + respLen);
            }
            if (resp[respLen - 2] != 13 || resp[respLen - 1] != 10) {
                throw new IOException("response format error");
            }
            if (resp[respLen - 3] != Driver.getChecksum(resp, respLen - 3)) {
                throw new IOException("response checksum error");
            }
        } else {
            byte[] r;
            resp = new byte[256];
            respLen = 0;
            if (this.debug) {
                System.err.print("<< ");
            }
            do {
                if ((r = this.readCommBytes(this.commPort, 1)) == null) {
                    throw new IOException("read comm error: null");
                }
                if (r.length != 1) {
                    throw new IOException("read comm error: length");
                }
                if (this.debug) {
                    System.err.print(String.valueOf(Integer.toHexString(r[0] & 0xFF)) + "#" + (char)r[0] + " ");
                }
                resp[respLen++] = r[0];
            } while (r[0] != 10 || resp[respLen - 2] != 13);
            if (this.debug) {
                System.err.println();
            }
            if (resp[respLen - 3] != Driver.getChecksum(resp, respLen - 3)) {
                throw new IOException("response checksum error");
            }
        }
        if (respLen == 8 && (err = new String(resp, 0, 5, StandardCharsets.US_ASCII)).equals("ERROR")) {
            throw new RespException("Error response 2");
        }
        c2.accept(this, resp, respLen);
    }

    static byte getChecksum(byte[] data, int last) {
        byte sum = 0;
        int i2 = 0;
        while (i2 < last) {
            sum = (byte)(sum + data[i2]);
            ++i2;
        }
        sum = ~sum;
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        if (this.debug) {
            System.err.println("LOOP ==============");
        }
        try {
            int i2 = 0;
            while (i2 < this.maxZone) {
                this.REQ_ZONE_STATUS[2] = (byte)i2;
                if (this.maxZone > 168) {
                    this.REQ_ZONE_STATUS[3] = (byte)(i2 >>> 8);
                }
                int numOfZones = this.maxZone < i2 + 50 ? this.maxZone - i2 : 50;
                this.REQ_ZONE_STATUS[this.maxZone > 168 ? 4 : 3] = (byte)numOfZones;
                Consumer.ZONE_STATUS_CONSUMER.setOption(i2);
                this.writeAndProcessResp(this.REQ_ZONE_STATUS, numOfZones * 2 + 3, Consumer.ZONE_STATUS_CONSUMER);
                i2 += 50;
            }
            this.writeAndProcessResp(this.REQ_SYSTEM_OUTPUT_STATUS, 11, Consumer.SYSTEM_STATUS_CONSUMER);
            i2 = 0;
            while (i2 < 4) {
                int startFlag = i2 * 18;
                this.REQ_PARTITIONS_OUTPUT_STATUS[2] = (byte)startFlag;
                this.writeAndProcessResp(this.REQ_PARTITIONS_OUTPUT_STATUS, 0, Consumer.PARTITIONS_STATUS_CONSUMER);
                ++i2;
            }
            this.writeAndProcessResp(this.REQ_LCD, 0, Consumer.LCD_CONSUMER);
            this.writeAndProcessResp(this.REQ_LOG_POINTER, 5, Consumer.LOG_POINTER_CONSUMER);
            this.writeAndProcessResp(this.REQ_OUTPUTS_STATUS, 5, Consumer.OUTPUTS_STATUS_CONSUMER);
            this.writeAndProcessResp(this.REQ_TIME, 8, Consumer.TIME_CONSUMER);
            if (!this.online) {
                this.online = true;
                this.genEvent = true;
                this.ioWrite("connection", "online");
                this.securityLog("HSYCO ONLINE");
                this.uiSet("connection.offline", "visible", "false");
                this.uiSet("connection.online", "visible", "true");
            }
            Object i22 = this.pollingkLock;
            synchronized (i22) {
                this.pollingkLock.wait(this.pollInterval);
            }
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        if (cmd.startsWith("object.")) {
            if (cmd.endsWith("log")) {
                this.uiSet(session, "object.container.keypad", "visible", "false");
                this.uiSet(session, "object.container.log", "visible", "true");
            } else if (cmd.endsWith("keypad")) {
                this.uiSet(session, "object.container.keypad", "visible", "true");
                this.uiSet(session, "object.container.log", "visible", "false");
            }
        } else if (cmd.equals("key")) {
            int v = Integer.parseInt(value);
            if (v <= 10) {
                this.pinBuffer.add(value);
                if (this.pinBuffer.size() >= this.pinLength) {
                    StringBuilder sb = new StringBuilder();
                    int i2 = 0;
                    while (i2 < this.pinLength) {
                        sb.append(this.pinBuffer.get(i2));
                        sb.append(':');
                        ++i2;
                    }
                    this.keyCommand(sb.toString());
                }
            } else {
                this.keyCommand(value);
            }
            this.showPin();
        } else {
            this.command(cmd, value);
        }
        return "";
    }

    private void showPin() {
        StringBuilder pinText = new StringBuilder();
        int i2 = 0;
        while (i2 < this.pinBuffer.size()) {
            pinText.append('*');
            ++i2;
        }
        this.uiSet("keypad.pin", "text", pinText.toString());
    }

    private void keyCommand(String keys) {
        this.showPin();
        this.pinBuffer.clear();
        this.command("key", keys);
        try {
            this.writeAndProcessResp(this.REQ_LCD, 0, Consumer.LCD_CONSUMER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        block30: {
            try {
                String function;
                String target;
                name = name.toLowerCase();
                this.messageLog("Command: " + name + " = " + value);
                int dot = name.indexOf(46);
                if (dot > 0) {
                    target = name.substring(0, dot);
                    function = name.substring(dot + 1);
                } else {
                    target = null;
                    function = name;
                }
                boolean pollAfter = true;
                byte[] cmd = null;
                if (target == null) {
                    if (function.equals("key")) {
                        String[] ks = value.split(":");
                        ArrayList<Integer> keys = new ArrayList<Integer>();
                        String[] stringArray = ks;
                        int n2 = ks.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String k2 = stringArray[n3];
                            try {
                                keys.add(Integer.parseInt(k2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            ++n3;
                        }
                        cmd = new byte[keys.size() + 5];
                        cmd[0] = 92;
                        cmd[1] = 75;
                        cmd[2] = (byte)keys.size();
                        int i2 = 0;
                        while (i2 < keys.size()) {
                            cmd[i2 + 3] = (byte)((Integer)keys.get(i2)).intValue();
                            ++i2;
                        }
                        cmd[cmd.length - 2] = 47;
                        pollAfter = false;
                    } else if (function.startsWith("o")) {
                        byte num;
                        if (function.charAt(1) == 'x') {
                            cmd = this.CMD_SET_X10_OUTPUT;
                            num = (byte)Integer.parseInt(function.substring(2));
                        } else {
                            cmd = this.CMD_SET_PC_OUTPUT;
                            num = (byte)Integer.parseInt(function.substring(1));
                        }
                        cmd[3] = (byte)(value.equals("1") ? 255 : 0);
                        cmd[4] = (byte)(1 << num - 1);
                    } else if (function.equals("time")) {
                        String[] date_time = value.split(" ");
                        String[] ymd = date_time[0].split("-");
                        String[] hm = date_time[1].split(":");
                        cmd = this.CMD_SET_TIME;
                        cmd[2] = Byte.parseByte(ymd[2]);
                        cmd[3] = Byte.parseByte(ymd[1]);
                        cmd[4] = Byte.parseByte(ymd[0]);
                        cmd[5] = Byte.parseByte(hm[0]);
                        cmd[6] = Byte.parseByte(hm[1]);
                    }
                } else if (target.startsWith("z")) {
                    if (function.equals("bypass")) {
                        cmd = value.equals("1") ? this.CMD_BYPASS_ZONE : this.CMD_UNBYPASS_ZONE;
                        int idx = Integer.parseInt(target.substring(1));
                        cmd[2] = (byte)idx;
                        if (this.maxZone > 168) {
                            cmd[3] = (byte)(idx >>> 8);
                        }
                    }
                } else if (target.startsWith("p")) {
                    int num = Integer.parseInt(target.substring(1)) - 1;
                    cmd = num < 8 ? new byte[5] : (num < 16 ? new byte[6] : new byte[12]);
                    cmd[0] = 92;
                    int b2 = num / 8;
                    int s = num % 8;
                    cmd[b2 + 2] = (byte)(1 << s);
                    cmd[cmd.length - 2] = 47;
                    if (function.startsWith("armed")) {
                        cmd[1] = function.endsWith(".part") && value.equals("1") ? 89 : (value.equals("1") ? 65 : 68);
                    } else if (function.equals("reset") && value.equals("1")) {
                        cmd[1] = 82;
                    } else {
                        cmd = null;
                    }
                }
                if (cmd != null) {
                    this.writeAndProcessResp(cmd, 0, Consumer.OK_CONSUMER);
                    if (!pollAfter) break block30;
                    Object object = this.pollingkLock;
                    synchronized (object) {
                        this.pollingkLock.notify();
                        break block30;
                    }
                }
                throw new Exception("unknown command");
            }
            catch (Exception e2) {
                this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
            }
        }
    }

    protected void ioWrite(String name, String value, boolean uiSetVisible) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
        if (uiSetVisible) {
            if ("1".equals(value)) {
                this.uiSet(String.valueOf(name) + ".1", "visible", "true");
                this.uiSet(String.valueOf(name) + ".0", "visible", "false");
            } else {
                this.uiSet(String.valueOf(name) + ".1", "visible", "false");
                this.uiSet(String.valueOf(name) + ".0", "visible", "true");
            }
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    void securityLog(String message) {
        String entry;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        if (message.startsWith("HSYCO")) {
            entry = String.valueOf(this.dateFormat.format(new Date())) + "<br />" + message;
        } else {
            int space = message.indexOf(32);
            space = message.indexOf(32, space + 1);
            entry = String.valueOf(message.substring(0, space)) + "<br />" + message.substring(space + 1);
        }
        this.logs.add(0, entry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            entry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(entry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }
}

