/*
 * Decompiled with CFR 0.152.
 */
package drivers.strato;

import com.hsyco.driverBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final long LOOP_INTERVAL_MILLIS = 200L;
    private static final long BATTERY_ALARM_INTERVAL_MILLIS = 10000L;
    private static final long TEMPERATURE_INTERVAL_MILLIS = 4000L;
    private static final int WATCHDOG_TIMEOUT_SHORT_SECONDS = 60;
    private static final int WATCHDOG_TIMEOUT_LONG_SECONDS = 3600;
    private static final File sysfs = new File("/sys/devices/virtual/stratopi");
    private static final File sysfsFan = new File("/sys/devices/virtual/stratopifan");
    private String driverid = null;
    private boolean kernelModuleMode = false;
    private boolean kernelModuleFanMode = false;
    private int sysfsPathnameLength = 0;
    private int watchdogEnableOption = 0;
    private int shutdownMinutesOption = -1;
    private int dualSdSyncOption = 0;
    private boolean quietOption = false;
    private int version = 0;
    private ArrayList<File> files = new ArrayList();
    private Boolean watchdogControlSemaphore = new Boolean(false);
    private int watchdogHeartbeatPin;
    private int watchdogEnablePin;
    private int watchdogTimeoutPin;
    private int shutdownEnablePin;
    private int buzzerLedPin;
    private int batteryPowerPin;
    private int buttonPin;
    private int relayPin;
    private int watchdogEnabledValue = -1;
    private int watchdogEnableModeValue = -1;
    private int watchdogExpiredValue = -1;
    private int watchdogHeartbeatValue = -1;
    private int watchdogTimeoutValue = -1;
    private int sd1EnabledValue = -1;
    private int sdSwitchValue = -1;
    private int shutdownValue = -1;
    private int buzzerLedValue = -1;
    private int batteryValue = -1;
    private int buttonValue = -1;
    private int relayValue = -1;
    private int backlightBrightnessValue = -1;
    private int temperatureValue = -1;
    private int temperatureFanValue = -1;
    private int temperatureFanOnValue = -1;
    private int temperatureFanOffValue = -1;
    private long loopTimestamp = 0L;
    private long shutdownTimestamp = 0L;
    private long batteryTimestamp = 0L;
    private long watchdogExpiredTimestamp = 0L;
    private long temperatureTimestamp = 0L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.driverid = new String(name);
        if (sysfs.isDirectory()) {
            this.kernelModuleMode = true;
            this.watchdogEnableOption = 2;
        }
        if (sysfsFan.isDirectory()) {
            this.kernelModuleFanMode = true;
        }
        try {
            String s;
            block73: {
                this.quietOption = Boolean.parseBoolean(config.get("quiet"));
                s = config.get("shutdown_minutes");
                if (s != null && s.length() > 0) {
                    int i2 = Integer.parseInt(s);
                    if (i2 < 0) throw new Exception();
                    this.shutdownMinutesOption = i2;
                }
                if ((s = config.get("version")) != null && s.length() > 0) {
                    if (s.equalsIgnoreCase("base") || s.equalsIgnoreCase("ups")) {
                        this.version = 0;
                    } else if (s.equalsIgnoreCase("mini")) {
                        this.version = 1;
                    } else if (s.equalsIgnoreCase("cm")) {
                        this.version = 2;
                    } else if (s.equalsIgnoreCase("can")) {
                        this.version = 3;
                    } else {
                        if (!s.equalsIgnoreCase("cmduo")) throw new Exception();
                        this.version = 4;
                    }
                } else if (this.kernelModuleMode) {
                    BufferedReader in = null;
                    try {
                        try {
                            in = new BufferedReader(new FileReader(new File(sysfs, "mcu/fw_version")));
                            String value = in.readLine();
                            if (value != null) {
                                int model = Integer.parseInt(value.substring(value.indexOf(47) + 1));
                                switch (model) {
                                    case 1: 
                                    case 5: {
                                        this.version = 0;
                                        this.messageLog("Strato Driver - version detected [" + this.driverid + "] - base");
                                        break;
                                    }
                                    case 2: 
                                    case 6: {
                                        this.version = 0;
                                        this.messageLog("Strato Driver - version detected [" + this.driverid + "] - ups");
                                        break;
                                    }
                                    case 4: {
                                        this.version = 2;
                                        this.messageLog("Strato Driver - version detected [" + this.driverid + "] - cm");
                                        break;
                                    }
                                    case 3: 
                                    case 8: {
                                        this.version = 3;
                                        this.messageLog("Strato Driver - version detected [" + this.driverid + "] - can");
                                        break;
                                    }
                                    case 7: {
                                        this.version = 4;
                                        this.messageLog("Strato Driver - version detected [" + this.driverid + "] - cmduo");
                                        break;
                                    }
                                    default: {
                                        this.errorLog("Strato Driver - kernel module [" + this.driverid + "] - error reading firmware version and model");
                                        break;
                                    }
                                }
                            } else {
                                this.errorLog("Strato Driver - kernel module [" + this.driverid + "] - error reading firmware version and model");
                            }
                        }
                        catch (Exception e2) {
                            this.errorLog("Strato Driver - kernel module [" + this.driverid + "] - error reading firmware version and model");
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                            break block73;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            s = config.get("watchdog");
            if ("false".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = 0;
            } else if ("true".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = 1;
            } else if ("always".equalsIgnoreCase(s)) {
                if (this.kernelModuleMode) {
                    this.watchdogEnableOption = 2;
                } else {
                    this.errorLog("Strato Driver - options error [" + name + "] - watchdog=always requires Strato Pi kernel module");
                }
            } else if ("ignore".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = -1;
            } else if (s != null) {
                this.errorLog("Strato Driver - option error [" + name + "] - watchdog ignored");
            }
            s = config.get("dualsdsync");
            if ("false".equalsIgnoreCase(s)) {
                this.dualSdSyncOption = 0;
            } else if ("true".equalsIgnoreCase(s)) {
                if (this.kernelModuleMode) {
                    this.dualSdSyncOption = 1;
                } else {
                    this.errorLog("Strato Driver - options error [" + name + "] - dualsdsync requires Strato Pi kernel module");
                }
            } else if ("manual".equalsIgnoreCase(s)) {
                if (this.kernelModuleMode) {
                    this.dualSdSyncOption = 2;
                } else {
                    this.errorLog("Strato Driver - options error [" + name + "] - dualsdsync requires Strato Pi kernel module");
                }
            } else if (s != null) {
                this.errorLog("Strato Driver - options error [" + name + "] - dualsdsync ignored");
            }
        }
        catch (Exception e3) {
            this.errorLog("Strato Driver - options error [" + name + "] - quit");
            return false;
        }
        if (this.watchdogEnableOption > 0) {
            this.registerMainLoopHeartbeat(true);
        }
        if (this.kernelModuleMode) {
            try {
                this.controlFileWrite("watchdog.timeout", this.watchdogEnableOption == 2 ? Integer.toString(3600) : null);
            }
            catch (Exception e4) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - failed to set watchdog timeout");
            }
        }
        if (this.dualSdSyncOption == 1) {
            this.registerDualSdSync(true);
        }
        if (this.kernelModuleMode) {
            this.sysfsPathnameLength = sysfs.getAbsolutePath().length();
            return this.scanDirectory(sysfs, 1);
        }
        try {
            switch (this.version) {
                case 0: {
                    this.watchdogHeartbeatPin = 5;
                    this.watchdogEnablePin = 6;
                    this.watchdogTimeoutPin = 12;
                    this.shutdownEnablePin = 16;
                    this.buzzerLedPin = 20;
                    this.batteryPowerPin = 26;
                    this.buttonPin = 0;
                    this.relayPin = 0;
                    this.export(this.watchdogHeartbeatPin);
                    this.direction(this.watchdogHeartbeatPin, true);
                    this.export(this.watchdogEnablePin);
                    this.direction(this.watchdogEnablePin, true);
                    this.export(this.watchdogTimeoutPin);
                    this.direction(this.watchdogTimeoutPin, false);
                    this.export(this.shutdownEnablePin);
                    this.direction(this.shutdownEnablePin, true);
                    this.export(this.buzzerLedPin);
                    this.direction(this.buzzerLedPin, true);
                    this.export(this.batteryPowerPin);
                    this.direction(this.batteryPowerPin, false);
                    return true;
                }
                case 1: {
                    this.watchdogHeartbeatPin = 0;
                    this.watchdogEnablePin = 0;
                    this.watchdogTimeoutPin = 0;
                    this.shutdownEnablePin = 0;
                    this.buzzerLedPin = 17;
                    this.batteryPowerPin = 0;
                    this.buttonPin = 0;
                    this.relayPin = 0;
                    this.export(this.buzzerLedPin);
                    this.direction(this.buzzerLedPin, true);
                    return true;
                }
                case 2: {
                    this.watchdogHeartbeatPin = 27;
                    this.watchdogEnablePin = 22;
                    this.watchdogTimeoutPin = 17;
                    this.shutdownEnablePin = 18;
                    this.buzzerLedPin = 16;
                    this.batteryPowerPin = 0;
                    this.buttonPin = 25;
                    this.relayPin = 0;
                    this.export(this.watchdogHeartbeatPin);
                    this.direction(this.watchdogHeartbeatPin, true);
                    this.export(this.watchdogEnablePin);
                    this.direction(this.watchdogEnablePin, true);
                    this.export(this.watchdogTimeoutPin);
                    this.direction(this.watchdogTimeoutPin, false);
                    this.export(this.shutdownEnablePin);
                    this.direction(this.shutdownEnablePin, true);
                    this.export(this.buzzerLedPin);
                    this.direction(this.buzzerLedPin, true);
                    this.export(this.buttonPin);
                    this.direction(this.buttonPin, false);
                    return true;
                }
                case 3: {
                    this.watchdogHeartbeatPin = 5;
                    this.watchdogEnablePin = 6;
                    this.watchdogTimeoutPin = 12;
                    this.shutdownEnablePin = 16;
                    this.buzzerLedPin = 20;
                    this.batteryPowerPin = 0;
                    this.buttonPin = 0;
                    this.relayPin = 26;
                    this.export(this.watchdogHeartbeatPin);
                    this.direction(this.watchdogHeartbeatPin, true);
                    this.export(this.watchdogEnablePin);
                    this.direction(this.watchdogEnablePin, true);
                    this.export(this.watchdogTimeoutPin);
                    this.direction(this.watchdogTimeoutPin, false);
                    this.export(this.shutdownEnablePin);
                    this.direction(this.shutdownEnablePin, true);
                    this.export(this.buzzerLedPin);
                    this.direction(this.buzzerLedPin, true);
                    this.export(this.relayPin);
                    this.direction(this.relayPin, true);
                    return true;
                }
                case 4: {
                    this.watchdogHeartbeatPin = 32;
                    this.watchdogEnablePin = 39;
                    this.watchdogTimeoutPin = 17;
                    this.shutdownEnablePin = 18;
                    this.buzzerLedPin = 16;
                    this.batteryPowerPin = 0;
                    this.buttonPin = 38;
                    this.relayPin = 0;
                    this.export(this.watchdogHeartbeatPin);
                    this.direction(this.watchdogHeartbeatPin, true);
                    this.export(this.watchdogEnablePin);
                    this.direction(this.watchdogEnablePin, true);
                    this.export(this.watchdogTimeoutPin);
                    this.direction(this.watchdogTimeoutPin, false);
                    this.export(this.shutdownEnablePin);
                    this.direction(this.shutdownEnablePin, true);
                    this.export(this.buzzerLedPin);
                    this.direction(this.buzzerLedPin, true);
                    this.export(this.buttonPin);
                    this.direction(this.buttonPin, false);
                }
                default: {
                    return true;
                }
            }
        }
        catch (Exception e5) {
            this.errorLog("Strato Driver - GPIO initialization error [" + name + "] - quit. " + e5);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        boolean r = false;
        long ts = System.nanoTime() / 1000000L;
        if (ts - this.loopTimestamp < 200L) {
            this.sleep(200L - ts + this.loopTimestamp);
            this.loopTimestamp += 200L;
        } else {
            this.loopTimestamp = ts;
        }
        try {
            block59: {
                int v;
                if (this.kernelModuleMode) {
                    int i2 = 0;
                    while (i2 < this.files.size()) {
                        r |= this.readFile(this.files.get(i2), true);
                        this.sleep(10L);
                        ++i2;
                    }
                } else {
                    r = true;
                    if (this.watchdogHeartbeatPin != 0 && (v = this.value(this.watchdogHeartbeatPin)) != this.watchdogHeartbeatValue) {
                        this.watchdogHeartbeatValue = v;
                        this.ioWrite("heartbeat", Integer.toString(v));
                    }
                    if (this.watchdogEnablePin != 0 && (v = this.value(this.watchdogEnablePin)) != this.watchdogEnabledValue) {
                        this.watchdogEnabledValue = v;
                        this.ioWrite("watchdog", Integer.toString(v));
                    }
                    if (this.watchdogTimeoutPin != 0 && (v = this.value(this.watchdogTimeoutPin)) != this.watchdogExpiredValue) {
                        this.watchdogExpiredValue = v;
                        this.ioWrite("timeout", Integer.toString(v));
                    }
                    if (this.shutdownEnablePin != 0 && (v = this.value(this.shutdownEnablePin)) != this.shutdownValue) {
                        this.shutdownValue = v;
                        this.ioWrite("shutdown", Integer.toString(v));
                    }
                    if (this.buzzerLedPin != 0 && (v = this.value(this.buzzerLedPin)) != this.buzzerLedValue) {
                        this.buzzerLedValue = v;
                        this.ioWrite(this.version == 2 || this.version == 4 ? "led" : "beep", Integer.toString(v));
                    }
                    if (this.batteryPowerPin != 0 && (v = this.value(this.batteryPowerPin)) != this.batteryValue) {
                        this.batteryValue = v;
                        this.ioWrite("battery", Integer.toString(v));
                    }
                    if (this.buttonPin != 0) {
                        v = this.value(this.buttonPin);
                        if (this.buttonPin != 0 && v != this.buttonValue) {
                            this.buttonValue = v;
                            this.ioWrite("button", Integer.toString(v));
                        }
                    }
                    if (this.relayPin != 0 && (v = this.value(this.relayPin)) != this.relayValue) {
                        this.relayValue = v;
                        this.ioWrite("relay", Integer.toString(v));
                    }
                }
                try {
                    v = this.brightness();
                    if (v != this.backlightBrightnessValue) {
                        this.backlightBrightnessValue = v;
                        this.ioWrite("backlight.brightness", Integer.toString(v));
                    }
                }
                catch (Exception i2) {
                    // empty catch block
                }
                try {
                    if (this.loopTimestamp - this.temperatureTimestamp > 4000L) {
                        this.temperatureTimestamp = this.loopTimestamp;
                        v = this.temperature();
                        if (v != this.temperatureValue) {
                            this.temperatureValue = v;
                            this.ioWrite("cpu.temperature", Integer.toString(v));
                        }
                        if (this.kernelModuleFanMode) {
                            v = this.temperatureFan(0);
                            if (v != this.temperatureFanValue) {
                                this.temperatureFanValue = v;
                                this.ioWrite("fan.temperature", Integer.toString(v));
                            }
                            if ((v = this.temperatureFan(1)) != this.temperatureFanOnValue) {
                                this.temperatureFanOnValue = v;
                                this.ioWrite("fan.temperature.on", Integer.toString(v));
                            }
                            if ((v = this.temperatureFan(2)) != this.temperatureFanOffValue) {
                                this.temperatureFanOffValue = v;
                                this.ioWrite("fan.temperature.off", Integer.toString(v));
                            }
                        }
                    }
                }
                catch (Exception i2) {
                    // empty catch block
                }
                if (this.dualSdSyncOption != 0 && this.sd1EnabledValue != 2) {
                    this.sysFsWrite("sd.sd1_enabled", "2");
                }
                if (this.watchdogExpiredValue == 1 && this.watchdogExpiredTimestamp == 0L) {
                    this.watchdogExpiredTimestamp = this.loopTimestamp;
                    this.messageLog("Strato Driver - watchdog timeout detected [" + this.driverid + "]");
                    this.command("shutdown", "1");
                }
                Boolean i2 = this.watchdogControlSemaphore;
                synchronized (i2) {
                    block60: {
                        if (this.watchdogControlSemaphore.booleanValue()) break block59;
                        if (!this.kernelModuleMode) break block60;
                        switch (this.watchdogEnableOption) {
                            case 0: {
                                if (!(this.watchdogEnableModeValue == 68 || this.sysFsWrite("watchdog.enable_mode", "D") && this.sysFsWrite("watchdog.timeout", Integer.toString(60)) && this.sysFsWrite("mcu.config", "s"))) {
                                    return false;
                                }
                                if (this.watchdogEnabledValue != 0 && !this.sysFsWrite("watchdog.enabled", "0")) {
                                    return false;
                                }
                                break block59;
                            }
                            case 1: {
                                if (!(this.watchdogEnableModeValue == 68 || this.sysFsWrite("watchdog.enable_mode", "D") && this.sysFsWrite("watchdog.timeout", Integer.toString(60)) && this.sysFsWrite("mcu.config", "s"))) {
                                    return false;
                                }
                                if (this.watchdogEnabledValue != 1 && !this.sysFsWrite("watchdog.enabled", "1")) {
                                    return false;
                                }
                                if (!(this.dualSdSyncOption <= 0 || this.sdSwitchValue == 1 || this.sysFsWrite("watchdog.sd_switch", "1") && this.sysFsWrite("mcu.config", "s"))) {
                                    return false;
                                }
                                if (this.watchdogTimeoutValue != 60 && !this.sysFsWrite("watchdog.timeout", Integer.toString(60))) {
                                    return false;
                                }
                                break block59;
                            }
                            case 2: {
                                if (!(this.watchdogEnableModeValue == 65 || this.sysFsWrite("watchdog.enable_mode", "A") && this.sysFsWrite("watchdog.timeout", Integer.toString(60)) && this.sysFsWrite("mcu.config", "s"))) {
                                    return false;
                                }
                                if (!(this.dualSdSyncOption <= 0 || this.sdSwitchValue == 2 || this.sysFsWrite("watchdog.sd_switch", "2") && this.sysFsWrite("mcu.config", "s"))) {
                                    return false;
                                }
                                if (this.watchdogTimeoutValue != 60 && !this.sysFsWrite("watchdog.timeout", Integer.toString(60))) {
                                    return false;
                                }
                                break block59;
                            }
                        }
                        break block59;
                    }
                    if (this.watchdogEnablePin != 0) {
                        switch (this.watchdogEnableOption) {
                            case 0: {
                                this.value(this.watchdogEnablePin, 0);
                                break;
                            }
                            case 1: {
                                this.value(this.watchdogEnablePin, 1);
                            }
                        }
                    }
                }
            }
            if (!this.quietOption && this.batteryValue == 1 && this.loopTimestamp - this.batteryTimestamp > 10000L) {
                this.batteryTimestamp = this.loopTimestamp;
                this.beep(20, 20, 6);
            }
            if (this.shutdownMinutesOption != -1) {
                if (this.batteryValue == 1) {
                    if (this.shutdownTimestamp == 0L) {
                        this.shutdownTimestamp = this.loopTimestamp;
                        this.messageLog("Strato Driver - power failure detected [" + this.driverid + "] - shutdown in " + this.shutdownMinutesOption + " minutes");
                    } else if (this.loopTimestamp - this.shutdownTimestamp > (long)(this.shutdownMinutesOption * 60000)) {
                        this.shutdownMinutesOption = -1;
                        this.messageLog("Strato Driver - power failure detected [" + this.driverid + "] - shutdown now");
                        this.command("shutdown", "1");
                        this.exit();
                    }
                } else if (this.shutdownTimestamp != 0L) {
                    this.messageLog("Strato Driver - power restored [" + this.driverid + "] - shutdown cancelled");
                    this.shutdownTimestamp = 0L;
                }
            }
            return r;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean end() {
        if (this.dualSdSyncOption > 0) {
            this.registerDualSdSync(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        block39: {
            try {
                if (name.equals("beep") && (this.version == 0 || this.version == 1) || name.equals("led") && (this.version == 2 || this.version == 4)) {
                    if (value.equalsIgnoreCase("on")) {
                        this.beep(true);
                        break block39;
                    }
                    if (value.equalsIgnoreCase("off")) {
                        this.beep(false);
                        break block39;
                    }
                    int i2 = value.indexOf(59);
                    if (i2 == -1) {
                        float t1 = Float.parseFloat(value);
                        if (t1 > 0.0f && t1 <= 10.0f) {
                            this.beep(Math.round(t1 * 1000.0f));
                            break block39;
                        }
                        throw new Exception();
                    }
                    float t1 = Float.parseFloat(value.substring(0, i2));
                    float t2 = Float.parseFloat(value.substring(i2 + 1));
                    if (t1 > 0.0f && t1 <= 10.0f && t2 > 0.0f && t2 <= 10.0f) {
                        this.beep(Math.round(t1 * 1000.0f), Math.round(t2 * 1000.0f), 1);
                        break block39;
                    }
                    throw new Exception();
                }
                if (name.equals("relay") && this.version == 3) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.relay(true);
                    } else if (value.equalsIgnoreCase("off") || value.equals("0")) {
                        this.relay(false);
                    }
                    break block39;
                }
                if (name.equals("watchdog")) {
                    if (this.kernelModuleMode) {
                        this.sysFsWrite("watchdog.enabled", value);
                        break block39;
                    }
                    if (value.equals("0")) {
                        this.value(this.watchdogEnablePin, 0);
                        break block39;
                    }
                    if (value.equals("1")) {
                        this.value(this.watchdogEnablePin, 1);
                        break block39;
                    }
                    throw new Exception();
                }
                if (name.equals("heartbeat")) {
                    if (this.kernelModuleMode) {
                        this.sysFsWrite("watchdog.heartbeat", value);
                        break block39;
                    }
                    if (value.equals("0")) {
                        this.value(this.watchdogHeartbeatPin, 0);
                        break block39;
                    }
                    if (value.equals("1")) {
                        this.value(this.watchdogHeartbeatPin, 1);
                        break block39;
                    }
                    throw new Exception();
                }
                if (name.equals("shutdown")) {
                    if (value.equals("1")) {
                        this.beep(3000);
                        Boolean i2 = this.watchdogControlSemaphore;
                        synchronized (i2) {
                            this.watchdogControlSemaphore = true;
                            if (this.kernelModuleMode) {
                                if (this.sysFsWrite("power.down_enable_mode", "A") && this.sysFsWrite("power.down_delay", "2") && this.sysFsWrite("power.down_enabled", "1") && this.sysFsWrite("watchdog.timeout", "60") && this.sysFsWrite("watchdog.down_delay", "60") && this.sysFsWrite("watchdog.enabled", "1")) {
                                    this.messageLog("Strato Driver - shutdown command [" + this.driverid + "] - shutdown now");
                                    this.controlFileWrite("shutdown", "shutdown");
                                    this.exit();
                                } else {
                                    this.watchdogControlSemaphore = false;
                                    this.errorLog("Strato Driver - shutdown command [" + this.driverid + "] - failed. Exit aborted");
                                }
                            } else {
                                this.value(this.shutdownEnablePin, 1);
                                this.controlFileWrite("shutdown", "shutdown");
                            }
                            break block39;
                        }
                    }
                    throw new Exception();
                }
                if (name.equals("backlight.brightness")) {
                    this.ioWrite("backlight.brightness", Integer.toString(this.brightness(Integer.parseInt(value))));
                } else if (name.equals("dualsdsync")) {
                    if (this.dualSdSyncOption == 2 && value.equals("1")) {
                        this.registerDualSdSync(true);
                        this.ioWrite("dualsdsync", "1");
                    }
                } else if (name.equals("fan.temperature.on")) {
                    this.ioWrite("fan.temperature.on", Integer.toString(this.temperatureFanOn(Math.round(Float.parseFloat(value)))));
                } else if (name.equals("fan.temperature.off")) {
                    this.ioWrite("fan.temperature.off", Integer.toString(this.temperatureFanOff(Math.round(Float.parseFloat(value)))));
                } else if (this.kernelModuleMode) {
                    this.sysFsWrite(name, value);
                }
            }
            catch (Exception e2) {
                this.errorLog("Strato Driver - command error [" + name + "] - " + name + " = " + value);
            }
        }
    }

    public void dualSdSyncWriteStatus(long time, int status) {
        if (this.dualSdSyncOption == 2) {
            this.registerDualSdSync(false);
            this.ioWrite("dualsdsync", "0");
        }
        this.ioWriteForced("dualsdsync.time", Long.toString(time));
        this.ioWriteForced("dualsdsync.status", Integer.toString(status));
    }

    public void hearbeat() {
        if (this.kernelModuleMode) {
            this.sysFsWrite("watchdog.heartbeat", "F");
        } else {
            try {
                this.value(this.watchdogHeartbeatPin, this.watchdogHeartbeatValue == 0 ? 1 : 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean scanDirectory(File d2, int depth) {
        String fn = null;
        boolean success = false;
        try {
            File[] fa = d2.listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                block19: {
                    fn = fa[i2].getName();
                    if (!(Files.isSymbolicLink(fa[i2].toPath()) || fn.startsWith(".") || fn.equals("uevent"))) {
                        if (fa[i2].isDirectory() && depth > 0) {
                            success |= this.scanDirectory(fa[i2], depth - 1);
                        } else if (fa[i2].canRead()) {
                            BufferedReader in = null;
                            try {
                                try {
                                    in = new BufferedReader(new FileReader(fa[i2]));
                                    String value = in.readLine();
                                    if (value != null) {
                                        this.files.add(fa[i2]);
                                        success = true;
                                    }
                                }
                                catch (Exception exception) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception exception2) {}
                                    break block19;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++i2;
            }
            return success;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void controlFileWrite(String name, String value) throws Exception {
        if (value == null) {
            new File(".~" + name).delete();
        } else {
            FileOutputStream controlFileOutputStream = new FileOutputStream(".~" + name, false);
            OutputStreamWriter controlFileWriter = new OutputStreamWriter((OutputStream)controlFileOutputStream, "ASCII");
            controlFileWriter.write(value);
            controlFileWriter.close();
            controlFileOutputStream.close();
        }
    }

    private boolean sysFsWrite(String name, String value) {
        try {
            File f2 = new File(sysfs, name.toLowerCase().replace('.', '/'));
            if (f2.canWrite()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(f2));
                out.write(value);
                out.close();
                this.readFile(f2, true);
                return true;
            }
        }
        catch (Exception e2) {
            this.errorLog("Strato Driver - SysFS command [" + this.driverid + "] - exception [" + name + " = " + value + "]: " + e2.getLocalizedMessage());
            return false;
        }
        this.errorLog("Strato Driver - SysFS command [" + this.driverid + "] - error [" + name + " = " + value + "]");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(File f2, boolean events2) {
        try {
            if (!f2.canRead()) return false;
            BufferedReader in = null;
            try {
                block23: {
                    String dp;
                    String value;
                    block26: {
                        block24: {
                            block29: {
                                block28: {
                                    block27: {
                                        block25: {
                                            in = new BufferedReader(new FileReader(f2));
                                            value = in.readLine();
                                            if (value == null) break block23;
                                            dp = f2.getAbsolutePath().substring(this.sysfsPathnameLength + 1).replace('/', '.');
                                            if (!dp.startsWith("watchdog.")) break block24;
                                            if (!dp.endsWith("enabled")) break block25;
                                            this.watchdogEnabledValue = Integer.parseInt(value);
                                            dp = "watchdog";
                                            break block26;
                                        }
                                        if (!dp.endsWith("enable_mode")) break block27;
                                        this.watchdogEnableModeValue = value.charAt(0);
                                        break block26;
                                    }
                                    if (!dp.endsWith("expired")) break block28;
                                    this.watchdogExpiredValue = Integer.parseInt(value);
                                    dp = "timeout";
                                    break block26;
                                }
                                if (!dp.endsWith("heartbeat")) break block29;
                                this.watchdogHeartbeatValue = Integer.parseInt(value);
                                dp = "heartbeat";
                                break block26;
                            }
                            if (dp.endsWith("sd_switch")) {
                                this.sdSwitchValue = Integer.parseInt(value);
                                break block26;
                            } else if (dp.endsWith("timeout")) {
                                this.watchdogTimeoutValue = Integer.parseInt(value);
                                dp = "timeout.time";
                            }
                            break block26;
                        }
                        if (dp.equals("ups.battery")) {
                            this.batteryValue = Integer.parseInt(value);
                            dp = "battery";
                        } else if (dp.equals("sd.sd1_enabled")) {
                            this.sd1EnabledValue = Integer.parseInt(value);
                        }
                    }
                    if (events2) {
                        this.ioWrite(dp, value);
                        return true;
                    }
                    this.ioWriteNoEvents(dp, value);
                    return true;
                }
                this.errorLog("Strato Driver - kernel module [" + this.driverid + "] - error reading " + f2.getAbsolutePath());
                return false;
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void export(int gpio) throws Exception {
        if (!new File("/sys/class/gpio/gpio" + gpio).isDirectory()) {
            FileOutputStream exportFileOutputStream = new FileOutputStream("/sys/class/gpio/export", false);
            OutputStreamWriter exportFileWriter = new OutputStreamWriter((OutputStream)exportFileOutputStream, "ASCII");
            exportFileWriter.write(Integer.toString(gpio));
            exportFileWriter.close();
            exportFileOutputStream.close();
        }
    }

    private void direction(int gpio, boolean out) throws Exception {
        FileOutputStream gpioFileOutputStream = new FileOutputStream("/sys/class/gpio/gpio" + gpio + "/direction", false);
        OutputStreamWriter gpioFileWriter = new OutputStreamWriter((OutputStream)gpioFileOutputStream, "ASCII");
        gpioFileWriter.write(out ? "out" : "in");
        gpioFileWriter.close();
        gpioFileOutputStream.close();
    }

    private void value(int gpio, int value) throws Exception {
        FileOutputStream gpioFileOutputStream = new FileOutputStream("/sys/class/gpio/gpio" + gpio + "/value", false);
        OutputStreamWriter gpioFileWriter = new OutputStreamWriter((OutputStream)gpioFileOutputStream, "ASCII");
        gpioFileWriter.write(Integer.toString(value));
        gpioFileWriter.close();
        gpioFileOutputStream.close();
    }

    private int value(int gpio) throws Exception {
        FileInputStream gpioFileinputStream = new FileInputStream("/sys/class/gpio/gpio" + gpio + "/value");
        InputStreamReader gpioFileReader = new InputStreamReader((InputStream)gpioFileinputStream, "ASCII");
        int v = gpioFileReader.read();
        gpioFileReader.close();
        gpioFileinputStream.close();
        switch (v) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
        }
        throw new Exception();
    }

    private int temperature() throws Exception {
        FileReader tempfr = new FileReader(new File("/sys/class/thermal/thermal_zone0/temp"));
        BufferedReader tempbr = new BufferedReader(tempfr);
        int v = Integer.parseInt(tempbr.readLine());
        tempbr.close();
        tempfr.close();
        return Math.round(v / 1000);
    }

    private int temperatureFan(int mode) throws Exception {
        FileReader tempfr;
        switch (mode) {
            case 0: {
                tempfr = new FileReader(new File(sysfsFan, "sys_temp/temp"));
                break;
            }
            case 1: {
                tempfr = new FileReader(new File(sysfsFan, "fan/temp_on"));
                break;
            }
            case 2: {
                tempfr = new FileReader(new File(sysfsFan, "fan/temp_off"));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        BufferedReader tempbr = new BufferedReader(tempfr);
        int v = Integer.parseInt(tempbr.readLine());
        tempbr.close();
        tempfr.close();
        return Math.round(v / 100);
    }

    private void relay(boolean on) throws Exception {
        if (this.kernelModuleMode) {
            this.sysFsWrite("relay.status", on ? "1" : "0");
        } else {
            this.value(this.relayPin, on ? 1 : 0);
        }
    }

    private void beep(boolean on) throws Exception {
        if (this.kernelModuleMode) {
            this.sysFsWrite(this.version == 2 || this.version == 4 ? "led.blink" : "buzzer.beep", on ? "1" : "0");
        } else {
            this.value(this.buzzerLedPin, on ? 1 : 0);
        }
    }

    private void beep(int durationmillis) throws Exception {
        if (this.kernelModuleMode) {
            this.sysFsWrite(this.version == 2 || this.version == 4 ? "led.blink" : "buzzer.beep", Integer.toString(durationmillis));
        } else {
            this.value(this.buzzerLedPin, 1);
            this.sleep(Math.round(durationmillis));
            this.value(this.buzzerLedPin, 0);
        }
    }

    private void beep(int durationmillis, int pausemillis, int repeats) throws Exception {
        if (this.kernelModuleMode) {
            this.sysFsWrite(this.version == 2 || this.version == 4 ? "led.blink" : "buzzer.beep", String.valueOf(Integer.toString(durationmillis)) + " " + Integer.toString(pausemillis) + " " + Integer.toString(repeats));
        } else {
            int i2 = 0;
            while (i2 < repeats) {
                this.beep(durationmillis);
                this.sleep(pausemillis);
                ++i2;
            }
        }
    }

    private int brightness(int brightness) throws Exception {
        if (brightness >= 0 && brightness <= 255) {
            BufferedWriter out = new BufferedWriter(new FileWriter("/sys/class/backlight/rpi_backlight/brightness"));
            out.write(Integer.toString(brightness));
            out.close();
        }
        return this.brightness();
    }

    private int brightness() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader("/sys/class/backlight/rpi_backlight/brightness"));
        int v = Integer.parseInt(in.readLine());
        in.close();
        return v;
    }

    private int temperatureFanOn(int temperature) throws Exception {
        if (temperature >= -128 && temperature <= 127) {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(sysfsFan, "fan/temp_on")));
            out.write(Integer.toString(temperature * 100));
            out.close();
        }
        return this.temperatureFan(1);
    }

    private int temperatureFanOff(int temperature) throws Exception {
        if (temperature >= -128 && temperature <= 127) {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(sysfsFan, "fan/temp_off")));
            out.write(Integer.toString(temperature * 100));
            out.close();
        }
        return this.temperatureFan(2);
    }
}

