/*
 * Decompiled with CFR 0.152.
 */
package drivers.sigfox;

import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.sigfox.Driver;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class CallbackThread
extends Thread {
    private Socket connectionSocket;
    private Driver driver;

    public CallbackThread(Socket s, Driver d2) {
        this.connectionSocket = s;
        this.driver = d2;
    }

    @Override
    public void run() {
        block21: {
            BufferedReader in = null;
            DataOutputStream out = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.connectionSocket.getInputStream()));
                out = new DataOutputStream(this.connectionSocket.getOutputStream());
                String response = null;
                String URL2 = in.readLine().split(" ")[1];
                String path = URL2.split("\\?")[0];
                if (this.driver.isVerbose()) {
                    hsyco.messageLog(String.valueOf(this.driver.name) + " - debug http - " + this.connectionSocket.getInetAddress().getHostAddress() + " - " + URL2);
                }
                if (CallbackThread.checkRange(this.connectionSocket.getInetAddress().getHostAddress(), this.driver)) {
                    if (this.driver.isVerbose()) {
                        hsyco.messageLog(String.valueOf(this.driver.name) + " - debug http - " + this.connectionSocket.getInetAddress().getHostAddress() + " - Call accepted");
                    }
                    this.handleRequest(response, path, URL2, out);
                    break block21;
                }
                if (this.driver.isVerbose()) {
                    hsyco.messageLog(String.valueOf(this.driver.name) + " - debug http - " + this.connectionSocket.getInetAddress().getHostAddress() + " - Call ignored - address out of the trusted net");
                }
                response = "HTTP/1.1 404 path not found\r\n";
                out.write(response.getBytes("UTF-8"));
                out.close();
                return;
            }
            catch (SocketException e2) {
                userBase.errorLog("connection problems with Sigfox cloud - " + e2.getMessage());
            }
            catch (Exception f2) {
                userBase.errorLog("error processing incoming callback request - " + f2.getMessage());
            }
            finally {
                try {
                    this.connectionSocket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void handleRequest(String response, String path, String URL2, DataOutputStream out) throws UnsupportedEncodingException, IOException {
        if (!path.equals(this.driver.callbackPath)) {
            response = "HTTP/1.1 404 path not found\r\n";
            out.write(response.getBytes("UTF-8"));
            out.close();
            return;
        }
        String body = URL2.split("\\?")[1];
        String[] fields = body.split("&");
        String id = null;
        String timestamp = null;
        String seqNumber = null;
        String data = null;
        String batt = null;
        String temp = null;
        String key = null;
        String lqi = null;
        String deviceTypeId = null;
        String[] stringArray = fields;
        int n2 = fields.length;
        int n3 = 0;
        while (n3 < n2) {
            String field = stringArray[n3];
            String fieldId = field.split("=")[0];
            String fieldValue = field.split("=")[1];
            if (fieldId.equals("id")) {
                id = fieldValue;
            } else if (fieldId.equals("data")) {
                data = fieldValue;
            } else if (fieldId.equals("time")) {
                timestamp = fieldValue;
            } else if (fieldId.equals("seqNumber")) {
                seqNumber = fieldValue;
            } else if (fieldId.equals("batt")) {
                batt = fieldValue;
            } else if (fieldId.equals("temp")) {
                temp = fieldValue;
            } else if (fieldId.equals("key")) {
                key = fieldValue;
            } else if (fieldId.equals("lqi")) {
                lqi = this.convertLqi(fieldValue);
            } else if (fieldId.equals("deviceTypeId")) {
                deviceTypeId = fieldValue;
            }
            ++n3;
        }
        if (key == null || !key.equals(this.driver.callbackkey)) {
            response = "HTTP/1.1 401 Unauthorized\r\n";
        } else if (id == null) {
            response = "HTTP/1.1 400 Format error: device id must not be empty\r\n";
        } else {
            long newTimestamp = timestamp != null ? Long.parseLong(timestamp) * 1000L : System.currentTimeMillis();
            this.driver.updateMsg(id, seqNumber, data, newTimestamp, temp, batt, lqi, deviceTypeId);
            response = "HTTP/1.1 200 OK\r\n";
        }
        out.write(response.getBytes("UTF-8"));
        out.flush();
        out.close();
    }

    public String convertLqi(String val) {
        String value = val.toLowerCase();
        if (value.equals("limit")) {
            return "0";
        }
        if (value.equals("average")) {
            return "1";
        }
        if (value.equals("good")) {
            return "2";
        }
        if (value.equals("excellent")) {
            return "3";
        }
        return "4";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkRange(String ipToCheck, Driver driver) {
        try {
            String[] rangeSplit;
            long test = CallbackThread.ipToLong(InetAddress.getByName(ipToCheck));
            String rangeStr = driver.callbackiprange;
            if (rangeStr == null || rangeStr.isEmpty()) {
                return false;
            }
            String[] stringArray = rangeSplit = rangeStr.split(",");
            int n2 = rangeSplit.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                String range = stringArray[n3];
                long lower = CallbackThread.ipToLong(InetAddress.getByName(range.split("-")[0]));
                long hi = CallbackThread.ipToLong(InetAddress.getByName(range.split("-")[1]));
                if (test >= lower && test <= hi) {
                    return true;
                }
                ++n3;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        byte[] byArray = octets;
        int n2 = octets.length;
        int n3 = 0;
        while (n3 < n2) {
            byte octet = byArray[n3];
            result <<= 8;
            result |= (long)(octet & 0xFF);
            ++n3;
        }
        return result;
    }
}

