/*
 * Decompiled with CFR 0.152.
 */
package drivers.siemensedp;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import drivers.siemensedp.Command;
import drivers.siemensedp.Driver;
import drivers.siemensedp.MessageFrameV2;
import drivers.siemensedp.MessageManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class SiemensEdpServer
extends Thread {
    private final byte DATA_SEPARATOR = (byte)9;
    private final byte DATA_LINE_FEED = (byte)10;
    private final int POLLING_TIME_TOLLERANCE_MILLISEC = 2000;
    private final byte DEFAULT_OUTPUTS = (byte)6;
    private final byte RESPONSE_OK = (byte)-16;
    private final byte RESPONSE_OK_INCOMPLETE = (byte)-15;
    ArrayList<String> logs = new ArrayList();
    String pattern = "yyyy-MM-dd HH:mm:ss";
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.pattern);
    Driver driver;
    public boolean run;
    Driver.SOCKET_TYPE socketType;
    private boolean processInitialized = false;
    private ServerSocket serverSocket;
    private Socket socket;
    private long lastSequenceNumber = 0L;
    private long lastMsgTimestamp = 0L;
    private boolean socketConnected = false;
    private final String XML_COMMAND = "COMMAND";
    private final String XML_COMMAND_ID = "ID";
    private COMMAND_TYPE lastSentCommand = null;
    private XML_COMMAND_TYPE lastSentXmlCommand = null;
    private long expectedCommandSequenceNumber = 0L;
    private boolean firstReadDone = false;
    private int panelAddress = 0;
    private int lastZoneRead = 1;
    private int maxZones = 1;
    private ArrayList<Command> commandsToExecute = new ArrayList();
    private static final String AREA_MODE_UNSET = "0";
    private static final String AREA_MODE_PART_SET_A = "1";
    private static final String AREA_MODE_PART_SET_B = "2";
    private static final String AREA_MODE_FULL_SET = "3";
    static final HashMap<String, String> areaModes = new HashMap();
    private static final String ZONE_STATE_INHIBIT = "INHIBIT";
    private static final String ZONE_STATE_ISOLATE = "ISOLATE";
    private static final String ZONE_STATE_ALARM = "ALARM";
    private static final String ZONE_STATE_SHORT = "SHORT";
    private static final String ZONE_STATE_OFFLINE = "OFFLINE";

    static {
        areaModes.put(AREA_MODE_UNSET, "unset");
        areaModes.put(AREA_MODE_PART_SET_A, "part_a");
        areaModes.put(AREA_MODE_PART_SET_B, "part_b");
        areaModes.put(AREA_MODE_FULL_SET, "fullset");
    }

    public SiemensEdpServer(Driver driver, Driver.SOCKET_TYPE socketType) {
        this.driver = driver;
        this.socketType = socketType;
        this.maxZones = driver.forcedLastZone;
    }

    private boolean startup() {
        this.lastSequenceNumber = 0L;
        this.socketConnected = false;
        this.lastSentCommand = null;
        this.lastSentXmlCommand = null;
        this.expectedCommandSequenceNumber = 0L;
        this.firstReadDone = false;
        this.panelAddress = 0;
        this.simpleDateFormat = new SimpleDateFormat(this.pattern);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        hsyco.messageLog("SiemensEdp: Starting Siemens EDP server for " + this.socketType.toString());
        try {
            block12: {
                if (this.serverSocket == null) {
                    if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                        this.serverSocket = new ServerSocket(this.driver.commandsSocketPort);
                        this.serverSocket.setSoTimeout(this.driver.commandsPollingTimeMilli + 2000);
                    } else {
                        this.serverSocket = new ServerSocket(this.driver.eventsSocketPort);
                        this.serverSocket.setSoTimeout(this.driver.eventsPollingTimeMilli + 2000);
                    }
                }
                if (Configuration.verboseLog) {
                    hsyco.messageLog("SiemensEdp: Server accepting connections on port: " + this.serverSocket.getLocalPort());
                }
                try {
                    this.socket = this.serverSocket.accept();
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("SiemensEdp: EVENTS SOCKET ACCEPT: " + this.socket.getInetAddress());
                    }
                    this.socketConnected = true;
                }
                catch (IOException ex) {
                    if (!Configuration.verboseLog) break block12;
                    hsyco.errorLog("SiemensEdp: EXCEPTION: " + ex);
                }
            }
            Date now = new Date();
            this.lastMsgTimestamp = now.getTime();
            this.processInitialized = true;
            return true;
        }
        catch (Exception e2) {
            hsyco.errorLog("SiemensEdp: Server not started because of: " + e2.getClass() + " - " + e2.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void run() {
        if (!this.processInitialized) {
            this.driver.ioWriteInternal("connection", "offline", this.driver.startupEvent);
            if (this.driver.gui) {
                this.driver.uiSetVisible("connection.online", "false");
                this.driver.uiSetVisible("connection.offline", "true");
            }
            if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                this.driver.ioWriteInternal("connection.socket.commands", "offline", this.driver.startupEvent);
                if (this.driver.gui) {
                    this.driver.uiSetVisible("connection.socket.commands.online", "false");
                    this.driver.uiSetVisible("connection.socket.commands.offline", "true");
                }
            } else {
                this.driver.ioWriteInternal("connection.socket.events", "offline", this.driver.startupEvent);
                if (this.driver.gui) {
                    this.driver.uiSetVisible("connection.socket.events.online", "false");
                    this.driver.uiSetVisible("connection.socket.events.offline", "true");
                }
            }
            this.startup();
        }
        this.run = true;
        while (this.run) {
            if (!this.socketConnected) {
                this.driver.ioWriteInternal("connection", "offline", true);
                if (this.driver.gui) {
                    this.driver.uiSetVisible("connection.online", "false");
                    this.driver.uiSetVisible("connection.offline", "true");
                }
                if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                    this.driver.ioWriteInternal("connection.socket.commands", "offline", true);
                    if (this.driver.gui) {
                        this.driver.uiSetVisible("connection.socket.commands.online", "false");
                        this.driver.uiSetVisible("connection.socket.commands.offline", "true");
                    }
                } else {
                    this.driver.ioWriteInternal("connection.socket.events", "offline", true);
                    if (this.driver.gui) {
                        this.driver.uiSetVisible("connection.socket.events.online", "false");
                        this.driver.uiSetVisible("connection.socket.events.offline", "true");
                    }
                }
                this.startup();
            }
            Date now = new Date();
            if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                if (now.getTime() - this.lastMsgTimestamp > (long)(this.driver.commandsPollingTimeMilli + 2000)) {
                    this.driver.ioWriteInternal("connection", "offline", true);
                    this.driver.ioWriteInternal("connection.socket.commands", "offline", true);
                    if (this.driver.gui) {
                        this.driver.uiSetVisible("connection.online", "false");
                        this.driver.uiSetVisible("connection.offline", "true");
                        this.driver.uiSetVisible("connection.socket.commands.online", "false");
                        this.driver.uiSetVisible("connection.socket.commands.offline", "true");
                    }
                    this.startup();
                }
            } else if (now.getTime() - this.lastMsgTimestamp > (long)(this.driver.eventsPollingTimeMilli + 2000)) {
                this.driver.ioWriteInternal("connection", "offline", true);
                this.driver.ioWriteInternal("connection.socket.events", "offline", true);
                if (this.driver.gui) {
                    this.driver.uiSetVisible("connection.online", "false");
                    this.driver.uiSetVisible("connection.offline", "true");
                    this.driver.uiSetVisible("connection.socket.events.online", "false");
                    this.driver.uiSetVisible("connection.socket.events.offline", "true");
                }
                this.startup();
            }
            try {
                if (!this.firstReadDone) {
                    this.processRequest(this.driver.startupEvent);
                    this.firstReadDone = true;
                } else {
                    this.processRequest(true);
                }
            }
            catch (Exception e2) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("SiemensEdp: Generic exception in processor loop: " + e2);
                }
                this.processInitialized = false;
            }
            try {
                SiemensEdpServer.sleep(5L);
            }
            catch (InterruptedException e3) {
                if (!Configuration.verboseLog) continue;
                hsyco.errorLog("SiemensEdp: Exception in processor loop sleep: " + e3);
            }
        }
    }

    void processRequest(boolean triggerEvent) {
        if (this.socket != null) {
            String line = "";
            try {
                int byteInt = 0;
                while (this.socket.getInputStream().available() > 0) {
                    byteInt = this.socket.getInputStream().read();
                    String hexStr = Integer.toHexString(byteInt);
                    if (hexStr.length() % 2 == 1) {
                        hexStr = AREA_MODE_UNSET + hexStr;
                    }
                    line = String.valueOf(line) + hexStr;
                }
                if (!line.equals("")) {
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("last.message.frame: " + line);
                    }
                    MessageFrameV2 frame = MessageManager.parseMessageFrame(line);
                    Date now = new Date();
                    this.lastSequenceNumber = Driver.bytesToUnsignedLong(frame.getSequenceNumber());
                    this.lastMsgTimestamp = now.getTime();
                    this.panelAddress = Driver.bytesToUnsignedInteger(frame.getSourceId());
                    if (frame.getMajorFunctionCode() == MAJOR_CODE.CONNECTION_MNG.byteValue && frame.getMinorFunctionCode() == 2) {
                        this.lastSentCommand = null;
                        this.lastSentXmlCommand = null;
                        MessageFrameV2 responseFrame = MessageManager.createTcpConnectionEstablishReply((byte)8, frame.getSequenceNumber(), frame.getDestinationId(), frame.getSourceId(), frame.getData());
                        byte[] response = responseFrame.getBytesForTransmission();
                        OutputStream outputStream = this.socket.getOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        dataOutputStream.write(response);
                        dataOutputStream.flush();
                    } else if (frame.getMajorFunctionCode() == MAJOR_CODE.CONNECTION_MNG.byteValue && frame.getMinorFunctionCode() == 0) {
                        this.lastSentCommand = null;
                        this.lastSentXmlCommand = null;
                        MessageFrameV2 responseFrame = MessageManager.createTcpConnectionPollReply((byte)8, frame.getSequenceNumber(), frame.getDestinationId(), frame.getSourceId(), frame.getData());
                        byte[] response = responseFrame.getBytesForTransmission();
                        OutputStream outputStream = this.socket.getOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        dataOutputStream.write(response);
                        dataOutputStream.flush();
                        this.driver.ioWriteInternal("connection", "online", triggerEvent);
                        if (this.driver.gui) {
                            this.driver.uiSetVisible("connection.online", "true");
                            this.driver.uiSetVisible("connection.offline", "false");
                        }
                        if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                            this.driver.ioWriteInternal("connection.socket.commands", "online", triggerEvent);
                            if (this.driver.gui) {
                                this.driver.uiSetVisible("connection.socket.commands.online", "true");
                                this.driver.uiSetVisible("connection.socket.commands.offline", "false");
                            }
                        } else {
                            this.driver.ioWriteInternal("connection.socket.events", "online", triggerEvent);
                            if (this.driver.gui) {
                                this.driver.uiSetVisible("connection.socket.events.online", "true");
                                this.driver.uiSetVisible("connection.socket.events.offline", "false");
                            }
                        }
                        if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                            String hexSourceDeviceNumber = Integer.toHexString(this.driver.commandsDeviceAddress);
                            while (hexSourceDeviceNumber.length() < 8) {
                                hexSourceDeviceNumber = AREA_MODE_UNSET + hexSourceDeviceNumber;
                            }
                            byte[] source = Driver.hexStringToByteArray(hexSourceDeviceNumber);
                            Driver.invertEndianessUsingFor(source);
                            String hexDestinationDeviceNumber = Integer.toHexString(this.panelAddress);
                            while (hexDestinationDeviceNumber.length() < 8) {
                                hexDestinationDeviceNumber = AREA_MODE_UNSET + hexDestinationDeviceNumber;
                            }
                            byte[] destination = Driver.hexStringToByteArray(hexDestinationDeviceNumber);
                            Driver.invertEndianessUsingFor(destination);
                            int commandCounter = 0;
                            for (Command command : this.commandsToExecute) {
                                if (commandCounter >= 2) break;
                                this.execute(source, destination, command.getMajorCode().getByteValue(), command.getCommandData(), triggerEvent);
                                this.commandsToExecute.remove(command);
                            }
                            if (this.driver.forcedLastZone != 10000) {
                                if (this.lastZoneRead == this.maxZones) {
                                    if (Configuration.verboseLog) {
                                        hsyco.messageLog("SiemensEdp: processrequest - forced, lastZoneRead == maxZones");
                                    }
                                    this.lastZoneRead = 1;
                                }
                                byte[] startingZone = SiemensEdpServer.intToInvertedHexByteArray(this.lastZoneRead);
                                byte[] startingZoneNormal = SiemensEdpServer.intToHexByteArray(this.lastZoneRead);
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("SiemensEdp: processrequest - forced, lastZoneRead = " + this.lastZoneRead);
                                }
                                this.lastZoneRead += 50;
                                if (this.lastZoneRead > this.maxZones) {
                                    this.lastZoneRead = this.maxZones;
                                    if (Configuration.verboseLog) {
                                        hsyco.messageLog("SiemensEdp: processrequest - forced, lastZoneRead > maxZones, lastZoneRead = " + this.lastZoneRead);
                                    }
                                }
                                byte[] endingZone = SiemensEdpServer.intToInvertedHexByteArray(this.lastZoneRead);
                                byte[] endingZoneNormal = SiemensEdpServer.intToHexByteArray(this.lastZoneRead);
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("SiemensEdp: processrequest - forced, read zones from:" + SiemensEdpServer.hexArrayToString(startingZoneNormal) + " to: " + SiemensEdpServer.hexArrayToString(endingZoneNormal));
                                }
                                int combinedLength = 1 + startingZone.length + endingZone.length;
                                byte[] combinedArray = new byte[combinedLength];
                                combinedArray[0] = COMMAND_TYPE.GET_ZONE_STATUS.byteValue;
                                System.arraycopy(startingZone, 0, combinedArray, 1, startingZone.length);
                                System.arraycopy(endingZone, 0, combinedArray, 1 + startingZone.length, endingZone.length);
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("SiemensEdp: processrequest - forced, combined array: " + SiemensEdpServer.byteArrayToString(combinedArray));
                                }
                                this.execute(source, destination, MAJOR_CODE.PANEL_COMMAND.getByteValue(), combinedArray, triggerEvent);
                            } else {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("SiemensEdp: processrequest - standard zone status request");
                                }
                                this.execute(source, destination, MAJOR_CODE.PANEL_COMMAND.getByteValue(), new byte[]{COMMAND_TYPE.GET_ZONE_STATUS.byteValue}, triggerEvent);
                            }
                            byte[] byArray = new byte[5];
                            byArray[0] = COMMAND_TYPE.GET_OUTPUT_STATUS.byteValue;
                            byArray[1] = 1;
                            byArray[3] = 6;
                            this.execute(source, destination, MAJOR_CODE.PANEL_COMMAND.getByteValue(), byArray, triggerEvent);
                            this.execute(source, destination, MAJOR_CODE.PANEL_COMMAND.getByteValue(), new byte[]{COMMAND_TYPE.GET_AREA_STATUS.byteValue}, triggerEvent);
                        }
                    } else if (frame.getMajorFunctionCode() == MAJOR_CODE.PANEL_COMMAND.byteValue && frame.getMinorFunctionCode() == 2) {
                        if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                            long replySeqNum = Driver.bytesToUnsignedLong(frame.getSequenceNumber());
                            if ((-16 == frame.getData()[0] || -15 == frame.getData()[0]) && replySeqNum == this.expectedCommandSequenceNumber) {
                                switch (this.lastSentCommand) {
                                    case GET_ZONE_STATUS: {
                                        byte[] dataByteArray = Arrays.copyOfRange(frame.getData(), 1, frame.getData().length);
                                        int recordFieldsSize = 4;
                                        ArrayList<byte[]> result = Driver.splitByteArrayOnPattern(dataByteArray, (byte)9, (byte)10);
                                        boolean zonesInhibited = false;
                                        boolean zonesIsolated = false;
                                        boolean zonesAlarmed = false;
                                        boolean zonesShorted = false;
                                        boolean zonesOffline = false;
                                        int i2 = 0;
                                        while (i2 < result.size() / recordFieldsSize) {
                                            String zoneNumber = new String(result.get(i2 * recordFieldsSize + 0), StandardCharsets.UTF_8);
                                            String zoneType = new String(result.get(i2 * recordFieldsSize + 1), StandardCharsets.UTF_8);
                                            String zoneState = new String(result.get(i2 * recordFieldsSize + 2), StandardCharsets.UTF_8);
                                            String zoneName = new String(result.get(i2 * recordFieldsSize + 3), StandardCharsets.UTF_8);
                                            this.driver.ioWriteInternal("zone." + zoneNumber + ".type", zoneType.toLowerCase(), triggerEvent);
                                            this.driver.ioWriteInternal("zone." + zoneNumber + ".state", zoneState.toLowerCase(), triggerEvent);
                                            this.driver.ioWriteInternal("zone." + zoneNumber + ".name", zoneName, triggerEvent);
                                            String dpInhibit = zoneState.equals(ZONE_STATE_INHIBIT) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpIsolate = zoneState.equals(ZONE_STATE_ISOLATE) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpAlarm = zoneState.equals(ZONE_STATE_ALARM) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpShort = zoneState.equals(ZONE_STATE_SHORT) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpOffline = zoneState.equals(ZONE_STATE_OFFLINE) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            this.driver.ioWriteInternal("zone." + zoneNumber + ".mode.cmd.inhibit", dpInhibit, triggerEvent);
                                            this.driver.ioWriteInternal("zone." + zoneNumber + ".mode.cmd.isolate", dpIsolate, triggerEvent);
                                            if (this.driver.gui) {
                                                this.driver.uiSetValue("zone." + zoneNumber + ".name", zoneName);
                                                this.driver.uiSetValue("zone." + zoneNumber + ".type", zoneType.toLowerCase());
                                                this.driver.uiSetValue("zone." + zoneNumber + ".state", zoneState.toLowerCase());
                                                String value = zoneState.equalsIgnoreCase("closed") ? "true" : "false";
                                                this.driver.uiSetVisible("zone." + zoneNumber + ".state.closed", value);
                                                value = zoneState.equalsIgnoreCase("open") ? "true" : "false";
                                                this.driver.uiSetVisible("zone." + zoneNumber + ".state.open", value);
                                                value = zoneState.equalsIgnoreCase("isolated") ? "true" : "false";
                                                this.driver.uiSetVisible("zone." + zoneNumber + ".state.isolated", value);
                                                value = zoneState.equalsIgnoreCase("inhibit") ? "true" : "false";
                                                this.driver.uiSetVisible("zone." + zoneNumber + ".state.inhibit", value);
                                            }
                                            if (dpInhibit.equalsIgnoreCase(AREA_MODE_PART_SET_A)) {
                                                zonesInhibited = true;
                                            }
                                            if (dpIsolate.equalsIgnoreCase(AREA_MODE_PART_SET_A)) {
                                                zonesIsolated = true;
                                            }
                                            if (dpAlarm.equalsIgnoreCase(AREA_MODE_PART_SET_A)) {
                                                zonesAlarmed = true;
                                            }
                                            if (dpShort.equalsIgnoreCase(AREA_MODE_PART_SET_A)) {
                                                zonesShorted = true;
                                            }
                                            if (dpOffline.equalsIgnoreCase(AREA_MODE_PART_SET_A)) {
                                                zonesOffline = true;
                                            }
                                            ++i2;
                                        }
                                        String dpAtLeastOneZoneInhibited = zonesInhibited ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("zones.inhibited", dpAtLeastOneZoneInhibited, triggerEvent);
                                        String dpAtLeastOneZoneIsolated = zonesIsolated ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("zones.isolated", dpAtLeastOneZoneIsolated, triggerEvent);
                                        String dpAtLeastOneZoneInAlarm = zonesAlarmed ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("zones.alarmed", dpAtLeastOneZoneInAlarm, triggerEvent);
                                        String dpAtLeastOneZoneShorted = zonesShorted ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("zones.shorted", dpAtLeastOneZoneShorted, triggerEvent);
                                        String dpAtLeastOneZoneOffline = zonesOffline ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("zones.offline", dpAtLeastOneZoneOffline, triggerEvent);
                                        if (!this.driver.gui) break;
                                        String value = dpAtLeastOneZoneInhibited.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("zones.inhibited", value);
                                        value = dpAtLeastOneZoneIsolated.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("zones.isolated", value);
                                        value = dpAtLeastOneZoneInAlarm.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("zones.alarmed", value);
                                        value = dpAtLeastOneZoneShorted.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("zones.shorted", value);
                                        value = dpAtLeastOneZoneOffline.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("zones.offline", value);
                                        break;
                                    }
                                    case GET_OUTPUT_STATUS: {
                                        int i3 = 1;
                                        while (i3 < frame.getData().length) {
                                            this.driver.ioWriteInternal("output." + i3 + ".value", "" + frame.getData()[i3], triggerEvent);
                                            if (this.driver.gui) {
                                                String value = frame.getData()[i3] == 1 ? "true" : "false";
                                                this.driver.uiSetVisible("output." + i3 + ".1", value);
                                                value = frame.getData()[i3] == 0 ? "true" : "false";
                                                this.driver.uiSetVisible("output." + i3 + ".0", value);
                                            }
                                            ++i3;
                                        }
                                        break;
                                    }
                                    case GET_AREA_STATUS: {
                                        byte[] dataByteArray = Arrays.copyOfRange(frame.getData(), 1, frame.getData().length);
                                        int recordFieldsSize = 3;
                                        ArrayList<byte[]> result = Driver.splitByteArrayOnPattern(dataByteArray, (byte)9, (byte)10);
                                        boolean areasArmed = false;
                                        int i4 = 0;
                                        while (i4 < result.size() / recordFieldsSize) {
                                            String areaNumber = new String(result.get(i4 * recordFieldsSize + 0), StandardCharsets.UTF_8);
                                            String areaName = new String(result.get(i4 * recordFieldsSize + 1), StandardCharsets.UTF_8);
                                            String areaMode = new String(result.get(i4 * recordFieldsSize + 2), StandardCharsets.UTF_8);
                                            this.driver.ioWriteInternal("area." + areaNumber + ".name", areaName, triggerEvent);
                                            this.driver.ioWriteInternal("area." + areaNumber + ".mode", areaModes.get(areaMode).toLowerCase(), triggerEvent);
                                            String dpFullSet = areaMode.equals(AREA_MODE_FULL_SET) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpPartSetA = areaMode.equals(AREA_MODE_PART_SET_A) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpPartSetB = areaMode.equals(AREA_MODE_PART_SET_B) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            String dpUnset = areaMode.equals(AREA_MODE_UNSET) ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                            this.driver.ioWriteInternal("area." + areaNumber + ".mode.cmd.fullset", dpFullSet, triggerEvent);
                                            this.driver.ioWriteInternal("area." + areaNumber + ".mode.cmd.part.set.a", dpPartSetA, triggerEvent);
                                            this.driver.ioWriteInternal("area." + areaNumber + ".mode.cmd.part.set.b", dpPartSetB, triggerEvent);
                                            this.driver.ioWriteInternal("area." + areaNumber + ".mode.cmd.unset", dpUnset, triggerEvent);
                                            if (this.driver.gui) {
                                                this.driver.uiSetValue("area." + areaNumber + ".name", areaName);
                                                this.driver.uiSetValue("area." + areaNumber + ".mode", areaMode);
                                                String value = areaMode.equalsIgnoreCase(AREA_MODE_FULL_SET) ? "true" : "false";
                                                this.driver.uiSetVisible("area." + areaNumber + ".mode.fullset", value);
                                                value = areaMode.equalsIgnoreCase(AREA_MODE_UNSET) ? "true" : "false";
                                                this.driver.uiSetVisible("area." + areaNumber + ".mode.unset", value);
                                                value = areaMode.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                                this.driver.uiSetVisible("area." + areaNumber + ".mode.part.set.a", value);
                                                value = areaMode.equalsIgnoreCase(AREA_MODE_PART_SET_B) ? "true" : "false";
                                                this.driver.uiSetVisible("area." + areaNumber + ".mode.part.set.b", value);
                                            }
                                            if (dpFullSet.equals(AREA_MODE_PART_SET_A) || dpPartSetA.equals(AREA_MODE_PART_SET_A) || dpPartSetB.equals(AREA_MODE_PART_SET_A)) {
                                                areasArmed = true;
                                            }
                                            ++i4;
                                        }
                                        String dpAtLeastOneAreaArmed = areasArmed ? AREA_MODE_PART_SET_A : AREA_MODE_UNSET;
                                        this.driver.ioWriteInternal("areas.armed", dpAtLeastOneAreaArmed, triggerEvent);
                                        if (!this.driver.gui) break;
                                        String value = dpAtLeastOneAreaArmed.equalsIgnoreCase(AREA_MODE_PART_SET_A) ? "true" : "false";
                                        this.driver.uiSetVisible("areas.armed", value);
                                        break;
                                    }
                                }
                                this.lastSentCommand = null;
                            }
                        }
                    } else if (frame.getMajorFunctionCode() == MAJOR_CODE.XML.byteValue && frame.getMinorFunctionCode() == 1) {
                        if (this.socketType == Driver.SOCKET_TYPE.COMMANDS) {
                            long replySeqNum = Driver.bytesToUnsignedLong(frame.getSequenceNumber());
                            if (-16 == frame.getData()[0] && replySeqNum == this.expectedCommandSequenceNumber) {
                                switch (this.lastSentXmlCommand) {
                                    case GET_INFO: {
                                        break;
                                    }
                                    case GET_OUTPUT_STATUS: {
                                        break;
                                    }
                                }
                                this.lastSentCommand = null;
                            }
                        }
                    } else if (frame.getMajorFunctionCode() == MAJOR_CODE.EVENT.byteValue && frame.getMinorFunctionCode() == 0) {
                        MessageFrameV2 responseFrame = MessageManager.createSiaEventAck((byte)8, frame.getSequenceNumber(), frame.getDestinationId(), frame.getSourceId(), frame.getData());
                        byte[] response = responseFrame.getBytesForTransmission();
                        OutputStream outputStream = this.socket.getOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        dataOutputStream.write(response);
                        dataOutputStream.flush();
                        String newLogLine = "Sia event = " + frame.getDataString();
                        this.driver.ioWriteInternal("log0", newLogLine, triggerEvent);
                        this.securityLog(newLogLine);
                    }
                }
            }
            catch (Exception e2) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("SiemensEdp: Generic exception in processor loop: " + e2);
                }
                try {
                    Thread.sleep((long)(Math.random() * 5000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void addCommandToExecutionList(MAJOR_CODE major, byte[] commandData) {
        Command command = new Command(major, commandData);
        this.commandsToExecute.add(command);
    }

    private void execute(byte[] source, byte[] destination, byte majorCode, byte[] commandData, boolean triggerEvent) {
        ++this.lastSequenceNumber;
        String hexNewSequenceNumber = Long.toHexString(this.lastSequenceNumber);
        while (hexNewSequenceNumber.length() < 8) {
            hexNewSequenceNumber = AREA_MODE_UNSET + hexNewSequenceNumber;
        }
        byte[] seqNumber = Driver.hexStringToByteArray(hexNewSequenceNumber);
        Driver.invertEndianessUsingFor(seqNumber);
        try {
            MessageFrameV2 commandFrame = MessageManager.createMessageFrame((byte)8, seqNumber, source, destination, majorCode, (byte)0, commandData);
            byte[] transmission = commandFrame.getBytesForTransmission();
            OutputStream outputStream = this.socket.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.write(transmission);
            dataOutputStream.flush();
        }
        catch (IOException e2) {
            hsyco.errorLog("SiemensEdp: Error trasmitting command " + e2.getLocalizedMessage());
        }
        if (majorCode == MAJOR_CODE.XML.byteValue) {
            byte[] newCommandData = Arrays.copyOfRange(commandData, 1, commandData.length);
            String commandDataStr = new String(newCommandData, StandardCharsets.UTF_8);
            Document doc = SiemensEdpServer.convertStringToXMLDocument(commandDataStr);
            NodeList nodeList = doc.getElementsByTagName("COMMAND");
            String commandId = nodeList.item(0).getAttributes().getNamedItem("ID").getNodeValue();
            this.lastSentXmlCommand = XML_COMMAND_TYPE.findXmlCommandType(commandId);
        } else {
            this.lastSentCommand = COMMAND_TYPE.findPanelCommandType(commandData[0]);
        }
        this.expectedCommandSequenceNumber = this.lastSequenceNumber;
        Date start = new Date();
        Date current = new Date();
        try {
            while (this.socket.getInputStream().available() <= 0) {
                current = new Date();
                if (current.getTime() - start.getTime() < (long)(this.driver.commandsPollingTimeMilli + 2000)) continue;
                hsyco.errorLog("SiemensEdp: Timeout error waiting command reply for command " + majorCode);
                this.socketConnected = false;
                return;
            }
        }
        catch (IOException e1) {
            hsyco.errorLog("SiemensEdp: Error waiting command reply" + e1.getLocalizedMessage());
        }
        this.processRequest(triggerEvent);
        Date now = new Date();
        this.lastMsgTimestamp = now.getTime();
    }

    void securityLog(String message) {
        hsyco.securityLog("SiemensEdp - " + message);
        this.driver.uiSetValue("log0", message);
        String entry = String.valueOf(this.simpleDateFormat.format(new Date())) + " - " + message + "<br />";
        this.logs.add(0, entry);
        while (this.logs.size() > this.driver.logSize) {
            this.logs.remove(this.driver.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            entry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(entry).append("</div>");
            ++i2;
        }
        this.driver.uiSetValue("log", text.toString());
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                String logVar = "SiemensEdplog";
                this.driver.varSetDriver(logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e2) {
            hsyco.errorLog("SiemensEdp: Xml string conversion error");
            return null;
        }
    }

    public static String byteArrayToString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = byteArray;
        int n2 = byteArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b2 = byArray[n3];
            hexString.append(String.format("%02X ", b2 & 0xFF));
            ++n3;
        }
        return hexString.toString().trim();
    }

    public static byte[] intToHexByteArray(int value) {
        if (value < 0 || value > 9999) {
            throw new IllegalArgumentException("Number should be between 0 and 9999");
        }
        String hexString = Integer.toHexString(value);
        if (hexString.length() % 2 != 0) {
            hexString = AREA_MODE_UNSET + hexString;
        }
        byte[] hexByteArray = new byte[hexString.length() / 2];
        int i2 = 0;
        while (i2 < hexByteArray.length) {
            int index = i2 * 2;
            hexByteArray[i2] = (byte)Integer.parseInt(hexString.substring(index, index + 2), 16);
            ++i2;
        }
        return hexByteArray;
    }

    public static byte[] intToInvertedHexByteArray(int value) {
        if (value < 0 || value > 9999) {
            throw new IllegalArgumentException("Number should be between 0 and 9999");
        }
        value = Math.min(value, 9999);
        String hexString = String.format("%04X", value);
        byte[] hexByteArray = new byte[]{(byte)Integer.parseInt(hexString.substring(2, 4), 16), (byte)Integer.parseInt(hexString.substring(0, 2), 16)};
        return hexByteArray;
    }

    public static String hexArrayToString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = byteArray;
        int n2 = byteArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b2 = byArray[n3];
            hexString.append(String.format("%02X ", b2 & 0xFF));
            ++n3;
        }
        return hexString.toString().trim();
    }

    static enum COMMAND_TYPE {
        GET_AREA_STATUS("Get area status", 23),
        SET_AREA("Set area", 1),
        UNSET_AREA("Unset area", 2),
        PART_SET_A_AREA("Part set area a", 15),
        PART_SET_B_AREA("Part set area b", 16),
        GET_ZONE_STATUS("Get zone status", 5),
        INHIBIT_ZONES("Inhibit zones", 3),
        DE_INHIBIT_ZONES("De-inhibit zones", 4),
        ISOLATE_ZONES("Isolate zones", 9),
        DE_ISOLATE_ZONES("De-isolate zones", 10),
        GET_OUTPUT_STATUS("Get output status", 12),
        SET_OUTPUTS("Set outputs", 13),
        RESET_OUTPUTS("Reset outputs", 14);

        private final String name;
        private final byte byteValue;

        private COMMAND_TYPE(String name, byte byteValue) {
            this.name = name;
            this.byteValue = byteValue;
        }

        public byte getByteValue() {
            return this.byteValue;
        }

        public String getName() {
            return this.name;
        }

        public static COMMAND_TYPE findPanelCommandType(byte value) {
            COMMAND_TYPE[] cOMMAND_TYPEArray = COMMAND_TYPE.values();
            int n2 = cOMMAND_TYPEArray.length;
            int n3 = 0;
            while (n3 < n2) {
                COMMAND_TYPE type = cOMMAND_TYPEArray[n3];
                if (type.byteValue == value) {
                    return type;
                }
                ++n3;
            }
            return null;
        }
    }

    static enum MAJOR_CODE {
        CONNECTION_MNG("Connection management", 1),
        EVENT("SIA event", 2),
        PANEL_COMMAND("Panel command", 4),
        SYSTEM_COMMAND("System command", 5),
        AUDIO("Audio", 6),
        VIDEO("Video", 7),
        CRYPTO("Crypto", 8),
        XML("XML", 10);

        private final String name;
        private final byte byteValue;

        private MAJOR_CODE(String name, byte byteValue) {
            this.name = name;
            this.byteValue = byteValue;
        }

        public byte getByteValue() {
            return this.byteValue;
        }

        public String getName() {
            return this.name;
        }

        public static MAJOR_CODE findMajorCode(byte value) {
            MAJOR_CODE[] mAJOR_CODEArray = MAJOR_CODE.values();
            int n2 = mAJOR_CODEArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MAJOR_CODE code = mAJOR_CODEArray[n3];
                if (code.byteValue == value) {
                    return code;
                }
                ++n3;
            }
            return null;
        }
    }

    static enum XML_COMMAND_TYPE {
        GET_INFO("Get info", "info"),
        GET_OUTPUT_STATUS("Get output status", "output_status");

        private final String name;
        private final String value;

        private XML_COMMAND_TYPE(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static XML_COMMAND_TYPE findXmlCommandType(String value) {
            XML_COMMAND_TYPE[] xML_COMMAND_TYPEArray = XML_COMMAND_TYPE.values();
            int n2 = xML_COMMAND_TYPEArray.length;
            int n3 = 0;
            while (n3 < n2) {
                XML_COMMAND_TYPE type = xML_COMMAND_TYPEArray[n3];
                if (type.value == value) {
                    return type;
                }
                ++n3;
            }
            return null;
        }
    }
}

