/*
 * Decompiled with CFR 0.152.
 */
package drivers.siemensedp;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import drivers.siemensedp.Driver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class MessageFrameV2 {
    private byte protocolId = (byte)69;
    private byte frameLayoutVersion = (byte)2;
    private byte protocolFlags;
    private byte[] sequenceNumber = new byte[4];
    private byte[] sourceId = new byte[4];
    private byte[] destinationId = new byte[4];
    private byte majorFunctionCode;
    private byte minorFunctionCode;
    private byte[] crcCheckSum = new byte[2];
    private byte[] dataLength = new byte[2];
    private byte[] data;
    private String dataString;
    private byte[] padding;

    public MessageFrameV2() {
        this.protocolId = (byte)69;
        this.frameLayoutVersion = (byte)2;
        this.crcCheckSum = new byte[2];
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public byte getFrameLayoutVersion() {
        return this.frameLayoutVersion;
    }

    public byte getProtocolFlags() {
        return this.protocolFlags;
    }

    public void setProtocolFlags(byte protocolFlags) {
        this.protocolFlags = protocolFlags;
    }

    public byte[] getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(byte[] sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public byte[] getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(byte[] sourceId) {
        this.sourceId = sourceId;
    }

    public byte[] getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(byte[] destinationId) {
        this.destinationId = destinationId;
    }

    public byte getMajorFunctionCode() {
        return this.majorFunctionCode;
    }

    public void setMajorFunctionCode(byte majorFunctionCode) {
        this.majorFunctionCode = majorFunctionCode;
    }

    public byte getMinorFunctionCode() {
        return this.minorFunctionCode;
    }

    public void setMinorFunctionCode(byte minorFunctionCode) {
        this.minorFunctionCode = minorFunctionCode;
    }

    public byte[] getCrcCheckSum() {
        return this.crcCheckSum;
    }

    public void setCrcCheckSum(byte[] crcCheckSum) {
        this.crcCheckSum = crcCheckSum;
    }

    public byte[] getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(byte[] dataLength) {
        this.dataLength = dataLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.setDataString(new String(data, StandardCharsets.UTF_8));
    }

    public String getDataString() {
        return this.dataString;
    }

    public void setDataString(String dataString) {
        this.dataString = dataString;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
    }

    public byte[] getFrameLength() {
        int result = 21 + Driver.bytesToUnsignedInteger(this.dataLength);
        String res = Integer.toHexString(result);
        if (res.length() < 4) {
            res = "0" + res;
        }
        byte[] byteArray = Driver.hexStringToByteArray(res);
        Driver.invertEndianessUsingFor(byteArray);
        return byteArray;
    }

    public String getCrcCheckSumString() {
        String res = "";
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.protocolId});
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.frameLayoutVersion});
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.protocolFlags});
        res = String.valueOf(res) + Driver.bytesToHex(this.sequenceNumber);
        res = String.valueOf(res) + Driver.bytesToHex(this.sourceId);
        res = String.valueOf(res) + Driver.bytesToHex(this.destinationId);
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.majorFunctionCode});
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.minorFunctionCode});
        res = String.valueOf(res) + Driver.bytesToHex(this.crcCheckSum);
        res = String.valueOf(res) + Driver.bytesToHex(this.dataLength);
        res = String.valueOf(res) + Driver.bytesToHex(this.data);
        if (Configuration.verboseLog) {
            hsyco.messageLog("SiemensEdp: Using hex string for CRC computation: " + res);
        }
        return res;
    }

    public byte[] getBytesForTransmission() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.getFrameLength());
        baos.write(this.protocolId);
        baos.write(this.frameLayoutVersion);
        baos.write(this.protocolFlags);
        baos.write(this.sequenceNumber);
        baos.write(this.sourceId);
        baos.write(this.destinationId);
        baos.write(this.majorFunctionCode);
        baos.write(this.minorFunctionCode);
        baos.write(this.crcCheckSum);
        baos.write(this.dataLength);
        baos.write(this.data);
        byte[] result = baos.toByteArray();
        if (Configuration.verboseLog) {
            hsyco.messageLog("SiemensEdp: Message frame to transmit: 0x" + Driver.bytesToHex(result));
        }
        return result;
    }

    public String printHexString() {
        String res = "";
        int length = 0;
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.protocolId});
        ++length;
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.frameLayoutVersion});
        ++length;
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.protocolFlags});
        ++length;
        res = String.valueOf(res) + Driver.bytesToHex(this.sequenceNumber);
        length += 4;
        res = String.valueOf(res) + Driver.bytesToHex(this.sourceId);
        length += 4;
        res = String.valueOf(res) + Driver.bytesToHex(this.destinationId);
        length += 4;
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.majorFunctionCode});
        ++length;
        res = String.valueOf(res) + Driver.bytesToHex(new byte[]{this.minorFunctionCode});
        ++length;
        res = String.valueOf(res) + Driver.bytesToHex(this.crcCheckSum);
        length += 2;
        res = String.valueOf(res) + Driver.bytesToHex(this.dataLength);
        length += 2;
        res = String.valueOf(res) + Driver.bytesToHex(this.data);
        length += this.data.length;
        res = String.valueOf(res) + Driver.bytesToHex(this.padding);
        hsyco.messageLog("SiemensEdp: Created message frame: " + res + ", length: " + (length += this.padding.length));
        return res;
    }

    public void printInfo() {
        hsyco.messageLog("SiemensEdp: [Frame info] Protocol Id: 0x" + Driver.bytesToHex(new byte[]{this.protocolId}) + ", " + Driver.bytesToUnsignedShort(new byte[]{this.protocolId}));
        hsyco.messageLog("SiemensEdp: [Frame info] Layout version: 0x" + Driver.bytesToHex(new byte[]{this.frameLayoutVersion}) + ", " + Driver.bytesToUnsignedShort(new byte[]{this.frameLayoutVersion}));
        hsyco.messageLog("SiemensEdp: [Frame info] Protocol flags: 0x" + Driver.bytesToHex(new byte[]{this.protocolFlags}) + ", " + Driver.bytesToUnsignedShort(new byte[]{this.protocolFlags}));
        hsyco.messageLog("SiemensEdp: [Frame info] Sequence number: 0x" + Driver.bytesToHex(this.sequenceNumber) + ", " + Driver.bytesToUnsignedLong(this.sequenceNumber));
        hsyco.messageLog("SiemensEdp: [Frame info] Source id: 0x" + Driver.bytesToHex(this.sourceId) + ", " + Driver.bytesToUnsignedLong(this.sourceId));
        hsyco.messageLog("SiemensEdp: [Frame info] Destination id: 0x" + Driver.bytesToHex(this.destinationId) + ", " + Driver.bytesToUnsignedLong(this.destinationId));
        hsyco.messageLog("SiemensEdp: [Frame info] Major function code: 0x" + Driver.bytesToHex(new byte[]{this.majorFunctionCode}) + ", " + Driver.bytesToUnsignedShort(new byte[]{this.majorFunctionCode}));
        hsyco.messageLog("SiemensEdp: [Frame info] Minor function code: 0x" + Driver.bytesToHex(new byte[]{this.minorFunctionCode}) + ", " + Driver.bytesToUnsignedShort(new byte[]{this.minorFunctionCode}));
        hsyco.messageLog("SiemensEdp: [Frame info] Crc checksum: 0x" + Driver.bytesToHex(this.crcCheckSum) + ", " + Driver.bytesToUnsignedInteger(this.crcCheckSum));
        hsyco.messageLog("SiemensEdp: [Frame info] Data length: 0x" + Driver.bytesToHex(this.dataLength) + ", " + Driver.bytesToUnsignedInteger(this.dataLength));
        hsyco.messageLog("SiemensEdp: [Frame info] Data: 0x" + Driver.bytesToHex(this.data) + ", String format: " + this.dataString);
    }
}

