/*
 * Decompiled with CFR 0.152.
 */
package drivers.siemensedp;

import com.hsyco.driverBase;
import drivers.siemensedp.SiemensEdpServer;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Driver
extends driverBase {
    private SiemensEdpServer eventsServerThread;
    private SiemensEdpServer commandsServerThread;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    public static final String driverName = "SiemensEdp";
    public static final int DEFAULT_EVENTS_ADDRESS = 1;
    public static final int DEFAULT_EVENTS_SOCKET_PORT = 50000;
    public static final int DEFAULT_EVENTS_POLLING_TIME = 8000;
    public static final int DEFAULT_COMMANDS_ADDRESS = 2;
    public static final int DEFAULT_COMMANDS_SOCKET_PORT = 50001;
    public static final int DEFAULT_COMMANDS_POLLING_TIME = 2000;
    public static final int FORCED_LAST_ZONE = 10000;
    int eventsSocketPort = 50000;
    int eventsDeviceAddress = 1;
    int commandsSocketPort = 50001;
    int commandsDeviceAddress = 2;
    int eventsPollingTimeMilli = 8000;
    int commandsPollingTimeMilli = 2000;
    int forcedLastZone = 10000;
    boolean startupEvent = true;
    boolean gui = true;
    int logSize = 100;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        try {
            this.eventsSocketPort = Integer.parseInt(config.get("eventsport"));
            if (this.eventsSocketPort < 1 || this.eventsSocketPort > 65535) {
                this.eventsSocketPort = 50000;
            }
        }
        catch (Exception e2) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - eventsport ignored");
        }
        try {
            this.commandsSocketPort = Integer.parseInt(config.get("commandsport"));
            if (this.commandsSocketPort < 1 || this.commandsSocketPort > 65535) {
                this.commandsSocketPort = 50001;
            }
        }
        catch (Exception e3) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - commandsport ignored");
        }
        try {
            this.eventsDeviceAddress = Integer.parseInt(config.get("eventsaddress"));
            if (this.eventsDeviceAddress < 1 || this.eventsDeviceAddress > 65535) {
                this.eventsDeviceAddress = 1;
            }
        }
        catch (Exception e4) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - eventsaddress ignored");
        }
        try {
            this.commandsDeviceAddress = Integer.parseInt(config.get("commandsaddress"));
            if (this.commandsDeviceAddress < 1 || this.commandsDeviceAddress > 65535) {
                this.commandsDeviceAddress = 2;
            }
        }
        catch (Exception e5) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - commandsaddress ignored");
        }
        try {
            this.eventsPollingTimeMilli = Integer.parseInt(config.get("eventspolling"));
            if (this.eventsPollingTimeMilli < 1000 || this.eventsPollingTimeMilli > 60000) {
                this.eventsPollingTimeMilli = 8000;
            }
        }
        catch (Exception e6) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - eventspolling ignored");
        }
        try {
            this.commandsPollingTimeMilli = Integer.parseInt(config.get("commandspolling"));
            if (this.commandsPollingTimeMilli < 1000 || this.commandsPollingTimeMilli > 60000) {
                this.commandsPollingTimeMilli = 2000;
            }
        }
        catch (Exception e7) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - commandspolling ignored");
        }
        try {
            this.startupEvent = Boolean.parseBoolean(config.get("startupevents"));
        }
        catch (Exception e8) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - startupevents ignored");
        }
        try {
            this.gui = Boolean.parseBoolean(config.get("gui"));
        }
        catch (Exception e9) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - gui ignored");
        }
        try {
            this.forcedLastZone = Integer.parseInt(config.get("forcedlastzone"));
            if (this.forcedLastZone < 1) {
                this.forcedLastZone = 1;
            }
            if (this.forcedLastZone >= 10000) {
                this.forcedLastZone = 10000;
            }
        }
        catch (Exception e10) {
            this.errorLog("SiemensEdp: ioServersOption format error [" + name + "] - forced last zone ignored");
        }
        this.eventsServerThread = new SiemensEdpServer(this, SOCKET_TYPE.EVENTS);
        this.eventsServerThread.start();
        this.commandsServerThread = new SiemensEdpServer(this, SOCKET_TYPE.COMMANDS);
        this.commandsServerThread.start();
        return true;
    }

    public boolean loop() {
        this.sleep(5L);
        return true;
    }

    public boolean end() {
        this.eventsServerThread.run = false;
        this.commandsServerThread.run = false;
        return true;
    }

    public void command(String name, String value) {
        block35: {
            try {
                byte[] data;
                ByteArrayOutputStream outputStream;
                byte[] newNumberInBytes;
                byte[] numberInBytes;
                String hexNumber;
                if (this.isVerboseLog()) {
                    this.messageLog("SiemensEdp: command: " + name + " / value: " + value);
                    this.messageLog("SiemensEdp: command - subcommand: " + name + " / value: " + value);
                }
                if (name.startsWith("zone.")) {
                    hexNumber = Integer.toHexString(Integer.parseInt(name.split("\\.")[1]));
                    if (hexNumber.length() < 4) {
                        hexNumber = "0" + hexNumber;
                    }
                    if ((numberInBytes = Driver.hexStringToByteArray(hexNumber)).length < 2) {
                        newNumberInBytes = new byte[2];
                        newNumberInBytes[0] = numberInBytes[0];
                        numberInBytes = newNumberInBytes;
                    }
                    if (name.endsWith("mode.cmd.inhibit")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.INHIBIT_ZONES.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        } else if (value.equals("0")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.DE_INHIBIT_ZONES.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    } else if (name.endsWith("mode.cmd.isolate")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.ISOLATE_ZONES.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        } else if (value.equals("0")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.DE_ISOLATE_ZONES.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    }
                }
                if (name.startsWith("area.")) {
                    hexNumber = Integer.toHexString(Integer.parseInt(name.split("\\.")[1]));
                    if (hexNumber.length() < 4) {
                        hexNumber = "0" + hexNumber;
                    }
                    if ((numberInBytes = Driver.hexStringToByteArray(hexNumber)).length < 2) {
                        newNumberInBytes = new byte[2];
                        newNumberInBytes[0] = numberInBytes[0];
                        numberInBytes = newNumberInBytes;
                    }
                    if (name.endsWith("mode.cmd.fullset")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.SET_AREA.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    } else if (name.endsWith("mode.cmd.part.set.a")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.PART_SET_A_AREA.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    } else if (name.endsWith("mode.cmd.part.set.b")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.PART_SET_B_AREA.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    } else if (name.endsWith("mode.cmd.unset") && value.equals("1")) {
                        outputStream = new ByteArrayOutputStream();
                        outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.UNSET_AREA.getByteValue()});
                        outputStream.write(numberInBytes);
                        data = outputStream.toByteArray();
                        this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                    }
                }
                if (name.startsWith("output.")) {
                    hexNumber = Integer.toHexString(Integer.parseInt(name.split("\\.")[1]));
                    if (hexNumber.length() < 4) {
                        hexNumber = "0" + hexNumber;
                    }
                    if ((numberInBytes = Driver.hexStringToByteArray(hexNumber)).length < 2) {
                        newNumberInBytes = new byte[2];
                        newNumberInBytes[0] = numberInBytes[0];
                        numberInBytes = newNumberInBytes;
                    }
                    if (name.endsWith("value")) {
                        if (value.equals("1")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.SET_OUTPUTS.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        } else if (value.equals("0")) {
                            outputStream = new ByteArrayOutputStream();
                            outputStream.write(new byte[]{SiemensEdpServer.COMMAND_TYPE.RESET_OUTPUTS.getByteValue()});
                            outputStream.write(numberInBytes);
                            data = outputStream.toByteArray();
                            this.commandsServerThread.addCommandToExecutionList(SiemensEdpServer.MAJOR_CODE.PANEL_COMMAND, data);
                        }
                    }
                }
            }
            catch (Exception e2) {
                if (!this.isVerboseLog()) break block35;
                this.messageLog("SiemensEdp - command failed " + name + ": " + value);
            }
        }
    }

    void ioWriteInternal(String name, String value, boolean eventNotification) {
        if (eventNotification) {
            this.ioWrite(name, value);
        } else {
            this.ioWriteNoEvents(name, value);
        }
    }

    void uiSetVisible(String name, String value) {
        this.uiSet(name, "visible", value);
    }

    void uiSetValue(String name, String value) {
        this.uiSet(name, "value", value);
    }

    void varSetDriver(String name, String value) {
        this.varSet("$" + name, value);
    }

    static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        if (len % 2 == 1) {
            ++len;
            s = "0" + s;
        }
        byte[] data = new byte[len / 2];
        int i2 = 0;
        while (i2 < len) {
            data[i2 / 2] = (byte)((Character.digit(s.charAt(i2), 16) << 4) + Character.digit(s.charAt(i2 + 1), 16));
            i2 += 2;
        }
        return data;
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        String result = new String(hexChars).toLowerCase();
        if (result.length() % 2 != 0) {
            result = "0" + result;
        }
        return result;
    }

    static short bytesToUnsignedShort(byte[] array) {
        byte[] paddedArray = new byte[2];
        int arrayLengthToCopy = array.length <= 2 ? array.length : 2;
        int i2 = 0;
        while (i2 < arrayLengthToCopy) {
            paddedArray[i2] = array[i2];
            ++i2;
        }
        Driver.invertEndianessUsingFor(paddedArray);
        ByteBuffer wrapped = ByteBuffer.wrap(paddedArray);
        short value = wrapped.getShort();
        return value;
    }

    static int bytesToUnsignedInteger(byte[] array) {
        byte[] paddedArray = new byte[4];
        int arrayLengthToCopy = array.length <= 4 ? array.length : 4;
        int i2 = 0;
        while (i2 < arrayLengthToCopy) {
            paddedArray[i2] = array[i2];
            ++i2;
        }
        Driver.invertEndianessUsingFor(paddedArray);
        ByteBuffer wrapped = ByteBuffer.wrap(paddedArray);
        int value = wrapped.getInt();
        return value;
    }

    static long bytesToUnsignedLong(byte[] array) {
        byte[] paddedArray = new byte[8];
        int arrayLengthToCopy = array.length <= 8 ? array.length : 8;
        int i2 = 0;
        while (i2 < arrayLengthToCopy) {
            paddedArray[i2] = array[i2];
            ++i2;
        }
        Driver.invertEndianessUsingFor(paddedArray);
        ByteBuffer wrapped = ByteBuffer.wrap(paddedArray);
        long value = wrapped.getLong();
        return value;
    }

    static int hexCharToDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    static void invertEndianessUsingFor(byte[] array) {
        int i2 = 0;
        while (i2 < array.length / 2) {
            byte temp = array[i2];
            array[i2] = array[array.length - 1 - i2];
            array[array.length - 1 - i2] = temp;
            ++i2;
        }
    }

    static ArrayList<byte[]> splitByteArrayOnPattern(byte[] byteArray, byte pattern, byte lineFeed) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int bytesLength = 0;
        int i2 = 0;
        while (i2 < byteArray.length) {
            if (byteArray[i2] == pattern || byteArray[i2] == lineFeed) {
                byte[] data = Arrays.copyOfRange(byteArray, i2 - bytesLength, i2);
                result.add(data);
                bytesLength = 0;
            } else {
                ++bytesLength;
            }
            ++i2;
        }
        byte[] data = Arrays.copyOfRange(byteArray, byteArray.length - bytesLength, byteArray.length);
        result.add(data);
        return result;
    }

    public static enum SOCKET_TYPE {
        EVENTS,
        COMMANDS;

    }
}

