/*
 * Decompiled with CFR 0.152.
 */
package drivers.siemensedp;

import drivers.siemensedp.Driver;
import java.io.IOException;

public class CRC {
    private static final String EDP_MAGIC = "E";
    private static final short EDP_INX_MAGIC = 0;
    private static final short EDP_INX_VERSION = 1;
    private static final short EDP_INX_FLAGS = 2;
    private static final short EDP_V1_INX_SEQ = 3;
    private static final short EDP_V1_INX_SOURCE = 4;
    private static final short EDP_V1_INX_MAJOR = 8;
    private static final short EDP_V1_INX_MINOR = 9;
    private static final short EDP_V1_INX_CRC = 10;
    private static final short EDP_V1_INX_DATA_LENGTH = 12;
    private static final short EDP_V1_INX_DATA = 14;
    private static final short EDP_V1_HEAD1LEN = 8;
    private static final short EDP_V1_HEAD2LEN = 6;
    private static final short EDP_V1_HEAD_LENGTH = 14;
    private static final short EDP_V2_INX_SEQ = 3;
    private static final short EDP_V2_INX_SOURCE = 7;
    private static final short EDP_V2_INX_DESTINATION = 11;
    private static final short EDP_V2_INX_MAJOR = 15;
    private static final short EDP_V2_INX_MINOR = 16;
    private static final short EDP_V2_INX_CRC = 17;
    private static final short EDP_V2_INX_DATA_LENGTH = 19;
    private static final short EDP_V2_INX_DATA = 21;
    private static final short EDP_V2_HEAD1LEN = 15;
    private static final short EDP_V2_HEAD2LEN = 6;
    private static final short EDP_V2_HEAD_LENGTH = 21;
    private static final short EDP_FLAGS_ENCRYPT = 1;
    private static final short EDP_FLAGS_MASTERKEY = 2;
    private static final short EDP_FLAGS_COMPRESS = 4;
    private static final short EDP_FLAGS_DONT_COMPRESS = 8;

    private static int edp_net2hs(byte[] p) throws IOException {
        if (p.length != 2) {
            throw new IOException("CRC conversion error, byte array length should be 2");
        }
        int val = Driver.bytesToUnsignedInteger(p);
        return val;
    }

    static byte[] edp_calc_crc(String packet, short version) throws IOException {
        int edp_inx_crc;
        int j2;
        String subStr;
        int hl = 0;
        int lo = 255;
        int hi = 255;
        if (version == 1) {
            subStr = packet.substring(24, 28);
            j2 = CRC.edp_net2hs(Driver.hexStringToByteArray(subStr)) + 14;
            edp_inx_crc = 10;
        } else {
            subStr = packet.substring(38, 42);
            j2 = CRC.edp_net2hs(Driver.hexStringToByteArray(subStr)) + 21;
            edp_inx_crc = 17;
        }
        int i2 = 0;
        while (i2 < j2) {
            if (i2 != edp_inx_crc && i2 != edp_inx_crc + 1) {
                int c2 = hi;
                hl = (hi << 8) + lo;
                hl <<= 1;
                lo = (short)(hl &= 0xFFFF);
                hi = (short)(hl >> 8);
                hi = (short)(hi & 0xFF);
                String s = packet.substring(i2 * 2, i2 * 2 + 2);
                short n2 = (short)Integer.parseInt(s, 16);
                lo = (short)(lo + n2);
                lo = (short)(lo & 0xFF);
                if ((c2 & 0x80) != 0) {
                    lo = (short)(lo ^ 0x97);
                    hi = (short)(hi ^ 0xA0);
                }
            }
            ++i2;
        }
        hl = (hi << 8) + lo;
        String hexString = Long.toHexString(hl);
        byte[] result = Driver.hexStringToByteArray(hexString);
        Driver.invertEndianessUsingFor(result);
        byte[] paddedResult = new byte[2];
        int k2 = 0;
        while (k2 < result.length) {
            paddedResult[k2] = result[k2];
            ++k2;
        }
        return paddedResult;
    }
}

