/*
 * Decompiled with CFR 0.152.
 */
package drivers.protege;

import drivers.protege.Driver;
import java.util.ArrayList;
import java.util.List;

public class Listener
extends Thread {
    public boolean run;
    Driver d;
    private List<Byte> response = new ArrayList<Byte>();
    private boolean areasLastIndexRead = false;
    private boolean inputsLastIndexRead = false;
    private boolean outputsLastIndexRead = false;
    private boolean doorsLastIndexRead = false;
    private boolean troubleInputsLastIndexRead = false;
    private byte[] REQAREASTATUS;
    private byte[] REQOUTPUTSTATUS;
    private byte[] REQINPUTSTATUS;
    private byte[] REQDOORSTATUS;
    private byte[] REQTROUBLEINPUTSTATUS;

    public Listener(Driver d2) {
        byte[] byArray = new byte[12];
        byArray[0] = 73;
        byArray[1] = 67;
        byArray[2] = 12;
        byArray[6] = 2;
        byArray[7] = -128;
        byArray[8] = 1;
        this.REQAREASTATUS = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 73;
        byArray2[1] = 67;
        byArray2[2] = 12;
        byArray2[6] = 3;
        byArray2[7] = -128;
        byArray2[8] = 1;
        this.REQOUTPUTSTATUS = byArray2;
        byte[] byArray3 = new byte[12];
        byArray3[0] = 73;
        byArray3[1] = 67;
        byArray3[2] = 12;
        byArray3[6] = 4;
        byArray3[7] = -128;
        byArray3[8] = 1;
        this.REQINPUTSTATUS = byArray3;
        byte[] byArray4 = new byte[12];
        byArray4[0] = 73;
        byArray4[1] = 67;
        byArray4[2] = 12;
        byArray4[6] = 1;
        byArray4[7] = -128;
        byArray4[8] = 1;
        this.REQDOORSTATUS = byArray4;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 73;
        byArray5[1] = 67;
        byArray5[2] = 12;
        byArray5[6] = 6;
        byArray5[7] = -128;
        byArray5[8] = 1;
        this.REQTROUBLEINPUTSTATUS = byArray5;
        this.d = d2;
    }

    @Override
    public void run() {
        this.run = true;
        while (this.run) {
            try {
                this.response = this.d.readSomething2(this.d.dIn);
                if (this.response.isEmpty()) continue;
                if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 48 && this.response.get(7) == 1) {
                    this.readSystemLog(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 2) {
                    this.readAreaStatus(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 3) {
                    this.readOutputStatus(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 4) {
                    this.readInputStatus(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 1) {
                    this.readDoorStatus(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 5) {
                    this.readVariableStatus(this.response.subList(9, this.response.size()));
                } else if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 0 && this.response.get(7) == 6) {
                    this.readTroubleInputStatus(this.response.subList(9, this.response.size()));
                }
                if (this.response.get(0) == 73 && this.response.get(1) == 67 && this.response.get(6) == 48 && this.response.get(7) == 0) {
                    this.readNumericLog(this.response.subList(9, this.response.size()));
                }
                if (!this.d.endFirstLoop) continue;
                if (this.d.whichCase == 0 && this.areasLastIndexRead) {
                    this.d.genEvent = true;
                    this.d.ioWrite("connection", "online");
                    this.d.securityLog("HSYCO ONLINE");
                    this.d.endFirstLoop = false;
                    if (!this.d.isVerboseLog()) continue;
                    this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - first loop end case 0");
                    continue;
                }
                if (this.d.whichCase == 1 && this.inputsLastIndexRead) {
                    this.d.genEvent = true;
                    this.d.ioWrite("connection", "online");
                    this.d.securityLog("HSYCO ONLINE");
                    this.d.endFirstLoop = false;
                    if (!this.d.isVerboseLog()) continue;
                    this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - first loop end case 1");
                    continue;
                }
                if (this.d.whichCase == 2 && this.outputsLastIndexRead) {
                    this.d.genEvent = true;
                    this.d.ioWrite("connection", "online");
                    this.d.securityLog("HSYCO ONLINE");
                    this.d.endFirstLoop = false;
                    if (!this.d.isVerboseLog()) continue;
                    this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - first loop end case 2");
                    continue;
                }
                if (this.d.whichCase == 3 && this.doorsLastIndexRead) {
                    this.d.genEvent = true;
                    this.d.ioWrite("connection", "online");
                    this.d.securityLog("HSYCO ONLINE");
                    this.d.endFirstLoop = false;
                    if (!this.d.isVerboseLog()) continue;
                    this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - first loop end case 3");
                    continue;
                }
                if (this.d.whichCase != 4 || !this.troubleInputsLastIndexRead) continue;
                this.d.genEvent = true;
                this.d.ioWrite("connection", "online");
                this.d.securityLog("HSYCO ONLINE");
                this.d.endFirstLoop = false;
                if (!this.d.isVerboseLog()) continue;
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - first loop end case 4");
            }
            catch (Exception e2) {
                if (this.d.isVerboseLog()) {
                    this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - EXCEPTION - quit driver " + e2.getMessage());
                }
                this.d.quit = true;
            }
        }
    }

    private void readSystemLog(List<Byte> r) {
        String newLogLine = "";
        boolean cleanQuit = false;
        for (byte b2 : r) {
            char c2 = (char)b2;
            newLogLine = String.valueOf(newLogLine) + c2;
            if (b2 != 0) continue;
            this.d.ioWrite("log0", newLogLine);
            this.d.securityLog(newLogLine);
            cleanQuit = true;
            break;
        }
        if (!cleanQuit && this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - log with missing terminator");
        }
    }

    private void readNumericLog(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(5), r.get(4), r.get(3), r.get(2)};
        long index = this.byteArrayToLong(indexBytes);
        if (r.get(1) == 4) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " for input index: " + index);
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - request - input status - index: " + index);
            }
            this.REQINPUTSTATUS[8] = r.get(2);
            this.REQINPUTSTATUS[9] = r.get(3);
            this.REQINPUTSTATUS[10] = r.get(4);
            this.REQINPUTSTATUS[11] = r.get(5);
            this.d.sendCommand(this.REQINPUTSTATUS);
        } else if (r.get(1) == 5) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " for trouble input index: " + index);
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - request - trouble input status - index: " + index);
            }
            this.REQTROUBLEINPUTSTATUS[8] = r.get(2);
            this.REQTROUBLEINPUTSTATUS[9] = r.get(3);
            this.REQTROUBLEINPUTSTATUS[10] = r.get(4);
            this.REQTROUBLEINPUTSTATUS[11] = r.get(5);
            this.d.sendCommand(this.REQTROUBLEINPUTSTATUS);
        } else if (r.get(1) == 6) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " for output index: " + index);
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - request - output status - index: " + index);
            }
            this.REQOUTPUTSTATUS[8] = r.get(2);
            this.REQOUTPUTSTATUS[9] = r.get(3);
            this.REQOUTPUTSTATUS[10] = r.get(4);
            this.REQOUTPUTSTATUS[11] = r.get(5);
            this.d.sendCommand(this.REQOUTPUTSTATUS);
        } else if (r.get(1) == 8) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " for area index: " + index);
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - request - area status - index: " + index);
            }
            this.REQAREASTATUS[8] = r.get(2);
            this.REQAREASTATUS[9] = r.get(3);
            this.REQAREASTATUS[10] = r.get(4);
            this.REQAREASTATUS[11] = r.get(5);
            this.d.sendCommand(this.REQAREASTATUS);
        } else if (r.get(1) == 10) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " for door index: " + index);
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - request - door status - index: " + index);
            }
            this.REQDOORSTATUS[8] = r.get(2);
            this.REQDOORSTATUS[9] = r.get(3);
            this.REQDOORSTATUS[10] = r.get(4);
            this.REQDOORSTATUS[11] = r.get(5);
            this.d.sendCommand(this.REQDOORSTATUS);
        } else if (r.get(1) == 15) {
            byte[] moduleBytes = new byte[]{r.get(9), r.get(8), r.get(7), r.get(6)};
            long moduleIndex = this.byteArrayToLong(moduleBytes);
            byte[] channelBytes = new byte[]{r.get(13), r.get(12), r.get(11), r.get(10)};
            long channelIndex = this.byteArrayToLong(channelBytes);
            byte[] valueBytes = new byte[]{r.get(14), r.get(18)};
            long value = this.byteArrayToLong2(valueBytes);
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - numeric log: event code: " + r.get(1) + " analog status - module: " + moduleIndex + " - channel: " + channelIndex + " - value: " + value);
            }
            this.d.ioWrite("av.module." + moduleIndex + ".channel." + channelIndex, String.valueOf(value));
        }
    }

    private void readAreaStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L) {
            String areaTamperState;
            String areaState = Integer.toHexString(r.get(4) & 0xFF);
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - area status - index: " + index);
            }
            if (areaState.equals("0")) {
                this.d.ioWrite("a" + index + ".state", "disarmed");
                this.d.ioWrite("a" + index + ".armed", "0");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "disarmed");
                }
            } else if (areaState.equals("80")) {
                this.d.ioWrite("a" + index + ".state", "armed");
                this.d.ioWrite("a" + index + ".armed", "1");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "armed");
                }
            } else if (areaState.equals("1")) {
                this.d.ioWrite("a" + index + ".state", "inputsopen");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "inputsopen");
                }
            } else if (areaState.equals("2")) {
                this.d.ioWrite("a" + index + ".state", "trouble");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "trouble");
                }
            } else if (areaState.equals("3")) {
                this.d.ioWrite("a" + index + ".state", "bypasserror");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "bypasserror");
                }
            } else if (areaState.equals("4")) {
                this.d.ioWrite("a" + index + ".state", "bypasswarning");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "bypasswarning");
                }
            } else if (areaState.equals("5")) {
                this.d.ioWrite("a" + index + ".state", "usercountnotzero");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "usercountnotzero");
                }
            } else if (areaState.equals("81")) {
                this.d.ioWrite("a" + index + ".state", "exitdelay");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "exitdelay");
                }
            } else if (areaState.equals("82")) {
                this.d.ioWrite("a" + index + ".state", "entrydelay");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "entrydelay");
                }
            } else if (areaState.equals("83")) {
                this.d.ioWrite("a" + index + ".state", "disarmdelay");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "disarmdelay");
                }
            } else if (areaState.equals("84")) {
                this.d.ioWrite("a" + index + ".state", "codedelay");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".state", "value", "codedelay");
                }
            }
            if ((areaTamperState = Integer.toHexString(r.get(5) & 0xFF)).equals("0")) {
                this.d.ioWrite("a" + index + ".tamper.state", "disarmed");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".tamper.state", "value", "disarmed");
                }
            } else if (areaTamperState.equals("1")) {
                this.d.ioWrite("a" + index + ".tamper.state", "busy");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".tamper.state", "value", "busy");
                }
            } else if (areaTamperState.equals("80")) {
                this.d.ioWrite("a" + index + ".tamper.state", "armed");
                if (this.d.gui) {
                    this.d.uiSet("a" + index + ".tamper.state", "value", "armed");
                }
            }
            String areaStateFlags = String.format("%8s", Integer.toBinaryString(r.get(6) & 0xFF)).replace(' ', '0');
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - area status state flags: " + areaStateFlags);
            }
            this.d.ioWrite("a" + index + ".state.flags.alarm.activated", areaStateFlags.substring(7, 8));
            this.d.ioWrite("a" + index + ".state.flags.siren.activated", areaStateFlags.substring(6, 7));
            this.d.ioWrite("a" + index + ".state.flags.alarms.in.memory", areaStateFlags.substring(5, 6));
            this.d.ioWrite("a" + index + ".state.flags.remote.armed", areaStateFlags.substring(4, 5));
            this.d.ioWrite("a" + index + ".state.flags.force.armed", areaStateFlags.substring(3, 4));
            this.d.ioWrite("a" + index + ".state.flags.instant.armed", areaStateFlags.substring(2, 3));
            this.d.ioWrite("a" + index + ".state.flags.partial.armed", areaStateFlags.substring(1, 2));
            if (index == this.d.areasLastIndex) {
                this.areasLastIndexRead = true;
            }
        } else if (this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - area status - index error: " + index);
        }
    }

    private void readOutputStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - ouput status - index: " + index);
            }
            String outputAscii = "";
            int i2 = 4;
            while (i2 <= 11) {
                byte b2 = r.get(i2);
                char c2 = (char)b2;
                outputAscii = String.valueOf(outputAscii) + c2;
                ++i2;
            }
            this.d.ioWrite("o" + index + ".ascii", outputAscii);
            String outputState = Integer.toHexString(r.get(12) & 0xFF);
            if (outputState.equals("0")) {
                this.d.ioWrite("o" + index + ".state", "off");
                if (this.d.gui) {
                    this.d.uiSet("o" + index + ".state", "value", "off");
                }
            } else if (outputState.equals("1")) {
                this.d.ioWrite("o" + index + ".state", "on");
                if (this.d.gui) {
                    this.d.uiSet("o" + index + ".state", "value", "on");
                }
            } else if (outputState.equals("2")) {
                this.d.ioWrite("o" + index + ".state", "onpulsed");
                if (this.d.gui) {
                    this.d.uiSet("o" + index + ".state", "value", "onpulsed");
                }
            } else if (outputState.equals("3")) {
                this.d.ioWrite("o" + index + ".state", "ontimed");
                if (this.d.gui) {
                    this.d.uiSet("o" + index + ".state", "value", "ontimed");
                }
            } else if (outputState.equals("4")) {
                this.d.ioWrite("o" + index + ".state", "onpulsedtimed");
                if (this.d.gui) {
                    this.d.uiSet("o" + index + ".state", "value", "onpulsedtimed");
                }
            }
            if (index == this.d.outputsLastIndex) {
                this.outputsLastIndexRead = true;
            }
        } else if (this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER - READ - ouput status - index error: " + index);
        }
    }

    private void readInputStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - input status - index: " + index);
            }
            String inputAscii = "";
            int i2 = 4;
            while (i2 <= 11) {
                byte b2 = r.get(i2);
                char c2 = (char)b2;
                inputAscii = String.valueOf(inputAscii) + c2;
                ++i2;
            }
            this.d.ioWrite("i" + index + ".ascii", inputAscii);
            String inputState = Integer.toHexString(r.get(12) & 0xFF);
            if (inputState.equals("0")) {
                this.d.ioWrite("i" + index + ".state", "closed");
                this.d.ioWrite("i" + index + ".closed", "1");
                this.d.ioWrite("i" + index + ".short", "0");
                this.d.ioWrite("i" + index + ".tamper", "0");
                if (this.d.gui) {
                    this.d.uiSet("i" + index + ".state", "value", "closed");
                }
            } else if (inputState.equals("1")) {
                this.d.ioWrite("i" + index + ".state", "open");
                this.d.ioWrite("i" + index + ".closed", "0");
                this.d.ioWrite("i" + index + ".short", "0");
                this.d.ioWrite("i" + index + ".tamper", "0");
                if (this.d.gui) {
                    this.d.uiSet("i" + index + ".state", "value", "open");
                }
            } else if (inputState.equals("2")) {
                this.d.ioWrite("i" + index + ".state", "short");
                this.d.ioWrite("i" + index + ".short", "1");
                this.d.ioWrite("i" + index + ".tamper", "0");
                this.d.ioWrite("i" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("i" + index + ".state", "value", "short");
                }
            } else if (inputState.equals("3")) {
                this.d.ioWrite("i" + index + ".state", "tamper");
                this.d.ioWrite("i" + index + ".short", "0");
                this.d.ioWrite("i" + index + ".tamper", "1");
                this.d.ioWrite("i" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("i" + index + ".state", "value", "tamper");
                }
            }
            String inputBypassState = String.format("%8s", Integer.toBinaryString(r.get(13) & 0xFF)).replace(' ', '0');
            this.d.ioWrite("i" + index + ".bypass.state.bypassed", inputBypassState.substring(7, 8));
            this.d.ioWrite("i" + index + ".bypass.state.bypasslatched", inputBypassState.substring(6, 7));
            this.d.ioWrite("i" + index + ".bypass.state.sirenlockout", inputBypassState.substring(5, 6));
            if (index == this.d.inputsLastIndex) {
                this.inputsLastIndexRead = true;
            }
        } else if (this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - input status - index error: " + index);
        }
    }

    private void readDoorStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L) {
            String doorState;
            String doorLockState;
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - door status - index: " + index);
            }
            if ((doorLockState = Integer.toHexString(r.get(4) & 0xFF)).equals("0")) {
                this.d.ioWrite("d" + index + ".lock.state", "locked");
                this.d.ioWrite("d" + index + ".locked", "1");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "locked");
                }
            } else if (doorLockState.equals("1")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyuseraccess");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyuseraccess");
                }
            } else if (doorLockState.equals("2")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyschedule");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyschedule");
                }
            } else if (doorLockState.equals("3")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyusertimed");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyusertimed");
                }
            } else if (doorLockState.equals("4")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyandlatched");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyandlatched");
                }
            } else if (doorLockState.equals("5")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyrex");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyrex");
                }
            } else if (doorLockState.equals("6")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyren");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyren");
                }
            } else if (doorLockState.equals("7")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbykeypadmenu");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbykeypadmenu");
                }
            } else if (doorLockState.equals("8")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyarea");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyarea");
                }
            } else if (doorLockState.equals("9")) {
                this.d.ioWrite("d" + index + ".lock.state", "unlockedbyfirealarm");
                this.d.ioWrite("d" + index + ".locked", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".lock.state", "value", "unlockedbyfirealarm");
                }
            }
            if ((doorState = Integer.toHexString(r.get(5) & 0xFF)).equals("0")) {
                this.d.ioWrite("d" + index + ".state", "closed");
                this.d.ioWrite("d" + index + ".closed", "1");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".state", "value", "closed");
                }
            } else if (doorState.equals("1")) {
                this.d.ioWrite("d" + index + ".state", "open");
                this.d.ioWrite("d" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".state", "value", "open");
                }
            } else if (doorState.equals("2")) {
                this.d.ioWrite("d" + index + ".state", "openalert");
                this.d.ioWrite("d" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".state", "value", "openalert");
                }
            } else if (doorState.equals("3")) {
                this.d.ioWrite("d" + index + ".state", "leftopen");
                this.d.ioWrite("d" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".state", "value", "leftopen");
                }
            } else if (doorState.equals("4")) {
                this.d.ioWrite("d" + index + ".state", "forcedopen");
                this.d.ioWrite("d" + index + ".closed", "0");
                if (this.d.gui) {
                    this.d.uiSet("d" + index + ".state", "value", "forcedopen");
                }
            }
            if (index == this.d.doorsLastIndex) {
                this.doorsLastIndexRead = true;
            }
        } else if (this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - door status - index error: " + index);
        }
    }

    private void readTroubleInputStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L) {
            if (this.d.isVerboseLog()) {
                this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - trouble input status - index: " + index);
            }
            String troubleInputAscii = "";
            int i2 = 4;
            while (i2 <= 11) {
                byte b2 = r.get(i2);
                char c2 = (char)b2;
                troubleInputAscii = String.valueOf(troubleInputAscii) + c2;
                ++i2;
            }
            this.d.ioWrite("ti" + index + ".ascii", troubleInputAscii);
            String troubleInputState = Integer.toHexString(r.get(12) & 0xFF);
            if (troubleInputState.equals("0")) {
                this.d.ioWrite("ti" + index + ".state", "closed");
                this.d.ioWrite("ti" + index + ".closed", "1");
                this.d.ioWrite("ti" + index + ".short", "0");
                this.d.ioWrite("ti" + index + ".tamper", "0");
                if (this.d.gui) {
                    this.d.uiSet("ti" + index + ".state", "value", "closed");
                }
            } else if (troubleInputState.equals("1")) {
                this.d.ioWrite("ti" + index + ".state", "open");
                this.d.ioWrite("ti" + index + ".closed", "0");
                this.d.ioWrite("ti" + index + ".short", "0");
                this.d.ioWrite("ti" + index + ".tamper", "0");
                if (this.d.gui) {
                    this.d.uiSet("ti" + index + ".state", "value", "open");
                }
            } else if (troubleInputState.equals("2")) {
                this.d.ioWrite("ti" + index + ".state", "short");
                this.d.ioWrite("ti" + index + ".closed", "0");
                this.d.ioWrite("ti" + index + ".short", "1");
                this.d.ioWrite("ti" + index + ".tamper", "0");
                if (this.d.gui) {
                    this.d.uiSet("ti" + index + ".state", "value", "short");
                }
            } else if (troubleInputState.equals("3")) {
                this.d.ioWrite("ti" + index + ".state", "tamper");
                this.d.ioWrite("ti" + index + ".closed", "0");
                this.d.ioWrite("ti" + index + ".short", "0");
                this.d.ioWrite("ti" + index + ".tamper", "1");
                if (this.d.gui) {
                    this.d.uiSet("ti" + index + ".state", "value", "tamper");
                }
            }
            String troubleInputBypassState = String.format("%8s", Integer.toBinaryString(r.get(13) & 0xFF)).replace(' ', '0');
            this.d.ioWrite("ti" + index + ".bypass.state.bypassed", troubleInputBypassState.substring(7, 8));
            this.d.ioWrite("ti" + index + ".bypass.state.bypasslatched", troubleInputBypassState.substring(6, 7));
            this.d.ioWrite("ti" + index + ".bypass.state.sirenlockout", troubleInputBypassState.substring(5, 6));
            if (index == this.d.troubleInputsLastIndex) {
                this.troubleInputsLastIndexRead = true;
            }
        } else if (this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - trouble input status - index error: " + index);
        }
    }

    private void readVariableStatus(List<Byte> r) {
        byte[] indexBytes = new byte[]{r.get(3), r.get(2), r.get(1), r.get(0)};
        long index = this.byteArrayToLong(indexBytes);
        if (index >= 0L && this.d.isVerboseLog()) {
            this.d.messageLog(String.valueOf(this.d.name) + " - LISTENER READ - variable status - index: " + index);
        }
        int val = (r.get(5) & 0xFF) << 8 | r.get(4) & 0xFF;
        String valS = String.valueOf(val);
        this.d.ioWrite("v" + index + ".value", valS);
    }

    private long byteArrayToLong(byte[] b2) {
        long currentLong = ((long)b2[0] & 0xFFL) << 24 | ((long)b2[1] & 0xFFL) << 16 | ((long)b2[2] & 0xFFL) << 8 | ((long)b2[3] & 0xFFL) << 0;
        return currentLong;
    }

    private long byteArrayToLong2(byte[] b2) {
        long currentLong = ((long)b2[1] & 0xFFL) << 8 | ((long)b2[0] & 0xFFL) << 0;
        return currentLong;
    }
}

