/*
 * Decompiled with CFR 0.152.
 */
package drivers.mqttbroker;

import com.hsyco.userBase;
import drivers.mqttbroker.Driver;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;

public class ThreadBroker
extends Thread {
    private Socket connectionSocket;
    private Driver broker;
    private int keepAliveTimer;
    private InputStream inFromClient;
    private DataOutputStream outToClient;
    private boolean connected;
    private int cleanSession;
    private String clientId;
    private int remLen;
    private int willQos;
    private String willTopic;
    private String willMessage;
    private int willRetain;
    private int willPacketId;
    private boolean willFlag;
    private int sessionExpInterval;
    private int receiveMaximum;
    private int maxPacketSize;
    private int topicAliasMax;
    private int topicAlias;
    private int reqRespInformation;
    private int reqProblemInformation;
    private int willDelayInterval;
    private int maxQos;
    private int payloadFormatIndicator;
    private int msgExpiryInterval;
    private String contentType;
    private String responseTopic;
    private HashMap<String, String> userProperty;
    private String authMethod;
    private String reasonString;
    private byte[] authData;
    private byte[] correlationData;
    private int retainAvailable;
    private int wildcardSubscription;
    private int subscriptionIdentifiers;
    private int sharedSubscription;
    private static int protocolLevel = 4;
    private static final int CONNECT = 1;
    private static final int PUBLISH = 3;
    private static final int PUBACK = 4;
    private static final int PUBREC = 5;
    private static final int PUBREL = 6;
    private static final int PUBCOMP = 7;
    private static final int SUBSCRIBE = 8;
    private static final int SUBACK = 9;
    private static final int UNSUBSCRIBE = 10;
    private static final int UNSUBACK = 11;
    private static final int PINGREQ = 12;
    private static final int PINGRESP = 13;
    private static final int DISCONNECT = 14;
    private static final int AUTH = 15;
    private static final int FIELDLEN = 2;
    private static final int PACKETIDLEN = 2;
    private static final int LENFLAGS = 16;
    private static final int BYTE = 256;
    private static final int AUTHORIZED = 0;
    private static final int REJECTED = 2;
    private static final int MALFORMED = 4;
    private static final int UNAUTHORIZED = 5;
    private static final int RETAINNOTSUPPORTED = 154;

    public ThreadBroker(Socket connectionSocket, Driver broker) {
        this.connectionSocket = connectionSocket;
        this.broker = broker;
        this.inFromClient = null;
        this.outToClient = null;
        this.connected = false;
        this.willTopic = "";
        this.willMessage = "";
        this.willPacketId = 0;
        this.willFlag = false;
        this.willDelayInterval = 0;
        this.sessionExpInterval = 0;
        this.receiveMaximum = 65536;
        this.maxPacketSize = 0xFFFFFFF;
        this.topicAliasMax = 0;
        this.topicAlias = 0;
        this.reqRespInformation = 0;
        this.reqProblemInformation = 1;
        this.payloadFormatIndicator = 1;
        this.msgExpiryInterval = 0;
        this.maxQos = 2;
        this.retainAvailable = 1;
        this.wildcardSubscription = 1;
        this.subscriptionIdentifiers = 1;
        this.sharedSubscription = 1;
        this.userProperty = new HashMap();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block45: {
            boolean exit = false;
            try {
                try {
                    this.connectionSocket.setSoTimeout(65536000);
                    this.inFromClient = this.connectionSocket.getInputStream();
                    this.outToClient = new DataOutputStream(this.connectionSocket.getOutputStream());
                    while (!exit) {
                        if (this.connected && userBase.ioGet(String.valueOf(this.broker.getName()) + ".client." + this.clientId.replace(" ", "_") + ".connected").equals("0")) {
                            this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "1");
                        }
                        int firstByte = this.read();
                        int packetType = firstByte / 16;
                        int flags = firstByte % 16;
                        this.remLen = this.computeRemainingLength();
                        if (!this.connected && firstByte != 16) {
                            throw new Exception("First packet must be a connect packet");
                        }
                        switch (packetType) {
                            case 1: {
                                if (this.connected) {
                                    throw new Exception("Connect packet already sent");
                                }
                                if (flags != 0) {
                                    throw new Exception("Connect: invalid flags");
                                }
                                this.connect();
                                this.connected = true;
                                this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "1");
                                if (this.cleanSession != 0) break;
                                this.broker.resendUnackMessages(this.clientId);
                                break;
                            }
                            case 3: {
                                this.publishPacket(flags);
                                break;
                            }
                            case 4: {
                                if (flags != 0) {
                                    throw new Exception("Puback: invalid flags");
                                }
                                this.receivePubackPacket();
                                break;
                            }
                            case 5: {
                                if (flags != 0) {
                                    throw new Exception("Pubrec: invalid flags");
                                }
                                this.receivePubrecPacket();
                                break;
                            }
                            case 6: {
                                if (flags != 2) {
                                    throw new Exception("Pubrel: invalid flags");
                                }
                                this.receivePubrelPacket();
                                break;
                            }
                            case 7: {
                                if (flags != 0) {
                                    throw new Exception("Pubcomp: invalid flags");
                                }
                                this.receivePubcompPacket();
                                break;
                            }
                            case 8: {
                                if (flags != 2) {
                                    throw new Exception("Subscribe: invalid flags");
                                }
                                this.subscribePacket();
                                break;
                            }
                            case 10: {
                                if (flags != 2) {
                                    throw new Exception("Unsubscribe: invalid flags");
                                }
                                this.unsubscribePacket();
                                break;
                            }
                            case 12: {
                                if (flags != 0) {
                                    throw new Exception("Pinreq: invalid flags");
                                }
                                byte[] response = new byte[]{-48, 0};
                                this.outToClient.write(response);
                                break;
                            }
                            case 14: {
                                if (flags != 0) {
                                    throw new Exception("Disconnect: invalid flags");
                                }
                                if (protocolLevel == 5) {
                                    this.read();
                                    this.getProperties();
                                }
                                exit = true;
                                break;
                            }
                            case 15: {
                                if (flags != 0) {
                                    throw new Exception("Auth: invalid flags");
                                }
                                this.authPacket();
                                break;
                            }
                            default: {
                                throw new Exception("Invalid packet type");
                            }
                        }
                        this.broker.updateLastSeenTimestamp(this.clientId, packetType);
                        this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".lastseen", "" + System.currentTimeMillis());
                    }
                }
                catch (SocketTimeoutException e2) {
                    this.broker.printErrorLog("Timeout expired. ClientId: " + this.clientId);
                    if (this.connected && !exit && this.willFlag) {
                        this.sendWillMessage(this.willQos, 0, this.willPacketId, this.willTopic, this.willMessage, this.willRetain);
                    }
                    this.closeConnection();
                    if (this.connected) {
                        this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "0");
                    }
                }
                catch (IOException e3) {
                    this.broker.printErrorLog(String.valueOf(e3.getLocalizedMessage()) + ". ClientId: " + this.clientId);
                    if (this.connected && !exit && this.willFlag) {
                        this.sendWillMessage(this.willQos, 0, this.willPacketId, this.willTopic, this.willMessage, this.willRetain);
                    }
                    this.closeConnection();
                    if (this.connected) {
                        this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "0");
                    }
                }
                catch (Exception e4) {
                    this.broker.printErrorLog(String.valueOf(e4.getLocalizedMessage()) + ". ClientId: " + this.clientId);
                    if (this.connected && !exit && this.willFlag) {
                        this.sendWillMessage(this.willQos, 0, this.willPacketId, this.willTopic, this.willMessage, this.willRetain);
                    }
                    this.closeConnection();
                    if (this.connected) {
                        this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "0");
                    }
                    break block45;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (this.connected && !exit && this.willFlag) {
                    this.sendWillMessage(this.willQos, 0, this.willPacketId, this.willTopic, this.willMessage, this.willRetain);
                }
                this.closeConnection();
                if (this.connected) {
                    this.broker.ioWrite("client." + this.clientId.replace(" ", "_") + ".connected", "0");
                }
            }
        }
    }

    public void connect() throws Exception {
        int connackValue;
        try {
            Integer conn_flags = this.checkHeaderAndGetConnFlags();
            if ((conn_flags & 1) != 0) {
                throw new Exception("bit 0 in connect flags must be set to 0");
            }
            this.cleanSession = (conn_flags & 2) / 2;
            this.willFlag = (conn_flags & 4) / 4 == 1;
            this.willQos = (conn_flags & 0x18) / 8;
            this.willRetain = (conn_flags & 0x20) / 32;
            int passFlag = (conn_flags & 0x40) / 64;
            int userFlag = (conn_flags & 0x80) / 128;
            this.checkConnFlags(passFlag, userFlag);
            this.remLen -= 10;
            if (protocolLevel == 5) {
                this.getProperties();
            }
            connackValue = this.getConnectPayload(passFlag, userFlag);
            if (this.willRetain == 1 && this.retainAvailable == 0) {
                connackValue = 154;
            }
        }
        catch (Exception e2) {
            throw new Exception("Connect error: " + e2.getLocalizedMessage());
        }
        this.sendConnack(connackValue);
        if (protocolLevel == 5 && this.broker.isConnected(this.clientId)) {
            this.disconnectPacket();
        }
        this.broker.closeConnectionIfAlreadyConnected(this.clientId);
        this.broker.setConnected(this.clientId, this.connectionSocket, this.cleanSession, this);
        if (this.willFlag && this.willRetain != 0) {
            int len = 2 + this.willTopic.getBytes().length + this.willMessage.getBytes().length;
            if (this.willQos != 0) {
                len += 2;
            }
            if (this.willMessage.length() == 0) {
                this.broker.deleteRetainMessage(this.willTopic);
            } else {
                this.broker.addRetainMessage(len, this.willQos, 0, this.willTopic, this.willMessage);
            }
        }
    }

    public int checkHeaderAndGetConnFlags() throws Exception {
        String protocolName = this.readNextField();
        if (!protocolName.equals("MQTT") && !protocolName.equals("MQIsdp")) {
            throw new Exception("protocol name incorrect");
        }
        protocolLevel = this.read();
        int conn_flags = this.read();
        int keepAliveMSB = this.read();
        int keepAliveLSB = this.read();
        this.keepAliveTimer = (keepAliveMSB * 256 + keepAliveLSB) * 1000;
        if (this.keepAliveTimer > 0) {
            this.connectionSocket.setSoTimeout((int)((double)this.keepAliveTimer * 1.5));
        }
        return conn_flags;
    }

    public void getProperties() throws Exception {
        int propLen = this.computeRemainingLength();
        while (propLen >= 2) {
            int propId = this.read();
            --propLen;
            switch (propId) {
                case 1: {
                    this.payloadFormatIndicator = this.read();
                    --propLen;
                    break;
                }
                case 2: {
                    this.msgExpiryInterval = this.read() * 256 * 256 * 256 + this.read() * 256 * 256 + this.read() * 256 + this.read();
                    this.msgExpiryInterval *= 1000;
                    propLen -= 4;
                    break;
                }
                case 3: {
                    this.contentType = this.readNextField();
                    propLen = propLen - 2 - this.contentType.length();
                    break;
                }
                case 8: {
                    this.responseTopic = this.readNextField();
                    propLen = propLen - 2 - this.responseTopic.length();
                    break;
                }
                case 9: {
                    int rem = this.read() * 256 + this.read();
                    this.correlationData = new byte[rem];
                    int i2 = 0;
                    while (i2 < rem) {
                        this.correlationData[i2] = (byte)this.read();
                        ++i2;
                    }
                    propLen = propLen - 2 - this.correlationData.length;
                    break;
                }
                case 11: {
                    this.subscriptionIdentifiers = this.computeRemainingLength();
                    propLen -= this.subscriptionIdentifiers;
                    break;
                }
                case 17: {
                    int sessExp = this.read() * 256 * 256 * 256 + this.read() * 256 * 256 + this.read() * 256 + this.read();
                    this.sessionExpInterval = sessExp *= 1000;
                    propLen -= 4;
                    break;
                }
                case 21: {
                    this.authMethod = this.readNextField();
                    propLen = propLen - 2 - this.authMethod.length();
                    break;
                }
                case 22: {
                    if (this.authMethod == null) {
                        throw new Exception("there can't be authentication data without authentication method");
                    }
                    int rem = this.read() * 256 + this.read();
                    this.authData = new byte[rem];
                    int i3 = 0;
                    while (i3 < rem) {
                        this.authData[i3] = (byte)this.read();
                        ++i3;
                    }
                    propLen = propLen - 2 - this.authData.length;
                    break;
                }
                case 23: {
                    int temp = this.read();
                    if (temp != 0 || temp != 1) {
                        throw new Exception("request problem information must be 0 or 1");
                    }
                    this.reqProblemInformation = temp;
                    --propLen;
                    break;
                }
                case 24: {
                    this.willDelayInterval = this.read() * 256 * 256 * 256 + this.read() * 256 * 256 + this.read() * 256 + this.read();
                    this.willDelayInterval *= 1000;
                    propLen -= 4;
                    break;
                }
                case 25: {
                    int temp = this.read();
                    if (temp != 0 || temp != 1) {
                        throw new Exception("request response information must be 0 or 1");
                    }
                    this.reqRespInformation = temp;
                    --propLen;
                    break;
                }
                case 31: {
                    this.reasonString = this.readNextField();
                    propLen = propLen - 2 - this.reasonString.length();
                    break;
                }
                case 33: {
                    this.receiveMaximum = this.read() * 256 + this.read();
                    propLen -= 2;
                    break;
                }
                case 34: {
                    this.topicAliasMax = this.read() * 256 + this.read();
                    propLen -= 2;
                    break;
                }
                case 35: {
                    this.topicAlias = this.read() * 256 + this.read();
                    propLen -= 2;
                    break;
                }
                case 38: {
                    String key = this.readNextField();
                    String value = this.readNextField();
                    this.userProperty.put(key, value);
                    propLen = propLen - key.length() - value.length() - 4;
                    break;
                }
                case 39: {
                    this.maxPacketSize = this.read() * 256 * 256 * 256 + this.read() * 256 * 256 + this.read() * 256 + this.read();
                    propLen -= 4;
                }
            }
        }
    }

    public int getConnectPayload(int passwordFlag, int usernameFlag) throws Exception {
        this.clientId = this.readNextField();
        if (this.clientId.length() == 0 && this.cleanSession == 0) {
            return 2;
        }
        if (this.clientId.length() == 0 && this.cleanSession == 1) {
            this.clientId = this.connectionSocket.getInetAddress().toString().substring(1).replace(".", "-");
        }
        this.remLen = this.remLen - 2 - this.clientId.getBytes().length;
        if (this.remLen < 2) {
            return this.broker.authorizedToConnect(this.clientId, "", "") ? 0 : 5;
        }
        if (this.willFlag) {
            if (protocolLevel == 5) {
                this.getProperties();
            }
            this.willTopic = this.readNextField().toLowerCase().replace(" ", "_");
            if (this.willTopic.matches(".*[#\\+]+.*")) {
                throw new Exception("will topic cannot contain wildcard characters");
            }
            this.willMessage = this.readNextField();
            this.remLen = this.remLen - 4 - this.willTopic.getBytes().length - this.willMessage.getBytes().length;
            ++this.willPacketId;
        }
        if (this.remLen < 2) {
            return this.broker.authorizedToConnect(this.clientId, "", "") ? 0 : 5;
        }
        String username = "";
        if (usernameFlag != 0) {
            username = this.readNextField();
            this.remLen = this.remLen - 2 - username.getBytes().length;
        }
        if (this.remLen < 2) {
            return this.broker.authorizedToConnect(this.clientId, username, "") ? 0 : 5;
        }
        String password = "";
        if (passwordFlag != 0) {
            password = this.readNextField();
        }
        return this.broker.authorizedToConnect(this.clientId, username, password) ? 0 : 5;
    }

    public void sendConnack(int connackValue) throws Exception {
        try {
            byte[] response;
            ArrayList<Byte> propertiesList = new ArrayList<Byte>();
            if (protocolLevel == 5) {
                propertiesList = this.connackProperties(propertiesList);
                byte[] properties = ThreadBroker.encodeProperties(propertiesList);
                int remainLenTot = ThreadBroker.fieldLength(properties.length);
                response = new byte[1 + remainLenTot + properties.length];
                response = ThreadBroker.encodeRemainLength(response, properties.length);
                int index = 1 + remainLenTot;
                response[index] = connackValue != 0 || this.cleanSession != 0 || this.broker.getSession(this.clientId) == null ? (byte)0 : 1;
                response[++index] = (byte)connackValue;
                ++index;
                int i2 = 1;
                while (i2 < properties.length) {
                    response[index] = properties[i2];
                    ++index;
                    ++i2;
                }
            } else {
                response = new byte[4];
                response[1] = 2;
                response[2] = connackValue != 0 || this.cleanSession != 0 || this.broker.getSession(this.clientId) == null ? (byte)0 : 1;
                response[3] = (byte)connackValue;
            }
            response[0] = 32;
            this.outToClient.write(response);
            switch (connackValue) {
                case 2: {
                    throw new Exception("clientId rejected");
                }
                case 4: {
                    throw new Exception("username or password malformed");
                }
                case 5: {
                    throw new Exception("unauthorized");
                }
                case 154: {
                    throw new Exception("Retain not supported");
                }
            }
        }
        catch (Exception e2) {
            throw new Exception("Connack error: " + e2.getLocalizedMessage());
        }
    }

    public ArrayList<Byte> connackProperties(ArrayList<Byte> b2) {
        byte[] k2;
        int i2;
        b2.add((byte)17);
        b2.add((byte)(this.sessionExpInterval / 0x1000000));
        b2.add((byte)(this.sessionExpInterval / 65536));
        b2.add((byte)(this.sessionExpInterval / 256));
        b2.add((byte)(this.sessionExpInterval % 256));
        b2.add((byte)33);
        b2.add((byte)(this.receiveMaximum / 256));
        b2.add((byte)(this.receiveMaximum % 256));
        b2.add((byte)36);
        b2.add((byte)this.maxQos);
        b2.add((byte)37);
        b2.add((byte)this.retainAvailable);
        b2.add((byte)39);
        b2.add((byte)(this.maxPacketSize / 0x1000000));
        b2.add((byte)(this.maxPacketSize / 65536));
        b2.add((byte)(this.maxPacketSize / 256));
        b2.add((byte)(this.maxPacketSize % 256));
        if (this.clientId.equals(this.connectionSocket.getInetAddress().toString().substring(1).replace(".", "-"))) {
            b2.add((byte)18);
            b2.add((byte)(this.clientId.length() / 256));
            b2.add((byte)(this.clientId.length() % 256));
            byte[] client = this.clientId.getBytes();
            i2 = 0;
            while (i2 < client.length) {
                b2.add(client[i2]);
                ++i2;
            }
        }
        b2.add((byte)34);
        b2.add((byte)(this.topicAliasMax / 256));
        b2.add((byte)(this.topicAliasMax % 256));
        if (this.reasonString != null) {
            b2.add((byte)31);
            k2 = this.reasonString.getBytes();
            b2.add((byte)(k2.length / 256));
            b2.add((byte)(k2.length % 256));
            i2 = 0;
            while (i2 < k2.length) {
                b2.add(k2[i2]);
                ++i2;
            }
        }
        if (this.userProperty.size() > 0) {
            b2.add((byte)38);
            for (String key : this.userProperty.keySet()) {
                k2 = key.getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                int i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
                k2 = this.userProperty.get(key).getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
            }
        }
        b2.add((byte)40);
        b2.add((byte)this.wildcardSubscription);
        b2.add((byte)41);
        b2.add((byte)this.subscriptionIdentifiers);
        b2.add((byte)42);
        b2.add((byte)this.sharedSubscription);
        b2.add((byte)19);
        b2.add((byte)(this.keepAliveTimer / 256));
        b2.add((byte)(this.keepAliveTimer % 256));
        if (this.authMethod != null) {
            b2.add((byte)21);
            b2.add((byte)(this.authMethod.length() / 256));
            b2.add((byte)(this.authMethod.length() % 256));
            k2 = this.authMethod.getBytes();
            int i4 = 0;
            while (i4 < k2.length) {
                b2.add(k2[i4]);
                ++i4;
            }
        }
        if (this.authData != null) {
            b2.add((byte)22);
            b2.add((byte)(this.authData.length / 256));
            b2.add((byte)(this.authData.length % 256));
            int i5 = 0;
            while (i5 < this.authData.length) {
                b2.add(this.authData[i5]);
                ++i5;
            }
        }
        return b2;
    }

    public void publishPacket(int flags) throws Exception {
        try {
            int retain = flags & 1;
            int qos = (flags & 6) / 2;
            if (qos == 3) {
                throw new Exception("invalid qos");
            }
            int len = this.remLen;
            String topic = this.readNextField().toLowerCase().replace(" ", "_");
            if (topic.length() == 0) {
                throw new Exception("topic length cannot be 0");
            }
            if (topic.matches(".*[#\\+]+.*")) {
                throw new Exception("publish topic cannot contain wildcard characters");
            }
            this.remLen = this.remLen - 2 - topic.getBytes().length;
            int packetId = 0;
            if (qos != 0) {
                int packetIdMSB = this.read();
                int packetIdLSB = this.read();
                packetId = packetIdMSB * 256 + packetIdLSB;
                this.remLen -= 2;
            }
            if (protocolLevel == 5) {
                this.getProperties();
            }
            byte[] tempMsg = new byte[this.remLen];
            int i2 = 0;
            while (i2 < this.remLen) {
                tempMsg[i2] = (byte)this.read();
                ++i2;
            }
            String msg = new String(tempMsg, StandardCharsets.UTF_8);
            this.broker.ioWriteForced("client." + this.clientId.replace(" ", "_") + ".publish." + topic, msg);
            if (retain != 0) {
                if (msg.length() == 0) {
                    this.broker.deleteRetainMessage(topic);
                } else {
                    this.broker.addRetainMessage(len, qos, packetId, topic, msg);
                }
            }
            ArrayList<Byte> propList = null;
            if (protocolLevel == 5) {
                propList = this.publishProperties(propList);
            }
            this.broker.propagateMessage(len, qos, 0, 0, packetId, topic, msg, propList);
            if (qos == 1) {
                this.sendAckPacket(64, packetId);
            } else if (qos == 2) {
                this.sendAckPacket(80, packetId);
            }
        }
        catch (Exception e2) {
            throw new Exception("Publish error: " + e2.getLocalizedMessage());
        }
    }

    public void sendAckPacket(int packetType, int packetId) throws IOException {
        try {
            byte[] response;
            ArrayList<Byte> propList = new ArrayList<Byte>();
            if (protocolLevel == 5) {
                propList = this.ackProperties(propList);
                byte[] props = ThreadBroker.encodeProperties(propList);
                int packetIdLen = 2;
                int remainLenField = ThreadBroker.fieldLength(packetIdLen + props.length);
                response = new byte[1 + remainLenField + packetIdLen + props.length];
                response = ThreadBroker.encodeRemainLength(response, packetIdLen + props.length);
                int index = 1 + remainLenField;
                response[index] = (byte)(packetId / 256);
                response[index + 1] = (byte)(packetId % 256);
                response[index + 2] = 0;
                index += 3;
                int i2 = 1;
                while (i2 < props.length) {
                    response[index] = props[i2];
                    ++index;
                    ++i2;
                }
            } else {
                response = new byte[4];
                response[1] = 2;
                response[2] = (byte)(packetId / 256);
                response[3] = (byte)(packetId % 256);
            }
            response[0] = (byte)packetType;
            this.broker.addMessageToSession(this.clientId, packetId, response);
            this.outToClient.write(response);
        }
        catch (Exception e2) {
            throw new IOException("Sending acknowledgment error: " + e2.getLocalizedMessage());
        }
    }

    public ArrayList<Byte> ackProperties(ArrayList<Byte> b2) {
        byte[] k2;
        if (this.reasonString != null) {
            b2.add((byte)31);
            k2 = this.reasonString.getBytes();
            b2.add((byte)(k2.length / 256));
            b2.add((byte)(k2.length % 256));
            int i2 = 0;
            while (i2 < k2.length) {
                b2.add(k2[i2]);
                ++i2;
            }
        }
        if (this.userProperty.size() > 0) {
            b2.add((byte)38);
            for (String key : this.userProperty.keySet()) {
                k2 = key.getBytes();
                b2.add((byte)(key.length() / 256));
                b2.add((byte)(key.length() % 256));
                int i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
                k2 = this.userProperty.get(key).getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
            }
        }
        return b2;
    }

    public void receivePubackPacket() throws IOException {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            if (protocolLevel == 5) {
                this.read();
                this.getProperties();
            }
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.broker.delMessageFromSession(this.clientId, packetId);
        }
        catch (Exception e2) {
            throw new IOException("Puback error: " + e2.getLocalizedMessage());
        }
    }

    public void receivePubrecPacket() throws IOException {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            if (protocolLevel == 5) {
                this.read();
                this.getProperties();
            }
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.sendAckPacket(98, packetId);
            this.broker.delMessageFromSession(this.clientId, packetId);
        }
        catch (Exception e2) {
            throw new IOException("Pubrec error: " + e2.getLocalizedMessage());
        }
    }

    public void receivePubrelPacket() throws IOException {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            if (protocolLevel == 5) {
                this.read();
                this.getProperties();
            }
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.sendAckPacket(112, packetId);
            this.broker.delMessageFromSession(this.clientId, packetId);
        }
        catch (Exception e2) {
            throw new IOException("Pubrel error: " + e2.getLocalizedMessage());
        }
    }

    public void receivePubcompPacket() throws IOException {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            if (protocolLevel == 5) {
                this.read();
                this.getProperties();
            }
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.broker.delMessageFromSession(this.clientId, packetId);
        }
        catch (Exception e2) {
            throw new IOException("Pubcomp error: " + e2.getLocalizedMessage());
        }
    }

    public void closeConnection() {
        try {
            this.connectionSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.connected && this.cleanSession == 1) {
            this.broker.deleteSession(this.clientId);
        }
    }

    public String readNextField() throws Exception {
        int fieldLenMSB = this.read();
        int fieldLenLSB = this.read();
        int fieldLen = fieldLenMSB * 256 + fieldLenLSB;
        byte[] field = new byte[fieldLen];
        int i2 = 0;
        while (i2 < fieldLen) {
            field[i2] = (byte)this.read();
            ++i2;
        }
        String s = new String(field, StandardCharsets.UTF_8);
        return s;
    }

    public static byte[] encodeRemainLength(byte[] mex, int n2) {
        byte[] toReturn = mex;
        int remLen = n2;
        int index = 1;
        do {
            int encodedByte = remLen % 128;
            if ((remLen /= 128) > 0) {
                encodedByte |= 0x80;
            }
            toReturn[index] = (byte)encodedByte;
            ++index;
        } while (remLen > 0);
        return toReturn;
    }

    public int computeRemainingLength() throws Exception {
        int encodedByte;
        int multiplier = 1;
        int value = 0;
        do {
            encodedByte = this.read();
            value += (encodedByte & 0x7F) * multiplier;
            if (multiplier > 0x200000) {
                throw new Exception("malformed remaining length");
            }
            multiplier *= 128;
        } while ((encodedByte & 0x80) != 0);
        return value;
    }

    public void checkConnFlags(int passwordFlag, int usernameFlag) throws Exception {
        if (!(this.willFlag || this.willQos == 0 && this.willRetain == 0)) {
            throw new Exception("Connect error: if willFlag is 0 also willQos and willRetain flags must be 0");
        }
        if (this.willQos == 3) {
            throw new Exception("Connect error: willQos invalid value");
        }
    }

    public int read() throws Exception {
        int nextByte = this.inFromClient.read();
        if (nextByte == -1) {
            throw new Exception("Stream error: no more data to read");
        }
        return nextByte;
    }

    public static int fieldLength(int l2) {
        int len = l2;
        int toReturn = 0;
        while (len > 0) {
            len /= 128;
            ++toReturn;
        }
        return toReturn;
    }

    public static byte[] preparePropagation(int payloadLen, int qos, int dup, int retain, int packetId, String topic, String msg, ArrayList<Byte> propList) {
        byte[] toReturn;
        int remainLenField;
        byte[] props = new byte[1];
        if (protocolLevel == 5) {
            props = ThreadBroker.encodeProperties(propList);
            int propertiesLen = props.length - 1;
            remainLenField = ThreadBroker.fieldLength(payloadLen + propertiesLen);
            toReturn = new byte[1 + remainLenField + payloadLen + propertiesLen];
            toReturn = ThreadBroker.encodeRemainLength(toReturn, payloadLen + propertiesLen);
        } else {
            remainLenField = ThreadBroker.fieldLength(payloadLen);
            toReturn = new byte[1 + remainLenField + payloadLen];
            toReturn = ThreadBroker.encodeRemainLength(toReturn, payloadLen);
        }
        toReturn[0] = (byte)(48 + qos * 2 + dup * 8 + retain);
        int index = 1 + remainLenField;
        toReturn[index] = (byte)(topic.getBytes().length / 256);
        toReturn[index + 1] = (byte)(topic.getBytes().length % 256);
        index += 2;
        int i2 = 0;
        while (i2 < topic.getBytes().length) {
            toReturn[index] = topic.getBytes()[i2];
            ++index;
            ++i2;
        }
        if (qos != 0) {
            toReturn[index] = (byte)(packetId / 256);
            toReturn[index + 1] = (byte)(packetId % 256);
            index += 2;
        }
        if (protocolLevel == 5) {
            i2 = 1;
            while (i2 < props.length) {
                toReturn[index] = props[i2];
                ++index;
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < msg.getBytes().length) {
            toReturn[index] = msg.getBytes()[i2];
            ++index;
            ++i2;
        }
        return toReturn;
    }

    public ArrayList<Byte> publishProperties(ArrayList<Byte> b2) {
        int i2;
        byte[] k2;
        b2 = new ArrayList();
        b2.add((byte)1);
        b2.add((byte)this.payloadFormatIndicator);
        b2.add((byte)2);
        b2.add((byte)(this.msgExpiryInterval / 0x1000000));
        b2.add((byte)(this.msgExpiryInterval / 65536));
        b2.add((byte)(this.msgExpiryInterval / 256));
        b2.add((byte)(this.msgExpiryInterval % 256));
        if (this.topicAlias != 0) {
            b2.add((byte)35);
            b2.add((byte)(this.topicAlias / 256));
            b2.add((byte)(this.topicAlias % 256));
        }
        if (this.responseTopic != null) {
            b2.add((byte)8);
            k2 = this.responseTopic.getBytes();
            b2.add((byte)(k2.length / 256));
            b2.add((byte)(k2.length % 256));
            int i3 = 0;
            while (i3 < k2.length) {
                b2.add(k2[i3]);
                ++i3;
            }
        }
        if (this.correlationData != null) {
            b2.add((byte)9);
            b2.add((byte)(this.correlationData.length / 256));
            b2.add((byte)(this.correlationData.length % 256));
            int i4 = 0;
            while (i4 < this.correlationData.length) {
                b2.add(this.correlationData[i4]);
                ++i4;
            }
        }
        if (this.userProperty.size() > 0) {
            b2.add((byte)38);
            for (String key : this.userProperty.keySet()) {
                k2 = key.getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                i2 = 0;
                while (i2 < k2.length) {
                    b2.add(k2[i2]);
                    ++i2;
                }
                k2 = this.userProperty.get(key).getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                i2 = 0;
                while (i2 < k2.length) {
                    b2.add(k2[i2]);
                    ++i2;
                }
            }
        }
        b2.add((byte)11);
        int rem = ThreadBroker.fieldLength(this.subscriptionIdentifiers);
        byte[] resp = new byte[1 + rem];
        resp = ThreadBroker.encodeRemainLength(resp, rem);
        int i5 = 1;
        while (i5 < resp.length) {
            b2.add(resp[i5]);
            ++i5;
        }
        if (this.contentType != null) {
            b2.add((byte)3);
            byte[] k3 = this.contentType.getBytes();
            b2.add((byte)(k3.length / 256));
            b2.add((byte)(k3.length % 256));
            i2 = 0;
            while (i2 < k3.length) {
                b2.add(k3[i2]);
                ++i2;
            }
        }
        return b2;
    }

    public void subscribePacket() throws Exception {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.remLen -= 2;
            if (protocolLevel == 5) {
                this.getProperties();
            }
            if (this.remLen < 4) {
                throw new Exception("subscribe packets must contain at least one topic");
            }
            String topic = "";
            ArrayList<String> topics = new ArrayList<String>();
            ArrayList<Integer> maxQosList = new ArrayList<Integer>();
            while (this.remLen > 3) {
                topic = this.readNextField().toLowerCase().replace(" ", "_");
                topics.add(topic);
                int maxQos = this.read();
                if (this.isRegularTopic(topic)) {
                    maxQosList.add(maxQos & 3);
                } else {
                    maxQosList.add(128);
                }
                this.remLen = this.remLen - 2 - topic.getBytes().length - 1;
            }
            this.broker.addSubscriber(topics, this.clientId, maxQosList);
            this.sendSubackPacket(packetId, maxQosList);
            ArrayList<Byte> propList = null;
            if (protocolLevel == 5) {
                propList = this.publishProperties(propList);
            }
            this.broker.sendRetainMessage(this.clientId, topics, propList);
        }
        catch (Exception e2) {
            throw new Exception("Subscribe error: " + e2.getLocalizedMessage());
        }
    }

    public void sendSubackPacket(int packetId, ArrayList<Integer> qosList) throws Exception {
        try {
            int index;
            byte[] response;
            ArrayList<Byte> propList = new ArrayList<Byte>();
            if (protocolLevel == 5) {
                propList = this.ackProperties(propList);
                byte[] props = ThreadBroker.encodeProperties(propList);
                int propertiesLen = props.length + 1;
                int remainLenField = ThreadBroker.fieldLength(propertiesLen);
                response = new byte[1 + remainLenField + propertiesLen];
                response = ThreadBroker.encodeRemainLength(response, propertiesLen);
                index = 1 + remainLenField;
                response[index] = (byte)(packetId / 256);
                response[index + 1] = (byte)(packetId % 256);
                index += 2;
                int i2 = 1;
                while (i2 < props.length) {
                    response[index] = props[i2];
                    ++index;
                    ++i2;
                }
            } else {
                response = new byte[4 + qosList.size()];
                response[1] = (byte)(2 + qosList.size());
                response[2] = (byte)(packetId / 256);
                response[3] = (byte)(packetId % 256);
                index = 4;
            }
            response[0] = -112;
            for (Integer topic : qosList) {
                response[index] = topic.byteValue();
                ++index;
            }
            this.outToClient.write(response);
        }
        catch (Exception e2) {
            throw new IOException("Sending suback error: " + e2.getLocalizedMessage());
        }
    }

    public void unsubscribePacket() throws Exception {
        try {
            int packetIdMSB = this.read();
            int packetIdLSB = this.read();
            int packetId = packetIdMSB * 256 + packetIdLSB;
            this.remLen -= 2;
            if (this.remLen < 3) {
                throw new Exception("unsubscribe packets must contain at least one topic");
            }
            if (protocolLevel == 5) {
                this.getProperties();
            }
            ArrayList<Integer> respCodes = new ArrayList<Integer>();
            while (this.remLen > 0) {
                String topic = this.readNextField().toLowerCase().replace(" ", "_");
                this.remLen = this.remLen - 2 - topic.getBytes().length;
                this.broker.removeSubscriber(topic, this.clientId);
                respCodes.add(0);
            }
            if (protocolLevel == 5) {
                this.sendUnsubackPacket(packetId, respCodes);
            } else {
                this.sendAckPacket(176, packetId);
            }
        }
        catch (Exception e2) {
            throw new Exception("Unsubscribe error: " + e2.getLocalizedMessage());
        }
    }

    public boolean isRegularTopic(String topic) {
        String[] levels = topic.split("/", -1);
        if (levels.length > 0 && levels[0].equals("$share") && (levels.length < 3 || levels[1].contains("+") || levels[1].contains("#"))) {
            return false;
        }
        int i2 = 0;
        while (i2 < levels.length) {
            if ((levels[i2].contains("+") || levels[i2].contains("#")) && levels[i2].length() > 1) {
                return false;
            }
            if (levels[i2].contains("#") && i2 < levels.length - 1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void sendUnsubackPacket(int packetId, ArrayList<Integer> respCodes) throws Exception {
        try {
            ArrayList<Byte> propList = new ArrayList<Byte>();
            propList = this.ackProperties(propList);
            byte[] props = ThreadBroker.encodeProperties(propList);
            int propertiesLen = props.length + 1;
            int remainLenField = ThreadBroker.fieldLength(propertiesLen + respCodes.size());
            byte[] response = new byte[1 + remainLenField + propertiesLen + respCodes.size()];
            response = ThreadBroker.encodeRemainLength(response, propertiesLen + respCodes.size());
            response[0] = -80;
            int index = 1 + remainLenField;
            response[index] = (byte)(packetId / 256);
            response[index + 1] = (byte)(packetId % 256);
            index += 2;
            int i2 = 1;
            while (i2 < props.length) {
                response[index] = props[i2];
                ++index;
                ++i2;
            }
            for (Integer i3 : respCodes) {
                response[index] = i3.byteValue();
                ++index;
            }
            this.broker.addMessageToSession(this.clientId, packetId, response);
            this.outToClient.write(response);
        }
        catch (Exception e2) {
            throw new IOException("Sending unsuback error: " + e2.getLocalizedMessage());
        }
    }

    public void sendWillMessage(int willQos, int dup, int packetId, String willTopic, String willMessage, int willRetain) {
        int len = 2 + willTopic.getBytes().length + willMessage.getBytes().length;
        if (willQos != 0) {
            len += 2;
        }
        ArrayList<Byte> propList = null;
        if (protocolLevel == 5) {
            propList = this.publishProperties(propList);
        }
        this.broker.ioWriteForced("client." + this.clientId.replace(" ", "_") + ".willpublish." + willTopic, willMessage.toString());
        this.broker.propagateMessage(len, willQos, willRetain, 0, packetId, willTopic, willMessage, propList);
    }

    public void disconnectPacket() throws Exception {
        try {
            ArrayList<Byte> propList = new ArrayList<Byte>();
            propList = this.disconnectProperties(propList);
            byte[] properties = ThreadBroker.encodeProperties(propList);
            int remainLenTot = ThreadBroker.fieldLength(properties.length);
            byte[] response = new byte[1 + remainLenTot + properties.length];
            response = ThreadBroker.encodeRemainLength(response, properties.length);
            int index = 1 + remainLenTot;
            response[0] = -32;
            response[index] = -114;
            ++index;
            int i2 = 1;
            while (i2 < properties.length) {
                response[index] = properties[i2];
                ++index;
                ++i2;
            }
            this.broker.sendDisconnectPacket(this.clientId, response);
        }
        catch (Exception e2) {
            throw new Exception("Disconnect error: " + e2.getLocalizedMessage());
        }
    }

    public ArrayList<Byte> disconnectProperties(ArrayList<Byte> b2) {
        byte[] k2;
        b2.add((byte)17);
        b2.add((byte)(this.sessionExpInterval / 0x1000000));
        b2.add((byte)(this.sessionExpInterval / 65536));
        b2.add((byte)(this.sessionExpInterval / 256));
        b2.add((byte)(this.sessionExpInterval % 256));
        if (this.reasonString != null) {
            b2.add((byte)31);
            k2 = this.reasonString.getBytes();
            b2.add((byte)(k2.length / 256));
            b2.add((byte)(k2.length % 256));
            int i2 = 0;
            while (i2 < k2.length) {
                b2.add(k2[i2]);
                ++i2;
            }
        }
        if (this.userProperty.size() > 0) {
            b2.add((byte)38);
            for (String key : this.userProperty.keySet()) {
                k2 = key.getBytes();
                b2.add((byte)(key.length() / 256));
                b2.add((byte)(key.length() % 256));
                int i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
                k2 = this.userProperty.get(key).getBytes();
                b2.add((byte)(k2.length / 256));
                b2.add((byte)(k2.length % 256));
                i3 = 0;
                while (i3 < k2.length) {
                    b2.add(k2[i3]);
                    ++i3;
                }
            }
        }
        return b2;
    }

    public void authPacket() throws Exception {
        this.read();
        this.getProperties();
    }

    public static byte[] encodeProperties(ArrayList<Byte> propertiesList) {
        int lenProperties = ThreadBroker.fieldLength(propertiesList.size());
        byte[] properties = new byte[1 + lenProperties + propertiesList.size()];
        properties = ThreadBroker.encodeRemainLength(properties, propertiesList.size());
        int index = 1 + lenProperties;
        for (Byte b2 : propertiesList) {
            properties[index] = b2;
            ++index;
        }
        return properties;
    }

    public void setCleanSession(int n2) {
        this.cleanSession = n2;
    }

    public void setInputStream(InputStream in) {
        this.inFromClient = in;
    }

    public void setRemainingLength(int n2) {
        this.remLen = n2;
    }
}

