/*
 * Decompiled with CFR 0.152.
 */
package drivers.mqttbroker;

import drivers.mqttbroker.MQTTClientSession;
import drivers.mqttbroker.ThreadBroker;
import java.net.Socket;

public class MQTTClient {
    private String username;
    private String password;
    private long lastMessage;
    private long lastSeen;
    private Socket socket;
    private MQTTClientSession session;
    private ThreadBroker trdb;

    public void closeConnection() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ThreadBroker getThread() {
        return this.trdb;
    }

    public void setThread(ThreadBroker tr) {
        this.trdb = tr;
    }

    public void setConnected(Socket s) {
        this.socket = s;
        this.updateLastSeenTimestamp(0);
    }

    public long getLastSeenTimestamp() {
        return this.lastSeen;
    }

    public long getMsgTimestamp() {
        return this.lastMessage;
    }

    public boolean isClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        return true;
    }

    public void updateLastSeenTimestamp(int packetType) {
        long timestamp;
        this.lastSeen = timestamp = System.currentTimeMillis();
        if (packetType == 0 || packetType == 3) {
            this.lastMessage = timestamp;
        }
    }

    public MQTTClientSession getSession() {
        return this.session;
    }

    public void prepareSession(boolean clean) {
        if (clean || this.session == null) {
            this.session = new MQTTClientSession();
        }
    }

    public void deleteSession() {
        this.session = null;
    }

    public void addMessageToSession(String msgId, byte[] msg) {
        this.session.addMessageToSession(msgId, msg);
    }

    public void delMessageFromSession(String packetId) {
        this.session.delMessageFromSession(packetId);
    }

    public void addSubscriptionToSession(String topic, int maxQos) {
        this.session.addSubscriptionToSession(topic, maxQos);
    }

    public int getMaxQos(String topic) {
        return this.session.getMaxQos(topic);
    }
}

