/*
 * Decompiled with CFR 0.152.
 */
package drivers.mqttbroker;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.mqttbroker.MQTTClient;
import drivers.mqttbroker.MQTTClientSession;
import drivers.mqttbroker.MQTTPublishMessage;
import drivers.mqttbroker.RetainMessage;
import drivers.mqttbroker.ThreadBroker;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 1883;
    public static final int DEFAULTMAXTHREADS = 64;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final int MAXCLIENTS = 1024;
    public static final int MAXRETAIN = 1024;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static Driver INSTANCE;
    private final File iniFile = new File("mqttbroker.ini");
    private long iniFileTs;
    private boolean startupevents;
    private int port;
    private boolean acceptunknown;
    private int maxThreads;
    private String name;
    private String username;
    private String password;
    private ServerSocket welcomeSocket;
    private boolean firstLoop = true;
    private HashMap<String, MQTTClient> clientsInfo;
    private HashMap<String, RetainMessage> retMsgs;
    private ThreadPoolExecutor executor;
    private HashMap<String, ArrayList<String>> subscribers;

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            INSTANCE = this;
            try {
                String tempPort = config.get("localport");
                this.port = tempPort == null ? 1883 : Integer.parseInt(tempPort);
                this.welcomeSocket = new ServerSocket(this.port);
                this.welcomeSocket.setSoTimeout(3000);
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": serversocket error [" + name + "] on port " + this.port + " - " + e2.getLocalizedMessage());
            }
            String tempStartupEvents = config.get("startupevents");
            this.startupevents = tempStartupEvents == null ? true : Boolean.parseBoolean(tempStartupEvents);
            this.acceptunknown = Boolean.parseBoolean(config.get("acceptunknown"));
            String tempMaxThreads = config.get("maxthreads");
            this.maxThreads = tempMaxThreads == null || Integer.parseInt(tempMaxThreads) < 1 ? 64 : Integer.parseInt(tempMaxThreads);
            this.username = config.get("user");
            this.password = config.get("password");
            if (this.username != null && this.password == null) {
                this.password = "";
            } else if (this.password != null && this.username == null) {
                this.username = "";
            }
            this.clientsInfo = new HashMap();
            this.retMsgs = new HashMap();
            this.subscribers = new HashMap();
            this.readAuthFile("mqttbroker.ini");
            this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.maxThreads);
            this.iniFileTs = this.iniFile.lastModified();
            this.messageLog("MQTTBROKER - driver started with ip: localhost | localport: " + this.port + " | startupevents: " + this.startupevents + " | acceptunknown: " + this.acceptunknown);
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() throws Exception {
        block14: {
            Socket connectionSocket = null;
            try {
                Object tbr2;
                try {
                    connectionSocket = this.welcomeSocket.accept();
                    while (this.executor.getActiveCount() >= this.maxThreads) {
                        this.deleteOldestThread();
                    }
                    while (this.clientsInfo.size() >= 1024) {
                        this.removeOldestClient();
                    }
                    while (this.retMsgs.size() >= 1024) {
                        this.removeOldestRetain();
                    }
                    tbr2 = new ThreadBroker(connectionSocket, this);
                    this.executor.execute((Runnable)tbr2);
                }
                catch (SocketTimeoutException tbr2) {
                    // empty catch block
                }
                if (!this.firstLoop) break block14;
                this.firstLoop = false;
                this.ioWrite("connection", "online");
                tbr2 = this;
                synchronized (tbr2) {
                    for (String clientId : this.clientsInfo.keySet()) {
                        if (this.isConnected(clientId)) continue;
                        this.ioWrite("client." + clientId.replace(" ", "_") + ".connected", "0");
                    }
                }
            }
            catch (Exception e2) {
                this.errorLog("Loop failed - " + e2.getLocalizedMessage());
                try {
                    connectionSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        if (this.iniFileTs != this.iniFile.lastModified()) {
            this.end();
            throw new Exception("mqttbroker.ini file modified - restarting");
        }
        return true;
    }

    public synchronized boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        for (MQTTClient client : this.clientsInfo.values()) {
            client.closeConnection();
        }
        try {
            this.welcomeSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.executor.shutdown();
        return true;
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstLoop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    public void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    public void readAuthFile(String filePath) throws Exception {
        BufferedReader br = null;
        File file = null;
        try {
            try {
                String next;
                file = new File(filePath);
                br = new BufferedReader(new FileReader(file));
                Pattern patternClient = Pattern.compile("[^\\\\]:|[^\\\\](\\\\\\\\)+:");
                Pattern patternUserPass = Pattern.compile("[^\\\\],|[^\\\\](\\\\\\\\)+,");
                Pattern patternField = Pattern.compile("[^\\\\]=|[^\\\\](\\\\\\\\)+=");
                while ((next = br.readLine()) != null) {
                    Matcher matcher = patternClient.matcher(next);
                    boolean clientPatternFound = matcher.find();
                    String[] fields = patternClient.split(next);
                    String clientId = fields[0];
                    MQTTClient client = new MQTTClient();
                    if (fields.length > 1) {
                        clientId = String.valueOf(clientId) + matcher.group().replaceAll(":$", "");
                        clientId = Driver.replaceSpecialChars(clientId);
                        matcher = patternUserPass.matcher(fields[1]);
                        matcher.find();
                        String[] credentials = patternUserPass.split(fields[1]);
                        String username = "";
                        String password = "";
                        int i2 = 0;
                        while (i2 < credentials.length) {
                            String nextField = credentials[i2];
                            if (credentials.length > 1) {
                                nextField = String.valueOf(nextField) + matcher.group().replaceAll(",$", "");
                            }
                            matcher = patternField.matcher(nextField);
                            matcher.find();
                            String[] fieldCouple = patternField.split(nextField);
                            fieldCouple[0] = String.valueOf(fieldCouple[0]) + matcher.group().replaceAll("=$", "");
                            if (fieldCouple[0].equals("username")) {
                                if (fieldCouple.length > 1) {
                                    username = fieldCouple[1];
                                    username = Driver.replaceSpecialChars(username);
                                }
                            } else if (fieldCouple[0].equals("password") && fieldCouple.length > 1) {
                                password = fieldCouple[1];
                                password = Driver.replaceSpecialChars(password);
                            }
                            ++i2;
                        }
                        client.setUsername(username);
                        client.setPassword(password);
                    } else {
                        if (clientPatternFound) {
                            clientId = String.valueOf(clientId) + matcher.group().replaceAll(":$", "");
                        }
                        clientId = Driver.replaceSpecialChars(clientId);
                    }
                    this.clientsInfo.put(clientId, client);
                }
            }
            catch (FileNotFoundException e2) {
                file.createNewFile();
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e3) {
                throw new Exception("exception while reading mqttbroker.ini - " + e3.getLocalizedMessage());
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String replaceSpecialChars(String s) {
        return s.replaceAll("\\\\:", ":").replaceAll("\\\\=", "=").replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public void printErrorLog(String s) {
        this.errorLog(s);
    }

    public synchronized boolean authorizedToConnect(String clientId, String username, String password) {
        if (this.clientsInfo.containsKey(clientId)) {
            MQTTClient client = this.clientsInfo.get(clientId);
            String user2 = client.getUsername();
            String pass = client.getPassword();
            if (user2 != null && pass != null ? user2.equals(username) && pass.equals(password) : (this.username != null && this.password != null ? this.username.equals(username) && this.password.equals(password) : this.username == null && this.password == null)) {
                return true;
            }
        } else if (this.acceptunknown) {
            if (this.containsEqualId(clientId)) {
                this.errorLog("Connection failed -  " + clientId + " : this id already exists");
                return false;
            }
            if (this.username != null && this.password != null) {
                if (this.username.equals(username) && this.password.equals(password)) {
                    this.clientsInfo.put(clientId, new MQTTClient());
                    return true;
                }
            } else if (this.username == null && this.password == null) {
                this.clientsInfo.put(clientId, new MQTTClient());
                return true;
            }
        }
        return false;
    }

    public synchronized void setConnected(String clientId, Socket socket, int clean, ThreadBroker tr) {
        MQTTClient client = this.clientsInfo.get(clientId);
        client.setConnected(socket);
        client.prepareSession(clean == 1);
        client.setThread(tr);
        this.clientsInfo.put(clientId, client);
    }

    public synchronized boolean isConnected(String clientId) {
        return !this.clientsInfo.get(clientId).isClosed();
    }

    public synchronized void closeConnectionIfAlreadyConnected(String clientId) {
        MQTTClient client = this.clientsInfo.get(clientId);
        if (client.getSocket() != null) {
            ThreadBroker trdb = client.getThread();
            trdb.setCleanSession(0);
            client.closeConnection();
        }
    }

    public synchronized void sendDisconnectPacket(String clientId, byte[] response) {
        try {
            DataOutputStream outToClient = new DataOutputStream(this.getSocket(clientId).getOutputStream());
            outToClient.write(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized HashMap<String, MQTTClient> getClientsInfo() {
        return this.clientsInfo;
    }

    public synchronized void updateClient(String oldId, String newId, MQTTClient client) {
        this.removeClient(oldId);
        this.clientsInfo.put(newId, client);
        String conn = this.isConnected(newId) ? "1" : "0";
        this.ioWrite("client." + newId.replace(" ", "_") + ".connected", conn);
    }

    public synchronized void removeClient(String clientId) {
        MQTTClient toRemove = this.clientsInfo.get(clientId);
        if (toRemove != null) {
            toRemove.closeConnection();
            toRemove.deleteSession();
            this.clientsInfo.remove(clientId);
            this.removeClientFromTopics(clientId);
        }
    }

    public void removeClientFromTopics(String clientId) {
        for (String topic : this.subscribers.keySet()) {
            ArrayList<String> subs = this.subscribers.get(topic);
            if (subs == null) continue;
            subs.remove(clientId);
            this.subscribers.put(topic, subs);
        }
    }

    public boolean getAcceptUnknown() {
        return this.acceptunknown;
    }

    public void setAcceptUnknown(boolean b2) {
        this.acceptunknown = b2;
    }

    public synchronized void updateLastSeenTimestamp(String clientId, int packetType) {
        MQTTClient client = this.clientsInfo.get(clientId);
        client.updateLastSeenTimestamp(packetType);
        this.clientsInfo.put(clientId, client);
    }

    public synchronized long getLastSeenTimestamp(String clientId) {
        return this.clientsInfo.get(clientId).getLastSeenTimestamp();
    }

    public synchronized void deleteOldestThread() {
        MQTTClient oldestClient = null;
        long oldestTmsp = System.currentTimeMillis();
        for (MQTTClient client : this.clientsInfo.values()) {
            long msgTmsp;
            if (client.isClosed() || (msgTmsp = client.getMsgTimestamp()) == 0L || msgTmsp >= oldestTmsp) continue;
            oldestTmsp = msgTmsp;
            oldestClient = client;
        }
        if (oldestClient == null) {
            Random random = new Random();
            int rand = random.nextInt(this.clientsInfo.size());
            oldestClient = (MQTTClient)this.clientsInfo.values().toArray()[rand];
        }
        oldestClient.closeConnection();
    }

    public synchronized void deleteSession(String clientId) {
        MQTTClient client = this.clientsInfo.get(clientId);
        if (client != null) {
            client.deleteSession();
            this.clientsInfo.put(clientId, client);
            this.removeClientFromTopics(clientId);
        }
    }

    public synchronized MQTTClientSession getSession(String clientId) {
        MQTTClient client = this.clientsInfo.get(clientId);
        if (client != null) {
            return client.getSession();
        }
        return null;
    }

    public synchronized void addRetainMessage(int len, int qos, int packetId, String topic, String msg) {
        this.retMsgs.put(topic, new RetainMessage(len, qos, packetId, msg));
    }

    public synchronized void deleteRetainMessage(String topic) {
        this.retMsgs.remove(topic);
    }

    public boolean isMatchOk(String publishTopic, String OtherTopic) {
        String[] levelsPublish = publishTopic.split("/", -1);
        String[] levelsOther = OtherTopic.split("/", -1);
        int i2 = 0;
        while (i2 < levelsPublish.length) {
            block5: {
                try {
                    if (i2 != 0 || !levelsOther[i2].equals("+") && !levelsOther[i2].equals("#") || levelsPublish[0].length() <= 0 || levelsPublish[i2].charAt(0) != '$') break block5;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            if (!levelsPublish[i2].equals(levelsOther[i2]) && !levelsOther[i2].equals("+")) {
                return levelsOther[i2].equals("#");
            }
            ++i2;
        }
        return levelsPublish.length == levelsOther.length;
    }

    public synchronized HashMap<String, Integer> obtainSubsToThisTopic(String publishTopic) {
        HashMap<String, Integer> subsToSend = new HashMap<String, Integer>();
        for (String topic : this.subscribers.keySet()) {
            if (!this.isMatchOk(publishTopic, topic)) continue;
            for (String subId : this.subscribers.get(topic)) {
                MQTTClient client = this.clientsInfo.get(subId);
                if (client.getSession() == null) continue;
                int maxQos = client.getMaxQos(topic);
                if (subsToSend.containsKey(subId)) {
                    if (maxQos >= subsToSend.get(subId)) continue;
                    subsToSend.put(subId, maxQos);
                    continue;
                }
                subsToSend.put(subId, maxQos);
            }
        }
        return subsToSend;
    }

    public void propagateMessage(int len, int qos, int retain, int dup, int packetId, String topic, String msg, ArrayList<Byte> propList) {
        HashMap<String, Integer> subs = this.obtainSubsToThisTopic(topic);
        for (String subscriberId : subs.keySet()) {
            try {
                int maxQosSub = subs.get(subscriberId);
                byte[] toSend = this.calculateQos(subscriberId, qos, len, maxQosSub, dup, 0, packetId, topic, msg, propList);
                DataOutputStream toWrite = new DataOutputStream(this.getSocket(subscriberId).getOutputStream());
                toWrite.write(toSend);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void addMessageToSession(String clientId, int packetId, byte[] msg) {
        MQTTClient client = this.clientsInfo.get(clientId);
        client.addMessageToSession(String.valueOf(packetId), msg);
        this.clientsInfo.put(clientId, client);
    }

    public synchronized void delMessageFromSession(String clientId, int packetId) {
        MQTTClient client = this.clientsInfo.get(clientId);
        client.delMessageFromSession(String.valueOf(packetId));
        this.clientsInfo.put(clientId, client);
    }

    public synchronized void addSubscriber(ArrayList<String> topics, String clientId, ArrayList<Integer> maxQosList) {
        MQTTClient client = this.clientsInfo.get(clientId);
        int i2 = 0;
        while (i2 < topics.size()) {
            String topic = topics.get(i2);
            int maxQos = maxQosList.get(i2);
            ArrayList<String> subs = this.subscribers.get(topic);
            if (subs == null) {
                subs = new ArrayList();
            }
            if (!subs.contains(clientId)) {
                subs.add(clientId);
            }
            this.subscribers.put(topic, subs);
            client.addSubscriptionToSession(topic, maxQos);
            this.ioWriteForced("client." + clientId.replace(" ", "_") + ".subscribe." + topic, "subscribed, " + maxQos);
            ++i2;
        }
        this.clientsInfo.put(clientId, client);
    }

    public synchronized void removeSubscriber(String topic, String clientId) {
        ArrayList<String> subs = this.subscribers.get(topic);
        if (subs != null) {
            subs.remove(clientId);
            this.subscribers.put(topic, subs);
        }
        this.ioWriteForced("client." + clientId.replace(" ", "_") + ".subscribe." + topic, "unsubscribed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRetainMessage(String clientId, ArrayList<String> topics, ArrayList<Byte> propList) {
        Set<String> retTopics;
        HashMap<String, RetainMessage> hashMap = this.retMsgs;
        synchronized (hashMap) {
            retTopics = this.retMsgs.keySet();
        }
        try {
            DataOutputStream toWrite = new DataOutputStream(this.getSocket(clientId).getOutputStream());
            for (String subTopic : topics) {
                for (String retTopic : retTopics) {
                    int maxQosSub;
                    RetainMessage retMsg;
                    if (!this.isMatchOk(retTopic, subTopic)) continue;
                    Driver driver = this;
                    synchronized (driver) {
                        retMsg = this.retMsgs.get(retTopic);
                        maxQosSub = this.clientsInfo.get(clientId).getMaxQos(subTopic);
                    }
                    int len = retMsg.getLen();
                    int qos = retMsg.getQos();
                    int packetId = retMsg.getPacketId();
                    String msg = retMsg.getMessage();
                    byte[] toSend = this.calculateQos(clientId, qos, len, maxQosSub, 0, 1, packetId, retTopic, msg, propList);
                    toWrite.write(toSend);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendUnackMessages(String clientId) {
        MQTTClientSession session;
        HashMap<String, MQTTClient> hashMap = this.clientsInfo;
        synchronized (hashMap) {
            session = this.clientsInfo.get(clientId).getSession();
        }
        try {
            DataOutputStream toWrite = new DataOutputStream(this.getSocket(clientId).getOutputStream());
            ArrayList<MQTTPublishMessage> list = session.getOrderedMessages();
            for (MQTTPublishMessage msg : list) {
                byte[] byteMsg = msg.getMsg();
                byteMsg[0] = (byte)(byteMsg[0] | 8);
                toWrite.write(byteMsg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeOldestClient() {
        String clientToRemove = null;
        long oldestTmsp = System.currentTimeMillis();
        for (String key : this.clientsInfo.keySet()) {
            MQTTClient client = this.clientsInfo.get(key);
            long msgTmsp = client.getMsgTimestamp();
            if (msgTmsp == 0L || msgTmsp < oldestTmsp) {
                oldestTmsp = msgTmsp;
                clientToRemove = key;
            }
            if (msgTmsp == 0L) break;
        }
        if (clientToRemove == null) {
            Random random = new Random();
            int rand = random.nextInt(this.clientsInfo.size());
            clientToRemove = (String)this.clientsInfo.keySet().toArray()[rand];
        }
        this.removeClient(clientToRemove);
    }

    public synchronized void removeOldestRetain() {
        String oldestTopic = null;
        long oldestTmsp = System.currentTimeMillis();
        for (String topic : this.retMsgs.keySet()) {
            RetainMessage msg = this.retMsgs.get(topic);
            long tmsp = msg.getTmsp();
            if (tmsp >= oldestTmsp) continue;
            oldestTopic = topic;
        }
        if (oldestTopic == null) {
            Random random = new Random();
            int rand = random.nextInt(this.retMsgs.size());
            oldestTopic = (String)this.retMsgs.keySet().toArray()[rand];
        }
        this.retMsgs.remove(oldestTopic);
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean containsEqualId(String c2) {
        String clientId = c2.toLowerCase();
        for (String k2 : this.clientsInfo.keySet()) {
            if (!k2.toLowerCase().equals(clientId)) continue;
            return true;
        }
        return false;
    }

    public synchronized Socket getSocket(String id) {
        return this.clientsInfo.get(id).getSocket();
    }

    public byte[] calculateQos(String id, int qos, int len, int maxQosSub, int dup, int retain, int packetId, String topic, String msg, ArrayList<Byte> propList) {
        byte[] toSend;
        if (maxQosSub < qos) {
            if (maxQosSub == 0) {
                toSend = ThreadBroker.preparePropagation(len - 2, maxQosSub, dup, retain, packetId, topic, msg, propList);
            } else {
                toSend = ThreadBroker.preparePropagation(len, maxQosSub, dup, retain, packetId, topic, msg, propList);
                this.addMessageToSession(id, packetId, toSend);
            }
        } else {
            toSend = ThreadBroker.preparePropagation(len, qos, dup, retain, packetId, topic, msg, propList);
            if (qos > 0) {
                this.addMessageToSession(id, packetId, toSend);
            }
        }
        return toSend;
    }

    public void command(String name, String value) {
        try {
            if (name.startsWith("publish.")) {
                String topic = name.substring(8);
                int len = 2 + topic.getBytes().length + value.getBytes().length;
                this.propagateMessage(len, 0, 0, 0, 0, topic, value, null);
                this.ioWriteForced("publish." + topic, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setClientsInfo(HashMap<String, MQTTClient> map) {
        this.clientsInfo = map;
    }

    public HashMap<String, MQTTClient> getAuthList() {
        return this.clientsInfo;
    }

    public void setAuthList(HashMap<String, MQTTClient> list) {
        this.clientsInfo = list;
    }

    public void setUsername(String user2) {
        this.username = user2;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }
}

