/*
 * Decompiled with CFR 0.152.
 */
package drivers.mews;

import com.hsyco.hsyco;
import drivers.mews.Driver;
import drivers.mews.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class apiUtils {
    protected static JSONObject buildAPICallPOST(JSONObject params, String urlString, Driver driver) throws IOException, JSONException, ParseException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setConnectTimeout(5000);
        conn.setDoOutput(true);
        try {
            OutputStream os = conn.getOutputStream();
            byte[] input = params.toString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        catch (Exception os) {
            // empty catch block
        }
        if (conn.getResponseCode() == 201 || conn.getResponseCode() == 200) {
            InputStream response = conn.getInputStream();
            String jsonReply = Utils.convertStreamToString(response);
            JSONObject o2 = new JSONObject(jsonReply);
            if (driver.isVerbose()) {
                hsyco.messageLog(String.valueOf(driver.DriverName) + " - MEWS-WEB VERBOSE LOGS TO: " + urlString + " ClientID: " + params.getString("Client"));
                hsyco.messageLog(String.valueOf(driver.DriverName) + " - MEWS-WEB JSON RESPONSE FROM: " + urlString + " - " + o2.toString());
            }
            return o2;
        }
        if (conn.getResponseCode() == 429) {
            long epoch;
            String retryAfter = conn.getHeaderField("Retry-After");
            hsyco.errorLog(String.valueOf(driver.DriverName) + "Error 429 " + urlString + " | Retry-After: " + retryAfter);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            Date date = df.parse(retryAfter);
            Driver.retryAfterEpoch = epoch = date.getTime();
            ++Driver.retryAfterInterrupt;
        } else {
            hsyco.errorLog(String.valueOf(driver.DriverName) + "Error in " + urlString + " | Status code: " + conn.getResponseCode());
        }
        return null;
    }
}

