/*
 * Decompiled with CFR 0.152.
 */
package drivers.mews;

import com.hsyco.driverBase;
import drivers.mews.Customer;
import drivers.mews.Room;
import drivers.mews.apiCalls;
import drivers.mews.genDatapoints;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    protected String mewsClientId = "HSYCO Srl - Partner Id INT223610";
    public String MEWSAPIURL = "https://api.mews.com/api/connector/v1/";
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private long loopTimemillis = 0L;
    private int pollingtime = 0;
    public String clientToken = null;
    public String accessToken = null;
    private String startupevents = null;
    private String demoenv = null;
    private String useidsasdatapoints = null;
    public Boolean idsAsDataPoints = false;
    private Boolean genEvent = false;
    public HashMap<String, Room> rooms = new HashMap();
    public HashMap<String, String> roomsIdToName = new HashMap();
    public List<String> reservedRooms = new ArrayList<String>();
    public List<String> reservedRoomsToRemove = new ArrayList<String>();
    public HashMap<String, Customer> customers = new HashMap();
    public HashMap<String, Customer> customerReservations = new HashMap();
    public HashMap<String, String> serviceIoToName = new HashMap();
    public List<String> bookableServices = new ArrayList<String>();
    public HashMap<String, List<String>> roomsChildrens = new HashMap();
    protected static long retryAfterEpoch = 0L;
    protected static int retryAfterInterrupt = 0;
    protected static int retryAfterInterruptUser = 0;
    public String DriverName = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.DriverName = name;
        this.loadConfig(config);
        if (this.checkConfig()) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.DriverName) + " - MEWS-WEB DRIVER STARTUP, " + " | genEvent: " + this.genEvent + " | pollingtime: " + this.pollingtime + " | clientToken: " + this.clientToken + " | accessToken: " + this.accessToken + " | retryAfterInterruptUser: " + retryAfterInterruptUser + " - driver version: 1.0");
            }
            try {
                genDatapoints.genHotelBasicInfoDataPoints(apiCalls.getHotelBasicInfo(this), this);
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(this.DriverName) + " init exception: " + e2.getLocalizedMessage());
                return false;
            }
            return true;
        }
        this.genEvent = true;
        this.ioWrite("connection", "offline");
        return false;
    }

    public boolean loop() {
        long now = System.currentTimeMillis();
        long sleepTime = this.loopTimemillis + (long)this.pollingtime - now;
        if (sleepTime > 0L) {
            this.sleep(sleepTime);
            this.loopTimemillis += (long)this.pollingtime;
        } else {
            this.loopTimemillis = now;
        }
        if (retryAfterInterrupt == retryAfterInterruptUser) {
            return false;
        }
        if (retryAfterEpoch != 0L) {
            this.messageLog(String.valueOf(this.DriverName) + " We got a 429 sleeping... Epoch now: " + now + " | Epoch wait: " + retryAfterEpoch);
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            if (now >= retryAfterEpoch) {
                retryAfterInterrupt = 0;
                retryAfterEpoch = 0L;
                this.genEvent = true;
                this.ioWrite("connection", "online");
            }
        } else {
            this.loopFunction();
        }
        return true;
    }

    private void loopFunction() {
        try {
            genDatapoints.genHotelDepartmentsDataPoints(apiCalls.getHotelDepartments(this), this);
            genDatapoints.genHotelServicesDataPoints(apiCalls.getHotelServices(this), this);
            genDatapoints.genHotelCustomersDataPoints(apiCalls.getHotelCustomers(this), this);
            genDatapoints.genHotelResourcesDataPoints(apiCalls.getHotelResurces(this), this);
            genDatapoints.genHotelReservationTodayTomorrow(this);
            if (!this.genEvent.booleanValue()) {
                this.genEvent = true;
                this.ioWrite("connection", "online");
            } else if (this.genEvent.booleanValue() && this.startupevents.equals("true")) {
                this.ioWrite("connection", "online");
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.errorLog(String.valueOf(this.DriverName) + " Network Error");
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            this.genEvent = false;
        }
        catch (ConnectException connException) {
            this.errorLog(String.valueOf(this.DriverName) + " Network Error");
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            this.genEvent = false;
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.DriverName) + " loop exception: " + e2.getLocalizedMessage());
        }
    }

    public boolean end() {
        this.genEvent = true;
        this.ioWrite("connection", "offline");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        if (name.equals("task.new")) {
            try {
                JSONObject jsonCommand = new JSONObject(value);
                String Name4 = jsonCommand.getString("Name");
                String Description = jsonCommand.getString("Description");
                String DeadlineUtc = jsonCommand.getString("DeadlineUtc");
                String DepartmentId = jsonCommand.getString("DepartmentId");
                apiCalls.newHotelTask(this, Name4, Description, DeadlineUtc, DepartmentId);
            }
            catch (JSONException ex) {
                this.errorLog(String.valueOf(this.DriverName) + " Error in JSON parsing - JSON input: " + value);
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(this.DriverName) + " Error in JSON call");
            }
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.genEvent.booleanValue()) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    private boolean checkConfig() {
        if (this.clientToken == null || this.clientToken == "") {
            this.errorLog(String.valueOf(this.DriverName) + " - WARN ioServersOption clientToken param is null");
            return false;
        }
        if (this.accessToken == null || this.accessToken == "") {
            this.errorLog(String.valueOf(this.DriverName) + " - WARN ioServersOption accessToken param is null");
            return false;
        }
        if (this.startupevents != null && this.startupevents.equals("true")) {
            this.genEvent = true;
        }
        if (this.demoenv != null && this.demoenv.equals("true")) {
            this.MEWSAPIURL = "https://api.mews-demo.com/api/connector/v1/";
        }
        if (this.useidsasdatapoints != null && this.useidsasdatapoints.equals("true")) {
            this.idsAsDataPoints = true;
        }
        if (this.pollingtime == 0 || this.pollingtime <= 10000) {
            this.pollingtime = 10000;
        }
        if (retryAfterInterruptUser == 0) {
            retryAfterInterruptUser = 10;
        }
        return true;
    }

    private void loadConfig(HashMap<String, String> config) {
        try {
            this.clientToken = config.get("clienttoken");
            this.accessToken = config.get("accesstoken");
            this.startupevents = config.get("startupevents");
            this.demoenv = config.get("demoenv");
            this.useidsasdatapoints = config.get("useidsasdatapoints");
            this.pollingtime = Integer.parseInt(config.get("pollingtime"));
            retryAfterInterruptUser = Integer.parseInt(config.get("retryafterinterrupt"));
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.DriverName) + " - WARN ioServersOption some params where ignored");
        }
    }

    public boolean isVerbose() {
        return this.isVerboseLog();
    }
}

