/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.DataPayload;
import drivers.lorawan.model.Direction;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.JoinAcceptPayload;
import drivers.lorawan.model.JoinRequestPayload;
import drivers.lorawan.model.MalformedPacketException;
import drivers.lorawan.model.ProprietaryPayload;
import drivers.lorawan.model.RFUPayload;

public enum MType {
    JOIN_REQUEST(0, JoinRequestPayload.class, Direction.UP),
    JOIN_ACCEPT(1, JoinAcceptPayload.class, Direction.DOWN),
    UNCONF_DATA_UP(2, DataPayload.class, Direction.UP),
    UNCONF_DATA_DOWN(3, DataPayload.class, Direction.DOWN),
    CONF_DATA_UP(4, DataPayload.class, Direction.UP),
    CONF_DATA_DOWN(5, DataPayload.class, Direction.DOWN),
    RFU(6, RFUPayload.class, null),
    PROPRIETARY(7, ProprietaryPayload.class, null);

    private final byte value;
    private final Class<? extends FRMPayload> mapper;
    private final Direction direction;
    private static Class<? extends RFUPayload> rfuMapper;
    private static Class<? extends ProprietaryPayload> proprietaryMapper;

    private MType(byte _value, Class<? extends FRMPayload> _mapper, Direction _direction) {
        this.value = _value;
        this.mapper = _mapper;
        this.direction = _direction;
    }

    public static MType from(byte _mhdr) throws MalformedPacketException {
        byte mType = (byte)(_mhdr >> 5 & 7);
        MType[] mTypeArray = MType.values();
        int n2 = mTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MType v = mTypeArray[n3];
            if (v.value == mType) {
                return v;
            }
            ++n3;
        }
        throw new MalformedPacketException("MType");
    }

    public Direction getDirection() {
        return this.direction;
    }

    public byte getValue() {
        return this.value;
    }

    public Class<? extends FRMPayload> getMapper() {
        if (this.mapper.equals(RFUPayload.class)) {
            if (rfuMapper == null) {
                throw new RuntimeException("Missing mapper for MType " + this.name());
            }
            return rfuMapper;
        }
        if (this.mapper.equals(ProprietaryPayload.class)) {
            if (proprietaryMapper == null) {
                throw new RuntimeException("Missing mapper for MType " + this.name());
            }
            return proprietaryMapper;
        }
        return this.mapper;
    }

    public static void setRfuPayloadMapper(Class<? extends RFUPayload> _handler) {
        rfuMapper = _handler;
    }

    public static void setProprietaryPayloadMapper(Class<? extends ProprietaryPayload> _handler) {
        proprietaryMapper = _handler;
    }
}

