/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.AesCmac;
import drivers.lorawan.model.Direction;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.MacPayload;
import drivers.lorawan.model.MalformedPacketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class DataPayload
implements FRMPayload {
    private MacPayload mac;
    private byte[] payload;
    private byte[] nwkSKey;
    private byte[] appSKey;

    public DataPayload(MacPayload _mac, ByteBuffer _raw) {
        this.mac = _mac;
        _raw.order(ByteOrder.LITTLE_ENDIAN);
        this.payload = new byte[_raw.remaining() - 4];
        _raw.get(this.payload);
    }

    public DataPayload(MacPayload _mac) {
        this.mac = _mac;
        this.mac.setPayload(this);
    }

    public byte[] computeMic(short fCntHighBits) throws MalformedPacketException {
        if (this.nwkSKey == null) {
            throw new RuntimeException("undefined nwkSKey");
        }
        ByteBuffer body = ByteBuffer.allocate(1 + this.mac.length() + 16);
        body.order(ByteOrder.LITTLE_ENDIAN);
        body.put((byte)73);
        body.put(new byte[4]);
        body.put(this.mac.getPhyPayload().getMType().getDirection().value());
        body.put(this.mac.getFhdr().getDevAddr());
        body.putShort(this.mac.getFhdr().getfCnt());
        body.putShort(fCntHighBits);
        body.put((byte)0);
        body.put((byte)(1 + this.mac.length()));
        body.put(this.mac.getPhyPayload().getMHDR());
        this.mac.toRaw(body);
        try {
            AesCmac aesCmac = new AesCmac();
            aesCmac.init(new SecretKeySpec(this.nwkSKey, "AES"));
            aesCmac.updateBlock(body.array());
            return Arrays.copyOfRange(aesCmac.doFinal(), 0, 4);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new RuntimeException("Could not compute AesCmac", ex);
        }
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public void toRaw(ByteBuffer _bb) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        _bb.put(this.payload);
    }

    public byte[] getClearPayLoad(short fCntHighBits) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, MalformedPacketException {
        byte[] key;
        if (this.mac.getfPort() == 0) {
            if (this.nwkSKey == null) {
                throw new RuntimeException("undefined nwkSKey");
            }
            key = this.nwkSKey;
        } else {
            if (this.appSKey == null) {
                throw new RuntimeException("undefined appSKey");
            }
            key = this.appSKey;
        }
        int k2 = (int)Math.ceil((double)this.payload.length / 16.0);
        ByteBuffer a2 = ByteBuffer.allocate(16 * k2);
        a2.order(ByteOrder.LITTLE_ENDIAN);
        int i2 = 1;
        while (i2 <= k2) {
            a2.put((byte)1);
            a2.put(new byte[4]);
            a2.put(this.mac.getPhyPayload().getMType().getDirection().value());
            a2.put(this.mac.getFhdr().getDevAddr());
            a2.putShort(this.mac.getFhdr().getfCnt());
            a2.putShort(fCntHighBits);
            a2.put((byte)0);
            a2.put((byte)i2);
            ++i2;
        }
        SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, aesKey);
        byte[] s = cipher.doFinal(a2.array());
        byte[] paddedPayload = new byte[16 * k2];
        System.arraycopy(this.payload, 0, paddedPayload, 0, this.payload.length);
        byte[] plainPayload = new byte[this.payload.length];
        int i3 = 0;
        while (i3 < this.payload.length) {
            plainPayload[i3] = (byte)(s[i3] ^ paddedPayload[i3]);
            ++i3;
        }
        return plainPayload;
    }

    public DataPayload setClearPayLoad(byte[] _data, Direction direction, byte[] devAddr, int fCnt32bits) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, MalformedPacketException {
        byte[] key;
        if (this.mac.getfPort() == 0) {
            if (this.nwkSKey == null) {
                throw new RuntimeException("undefined nwkSKey");
            }
            key = this.nwkSKey;
        } else {
            if (this.appSKey == null) {
                throw new RuntimeException("undefined appSKey");
            }
            key = this.appSKey;
        }
        int k2 = (int)Math.ceil((double)_data.length / 16.0);
        ByteBuffer a2 = ByteBuffer.allocate(16 * k2);
        a2.order(ByteOrder.LITTLE_ENDIAN);
        int i2 = 1;
        while (i2 <= k2) {
            a2.put((byte)1);
            a2.put(new byte[4]);
            a2.put(direction.value());
            a2.put(devAddr);
            a2.putInt(fCnt32bits);
            a2.put((byte)0);
            a2.put((byte)i2);
            ++i2;
        }
        SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, aesKey);
        byte[] s = cipher.doFinal(a2.array());
        byte[] paddedPayload = new byte[16 * k2];
        System.arraycopy(_data, 0, paddedPayload, 0, _data.length);
        this.payload = new byte[_data.length];
        int i3 = 0;
        while (i3 < _data.length) {
            this.payload[i3] = (byte)(s[i3] ^ paddedPayload[i3]);
            ++i3;
        }
        return this;
    }

    public DataPayload setClearPayLoad(byte[] _data, short fCntHighBits) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, MalformedPacketException {
        byte[] key;
        if (this.mac.getfPort() == 0) {
            if (this.nwkSKey == null) {
                throw new RuntimeException("undefined nwkSKey");
            }
            key = this.nwkSKey;
        } else {
            if (this.appSKey == null) {
                throw new RuntimeException("undefined appSKey");
            }
            key = this.appSKey;
        }
        int k2 = (int)Math.ceil((double)_data.length / 16.0);
        ByteBuffer a2 = ByteBuffer.allocate(16 * k2);
        a2.order(ByteOrder.LITTLE_ENDIAN);
        int i2 = 1;
        while (i2 <= k2) {
            a2.put((byte)1);
            a2.put(new byte[4]);
            a2.put(this.mac.getPhyPayload().getMType().getDirection().value());
            a2.put(this.mac.getFhdr().getDevAddr());
            a2.putShort(this.mac.getFhdr().getfCnt());
            a2.putShort(fCntHighBits);
            a2.put((byte)0);
            a2.put((byte)i2);
            ++i2;
        }
        SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, aesKey);
        byte[] s = cipher.doFinal(a2.array());
        byte[] paddedPayload = new byte[16 * k2];
        System.arraycopy(_data, 0, paddedPayload, 0, _data.length);
        this.payload = new byte[_data.length];
        int i3 = 0;
        while (i3 < _data.length) {
            this.payload[i3] = (byte)(s[i3] ^ paddedPayload[i3]);
            ++i3;
        }
        return this;
    }

    public MacPayload getMac() {
        return this.mac;
    }

    public DataPayload setMac(MacPayload _mac) {
        this.mac = _mac;
        return this;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public DataPayload setPayload(byte[] _payload) {
        this.payload = _payload;
        return this;
    }

    @Override
    public boolean validateMic(short fCntHighBits) throws MalformedPacketException {
        return Arrays.equals(this.computeMic(fCntHighBits), this.mac.getPhyPayload().getMic());
    }

    public DataPayload setNwkSKey(byte[] _nwkSKey) {
        this.nwkSKey = _nwkSKey;
        return this;
    }

    public byte[] getNwkSKey() {
        return this.nwkSKey;
    }

    public DataPayload setAppSKey(byte[] _appSKey) {
        this.appSKey = _appSKey;
        return this;
    }

    public byte[] getAppSKey() {
        return this.appSKey;
    }
}

