/*
 * Decompiled with CFR 0.152.
 */
package drivers.ksenia;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[]{"ksenia"};
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private final DateFormat logsDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final DateFormat logsTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private final DateFormat eventsTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String name;
    private String baseUrl;
    private String user;
    private String password;
    private long pollInterval = 3000L;
    private boolean genEvent = false;
    private String pin = null;
    private int logSize = 20;
    private boolean online;
    private Vector<String> logs;
    private String logVar;
    private Object pollingkLock = new Object();
    String model;
    Map<Integer, Zone> zones;
    Map<Integer, Partition> partitions;
    private boolean partitionsStateChanged;
    private boolean zonesStateChanged;
    private long lastLogTs = 0L;
    final XMLConsumer GENERAL_INFO_CONSUMER = new XMLConsumer(this){
        String revision;

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null) {
                if (currElement.equals("productName")) {
                    this.ioWrite("model", data, false);
                    int sepIdx = data.lastIndexOf(32);
                    model = data.substring(sepIdx + 1).trim();
                } else if (currElement.equals("productHighRevision")) {
                    this.revision = data;
                } else if (currElement.equals("productLowRevision")) {
                    this.revision = String.valueOf(this.revision) + "." + data;
                } else if (currElement.equals("productBuildRevision")) {
                    this.revision = String.valueOf(this.revision) + "." + data;
                    this.ioWrite("revision", this.revision, false);
                } else if (currElement.equals("webServerFW")) {
                    this.ioWrite("webserverfw", data, false);
                } else if (currElement.equals("webServerHTML")) {
                    this.ioWrite("webserverhtml", data, false);
                }
            }
        }
    };
    final XMLConsumer DATE_TIME_CONSUMER = new XMLConsumer(this){

        @Override
        void data(String data) {
            this.ioWrite("clock", this.timestampToEventsDate(data), false);
        }
    };
    final XMLConsumer FAULTS_CONSUMER = new XMLConsumer(this){
        private int currPeripheralId;

        @Override
        void data(String data) {
            if (this.elements.size() >= 2) {
                String el1 = (String)this.elements.get(1);
                if (el1.equals("busPeripherals")) {
                    this.ioWrite("bus.peripherals.ko", data.equals("OK") ? "0" : "1", true);
                } else if (el1.equals("panelStatus")) {
                    this.ioWrite("panel.tamper", data, true);
                }
                if (this.elements.size() >= 3) {
                    String el2 = (String)this.elements.get(2);
                    if (el1.equals("battery")) {
                        if (el2.equals("low")) {
                            this.ioWrite("battery.low", data, true);
                        } else if (el2.equals("bad")) {
                            this.ioWrite("battery.bad", data, true);
                        } else if (el2.equals("voltage")) {
                            this.ioWrite("battery.volt", String.format(Locale.US, "%.1f", (double)Integer.parseInt(data) / 4145.73), false);
                        }
                    } else if (el1.equals("powerSupply")) {
                        if (el2.equals("no")) {
                            this.ioWrite("power.no", data, true);
                        } else if (el2.equals("ko")) {
                            this.ioWrite("power.ko", data, true);
                        } else if (el2.equals("low")) {
                            this.ioWrite("power.low", data, true);
                        } else if (el2.equals("voltage")) {
                            this.ioWrite("power.volt", String.format(Locale.US, "%.1f", (double)Integer.parseInt(data) / 4145.73), false);
                        }
                    } else if (el1.equals("gsm") || el1.equals("pstn")) {
                        String currElement = this.getCurrentElement();
                        if (currElement.equals("id")) {
                            this.currPeripheralId = Integer.parseInt(data) + 1;
                        } else if (currElement.equals("description")) {
                            this.ioWrite(String.valueOf(el1) + "." + this.currPeripheralId + ".descr", data, false);
                        } else if (currElement.equals("state")) {
                            this.ioWrite(String.valueOf(el1) + "." + this.currPeripheralId + ".state", data.replace("_PERIPHERAL", "").toLowerCase(Locale.ENGLISH), false);
                        } else if (currElement.equals("networkKo")) {
                            this.ioWrite(String.valueOf(el1) + "." + this.currPeripheralId + ".network.ko", data, true);
                        }
                    } else if ((el1.equals("ethernet") || el1.equals("bus") || el1.equals("fuses")) && el2.toLowerCase(Locale.ENGLISH).endsWith("ko")) {
                        this.ioWrite(String.valueOf(el1) + ".ko", data, true);
                    }
                }
            }
        }
    };
    final XMLConsumer LOG_CONSUMER = new XMLConsumer(this){
        private Long lastId;
        private String id;
        private String time;
        private String date;
        private String event;
        private String generator;
        private String means;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("log")) {
                this.means = null;
                this.generator = null;
                this.event = null;
                this.date = null;
                this.time = null;
                this.id = null;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null) {
                if (currElement.equals("id")) {
                    this.id = data;
                } else if (currElement.equals("time")) {
                    this.time = data;
                } else if (currElement.equals("data")) {
                    this.date = data;
                } else if (currElement.equals("event")) {
                    this.event = data;
                } else if (currElement.equals("generator")) {
                    this.generator = data;
                } else if (currElement.equals("means")) {
                    this.means = data;
                }
            }
        }

        @Override
        void end(String element) {
            super.end(element);
            if (element.equals("log")) {
                if (this.lastId == null) {
                    this.lastId = Long.parseLong(this.id);
                } else {
                    long idl = Long.parseLong(this.id);
                    if (idl > this.lastId || this.lastId - idl > 100L) {
                        this.securityLog(this.date, this.time, this.event, this.generator, this.means);
                        this.lastId = idl;
                    }
                }
            }
        }
    };
    final XMLConsumer OUTPUTS_DESCRIPTION_CONSUMER = new XMLConsumer(this){
        private int idx;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("outputsDescription")) {
                this.idx = 0;
            } else if (element.equals("output")) {
                ++this.idx;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null && currElement.equals("output")) {
                this.ioWrite("o" + this.idx + ".name", data, false);
            }
        }
    };
    final XMLConsumer OUTPUTS_STATUS_CONSUMER = new XMLConsumer(this){
        private int idx;
        private String status;
        private String type;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("outputsStatus")) {
                this.idx = 0;
            } else if (element.equals("output")) {
                ++this.idx;
                this.type = null;
                this.status = null;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null) {
                if (currElement.equals("status")) {
                    this.status = data;
                } else if (currElement.equals("type")) {
                    this.type = data;
                }
            }
        }

        @Override
        void end(String element) {
            if (element.equals("output") && this.type != null && !this.type.equals("NOT_USED")) {
                this.ioWrite("o" + this.idx, "ON".equals(this.status) ? "1" : "0", true);
            }
        }
    };
    final XMLConsumer PARTITIONS_DESCRIPTION_CONSUMER = new XMLConsumer(this){
        private int idx;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("partitionsDescription")) {
                this.idx = 0;
            } else if (element.equals("partition")) {
                ++this.idx;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null && currElement.equals("partition")) {
                Partition p = new Partition(this.idx);
                partitions.put(this.idx, p);
                p.setName(data);
            }
        }
    };
    final XMLConsumer PARTITIONS_STATUS_CONSUMER = new XMLConsumer(this){
        private int idx;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("partitionsStatus")) {
                this.idx = 0;
            } else if (element.equals("partition")) {
                ++this.idx;
            }
        }

        @Override
        void data(String data) {
            Partition p;
            String currElement = this.getCurrentElement();
            if (currElement != null && currElement.equals("partition") && (p = partitions.get(this.idx)) != null) {
                p.setStatus(data);
            }
        }
    };
    final XMLConsumer ZONES_DESCRIPTION_CONSUMER = new XMLConsumer(this){
        private int idx;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("zonesDescription")) {
                this.idx = 0;
            } else if (element.equals("zone")) {
                ++this.idx;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null && currElement.equals("zone")) {
                Zone z = new Zone(this.idx);
                zones.put(this.idx, z);
                z.setName(data);
            }
        }
    };
    final XMLConsumer ZONES_STATUS_CONSUMER = new XMLConsumer(this){
        private int idx;
        private String status;
        private String bypass;
        private String alarm;
        private String memoryAlarm;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("zonesStatus")) {
                this.idx = 0;
            } else if (element.equals("zone")) {
                ++this.idx;
                this.memoryAlarm = null;
                this.alarm = null;
                this.bypass = null;
                this.status = null;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null) {
                if (currElement.equals("status")) {
                    this.status = data;
                } else if (currElement.equals("bypass")) {
                    this.bypass = data;
                } else if (currElement.equals("alarm")) {
                    this.alarm = data;
                } else if (currElement.equals("memoryAlarm")) {
                    this.memoryAlarm = data;
                }
            }
        }

        @Override
        void end(String element) {
            if (element.equals("zone") && this.status != null && !this.status.equals("NOT_USED")) {
                Zone z = zones.get(this.idx);
                if (z == null) {
                    z = new Zone(this.idx);
                    zones.put(this.idx, z);
                }
                z.setState(this.status, this.bypass, this.alarm, this.memoryAlarm);
            }
        }
    };
    final XMLConsumer REAL_TIME_PERIPHERALS_CONSUMER = new XMLConsumer(this){
        private int currPeripheralId;

        @Override
        void data(String data) {
            if (this.elements.size() == 4) {
                String type = (String)this.elements.get(1);
                String prm = (String)this.elements.get(3);
                if (prm.equals("id")) {
                    this.currPeripheralId = Integer.parseInt(data) + 1;
                } else if (prm.equals("description")) {
                    this.ioWrite(String.valueOf(type) + "." + this.currPeripheralId + ".descr", data, false);
                } else if (prm.equals("state")) {
                    this.ioWrite(String.valueOf(type) + "." + this.currPeripheralId + ".state", data.replace("_PERIPHERAL", "").toLowerCase(Locale.ENGLISH), false);
                }
            }
        }
    };
    final XMLConsumer SCENARIOS_DESCRIPTION_CONSUMER = new XMLConsumer(this){
        private int idx;

        @Override
        void start(String element) {
            super.start(element);
            if (element.equals("scenariosDescription")) {
                this.idx = 0;
            } else if (element.equals("scenario")) {
                ++this.idx;
            }
        }

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null && currElement.equals("scenario")) {
                this.ioWrite("scen" + this.idx + ".name", data, false);
            }
        }
    };
    final XMLConsumer LARES_STATUS_CONSUMER = new XMLConsumer(this){

        @Override
        void data(String data) {
            String currElement = this.getCurrentElement();
            if (currElement != null) {
                if (currElement.equals("indoor")) {
                    try {
                        this.ioWrite("temp.in", "" + Float.parseFloat(data.split(" ")[0]), false);
                    }
                    catch (Exception exception) {}
                } else if (currElement.equals("outdoor")) {
                    try {
                        this.ioWrite("temp.out", "" + Float.parseFloat(data.split(" ")[0]), false);
                    }
                    catch (Exception exception) {}
                } else if (currElement.equals("signalStrenght")) {
                    this.ioWrite("gsm.signal", data, false);
                } else if (currElement.equals("credit")) {
                    if (data.equals("4294967295")) {
                        data = "0";
                    }
                    this.ioWrite("gsm." + (String)this.elements.get(2) + ".credit", data, false);
                } else if (currElement.equals("expiry")) {
                    this.ioWrite("gsm." + (String)this.elements.get(2) + ".exp", this.timestampToEventsDate(data), false);
                }
            }
        }
    };
    final XMLConsumer CMD_CONSUMER = new XMLConsumer(this){

        @Override
        void data(String data) throws Exception {
            if (!data.equalsIgnoreCase("cmdSent")) {
                throw new Exception("Command error");
            }
        }
    };

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            this.baseUrl = config.get("host");
            String port = config.get("port");
            if (port != null) {
                this.baseUrl = String.valueOf(this.baseUrl) + ":" + port;
            }
            this.baseUrl = "http://" + this.baseUrl;
            this.user = config.get("user");
            this.password = config.get("password");
            this.pin = config.get("pin");
            String startupevents = config.get("startupevents");
            if (startupevents != null) {
                this.genEvent = Boolean.parseBoolean(startupevents);
            }
            try {
                this.pollInterval = Integer.parseInt(config.get("pollinterval")) * 1000;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.logSize = Integer.parseInt(config.get("logsize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uiSet("object.zones.list", "panel", "false");
            this.uiSet("object.partitions.list", "panel", "false");
            this.loadLogs();
            this.zones = new HashMap<Integer, Zone>();
            this.partitions = new HashMap<Integer, Partition>();
            this.eventsTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.requestAndProcess("/xml/info/generalInfo.xml", this.GENERAL_INFO_CONSUMER);
            this.requestAndProcess("/xml/outputs/outputsDescription" + this.model + ".xml", this.OUTPUTS_DESCRIPTION_CONSUMER);
            this.requestAndProcess("/xml/partitions/partitionsDescription" + this.model + ".xml", this.PARTITIONS_DESCRIPTION_CONSUMER);
            this.requestAndProcess("/xml/zones/zonesDescription" + this.model + ".xml", this.ZONES_DESCRIPTION_CONSUMER);
            this.requestAndProcess("/xml/scenarios/scenariosDescription.xml", this.SCENARIOS_DESCRIPTION_CONSUMER);
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void loadLogs() {
        this.logVar = "__HSYCO__KSENIA_" + this.name + ".log!";
        ObjectInputStream ois = null;
        try {
            try {
                String s = userBase.varGet(this.logVar);
                if (s == null) {
                    this.logs = new Vector(this.logSize);
                }
                byte[] data = Base64.decodeBase64(s);
                ois = new ObjectInputStream(new ByteArrayInputStream(data));
                this.logs = (Vector)ois.readObject();
            }
            catch (Exception e2) {
                this.logs = new Vector(this.logSize);
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    private void requestAndProcess(String path, XMLConsumer consumer) throws Exception {
        String resp = userBase.urlGet(String.valueOf(this.baseUrl) + path, this.user, this.password);
        if (resp == null) {
            throw new IOException("request error");
        }
        int sepIdx = resp.indexOf(58);
        String code = resp.substring(0, sepIdx);
        if (!"200".equals(code)) {
            throw new IOException("response error: " + code);
        }
        if (resp.length() > sepIdx && consumer != null) {
            resp = resp.substring(sepIdx + 1);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(new StringReader(resp));
            while (eventReader.hasNext()) {
                String data;
                String element;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    element = event.asStartElement().getName().getLocalPart();
                    consumer.start(element);
                }
                if (event.isCharacters() && !(data = event.asCharacters().getData().trim()).isEmpty()) {
                    consumer.data(data);
                }
                if (!event.isEndElement()) continue;
                element = event.asEndElement().getName().getLocalPart();
                consumer.end(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        try {
            this.requestAndProcess("/xml/faults/faults.xml", this.FAULTS_CONSUMER);
            this.requestAndProcess("/xml/log/log30.xml", this.LOG_CONSUMER);
            this.requestAndProcess("/xml/outputs/outputsStatus" + this.model + ".xml", this.OUTPUTS_STATUS_CONSUMER);
            this.requestAndProcess("/xml/partitions/partitionsStatus" + this.model + ".xml", this.PARTITIONS_STATUS_CONSUMER);
            this.requestAndProcess("/xml/zones/zonesStatus" + this.model + ".xml", this.ZONES_STATUS_CONSUMER);
            this.requestAndProcess("/xml/peripherals/RealTimePeripherals" + this.model + ".xml", this.REAL_TIME_PERIPHERALS_CONSUMER);
            this.requestAndProcess("/xml/state/laresStatus.xml", this.LARES_STATUS_CONSUMER);
            if (this.partitionsStateChanged) {
                this.updateObjectList("partitions", this.partitions);
                this.partitionsStateChanged = false;
            }
            if (this.zonesStateChanged) {
                this.updateObjectList("zones", this.zones);
                this.zonesStateChanged = false;
            }
            if (!this.online) {
                this.online = true;
                this.genEvent = true;
                this.ioWrite("connection", "online");
                this.securityLog(null, null, "HSYCO ONLINE", null, null);
                this.uiSet("connection.offline", "visible", "false");
                this.uiSet("connection.online", "visible", "true");
            }
            if (this.lastLogTs != 0L && System.currentTimeMillis() > this.lastLogTs + 5000L) {
                this.uiSet("log0", "value", "");
                this.lastLogTs = 0L;
            }
            Object object = this.pollingkLock;
            synchronized (object) {
                this.pollingkLock.wait(this.pollInterval);
            }
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private <T extends Entity> void updateObjectList(String listName, Map<Integer, T> map) {
        String labels;
        String values;
        ArrayList<T> set = new ArrayList<T>(map.values());
        if (set.isEmpty()) {
            values = "";
            labels = "";
        } else {
            Collections.sort(set, new Comparator<Entity>(){

                @Override
                public int compare(Entity e1, Entity e2) {
                    return e1.name.compareTo(e2.name);
                }
            });
            StringBuilder valuesBuilder = new StringBuilder();
            StringBuilder labelsBuilder = new StringBuilder();
            for (Entity g2 : set) {
                valuesBuilder.append(",").append(g2.idx);
                labelsBuilder.append(",").append(g2.getListLabel());
            }
            values = valuesBuilder.substring(1);
            labels = labelsBuilder.substring(1);
        }
        this.uiSet("object." + listName + ".list", "values", values);
        this.uiSet("object." + listName + ".list", "labels", labels);
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog(null, null, "HSYCO OFFLINE", null, null);
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        if (cmd.startsWith("object.")) {
            if (cmd.endsWith(".list")) {
                this.uiSet(session, "object.index", "hidden", value);
                int idx = Integer.parseInt(value);
                if (cmd.startsWith("zones", 7)) {
                    Zone z = this.zones.get(idx);
                    if (z.bypass == 1) {
                        this.uiSet(session, "object.key.unbypass", "visible", "true");
                        this.uiSet(session, "object.key.bypass", "visible", "false");
                    } else {
                        this.uiSet(session, "object.key.unbypass", "visible", "false");
                        this.uiSet(session, "object.key.bypass", "visible", "true");
                    }
                    this.uiSet(session, "object.key.arm", "visible", "false");
                    this.uiSet(session, "object.key.disarm", "visible", "false");
                } else {
                    Partition p = this.partitions.get(idx);
                    if (p.armed == 1 || p.exit == 1) {
                        this.uiSet(session, "object.key.disarm", "visible", "true");
                        this.uiSet(session, "object.key.arm", "visible", "false");
                    } else {
                        this.uiSet(session, "object.key.disarm", "visible", "false");
                        this.uiSet(session, "object.key.arm", "visible", "true");
                    }
                    this.uiSet(session, "object.key.unbypass", "visible", "false");
                    this.uiSet(session, "object.key.bypass", "visible", "false");
                }
                this.uiSet(session, "object.container.keypad", "visible", "true");
                this.uiSet(session, "object.container.tabs", "visible", "false");
                this.uiSet(session, "object.pin", "value", "_");
                this.uiSet(session, "object.pin", "hidden", "");
            } else if (cmd.endsWith("key")) {
                if (value.length() == 1) {
                    String pin = userBase.uiGet(session, String.valueOf(this.name) + ".object.pin", "hidden");
                    if (pin == null) {
                        pin = "";
                    }
                    pin = String.valueOf(pin) + value;
                    this.uiSet(session, "object.pin", "hidden", pin);
                    this.uiSet(session, "object.pin", "value", String.valueOf(pin.replaceAll(".", "*")) + "_");
                } else {
                    this.uiSet(session, "object.container.keypad", "visible", "false");
                    this.uiSet(session, "object.container.tabs", "visible", "true");
                    String pin = userBase.uiGet(session, String.valueOf(this.name) + ".object.pin", "hidden");
                    String idx = userBase.uiGet(session, String.valueOf(this.name) + ".object.index", "hidden");
                    if (value.equals("arm")) {
                        this.command("p" + idx + ".armed", "1." + pin);
                    } else if (value.equals("disarm")) {
                        this.command("p" + idx + ".armed", "0." + pin);
                    } else if (value.equals("bypass")) {
                        this.command("z" + idx + ".bypass", "1." + pin);
                    } else {
                        this.command("z" + idx + ".bypass", "0." + pin);
                    }
                }
            }
        } else {
            this.command(cmd, value);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        try {
            String currPin;
            String val;
            String function;
            String target;
            name = name.toLowerCase();
            this.messageLog("Command: " + name + " = " + value);
            int dot = name.indexOf(46);
            if (dot > 0) {
                target = name.substring(0, dot);
                function = name.substring(dot + 1);
            } else {
                target = name;
                function = null;
            }
            dot = value.indexOf(46);
            if (dot > 0) {
                val = value.substring(0, dot);
                currPin = value.substring(dot + 1);
            } else {
                val = value;
                currPin = this.pin;
            }
            if (currPin == null) {
                throw new Exception("PIN not set");
            }
            String cmd = null;
            if (target.equals("clock")) {
                if (val.equals("read")) {
                    this.requestAndProcess("/xml/info/dateTime.xml", this.DATE_TIME_CONSUMER);
                    return;
                }
                String[] date_time = val.split(" ");
                String[] ymd = date_time[0].split("-");
                String[] hms = date_time[1].split(":");
                cmd = "cmd=setTimeStamp&YYYY=" + ymd[0] + "&MM=" + ymd[1] + "&dd=" + ymd[2] + "&hh=" + hms[0] + "&mm=" + hms[1] + "&ss=" + hms[2];
            } else if (target.startsWith("o")) {
                int idx = Integer.parseInt(target.substring(1)) - 1;
                cmd = "cmd=setOutput&outputId=" + idx + "&outputValue=" + val;
            } else if (target.startsWith("p")) {
                if (function.equals("armed")) {
                    int idx = Integer.parseInt(target.substring(1)) - 1;
                    if (val.equals("0")) {
                        val = "3";
                    } else if (val.equals("imm")) {
                        val = "2";
                    }
                    cmd = "cmd=setArmPartition&partitionId=" + idx + "&partitionValue=" + val;
                }
            } else if (target.startsWith("z")) {
                if (function.equals("bypass")) {
                    int idx = Integer.parseInt(target.substring(1));
                    cmd = "cmd=setByPassZone&zoneId=" + idx + "&zoneValue=" + val;
                }
            } else if (target.startsWith("scen") && val.equals("1")) {
                int scen = Integer.parseInt(target.substring(4)) - 1;
                cmd = "cmd=setMacro&macroId=" + scen;
            }
            if (cmd == null) {
                throw new Exception("unknown command");
            }
            String path = "/xml/cmd/cmdOk.xml?pin=" + currPin + "&" + cmd + "&redirectPage=/xml/cmd/cmdError.xml";
            this.requestAndProcess(path, this.CMD_CONSUMER);
            Object object = this.pollingkLock;
            synchronized (object) {
                this.pollingkLock.notify();
            }
        }
        catch (Exception e2) {
            this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
        }
    }

    protected void ioWrite(String name, String value, boolean uiSetVisible) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
        if (uiSetVisible) {
            if ("1".equals(value)) {
                this.uiSet(String.valueOf(name) + ".1", "visible", "true");
                this.uiSet(String.valueOf(name) + ".0", "visible", "false");
            } else {
                this.uiSet(String.valueOf(name) + ".1", "visible", "false");
                this.uiSet(String.valueOf(name) + ".0", "visible", "true");
            }
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    void securityLog(String date, String time, String event, String generator, String means) {
        String message = event;
        if (generator != null) {
            message = String.valueOf(message) + " - " + generator;
        }
        if (means != null) {
            message = String.valueOf(message) + " - " + means;
        }
        if (date != null) {
            hsyco.securityLog(String.valueOf(this.name) + " - " + date + " " + time + " - " + message);
        } else {
            hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        }
        Date now = new Date();
        date = this.logsDateFormat.format(now);
        time = this.logsTimeFormat.format(now);
        String guiEntry = String.valueOf(date) + " " + time + "<br /><div style=\"font-size:17px\">" + message + "</div>";
        this.logs.add(0, guiEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            guiEntry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message);
        this.lastLogTs = now.getTime();
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    String timestampToEventsDate(String timestamp) {
        return this.eventsTimeFormat.format(Long.parseLong(timestamp) * 1000L);
    }

    abstract class Entity {
        final int idx;
        String name;

        Entity(int idx) {
            this.idx = idx;
        }

        abstract String getListLabel();
    }

    class Partition
    extends Entity {
        String status;
        int armed;
        int alarm;
        int tamper;
        int exit;

        Partition(int idx) {
            super(idx);
            this.armed = -1;
            this.alarm = -1;
            this.tamper = -1;
            this.exit = -1;
        }

        void setName(String name) {
            if (!name.equals(this.name)) {
                this.name = name;
                Driver.this.ioWrite("p" + this.idx + ".name", name, false);
            }
        }

        void setStatus(String status) {
            if (!status.equals(this.status)) {
                this.status = status;
                if (status.equals("ARMED") || status.equals("PREALARM") || status.equals("ARMED_IMMEDIATE")) {
                    this.armed = 1;
                    this.alarm = 0;
                    this.tamper = 0;
                    this.exit = 0;
                } else if (status.equals("ALARM")) {
                    this.armed = 1;
                    this.alarm = 1;
                    this.tamper = 0;
                    this.exit = 0;
                } else if (status.equals("TAMPER")) {
                    this.alarm = 0;
                    this.tamper = 1;
                    this.exit = 0;
                } else if (status.equals("EXIT")) {
                    this.armed = 0;
                    this.alarm = 0;
                    this.tamper = 0;
                    this.exit = 1;
                } else {
                    this.armed = 0;
                    this.alarm = 0;
                    this.tamper = 0;
                    this.exit = 0;
                }
                Driver.this.ioWrite("p" + this.idx + ".armed", "" + this.armed, true);
                Driver.this.ioWrite("p" + this.idx + ".alarm", "" + this.alarm, true);
                Driver.this.ioWrite("p" + this.idx + ".tamper", "" + this.tamper, true);
                Driver.this.ioWrite("p" + this.idx + ".exit", "" + this.exit, true);
                Driver.this.partitionsStateChanged = true;
                if (this.armed == 1) {
                    Driver.this.ioWrite("armed", "1", true);
                } else {
                    boolean globalArmed = false;
                    for (Partition p : Driver.this.partitions.values()) {
                        if (p.armed != 1) continue;
                        globalArmed = true;
                        break;
                    }
                    Driver.this.ioWrite("armed", globalArmed ? "1" : "0", true);
                }
                if (this.alarm == 1 || this.tamper == 1) {
                    Driver.this.ioWrite("alarm", "1", true);
                } else {
                    boolean globalAlarm = false;
                    for (Partition p : Driver.this.partitions.values()) {
                        if (p.alarm != 1 && p.tamper != 1) continue;
                        globalAlarm = true;
                        break;
                    }
                    Driver.this.ioWrite("alarm", globalAlarm ? "1" : "0", true);
                }
            }
        }

        @Override
        String getListLabel() {
            StringBuilder imgs = new StringBuilder();
            if (this.armed == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/lock.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-2px;\">");
            }
            if (this.exit == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/runner.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-2px;\">");
            }
            if (this.alarm == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/alarm.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-2px;\">");
            }
            if (this.tamper == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/scissors.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-2px;\">");
            }
            return String.valueOf(this.name) + "|" + imgs.toString();
        }
    }

    abstract class XMLConsumer {
        protected List<String> elements = new ArrayList<String>();

        XMLConsumer() {
        }

        void start(String element) {
            this.elements.add(element);
        }

        void end(String element) {
            this.elements.remove(this.elements.size() - 1);
        }

        protected String getCurrentElement() {
            if (this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1);
        }

        abstract void data(String var1) throws Exception;
    }

    class Zone
    extends Entity {
        String status;
        int tamper;
        int mask;
        int alarm;
        int bypass;
        int open;
        int memoryAlarm;

        Zone(int idx) {
            super(idx);
            this.tamper = -1;
            this.mask = -1;
            this.alarm = -1;
            this.bypass = -1;
            this.open = -1;
            this.memoryAlarm = -1;
            this.name = "Zone " + idx;
        }

        void setName(String name) {
            if (!name.equals(this.name)) {
                this.name = name;
                Driver.this.ioWrite("z" + this.idx + ".name", name, false);
            }
        }

        public void setState(String status, String bypass, String alarm, String memoryAlarm) {
            int val;
            if (!status.equals(this.status)) {
                this.status = status;
                if (status.equals("TAMPER")) {
                    this.tamper = 1;
                    this.mask = 0;
                    this.alarm = 0;
                } else if (status.equals("MASK")) {
                    this.tamper = 0;
                    this.mask = 1;
                    this.alarm = 0;
                } else if (status.equals("ALARM")) {
                    this.tamper = 0;
                    this.mask = 0;
                    this.alarm = 1;
                } else {
                    this.tamper = 0;
                    this.mask = 0;
                    this.alarm = 0;
                }
                Driver.this.ioWrite("z" + this.idx + ".tamper", "" + this.tamper, true);
                Driver.this.ioWrite("z" + this.idx + ".mask", "" + this.mask, true);
                Driver.this.ioWrite("z" + this.idx + ".alarm", "" + this.alarm, true);
                Driver.this.zonesStateChanged = true;
            }
            int n2 = val = "BYPASS".equals(bypass) ? 1 : 0;
            if (this.bypass != val) {
                this.bypass = val;
                Driver.this.ioWrite("z" + this.idx + ".bypass", "" + val, true);
                Driver.this.zonesStateChanged = true;
            }
            int n3 = val = "1".equals(alarm) ? 1 : 0;
            if (this.open != val) {
                this.open = val;
                Driver.this.ioWrite("z" + this.idx + ".open", "" + val, true);
                Driver.this.zonesStateChanged = true;
            }
            int n4 = val = "1".equals(memoryAlarm) ? 1 : 0;
            if (this.memoryAlarm != val) {
                this.memoryAlarm = val;
                Driver.this.ioWrite("z" + this.idx + ".alarm.mem", "" + val, true);
                Driver.this.zonesStateChanged = true;
            }
        }

        @Override
        String getListLabel() {
            StringBuilder imgs = new StringBuilder();
            if (this.open == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/dooropen.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.alarm == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/alarm.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.tamper == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/scissors.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.mask == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/alert.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.bypass == 1) {
                imgs.append("<img src=\"/$skin$/pic/ksenia/block.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            return String.valueOf(this.name) + "|" + imgs.toString();
        }
    }
}

