/*
 * Decompiled with CFR 0.152.
 */
package drivers.kilsen;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.util.ArrayList;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String host = null;
    private int unitid = 1;
    private ArrayList<Integer> nodesList = new ArrayList();
    private boolean gui = true;
    private boolean startupevent = true;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private int delay = 1000;
    private String name = null;
    private int online = -1;
    private int currentNodeIndex = 0;
    private int currentLoopIndex = 1;
    private int loopsNumber = 1;
    private int sensorsNumber = 1;
    private int modulesNumber = 1;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
        }
        String s = config.get("unitid");
        if (s != null) {
            try {
                this.unitid = Integer.parseInt(s);
            }
            catch (NumberFormatException e3) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - unitid ignored");
            }
        }
        if ((s = config.get("nodes")) == null) {
            this.nodesList.add(1);
        } else {
            try {
                String[] spl = s.split("\\;");
                int i2 = 0;
                while (i2 <= spl.length - 1) {
                    this.nodesList.add(Integer.parseInt(spl[i2]));
                    ++i2;
                }
            }
            catch (NumberFormatException e4) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - nodes ignored");
            }
        }
        s = config.get("loopsnumber");
        if (s != null) {
            try {
                this.loopsNumber = Integer.parseInt(s);
            }
            catch (NumberFormatException e5) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - loopsnumber ignored");
            }
        }
        if ((s = config.get("sensorsnumber")) != null) {
            try {
                this.sensorsNumber = Integer.parseInt(s);
                if (this.sensorsNumber > 128) {
                    this.sensorsNumber = 128;
                }
            }
            catch (NumberFormatException e6) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - sensorsnumber ignored");
            }
        }
        if ((s = config.get("modulesnumber")) != null) {
            try {
                this.modulesNumber = Integer.parseInt(s);
                if (this.modulesNumber > 128) {
                    this.modulesNumber = 128;
                }
            }
            catch (NumberFormatException e7) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - modulesnumber ignored");
            }
        }
        if ((s = config.get("gui")) != null) {
            try {
                this.gui = Boolean.parseBoolean(s);
            }
            catch (Exception e8) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
            }
        }
        if ((s = config.get("startupevents")) != null) {
            try {
                this.startupevent = Boolean.parseBoolean(s);
            }
            catch (Exception e9) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents gui ignored");
            }
        }
        this.readGlobalStatus();
        this.readNodeStatus();
        this.currentNodeIndex = 0;
        return true;
    }

    public boolean loop() {
        this.readGlobalStatus();
        this.sleep(1000L);
        this.readNodeStatus();
        this.readSensorsStatus(this.currentNodeIndex);
        return true;
    }

    public boolean end() {
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(name) + ": command: " + name + " / value: " + value);
        }
        if (name.equalsIgnoreCase("reset")) {
            if (value.equals("1")) {
                byte[] cmd = new byte[2];
                userBase.modbusWriteSingleRegister(this.host, this.unitid, 0, cmd);
                this.ioWrite("reset", "1");
                this.sleep(1000L);
                this.ioWrite("reset", "0");
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": reset command");
                }
            }
        } else if (name.equalsIgnoreCase("panel.silence")) {
            if (value.equals("1")) {
                byte[] cmd = new byte[2];
                userBase.modbusWriteSingleRegister(this.host, this.unitid, 1, cmd);
                this.ioWrite("panel.silence", "1");
                this.sleep(1000L);
                this.ioWrite("panel.silence", "0");
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": silence command");
                }
            }
        } else if (name.equalsIgnoreCase("sounders.set")) {
            if (value.equals("1")) {
                byte[] byArray = new byte[2];
                byArray[1] = 1;
                byte[] cmd = byArray;
                userBase.modbusWriteSingleRegister(this.host, this.unitid, 2, cmd);
                this.ioWrite("sounders.set", "1");
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": sounder start command");
                }
            } else if (value.equals("0")) {
                byte[] cmd = new byte[2];
                userBase.modbusWriteSingleRegister(this.host, this.unitid, 2, cmd);
                this.ioWrite("sounders.set", "0");
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": sounder stop command");
                }
            }
        }
    }

    private void readGlobalStatus() {
        byte[] response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, 4096, 2);
        if (response != null) {
            String responseHex = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": global status read: " + Driver.bytesToHex(response));
            }
            if (responseHex.startsWith("03")) {
                boolean bit6;
                byte myByte = response[3];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit5 = (myByte & 0x20) != 0;
                boolean bl = bit6 = (myByte & 0x40) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.alarm", bit0 ? "1" : "0");
                    this.ioWrite("global.fault", bit1 ? "1" : "0");
                    this.ioWrite("global.disable", bit2 ? "1" : "0");
                    this.ioWrite("global.test", bit3 ? "1" : "0");
                    this.ioWrite("global.daynight", bit4 ? "1" : "0");
                    this.ioWrite("global.mcpalarm", bit5 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.alarm", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.fault", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.disable", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("global.test", bit3 ? "1" : "0");
                    this.ioWriteNoEvents("global.daynight", bit4 ? "1" : "0");
                    this.ioWriteNoEvents("global.mcpalarm", bit5 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.alarm", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.fault", "visible", bit2 ? "true" : "false");
                    this.uiSet("global.disable", "visible", bit3 ? "true" : "false");
                    this.uiSet("global.test", "visible", bit4 ? "true" : "false");
                    this.uiSet("global.daynight", "visible", bit5 ? "true" : "false");
                    this.uiSet("global.mcpalarm", "visible", bit6 ? "true" : "false");
                }
                bit0 = ((myByte = response[2]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                boolean bl2 = bit6 = (myByte & 0x40) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.sounder.delay.enabled", bit0 ? "1" : "0");
                    this.ioWrite("global.sounder.delay.in.progress", bit1 ? "1" : "0");
                    this.ioWrite("global.sounder.outputs.activated", bit2 ? "1" : "0");
                    this.ioWrite("global.sounder.outputs.silenced", bit3 ? "1" : "0");
                    this.ioWrite("global.sounder.disabled", bit4 ? "1" : "0");
                    this.ioWrite("global.sounder.override.time.elapsed", bit5 ? "1" : "0");
                    this.ioWrite("global.sounder.in.test", bit6 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.sounder.delay.enabled", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.delay.in.progress", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.outputs.activated", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.outputs.silenced", bit3 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.disabled", bit4 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.override.time.elapsed", bit5 ? "1" : "0");
                    this.ioWriteNoEvents("global.sounder.in.test", bit6 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.sounder.delay.enabled", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.sounder.delay.in.progress", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.sounder.outputs.activated", "visible", bit2 ? "true" : "false");
                    this.uiSet("global.sounder.outputs.silenced", "visible", bit3 ? "true" : "false");
                    this.uiSet("global.sounder.disabled", "visible", bit4 ? "true" : "false");
                    this.uiSet("global.sounder.override.time.elapsed", "visible", bit5 ? "true" : "false");
                    this.uiSet("global.sounder.in.test", "visible", bit6 ? "true" : "false");
                }
                bit0 = ((myByte = response[5]) & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                boolean bl3 = bit6 = (myByte & 0x40) != 0;
                if (this.startupevent) {
                    this.ioWrite("global.fire.routing.delay.enabled", bit0 ? "1" : "0");
                    this.ioWrite("global.fire.routing.delay.in.progress", bit1 ? "1" : "0");
                    this.ioWrite("global.fire.routing.outputs.activated", bit2 ? "1" : "0");
                    this.ioWrite("global.fire.routing.ack", bit3 ? "1" : "0");
                    this.ioWrite("global.fire.routing.disabled", bit4 ? "1" : "0");
                    this.ioWrite("global.fire.routing.test.on", bit5 ? "1" : "0");
                    this.ioWrite("global.fire.routing.ext.delay.in.progress", bit6 ? "1" : "0");
                } else {
                    this.ioWriteNoEvents("global.fire.routing.delay.enabled", bit0 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.delay.in.progress", bit1 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.outputs.activated", bit2 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.ack", bit3 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.disabled", bit4 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.test.on", bit5 ? "1" : "0");
                    this.ioWriteNoEvents("global.fire.routing.ext.delay.in.progress", bit6 ? "1" : "0");
                }
                if (this.gui) {
                    this.uiSet("global.fire.routing.delay.enabled", "visible", bit0 ? "true" : "false");
                    this.uiSet("global.fire.routing.delay.in.progress", "visible", bit1 ? "true" : "false");
                    this.uiSet("global.fire.routing.outputs.activated", "visible", bit2 ? "true" : "false");
                    this.uiSet("global.fire.routing.ack", "visible", bit3 ? "true" : "false");
                    this.uiSet("global.fire.routing.disabled", "visible", bit4 ? "true" : "false");
                    this.uiSet("global.fire.routing.test.on", "visible", bit5 ? "true" : "false");
                    this.uiSet("global.fire.routing.ext.delay.in.progress", "visible", bit6 ? "true" : "false");
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                }
                if (this.online != 0) {
                    this.online = 0;
                    this.ioWrite("connection", "offline");
                }
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
            }
            if (this.online != 0) {
                this.online = 0;
                this.ioWrite("connection", "offline");
            }
        }
    }

    private void readNodeStatus() {
        int i2 = 0;
        while (i2 < this.nodesList.size()) {
            byte[] response;
            int nodeAddress = 8188 + this.nodesList.get(i2) * 4;
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": node status read: " + this.nodesList.get(i2) + " starting from register: " + nodeAddress);
            }
            if ((response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, nodeAddress, 2)) != null) {
                String responseHex = Driver.bytesToHex(response);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": node status read: " + Driver.bytesToHex(response));
                }
                if (responseHex.startsWith("03")) {
                    boolean bit6;
                    byte myByte = response[3];
                    boolean bit0 = (myByte & 1) != 0;
                    boolean bit1 = (myByte & 2) != 0;
                    boolean bit2 = (myByte & 4) != 0;
                    boolean bit3 = (myByte & 8) != 0;
                    boolean bit4 = (myByte & 0x10) != 0;
                    boolean bit5 = (myByte & 0x20) != 0;
                    boolean bl = bit6 = (myByte & 0x40) != 0;
                    if (this.startupevent) {
                        this.ioWrite("node." + this.nodesList.get(i2) + ".alarm", bit0 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fault", bit1 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".disable", bit2 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".test", bit3 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".daynight", bit4 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".mcpalarm", bit5 ? "1" : "0");
                    } else {
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".alarm", bit0 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fault", bit1 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".disable", bit2 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".test", bit3 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".daynight", bit4 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".mcpalarm", bit5 ? "1" : "0");
                    }
                    if (this.gui) {
                        this.uiSet("node." + this.nodesList.get(i2) + ".alarm", "visible", bit0 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fault", "visible", bit1 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".disable", "visible", bit2 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".test", "visible", bit3 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".daynight", "visible", bit4 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".mcpalarm", "visible", bit5 ? "true" : "false");
                    }
                    bit0 = ((myByte = response[2]) & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    boolean bl2 = bit6 = (myByte & 0x40) != 0;
                    if (this.startupevent) {
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.delay.enabled", bit0 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.delay.in.progress", bit1 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.outputs.activated", bit2 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.outputs.silenced", bit3 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.disabled", bit4 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.override.time.elapsed", bit5 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".sounder.in.test", bit6 ? "1" : "0");
                    } else {
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.delay.enabled", bit0 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.delay.in.progress", bit1 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.outputs.activated", bit2 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.outputs.silenced", bit3 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.disabled", bit4 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.override.time.elapsed", bit5 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".sounder.in.test", bit6 ? "1" : "0");
                    }
                    if (this.gui) {
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.delay.enabled", "visible", bit0 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.delay.in.progress", "visible", bit1 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.outputs.activated", "visible", bit2 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.outputs.silenced", "visible", bit3 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.override.time.elapsed", "visible", bit4 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".sounder.in.test", "visible", bit5 ? "true" : "false");
                    }
                    bit0 = ((myByte = response[5]) & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    boolean bl3 = bit6 = (myByte & 0x40) != 0;
                    if (this.startupevent) {
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.delay.enabled", bit0 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.delay.in.progress", bit1 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.outputs.activated", bit2 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.ack", bit3 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.disabled", bit4 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.test.on", bit5 ? "1" : "0");
                        this.ioWrite("node." + this.nodesList.get(i2) + ".fire.routing.ext.delay.in.progress", bit6 ? "1" : "0");
                    } else {
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.delay.enabled", bit0 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.delay.in.progress", bit1 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.outputs.activated", bit2 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.ack", bit3 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.disabled", bit4 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.test.on", bit5 ? "1" : "0");
                        this.ioWriteNoEvents("node." + this.nodesList.get(i2) + ".fire.routing.ext.delay.in.progress", bit6 ? "1" : "0");
                    }
                    if (this.gui) {
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.delay.enabled", "visible", bit0 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.delay.in.progress", "visible", bit1 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.outputs.activated", "visible", bit2 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.ack", "visible", bit3 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.disabled", "visible", bit4 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.test.on", "visible", bit5 ? "true" : "false");
                        this.uiSet("node." + this.nodesList.get(i2) + ".fire.routing.ext.delay.in.progress", "visible", bit6 ? "true" : "false");
                    }
                } else if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                }
                this.sleep(this.delay);
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
            }
            ++i2;
        }
    }

    private void readSensorsStatus(int zone) {
        int sensorStartAddress = 27648 + this.nodesList.get(this.currentNodeIndex) * 1024;
        int i2 = 1;
        while (i2 <= this.loopsNumber) {
            int sensorAddress = sensorStartAddress + (this.currentLoopIndex - 1) * 256;
            if (i2 == this.currentLoopIndex) {
                boolean bit4;
                boolean bit3;
                boolean bit2;
                boolean bit1;
                boolean bit0;
                byte myByte;
                String responseHex;
                byte[] response;
                int j2 = 0;
                while (j2 < this.sensorsNumber) {
                    int currentSensorAddress = sensorAddress + j2;
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": sensors, polling node: " + this.nodesList.get(this.currentNodeIndex) + " - starting register: " + sensorStartAddress + " - current loop: " + i2 + " - current register: " + currentSensorAddress);
                    }
                    if ((response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, currentSensorAddress, 4)) != null) {
                        responseHex = Driver.bytesToHex(response);
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": sensors status read: " + Driver.bytesToHex(response));
                        }
                        if (responseHex.startsWith("03")) {
                            myByte = response[3];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".dis", bit4 ? "1" : "0");
                            }
                            if (this.gui) {
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".prealarm", "visible", bit0 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".alarm", "visible", bit1 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".fault", "visible", bit2 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".test", "visible", bit3 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 1) + ".dis", "visible", bit4 ? "true" : "false");
                            }
                            bit0 = ((myByte = response[5]) & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl2 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".dis", bit4 ? "1" : "0");
                            }
                            if (this.gui) {
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".prealarm", "visible", bit0 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".alarm", "visible", bit1 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".fault", "visible", bit2 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".test", "visible", bit3 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 2) + ".dis", "visible", bit4 ? "true" : "false");
                            }
                            bit0 = ((myByte = response[7]) & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl3 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".dis", bit4 ? "1" : "0");
                            }
                            if (this.gui) {
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".prealarm", "visible", bit0 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".alarm", "visible", bit1 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".fault", "visible", bit2 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".test", "visible", bit3 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 3) + ".dis", "visible", bit4 ? "true" : "false");
                            }
                            bit0 = ((myByte = response[9]) & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl4 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".dis", bit4 ? "1" : "0");
                            }
                            if (this.gui) {
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".prealarm", "visible", bit0 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".alarm", "visible", bit1 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".fault", "visible", bit2 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".test", "visible", bit3 ? "true" : "false");
                                this.uiSet("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".sensor." + (j2 + 4) + ".dis", "visible", bit4 ? "true" : "false");
                            }
                        } else if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                        }
                        j2 += 3;
                        this.sleep(this.delay);
                    } else {
                        this.online = -2;
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
                        }
                    }
                    ++j2;
                }
                int k2 = 0;
                while (k2 < this.modulesNumber) {
                    int currentModuleAddress = sensorAddress + k2 + 127;
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": modules, polling node: " + this.nodesList.get(this.currentNodeIndex) + " - starting register: " + sensorStartAddress + " - current loop: " + i2 + " - current register: " + currentModuleAddress + " - starting module: " + (k2 + 1));
                    }
                    if ((response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, currentModuleAddress, 4)) != null) {
                        responseHex = Driver.bytesToHex(response);
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": modules status read: " + Driver.bytesToHex(response));
                        }
                        if (responseHex.startsWith("03")) {
                            myByte = response[3];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 1) + ".dis", bit4 ? "1" : "0");
                            }
                            myByte = response[5];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl5 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 2) + ".dis", bit4 ? "1" : "0");
                            }
                            myByte = response[7];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl6 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 3) + ".dis", bit4 ? "1" : "0");
                            }
                            myByte = response[9];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            boolean bl7 = bit4 = (myByte & 0x10) != 0;
                            if (this.startupevent) {
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".alarm", bit1 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".fault", bit2 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".test", bit3 ? "1" : "0");
                                this.ioWrite("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".dis", bit4 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".prealarm", bit0 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".alarm", bit1 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".fault", bit2 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".test", bit3 ? "1" : "0");
                                this.ioWriteNoEvents("node." + this.nodesList.get(this.currentNodeIndex) + ".loop." + i2 + ".module." + (k2 + 4) + ".dis", bit4 ? "1" : "0");
                            }
                        } else if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                        }
                        k2 += 3;
                        this.sleep(this.delay);
                    } else {
                        this.online = -2;
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
                        }
                    }
                    ++k2;
                }
            }
            ++i2;
        }
        if (this.nodesList.get(this.currentNodeIndex) == this.nodesList.get(this.nodesList.size() - 1)) {
            ++this.currentLoopIndex;
        }
        if (this.currentLoopIndex > this.loopsNumber) {
            this.currentLoopIndex = 1;
        }
        ++this.currentNodeIndex;
        if (this.currentNodeIndex >= this.nodesList.size()) {
            this.currentNodeIndex = 0;
        }
        this.startupevent = true;
        if (this.online != 1 && this.online != -2) {
            this.online = 1;
            this.ioWrite("connection", "online");
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    public static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        int i2 = 0;
        while (i2 < hex.length()) {
            String str = hex.substring(i2, i2 + 2);
            output.append((char)Integer.parseInt(str, 16));
            i2 += 2;
        }
        return output.toString();
    }
}

