/*
 * Decompiled with CFR 0.152.
 */
package drivers.ionopi;

import drivers.ionopi.Driver;
import drivers.ionopi.IonoPiWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONObject;

public class RemoteIonoPiWrapper
extends IonoPiWrapper {
    private String host = null;
    private int port = 0;
    private boolean https = true;
    private String authCookie = null;
    private String connectionId = null;
    private int ackCounter = 0;

    @Override
    void init(Driver driver, String name, HashMap<String, String> config) throws Exception {
        String password;
        super.init(driver, name, config);
        this.host = config.get("host");
        try {
            this.port = Integer.parseInt(config.get("port"));
        }
        catch (Exception e2) {
            this.port = 80;
        }
        String user2 = config.get("user");
        if (user2 == null) {
            user2 = "admin";
        }
        if ((password = config.get("password")) == null) {
            password = "admin";
        }
        try {
            this.https = Boolean.parseBoolean(config.get("https"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL url = new URL(this.https ? "HTTPS" : "HTTP", this.host, this.port, "/api/login?user=" + user2 + "&" + "password=" + password);
        URLConnection uc = this.httpOpenConnection(url);
        int responseCode = this.httpResponseCode(uc);
        this.authCookie = uc.getHeaderFields().get("Set-Cookie").get(0);
        JSONObject responseBody = new JSONObject(this.httpResponseBody(uc));
        if (responseCode != 200 || this.authCookie == null || !responseBody.getString("result").equals("ok")) {
            throw new Exception("login error");
        }
        url = new URL(this.https ? "HTTPS" : "HTTP", this.host, this.port, "/api/connect");
        uc = this.httpOpenConnection(url);
        uc.setRequestProperty("Cookie", this.authCookie);
        responseCode = this.httpResponseCode(uc);
        responseBody = new JSONObject(this.httpResponseBody(uc));
        if (responseCode != 200 || !responseBody.has("cid")) {
            throw new Exception("connection error");
        }
        this.connectionId = responseBody.getString("cid");
        url = new URL(this.https ? "HTTPS" : "HTTP", this.host, this.port, "/api/subscribe?cid=" + this.connectionId + "&nodes=" + URLEncoder.encode("ionopi.*", "UTF-8"));
        uc = this.httpOpenConnection(url);
        uc.setRequestProperty("Cookie", this.authCookie);
        responseCode = this.httpResponseCode(uc);
        responseBody = new JSONObject(this.httpResponseBody(uc));
        if (responseCode != 200 || !responseBody.getString("result").equals("ok")) {
            throw new Exception("subscribe error");
        }
    }

    @Override
    boolean loop() throws Exception {
        URL url = new URL(this.https ? "HTTPS" : "HTTP", this.host, this.port, "/api/state?cid=" + this.connectionId + "&" + "ack=" + this.ackCounter + "&timeout=15");
        URLConnection uc = this.httpOpenConnection(url);
        uc.setRequestProperty("Cookie", this.authCookie);
        int responseCode = this.httpResponseCode(uc);
        JSONObject responseBody = new JSONObject(this.httpResponseBody(uc));
        if (responseCode != 200) {
            throw new Exception("response code: " + responseCode);
        }
        if (!responseBody.has("result")) {
            throw new Exception("response format error");
        }
        JSONObject result = responseBody.getJSONObject("result");
        this.processState(result);
        this.ackCounter = this.ackCounter < Integer.MAX_VALUE ? ++this.ackCounter : 1;
        return true;
    }

    @Override
    void end() {
    }

    @Override
    void command(String name, String value) throws Exception {
        String cmd;
        String val = value.equals("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") ? "true" : (value.equals("0") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") ? "false" : value);
        if (name.equalsIgnoreCase("led")) {
            cmd = "ionopi.setLed(" + val + ")";
        } else if (name.equalsIgnoreCase("o1")) {
            cmd = "ionopi.setO1(" + val + ")";
        } else if (name.equalsIgnoreCase("o2")) {
            cmd = "ionopi.setO2(" + val + ")";
        } else if (name.equalsIgnoreCase("o3")) {
            cmd = "ionopi.setO3(" + val + ")";
        } else if (name.equalsIgnoreCase("o4")) {
            cmd = "ionopi.setO4(" + val + ")";
        } else if (name.equalsIgnoreCase("oc1")) {
            cmd = "ionopi.setOc1(" + val + ")";
        } else if (name.equalsIgnoreCase("oc2")) {
            cmd = "ionopi.setOc2(" + val + ")";
        } else if (name.equalsIgnoreCase("oc3")) {
            cmd = "ionopi.setOc3(" + val + ")";
        } else if (name.equalsIgnoreCase("accesscontrol.conf")) {
            cmd = "accessControl.setConfig('" + val + "')";
        } else if (name.equalsIgnoreCase("clock")) {
            if (value.equals("read")) {
                cmd = "rpiconfig.getTime()";
            } else if (value.equals("auto")) {
                cmd = "rpiconfig.setTime(\"{\\\"ntpEnabled\\\":true}\")";
            } else {
                JSONObject json;
                String[] fields = value.split("\\.");
                String ts = value.split("\\.")[0];
                if (fields.length == 2) {
                    String tz = value.split("\\.")[1];
                    json = this.convertTimestamp(ts, tz);
                } else {
                    json = this.convertTimestamp(ts, null);
                }
                cmd = "rpiconfig.setTime(\"" + json.toString().replaceAll("\"", "\\\\\"") + "\")";
            }
        } else {
            throw new Exception("command format error");
        }
        URL url = new URL(this.https ? "HTTPS" : "HTTP", this.host, this.port, "/api/command?cid=" + this.connectionId + "&cmd=" + URLEncoder.encode(cmd, "UTF-8"));
        URLConnection uc = this.httpOpenConnection(url);
        uc.setRequestProperty("Cookie", this.authCookie);
        int responseCode = this.httpResponseCode(uc);
        if (responseCode == 200) {
            JSONObject responseBody = new JSONObject(this.httpResponseBody(uc));
            if (!responseBody.has("result")) {
                throw new Exception("response error");
            }
            if (name.equalsIgnoreCase("clock") && value.equals("read")) {
                try {
                    String result = responseBody.getString("result");
                    JSONObject json = new JSONObject(result);
                    String rawDate = json.getString("date");
                    String rawTime = json.getString("time");
                    String timezone = json.getString("timeZone");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    Date date = dateFormat.parse(String.valueOf(rawDate) + " " + rawTime);
                    this.driver.doIoWrite(true, "clock", String.valueOf(Long.toString(date.getTime())) + "." + timezone);
                }
                catch (Exception e2) {
                    throw new Exception("error while reading date/time from Iono Pi - " + e2.getMessage());
                }
            }
        } else {
            if (responseCode == -1) {
                throw new Exception("connection error");
            }
            throw new Exception("error response code: " + responseCode);
        }
    }

    private void processState(JSONObject data) throws Exception {
        Iterator<String> keys = data.keys();
        while (keys.hasNext()) {
            String val;
            String key = keys.next();
            if (!key.startsWith("ionopi.")) continue;
            String dp = key.substring(7).toLowerCase(Locale.ENGLISH);
            Object obj = data.get(key);
            if (obj == null || obj.equals(JSONObject.NULL)) {
                val = null;
            } else {
                val = obj.toString();
                if (dp.startsWith("wiegand.")) {
                    dp = dp.replaceAll("\\.i", "\\.");
                    String[] bits_data = val.split("/");
                    val = bits_data.length == 1 ? Long.toHexString(Long.parseLong(val)) : (this.wiegandBits ? String.valueOf(bits_data[0]) + "/" + Long.toHexString(Long.parseLong(bits_data[1])) : Long.toHexString(Long.parseLong(bits_data[1])));
                } else if (val.equals("true")) {
                    val = "1";
                } else if (val.equals("false")) {
                    val = "0";
                }
            }
            this.driver.doIoWrite(true, dp, val);
        }
    }

    private URLConnection httpOpenConnection(URL url) {
        try {
            URLConnection uc = url.openConnection();
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(30000);
            return uc;
        }
        catch (IOException e2) {
            return null;
        }
    }

    private String httpResponseBody(URLConnection uc) {
        try {
            int c2;
            InputStream instream = uc.getInputStream();
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < 1000000 && (c2 = instream.read()) != -1) {
                sb.append((char)c2);
                ++i2;
            }
            instream.close();
            return sb.toString();
        }
        catch (IOException e2) {
            return null;
        }
    }

    private int httpResponseCode(URLConnection uc) {
        try {
            String header = uc.getHeaderField(0);
            int bx = header.indexOf(32) + 1;
            int ex = header.indexOf(32, bx);
            return Integer.parseInt(header.substring(bx, ex));
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private JSONObject convertTimestamp(String timestamp, String timezone) throws Exception {
        JSONObject res = new JSONObject();
        try {
            if (timezone != null) {
                res.put("timeZone", timezone);
            }
            res.put("ntpEnabled", false);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(Long.parseLong(timestamp)));
            res.put("date", date);
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            String time = timeFormat.format(new Date(Long.parseLong(timestamp)));
            res.put("time", time);
        }
        catch (Exception e2) {
            throw new Exception("error while converting timestamp into date/time json");
        }
        return res;
    }
}

